/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.setting;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.component.UCScrollPane;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.setting.AdvancedSettingCallback;
import com.blisscloud.ezuc.client.setting.LanguageItem;
import com.blisscloud.ezuc.client.setting.LanguageSelectionRenderer;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AutoAttendantControlPanel
extends JPanel {
    private JScrollPane autoAttendantScrollPanel;
    private JPanel autoAttendantInsidePanel;
    private RoundedCornerPanel autoAttendantTopPanel;
    private JLabel autoAttendantBottomPadding;
    private JLabel languageLabel;
    private JComboBox<LanguageItem> languageBox;
    private DefaultComboBoxModel<LanguageItem> languageBoxModel = new DefaultComboBoxModel();
    private JLabel voicePassLabel;
    private JPasswordField txtNewPassword;
    private JLabel newNoticeEmailLabel;
    private JCheckBox newNoticeEmailCheckBox;
    private AdvancedSettingCallback mCallback;

    public AutoAttendantControlPanel(AdvancedSettingCallback callback) {
        this.mCallback = callback;
        BorderLayout autoAttendantControlLayout = new BorderLayout();
        autoAttendantControlLayout.setVgap(10);
        this.setLayout(autoAttendantControlLayout);
        this.setBorder(BorderFactory.createEmptyBorder(15, 10, 15, 10));
        this.autoAttendantScrollPanel = new UCScrollPane(10);
        this.add((Component)this.autoAttendantScrollPanel, "Center");
        this.autoAttendantInsidePanel = new JPanel();
        this.autoAttendantScrollPanel.setViewportView(this.autoAttendantInsidePanel);
        this.autoAttendantInsidePanel.setLayout(new GridBagLayout());
        int insidePanelY = 0;
        this.autoAttendantTopPanel = new RoundedCornerPanel();
        this.autoAttendantInsidePanel.add((Component)this.autoAttendantTopPanel, new GridBagConstraints(0, insidePanelY++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.autoAttendantTopPanel.setLayout(new GridBagLayout());
        this.autoAttendantTopPanel.setBackground(Color.WHITE);
        this.languageLabel = new JLabel();
        this.autoAttendantTopPanel.add((Component)this.languageLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
        this.languageLabel.setText(I18NUtil.getString("setting_label_prompt_lang"));
        this.languageLabel.setFont(UIConstants.FONT_12_BOLD);
        this.languageBox = new JComboBox();
        this.autoAttendantTopPanel.add(this.languageBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
        this.languageBox.setFont(UIConstants.FONT_12_PLAIN);
        this.languageBox.setModel(this.languageBoxModel);
        this.languageBox.setRenderer(new LanguageSelectionRenderer());
        JSeparator separator = new JSeparator();
        this.autoAttendantTopPanel.add((Component)separator, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        separator.setForeground(Color.LIGHT_GRAY);
        separator.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
        this.voicePassLabel = new JLabel();
        this.autoAttendantTopPanel.add((Component)this.voicePassLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
        this.voicePassLabel.setText(I18NUtil.getString("setting_label_voice_pwd"));
        this.voicePassLabel.setFont(UIConstants.FONT_12_BOLD);
        this.txtNewPassword = new JPasswordField(10);
        this.autoAttendantTopPanel.add((Component)this.txtNewPassword, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
        JSeparator separator2 = new JSeparator();
        this.autoAttendantTopPanel.add((Component)separator2, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        separator2.setForeground(Color.LIGHT_GRAY);
        separator2.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
        this.newNoticeEmailLabel = new JLabel();
        this.autoAttendantTopPanel.add((Component)this.newNoticeEmailLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
        this.newNoticeEmailLabel.setText(I18NUtil.getString("setting_label_send_email_if_new_msgs_received"));
        this.newNoticeEmailLabel.setFont(UIConstants.FONT_12_BOLD);
        this.newNoticeEmailCheckBox = new JCheckBox();
        this.autoAttendantTopPanel.add((Component)this.newNoticeEmailCheckBox, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
        this.newNoticeEmailCheckBox.setOpaque(false);
        this.newNoticeEmailCheckBox.setFont(UIConstants.FONT_12_PLAIN);
        this.autoAttendantBottomPadding = new JLabel();
        this.autoAttendantInsidePanel.add((Component)this.autoAttendantBottomPadding, new GridBagConstraints(0, insidePanelY++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel actionPanel = new JPanel();
        this.add((Component)actionPanel, "South");
        FlowLayout jPanel3Layout = new FlowLayout();
        jPanel3Layout.setAlignment(1);
        actionPanel.setLayout(jPanel3Layout);
        actionPanel.setOpaque(false);
        JButton btnSaveAutoAttendant = new JButton();
        actionPanel.add(btnSaveAutoAttendant);
        btnSaveAutoAttendant.setText(I18NUtil.getString("common_btn_apply"));
        btnSaveAutoAttendant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoAttendantControlPanel.this.btnSaveAutoAttendantActionPerformed(evt);
            }
        });
        JButton btnSaveCloseAutoAttendant = new JButton();
        actionPanel.add(btnSaveCloseAutoAttendant);
        btnSaveCloseAutoAttendant.setText(I18NUtil.getString("common_btn_apply_close"));
        btnSaveCloseAutoAttendant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoAttendantControlPanel.this.btnSaveCloseAutoAttendantActionPerformed(evt);
            }
        });
        JButton btnCancelAutoAttendant = new JButton();
        actionPanel.add(btnCancelAutoAttendant);
        btnCancelAutoAttendant.setText(I18NUtil.getString("common_btn_cancel"));
        btnCancelAutoAttendant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutoAttendantControlPanel.this.mCallback.onClose();
            }
        });
    }

    protected void btnSaveCloseAutoAttendantActionPerformed(ActionEvent evt) {
        boolean result = this.btnSaveAutoAttendantActionPerformed(evt);
        if (result) {
            this.mCallback.onClose();
        }
    }

    protected boolean btnSaveAutoAttendantActionPerformed(ActionEvent evt) {
        try {
            char[] passwordAry;
            String password;
            JSONObject voiceData = this.mCallback.getVoiceData();
            boolean doUpdate = false;
            if (this.txtNewPassword != null && StringUtils.isNotBlank((CharSequence)(password = new String(passwordAry = this.txtNewPassword.getPassword()).trim()))) {
                if (!TextUtils.isDigitsOnly(password)) {
                    JOptionPane.showMessageDialog(this, I18NUtil.getString("setting_label_voice_pwd_only_number"), I18NUtil.getString("common_title_error"), 0);
                    this.txtNewPassword.requestFocus();
                    return false;
                }
                voiceData.put("voicePassword", password);
                Arrays.fill(passwordAry, '0');
                doUpdate = true;
            }
            if (this.languageBoxModel != null) {
                LanguageItem data = (LanguageItem)this.languageBoxModel.getSelectedItem();
                voiceData.put("languageId", data.getId());
                doUpdate = true;
            }
            if (this.newNoticeEmailCheckBox != null) {
                voiceData.put("subscribeRecEmailFlag", this.newNoticeEmailCheckBox.isSelected());
                doUpdate = true;
            }
            if (doUpdate) {
                WebAgent.getInstance().updateVoiceConfigNew(voiceData);
            }
            return true;
        }
        catch (JSONException e) {
            Log.e(this.getClass().getSimpleName(), "setLanguage", e);
            return false;
        }
    }

    public void loadData(JSONObject voiceData) {
        this.loadLanguageData(voiceData);
        this.loadEmailNotification(voiceData);
    }

    private void loadEmailNotification(JSONObject voiceData) {
        boolean emailFlag = false;
        if (voiceData.has("subscribeRecEmailFlag")) {
            emailFlag = voiceData.optBoolean("subscribeRecEmailFlag", false);
        }
        this.newNoticeEmailCheckBox.setSelected(emailFlag);
    }

    private void loadLanguageData(JSONObject voiceData) {
        this.languageBoxModel.removeAllElements();
        String languageJsonStr = PreferencesUtil.getString(UCChatClient.context, "LANGUAGE_SETTING", "");
        if (!TextUtils.isEmpty((CharSequence)languageJsonStr)) {
            try {
                int languageId = 0;
                if (voiceData.has("languageId")) {
                    languageId = voiceData.getInt("languageId");
                }
                this.languageBoxModel.addElement(new LanguageItem(-1, I18NUtil.getString("setting_label_prompt_lang_default")));
                JSONArray arr = new JSONArray(languageJsonStr);
                int size = arr.length();
                for (int i = 0; i < size; ++i) {
                    JSONObject temp = (JSONObject)arr.get(i);
                    int id = temp.getInt("id");
                    String name = temp.getString("name");
                    LanguageItem data = new LanguageItem(id, name);
                    this.languageBoxModel.addElement(data);
                    if (languageId != id) continue;
                    this.languageBoxModel.setSelectedItem(data);
                }
            }
            catch (JSONException e) {
                Log.e(this.getClass().getSimpleName(), "setLanguage", e);
            }
        }
    }
}

