/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.setting;

import com.blisscloud.ezuc.bean.web.LiteOutboundPrefix;
import com.blisscloud.ezuc.bean.web.LiteSite;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.component.UCScrollPane;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.setting.AdvancedSettingCallback;
import com.blisscloud.ezuc.client.setting.OutboundPrefixComboBoxCellRenderer;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.db.UCDBSite;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class OutboundPrefixControlPanel
extends JPanel {
    private JScrollPane outboundPrefixScrollPanel;
    private JPanel outboundPrefixInsidePanel;
    private RoundedCornerPanel outboundPrefixTopPanel;
    private JLabel outboundPrefixBottomPadding;
    JComboBox<LiteOutboundPrefix>[] outboundPrefixBoxAry;
    private AdvancedSettingCallback mCallback;

    public OutboundPrefixControlPanel(AdvancedSettingCallback callback) {
        this.mCallback = callback;
        BorderLayout outboundPrefixControlLayout = new BorderLayout();
        outboundPrefixControlLayout.setVgap(10);
        this.setLayout(outboundPrefixControlLayout);
        this.setBorder(BorderFactory.createEmptyBorder(15, 10, 15, 10));
        this.outboundPrefixScrollPanel = new UCScrollPane(10);
        this.add((Component)this.outboundPrefixScrollPanel, "Center");
        this.outboundPrefixInsidePanel = new JPanel();
        this.outboundPrefixScrollPanel.setViewportView(this.outboundPrefixInsidePanel);
        this.outboundPrefixInsidePanel.setLayout(new GridBagLayout());
        int insidePanelY = 0;
        this.outboundPrefixTopPanel = new RoundedCornerPanel();
        this.outboundPrefixInsidePanel.add((Component)this.outboundPrefixTopPanel, new GridBagConstraints(0, insidePanelY++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.outboundPrefixTopPanel.setLayout(new GridBagLayout());
        this.outboundPrefixTopPanel.setBackground(Color.WHITE);
        this.outboundPrefixBottomPadding = new JLabel();
        this.outboundPrefixInsidePanel.add((Component)this.outboundPrefixBottomPadding, new GridBagConstraints(0, insidePanelY++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel actionPanel = new JPanel();
        this.add((Component)actionPanel, "South");
        FlowLayout jPanel3Layout = new FlowLayout();
        jPanel3Layout.setAlignment(1);
        actionPanel.setLayout(jPanel3Layout);
        actionPanel.setOpaque(false);
        JButton btnSaveCallForward = new JButton();
        actionPanel.add(btnSaveCallForward);
        btnSaveCallForward.setText(I18NUtil.getString("common_btn_apply"));
        btnSaveCallForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutboundPrefixControlPanel.this.btnSaveAutoOutboundPrefixPerformed(evt);
            }
        });
        JButton btnSaveCloseCallForward = new JButton();
        actionPanel.add(btnSaveCloseCallForward);
        btnSaveCloseCallForward.setText(I18NUtil.getString("common_btn_apply_close"));
        btnSaveCloseCallForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutboundPrefixControlPanel.this.btnSaveCloseOutboundPrefixActionPerformed(evt);
            }
        });
        JButton btnCancelCallForward = new JButton();
        actionPanel.add(btnCancelCallForward);
        btnCancelCallForward.setText(I18NUtil.getString("common_btn_cancel"));
        btnCancelCallForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutboundPrefixControlPanel.this.mCallback.onClose();
            }
        });
    }

    public void loadData() {
        this.outboundPrefixTopPanel.removeAll();
        this.outboundPrefixBoxAry = null;
        String[] myPbxSiteIds = CommonUtil.getJsonDataArray(PreferencesUtil.getSipMyPbxSiteList(UCChatClient.context), "id");
        if (myPbxSiteIds == null) {
            return;
        }
        this.outboundPrefixBoxAry = new JComboBox[myPbxSiteIds.length];
        for (int i = 0; myPbxSiteIds != null && i < myPbxSiteIds.length; ++i) {
            LiteSite site = UCDBSite.getSite(UCChatClient.context, Long.parseLong(myPbxSiteIds[i]));
            JLabel siteLabel = new JLabel();
            this.outboundPrefixTopPanel.add((Component)siteLabel, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            siteLabel.setText(I18NUtil.getString("fun_title_pbx_area_single") + " - " + site.getName());
            siteLabel.setFont(UIConstants.FONT_12_BOLD);
            DefaultComboBoxModel<LiteOutboundPrefix> outboundPrefixBoxModel = new DefaultComboBoxModel<LiteOutboundPrefix>();
            JComboBox<LiteOutboundPrefix> outboundPrefixBox = new JComboBox<LiteOutboundPrefix>();
            this.outboundPrefixTopPanel.add(outboundPrefixBox, new GridBagConstraints(1, i, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            outboundPrefixBox.setFont(UIConstants.FONT_12_PLAIN);
            outboundPrefixBox.setModel(outboundPrefixBoxModel);
            outboundPrefixBox.setRenderer(new OutboundPrefixComboBoxCellRenderer());
            outboundPrefixBox.setEnabled(PreferencesUtil.hasOutboundPrefixEditPermission(UCChatClient.context));
            this.outboundPrefixBoxAry[i] = outboundPrefixBox;
            LiteOutboundPrefix selectedOutboundPrefix = ContactManager.getMySelfOutboundPrefix(UCChatClient.context, site.getId());
            List<LiteOutboundPrefix> prefixList = UCDBSite.getOutboundPrefixList(UCChatClient.context, site.getId());
            for (int j = 0; prefixList != null && j < prefixList.size(); ++j) {
                LiteOutboundPrefix outboundPrefix = prefixList.get(j);
                outboundPrefixBoxModel.addElement(outboundPrefix);
                if (selectedOutboundPrefix == null || selectedOutboundPrefix.getId().longValue() != outboundPrefix.getId().longValue()) continue;
                outboundPrefixBoxModel.setSelectedItem(outboundPrefix);
            }
        }
        this.repaint();
    }

    protected void btnSaveCloseOutboundPrefixActionPerformed(ActionEvent evt) {
        boolean result = this.btnSaveAutoOutboundPrefixPerformed(evt);
        if (result) {
            this.mCallback.onClose();
        }
    }

    protected boolean btnSaveAutoOutboundPrefixPerformed(ActionEvent evt) {
        if (PreferencesUtil.hasOutboundPrefixEditPermission(UCChatClient.context)) {
            if (this.outboundPrefixBoxAry == null) {
                return true;
            }
            for (int i = 0; i < this.outboundPrefixBoxAry.length; ++i) {
                LiteOutboundPrefix outboundPrefix = (LiteOutboundPrefix)this.outboundPrefixBoxAry[i].getSelectedItem();
                if (outboundPrefix == null) continue;
                WebAgent.getInstance().updateOutboundPrefix(outboundPrefix.getId());
            }
        }
        return true;
    }
}

