/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.sorter;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.addressbook.AddressBookGroup;
import com.blisscloud.ezuc.client.sorter.SorterBase;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.Comparator;

public class DepartmentContactListSorter
extends SorterBase
implements Comparator<AddressBookGroup<LiteContact>> {
    private String departmentPath = null;
    private String upperLevel = null;
    private String topLevel = null;

    public DepartmentContactListSorter(Context ctx) {
        LiteContact mySelf = ContactManager.getContact(ctx, PreferencesUtil.getUserJid(ctx));
        this.departmentPath = mySelf.getDepartmentNamePath();
        int lastIndex = this.departmentPath.lastIndexOf("/");
        this.upperLevel = lastIndex != -1 ? this.departmentPath.substring(0, lastIndex) : this.departmentPath;
        int firstIndex = this.departmentPath.indexOf("/");
        this.topLevel = firstIndex != -1 ? this.departmentPath.substring(0, firstIndex) : this.departmentPath;
    }

    @Override
    public int compare(AddressBookGroup<LiteContact> group1, AddressBookGroup<LiteContact> group2) {
        String g1 = group1.getId();
        String g2 = group2.getId();
        if (g1.equalsIgnoreCase("location") && !g2.equalsIgnoreCase("location")) {
            return 1;
        }
        if (!g1.equalsIgnoreCase("location") && g2.equalsIgnoreCase("location")) {
            return -1;
        }
        if (g1.equals(this.departmentPath) && !g2.equals(this.departmentPath)) {
            return -1;
        }
        if (!g1.equals(this.departmentPath) && g2.equals(this.departmentPath)) {
            return 1;
        }
        if (g1.startsWith(this.departmentPath) && !g2.startsWith(this.departmentPath)) {
            return -1;
        }
        if (!g1.startsWith(this.departmentPath) && g2.startsWith(this.departmentPath)) {
            return 1;
        }
        if (this.upperLevel != null) {
            if (g1.startsWith(this.upperLevel) && !g2.startsWith(this.upperLevel)) {
                return -1;
            }
            if (!g1.startsWith(this.upperLevel) && g2.startsWith(this.upperLevel)) {
                return 1;
            }
        }
        if (this.topLevel != null) {
            if (g1.startsWith(this.topLevel) && !g2.startsWith(this.topLevel)) {
                return -1;
            }
            if (!g1.startsWith(this.topLevel) && g2.startsWith(this.topLevel)) {
                return 1;
            }
        }
        return this.collator.compare(g1.toUpperCase(), g2.toUpperCase());
    }
}

