/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.text;

import com.blisscloud.ezuc.client.chat.DomService;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.text.MsgTextWriter;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ChatTextWriter
implements MsgTextWriter {
    private DomService domService;
    private Element parentNode;
    private int iconSize = 16;
    private int writeSize = 0;
    private int maxLength = -1;
    private boolean skipEnabled = false;
    private boolean maxCheckEnabled = false;
    private String packetId;
    private String regexKey = null;
    private String targetPacketId;

    public ChatTextWriter(DomService domService, Element parentNode, String packetId, String regexKey, String targetPacketId) {
        this.domService = domService;
        this.parentNode = parentNode;
        this.packetId = packetId;
        this.regexKey = regexKey;
        this.targetPacketId = targetPacketId;
    }

    public ChatTextWriter(DomService domService, Element parentNode, String packetId, int iconSize, int maxLength) {
        this.domService = domService;
        this.parentNode = parentNode;
        this.packetId = packetId;
        this.iconSize = iconSize;
        this.maxLength = maxLength;
        this.maxCheckEnabled = this.maxLength > 0;
    }

    private Element createImageElemment(String url) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        Element a = this.domService.createElement("img");
        a.setAttribute("src", url);
        a.setAttribute("width", String.valueOf(this.iconSize));
        a.setAttribute("height", String.valueOf(this.iconSize));
        return a;
    }

    private Element createOneImageElemment(String url) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        Element a = this.domService.createElement("img");
        a.setAttribute("src", url);
        return a;
    }

    private void checkSize() throws UCThreadException {
        if (this.maxCheckEnabled && this.writeSize >= this.maxLength) {
            this.skipEnabled = true;
            Text prefixText = this.domService.createTextNode("...");
            this.parentNode.appendChild(prefixText);
        }
    }

    @Override
    public void writeStickerIcon(String stickerKey) throws UCThreadException {
        if (this.skipEnabled) {
            return;
        }
        String stickerIconURL = ChatRoomManager.getStickerURL(stickerKey);
        Element img = this.createOneImageElemment(stickerIconURL);
        this.parentNode.appendChild(img);
        this.parentNode.setAttribute("align", "center");
        ++this.writeSize;
        this.checkSize();
    }

    @Override
    public void writeOneEmoticonIcon(String emoticonKey) throws UCThreadException {
        if (this.skipEnabled) {
            return;
        }
        String emotIconURL = ChatRoomManager.getEmoticonLargeURL(emoticonKey);
        Element img = this.createOneImageElemment(emotIconURL);
        this.parentNode.setAttribute("align", "center");
        img.setAttribute("class", "onePic");
        this.parentNode.appendChild(img);
        ++this.writeSize;
        this.checkSize();
    }

    @Override
    public void writeLink(String text, String url) throws UCThreadException {
        if (this.skipEnabled) {
            return;
        }
        if (this.maxCheckEnabled) {
            if (this.writeSize + text.length() >= this.maxLength) {
                text = text.substring(0, this.maxLength - this.writeSize);
            }
            Element link = this.createLinkElemment(true, text, url);
            this.parentNode.appendChild(link);
            this.writeSize += text.length();
            this.checkSize();
        } else {
            Element link = this.createLinkElemment(false, text, url);
            this.parentNode.appendChild(link);
            this.writeSize += text.length();
        }
    }

    private Element createLinkElemment(boolean maxCheckEnabled, String text, String url) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        Element a = this.domService.createElement("a");
        if (maxCheckEnabled) {
            Text linkText = this.domService.createTextNode(text);
            a.appendChild(linkText);
        } else {
            ChatTextWriter.writeTextMatchSearchKey(this.domService, a, text, this.regexKey, this.packetId, this.targetPacketId);
        }
        a.setAttribute("title", text);
        a.setAttribute("urlToOpen", url);
        a.setAttribute("href", "#");
        if (StringUtils.isNotBlank((CharSequence)this.packetId)) {
            a.setAttribute("packetId", this.packetId);
        }
        a.setAttribute("command", "openUrl");
        this.domService.addEventListener(a, "click");
        return a;
    }

    @Override
    public boolean preWriteEmoticonIcon(String emoticonKey) throws UCThreadException {
        String emotIconURL;
        if (this.skipEnabled) {
            return true;
        }
        return (emoticonKey.startsWith("[emoticon_") || emoticonKey.startsWith("[emo")) && TextUtils.isNotBlank((CharSequence)(emotIconURL = ChatRoomManager.getEmoticonSmallURL(emoticonKey)));
    }

    @Override
    public boolean writeEmoticonIcon(String emoticonKey) throws UCThreadException {
        String emotIconURL;
        if (this.skipEnabled) {
            return true;
        }
        if ((emoticonKey.startsWith("[emoticon_") || emoticonKey.startsWith("[emo")) && TextUtils.isNotBlank((CharSequence)(emotIconURL = ChatRoomManager.getEmoticonSmallURL(emoticonKey)))) {
            Element img = this.createImageElemment(emotIconURL);
            this.parentNode.appendChild(img);
            ++this.writeSize;
            this.checkSize();
            return true;
        }
        return false;
    }

    @Override
    public boolean preWriteEmojiIcon(String codePointStr) throws UCThreadException {
        if (this.skipEnabled) {
            return true;
        }
        String emojiPath = "images/emoji/" + codePointStr + ".png";
        URL url = ChatTextWriter.class.getClassLoader().getResource(emojiPath);
        return url != null;
    }

    @Override
    public boolean writeEmojiIcon(String codePointStr) throws UCThreadException {
        if (this.skipEnabled) {
            return true;
        }
        String emojiPath = "images/emoji/" + codePointStr + ".png";
        try {
            URL url = ChatTextWriter.class.getClassLoader().getResource(emojiPath);
            if (url != null) {
                String emojiURI = url.toURI().toString();
                Element img = this.createImageElemment(emojiURI);
                this.parentNode.appendChild(img);
                ++this.writeSize;
                this.checkSize();
                return true;
            }
        }
        catch (URISyntaxException ex) {
            Log.e(ChatTextWriter.class.getSimpleName(), ex.getLocalizedMessage(), ex);
        }
        return false;
    }

    @Override
    public void writeText(String text) throws UCThreadException {
        if (this.skipEnabled) {
            return;
        }
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        if (this.maxCheckEnabled) {
            if (this.writeSize + text.length() >= this.maxLength) {
                text = text.substring(0, this.maxLength - this.writeSize);
            }
            Text prefixText = this.domService.createTextNode(text);
            this.parentNode.appendChild(prefixText);
            this.writeSize += text.length();
            this.checkSize();
        } else {
            ChatTextWriter.writeTextMatchSearchKey(this.domService, this.parentNode, text, this.regexKey, this.packetId, this.targetPacketId);
            this.writeSize += text.length();
        }
    }

    public int getWriteSize() {
        return this.writeSize;
    }

    public void setWriteSize(int writeSize) {
        this.writeSize = writeSize;
    }

    public static void writeTextMatchSearchKey(DomService xDomService, Element p, String text, String regex, String packetId, String targetPacketId) throws UCThreadException {
        if (StringUtils.isBlank((CharSequence)regex)) {
            Text prefixText = xDomService.createTextNode(text);
            p.appendChild(prefixText);
            return;
        }
        boolean searchNow = false;
        if (targetPacketId != null && targetPacketId.equalsIgnoreCase(packetId)) {
            searchNow = true;
        }
        String escapedSearchString = Pattern.quote(regex);
        Pattern pattern = Pattern.compile(escapedSearchString, 2);
        Matcher matcher = pattern.matcher(text);
        int lastIndex = 0;
        while (matcher.find()) {
            int s = matcher.start();
            int e = matcher.end();
            if (lastIndex != s) {
                String prefix = text.substring(lastIndex, s);
                Text prefixText = xDomService.createTextNode(prefix);
                p.appendChild(prefixText);
            }
            String middle = text.substring(s, e);
            System.out.println("+>" + middle);
            Element spanElement = xDomService.createElement("span");
            if (searchNow) {
                spanElement.setAttribute("class", "highlightSelected");
            } else {
                spanElement.setAttribute("class", "highlight");
            }
            Text middleText = xDomService.createTextNode(middle);
            spanElement.appendChild(middleText);
            p.appendChild(spanElement);
            lastIndex = e;
        }
        if (lastIndex < text.length()) {
            String finalStr = text.substring(lastIndex);
            Text prefixText = xDomService.createTextNode(finalStr);
            p.appendChild(prefixText);
        }
    }

    public String getTargetPacketId() {
        return this.targetPacketId;
    }

    public void setTargetPacketId(String targetPacketId) {
        this.targetPacketId = targetPacketId;
    }

    public static void main(String[] args) throws Exception {
        String escapedSearchString = Pattern.quote("[emo1000]");
        Pattern pattern = Pattern.compile(escapedSearchString, 2);
        String text = "123123 [emo1000] 123123";
        Matcher matcher = pattern.matcher(text);
        boolean lastIndex = false;
        while (matcher.find()) {
            int s = matcher.start();
            int e = matcher.end();
            String middle = text.substring(s, e);
            System.out.println(">" + middle);
        }
    }
}

