/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.text;

import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.chat.roomimpl.Chatroom;
import com.blisscloud.ezuc.client.text.MsgTextWriter;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.Utils;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MsgTextConverter {
    private static boolean isStickerContent(String str) {
        String stickerIconURL;
        String key;
        if (TextUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern p = Pattern.compile("\\[([^(\\[|\\])]*)\\]");
        Matcher m = p.matcher(str);
        return m.find() && m.groupCount() == 1 && (key = m.group(1)).startsWith("sticker") && (stickerIconURL = ChatRoomManager.getStickerURL(str)) != null;
    }

    private static boolean isOneEmoContent(String str) {
        String emotIconURL = ChatRoomManager.getEmoticonLargeURL(str);
        return !TextUtils.isBlank((CharSequence)emotIconURL);
    }

    public static boolean convertAndAppendText(String iText, MsgTextWriter writer) throws UCThreadException {
        String text = iText;
        text = text == null ? "" : text.trim();
        if (MsgTextConverter.isStickerContent(text)) {
            writer.writeStickerIcon(text);
            return true;
        }
        if (MsgTextConverter.isOneEmoContent(text)) {
            writer.writeOneEmoticonIcon(text);
            return true;
        }
        Matcher matcherTag = Utils.PATTERN_TAG.matcher(text);
        int lastIndex = 0;
        while (matcherTag.find()) {
            int s = matcherTag.start();
            int e = matcherTag.end();
            if (lastIndex != s) {
                String prefix = text.substring(lastIndex, s);
                MsgTextConverter.handleTextWebLink(prefix, writer);
            }
            String href = matcherTag.group(1);
            String linkText = matcherTag.group(2);
            String linkUrl = "";
            Matcher matcherLink = Utils.PATTERN_LINK.matcher(href);
            if (matcherLink.find()) {
                linkUrl = matcherLink.group(1);
            }
            linkUrl = linkUrl.replaceAll("'", "");
            linkUrl = linkUrl.replaceAll("\"", "");
            writer.writeLink(linkText, linkUrl);
            lastIndex = e;
        }
        if (lastIndex < text.length()) {
            String finalStr = text.substring(lastIndex);
            MsgTextConverter.handleTextWebLink(finalStr, writer);
        }
        return false;
    }

    private static void handleTextWebLink(String text, MsgTextWriter writer) throws UCThreadException {
        Pattern URL_PATTERN = Utils.HAS_HTTP_PREFIX_URL;
        Matcher mx = URL_PATTERN.matcher(text);
        int lastIndex = 0;
        while (mx.find()) {
            int s = mx.start();
            int e = mx.end();
            String middle = text.substring(s, e);
            if (lastIndex != s) {
                String prefix = text.substring(lastIndex, s);
                MsgTextConverter.handleTextWebLink1(prefix, writer);
            }
            writer.writeLink(middle, middle);
            lastIndex = e;
        }
        if (lastIndex < text.length()) {
            String suffix = text.substring(lastIndex);
            MsgTextConverter.handleTextWebLink1(suffix, writer);
        }
    }

    private static void handleTextWebLink1(String text, MsgTextWriter writer) throws UCThreadException {
        Pattern URL_PATTERN = Utils.HAS_WWW_AS_PREFIX_URL;
        Matcher mx = URL_PATTERN.matcher(text);
        int lastIndex = 0;
        while (mx.find()) {
            int s = mx.start();
            int e = mx.end();
            String prefix = text.substring(lastIndex, s);
            String middle = text.substring(s, e);
            MsgTextConverter.handleTextWebLink2(prefix, writer);
            writer.writeLink(middle, middle);
            lastIndex = e;
        }
        if (lastIndex < text.length()) {
            String suffix = text.substring(lastIndex);
            MsgTextConverter.handleTextWebLink2(suffix, writer);
        }
    }

    private static void handleTextWebLink2(String text, MsgTextWriter writer) throws UCThreadException {
        Pattern URL_PATTERN = Utils.NO_HTTP_PREFIX_URL;
        Matcher mx = URL_PATTERN.matcher(text);
        int lastIndex = 0;
        while (mx.find()) {
            int s = mx.start();
            int e = mx.end();
            String prefix = text.substring(lastIndex, s);
            String middle = text.substring(s, e);
            MsgTextConverter.handleText(prefix, writer);
            writer.writeLink(middle, middle);
            lastIndex = e;
        }
        if (lastIndex < text.length()) {
            String suffix = text.substring(lastIndex);
            MsgTextConverter.handleText(suffix, writer);
        }
    }

    private static void handleText(String text, MsgTextWriter writer) throws UCThreadException {
        int lastIndex = 0;
        Matcher m = Chatroom.PATTERN_EMOTICON.matcher(text);
        while (m.find()) {
            int e;
            int s = m.start();
            String emoticonKey = text.substring(s, e = m.end());
            boolean isHandle = writer.preWriteEmoticonIcon(emoticonKey);
            if (!isHandle) continue;
            if (lastIndex != s) {
                String prefix = text.substring(lastIndex, s);
                MsgTextConverter.handleTextEmoji0(prefix, writer);
            }
            writer.writeEmoticonIcon(emoticonKey);
            lastIndex = e;
        }
        if (lastIndex < text.length()) {
            String suffix = text.substring(lastIndex);
            MsgTextConverter.handleTextEmoji0(suffix, writer);
        }
    }

    private static void handleTextEmoji0(String text, MsgTextWriter writer) throws UCThreadException {
        int lastIndex = 0;
        Matcher mx = Utils.EMOJI_2WORD_PATTERN.matcher(text);
        while (mx.find()) {
            int s = mx.start();
            int e = mx.end();
            String middle = text.substring(s, e);
            int surrogatePairCount = 0;
            for (int i = 1; i < middle.length(); ++i) {
                if (!Character.isSurrogatePair(middle.charAt(i - 1), middle.charAt(i))) continue;
                ++surrogatePairCount;
                ++i;
            }
            int[] acp = new int[middle.length() - surrogatePairCount];
            int j = 0;
            for (int i = 0; i < middle.length(); ++i) {
                char ch1;
                char ch0 = middle.charAt(i);
                if (Character.isHighSurrogate(ch0) && i + 1 < middle.length() && Character.isLowSurrogate(ch1 = middle.charAt(i + 1))) {
                    acp[j++] = Character.toCodePoint(ch0, ch1);
                    ++i;
                    continue;
                }
                acp[j++] = ch0;
            }
            Object codePointStr = "";
            int j2 = 0;
            for (int i = 0; i < acp.length; ++i) {
                if (acp[i] == 65038 || acp[i] == 65039) continue;
                if (j2 != 0) {
                    codePointStr = (String)codePointStr + "-";
                }
                codePointStr = (String)codePointStr + Integer.toHexString(acp[i]);
                ++j2;
            }
            boolean isHandle = writer.preWriteEmojiIcon((String)codePointStr);
            if (!isHandle) continue;
            if (lastIndex != s) {
                String prefix = text.substring(lastIndex, s);
                MsgTextConverter.handleTextEmoji1(prefix, writer);
            }
            writer.writeEmojiIcon((String)codePointStr);
            lastIndex = e;
        }
        if (lastIndex < text.length()) {
            String suffix = text.substring(lastIndex);
            MsgTextConverter.handleTextEmoji1(suffix, writer);
        }
    }

    private static void handleTextEmoji1(String text, MsgTextWriter writer) throws UCThreadException {
        int lastIndex = 0;
        Matcher mx = Utils.EMOJI_PATTERN.matcher(text);
        while (mx.find()) {
            int i;
            int s = mx.start();
            int e = mx.end();
            String middle = text.substring(s, e);
            int surrogatePairCount = 0;
            for (int i2 = 1; i2 < middle.length(); ++i2) {
                if (!Character.isSurrogatePair(middle.charAt(i2 - 1), middle.charAt(i2))) continue;
                ++surrogatePairCount;
                ++i2;
            }
            int[] acp = new int[middle.length() - surrogatePairCount];
            int j = 0;
            for (int i3 = 0; i3 < middle.length(); ++i3) {
                char ch1;
                char ch0 = middle.charAt(i3);
                if (Character.isHighSurrogate(ch0) && i3 + 1 < middle.length() && Character.isLowSurrogate(ch1 = middle.charAt(i3 + 1))) {
                    acp[j++] = Character.toCodePoint(ch0, ch1);
                    ++i3;
                    continue;
                }
                acp[j++] = ch0;
            }
            boolean doHandle = false;
            for (i = 0; i < acp.length; ++i) {
                String codePointStr;
                boolean isHandle;
                if (acp[i] == 65038 || acp[i] == 65039 || !(isHandle = writer.preWriteEmojiIcon(codePointStr = Integer.toHexString(acp[i])))) continue;
                doHandle = true;
            }
            if (!doHandle) continue;
            if (lastIndex != s) {
                String prefix = text.substring(lastIndex, s);
                writer.writeText(prefix);
            }
            for (i = 0; i < acp.length; ++i) {
                if (acp[i] == 65038 || acp[i] == 65039) continue;
                String codePointStr = Integer.toHexString(acp[i]);
                writer.writeEmojiIcon(codePointStr);
            }
            lastIndex = e;
        }
        if (lastIndex < text.length()) {
            String suffix = text.substring(lastIndex);
            writer.writeText(suffix);
        }
    }
}

