/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.tool;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class RoundedPanel
extends JPanel {
    protected int strokeSize = 0;
    private Color strokeColor = Color.GRAY;
    protected Color shadowColor = Color.gray;
    protected boolean shady = false;
    protected boolean highQuality = true;
    protected Dimension arcs = new Dimension(25, 25);
    protected int shadowGap = 5;
    protected int shadowOffset = 4;
    protected int shadowAlpha = 150;

    public RoundedPanel() {
        this.setOpaque(false);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        int shadowGap = this.shadowGap;
        Color shadowColorA = new Color(this.shadowColor.getRed(), this.shadowColor.getGreen(), this.shadowColor.getBlue(), this.shadowAlpha);
        Graphics2D graphics = (Graphics2D)g;
        if (this.highQuality) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.shady) {
            graphics.setColor(shadowColorA);
            graphics.fillRoundRect(this.shadowOffset, this.shadowOffset, width - this.strokeSize - this.shadowOffset, height - this.strokeSize - this.shadowOffset, this.arcs.width, this.arcs.height);
        } else {
            shadowGap = 1;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRoundRect(0, 0, width - shadowGap, height - shadowGap, this.arcs.width, this.arcs.height);
        graphics.setColor(this.strokeColor);
        graphics.setStroke(new BasicStroke(this.strokeSize));
        graphics.drawRoundRect(0, 0, width - shadowGap, height - shadowGap, this.arcs.width, this.arcs.height);
        graphics.setStroke(new BasicStroke());
    }
}

