/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import com.blisscloud.ezuc.client.annotation.MigratedFromMobileApp;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

@MigratedFromMobileApp
public class DateTimeUtil {
    public static boolean is24HoursTime = false;

    public static String getDateTimeStr(long time) {
        SimpleDateFormat formater = new SimpleDateFormat("yyyyMMdd_HHmmss", I18NUtil.getAppLocale());
        return formater.format(new Date(time));
    }

    public static String getBulletinTimeStr(long time) {
        String format = "yyyy/MM/dd HH:mm";
        Locale locale = I18NUtil.getAppLocale();
        if (!is24HoursTime) {
            format = locale.equals(Locale.TAIWAN) || locale.equals(Locale.CHINA) || locale.equals(Locale.CHINESE) ? "yyyy/MM/dd a hh:mm" : "yyyy/MM/dd hh:mm a";
        }
        SimpleDateFormat formater = new SimpleDateFormat(format, locale);
        return formater.format(new Date(time));
    }

    public static String getVoicemailTimeStr(long time) {
        String format = "yyyy/MM/dd HH:mm";
        Locale locale = I18NUtil.getAppLocale();
        if (!is24HoursTime) {
            format = locale.equals(Locale.TAIWAN) || locale.equals(Locale.CHINA) || locale.equals(Locale.CHINESE) ? "yyyy/MM/dd a hh:mm" : "yyyy/MM/dd hh:mm a";
        }
        SimpleDateFormat formater = new SimpleDateFormat(format, locale);
        return formater.format(new Date(time));
    }

    public static String getBirthdayTimeStr(Long time) {
        if (time == null) {
            return null;
        }
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
        return formater.format(new Date(time));
    }

    public static String getBirthdayTimeStr(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
        return formater.format(date);
    }

    public static String getTimeKey(long msgTime) {
        SimpleDateFormat formater2 = new SimpleDateFormat("yyyyMMdd", Locale.US);
        return formater2.format(new Date(msgTime));
    }

    public static String getTimeStr(long msgTime) {
        if (DateTimeUtil.isToday(msgTime)) {
            return I18NUtil.getString("time_today_no_time");
        }
        if (DateTimeUtil.isYesterday(msgTime)) {
            return I18NUtil.getString("time_yesterday_no_time");
        }
        if (DateTimeUtil.isThisYear(msgTime)) {
            SimpleDateFormat formater2 = new SimpleDateFormat("MM/dd", Locale.US);
            String date = formater2.format(new Date(msgTime));
            if (DateTimeUtil.isWeek(msgTime)) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(msgTime);
                int day = cal.get(7);
                if (day == 2) {
                    return String.format(I18NUtil.getString("time_mon_no_time"), date);
                }
                if (day == 3) {
                    return String.format(I18NUtil.getString("time_tue_no_time"), date);
                }
                if (day == 4) {
                    return String.format(I18NUtil.getString("time_wed_no_time"), date);
                }
                if (day == 5) {
                    return String.format(I18NUtil.getString("time_thu_no_time"), date);
                }
                if (day == 6) {
                    return String.format(I18NUtil.getString("time_fri_no_time"), date);
                }
                if (day == 7) {
                    return String.format(I18NUtil.getString("time_sat_no_time"), date);
                }
                if (day == 1) {
                    return String.format(I18NUtil.getString("time_sun_no_time"), date);
                }
            }
            return date;
        }
        SimpleDateFormat formater2 = new SimpleDateFormat("yyyy/MM/dd", Locale.US);
        return formater2.format(new Date(msgTime));
    }

    public static String getTimeStr(long msgTime, boolean fullTime) {
        return DateTimeUtil.getTimeStr(msgTime, fullTime ? 1 : 0);
    }

    public static String getTimeStr(long msgTime, int timeType) {
        String format = "HH:mm";
        Locale locale = I18NUtil.getAppLocale();
        if (!is24HoursTime) {
            format = locale.equals(Locale.TAIWAN) || locale.equals(Locale.CHINA) || locale.equals(Locale.CHINESE) ? "a hh:mm" : "hh:mm a";
        }
        SimpleDateFormat formater = new SimpleDateFormat(format, locale);
        String timeInDay = formater.format(new Date(msgTime));
        if (timeType == 2) {
            return timeInDay;
        }
        if (DateTimeUtil.isToday(msgTime)) {
            return timeInDay;
        }
        if (DateTimeUtil.isYesterday(msgTime)) {
            if (timeType == 1) {
                return String.format(I18NUtil.getString("time_yesterday_with_time"), timeInDay);
            }
            return I18NUtil.getString("time_yesterday_no_time");
        }
        if (DateTimeUtil.isWeek(msgTime)) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(msgTime);
            int day = cal.get(7);
            if (day == 2) {
                if (timeType == 1) {
                    return String.format(I18NUtil.getString("time_mon_with_time"), timeInDay);
                }
                return String.format(I18NUtil.getString("time_mon_with_time"), "").trim();
            }
            if (day == 3) {
                if (timeType == 1) {
                    return String.format(I18NUtil.getString("time_tue_with_time"), timeInDay);
                }
                return String.format(I18NUtil.getString("time_tue_with_time"), "").trim();
            }
            if (day == 4) {
                if (timeType == 1) {
                    return String.format(I18NUtil.getString("time_wed_with_time"), timeInDay);
                }
                return String.format(I18NUtil.getString("time_wed_with_time"), "").trim();
            }
            if (day == 5) {
                if (timeType == 1) {
                    return String.format(I18NUtil.getString("time_thu_with_time"), timeInDay);
                }
                return String.format(I18NUtil.getString("time_thu_with_time"), "").trim();
            }
            if (day == 6) {
                if (timeType == 1) {
                    return String.format(I18NUtil.getString("time_fri_with_time"), timeInDay);
                }
                return String.format(I18NUtil.getString("time_fri_with_time"), "").trim();
            }
            if (day == 7) {
                if (timeType == 1) {
                    return String.format(I18NUtil.getString("time_sat_with_time"), timeInDay);
                }
                return String.format(I18NUtil.getString("time_sat_with_time"), "").trim();
            }
            if (day == 1) {
                if (timeType == 1) {
                    return String.format(I18NUtil.getString("time_sun_with_time"), timeInDay);
                }
                return String.format(I18NUtil.getString("time_sun_with_time"), "").trim();
            }
            return "";
        }
        if (DateTimeUtil.isThisYear(msgTime)) {
            if (timeType == 1) {
                SimpleDateFormat formater2 = new SimpleDateFormat("MM/dd", Locale.US);
                return formater2.format(new Date(msgTime)) + " " + timeInDay;
            }
            SimpleDateFormat formater2 = new SimpleDateFormat("MM/dd", Locale.US);
            return formater2.format(new Date(msgTime));
        }
        if (timeType == 1) {
            SimpleDateFormat formater2 = new SimpleDateFormat("yyyy/MM/dd");
            return formater2.format(new Date(msgTime)) + " " + timeInDay;
        }
        SimpleDateFormat formater2 = new SimpleDateFormat("yyyy/MM/dd");
        return formater2.format(new Date(msgTime));
    }

    private static boolean isToday(long msgTime) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return msgTime >= cal.getTimeInMillis();
    }

    private static boolean isYesterday(long msgTime) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, -1);
        return msgTime >= cal.getTimeInMillis();
    }

    private static boolean isThisYear(long msgTime) {
        Calendar today = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal2.setTimeInMillis(msgTime);
        return today.get(1) == cal2.get(1);
    }

    private static boolean isWeek(long msgTime) {
        Calendar current = Calendar.getInstance();
        int year1 = current.get(1);
        int week1 = current.get(3);
        Calendar c2 = Calendar.getInstance();
        c2.setTimeInMillis(msgTime);
        int year2 = c2.get(1);
        int week2 = c2.get(3);
        return year1 == year2 && week1 == week2;
    }

    public static boolean is24HoursStyle() throws Exception {
        boolean is24Hours = false;
        Locale locale = I18NUtil.getAppLocale();
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            String line;
            Process uptimeProc = Runtime.getRuntime().exec("cmd /c time /t");
            BufferedReader in = new BufferedReader(new InputStreamReader(uptimeProc.getInputStream()));
            while ((line = in.readLine()) != null) {
                String[] xx = line.split(" ");
                if (xx.length != 1) continue;
                is24Hours = true;
            }
        } else if ((os.contains("mac") || os.contains("nix") || os.contains("nux") || os.contains("aix")) && !locale.equals(Locale.TAIWAN) && (locale.equals(Locale.CHINA) || locale.equals(Locale.CHINESE))) {
            is24Hours = true;
        }
        return is24Hours;
    }

    static {
        try {
            is24HoursTime = DateTimeUtil.is24HoursStyle();
        }
        catch (Throwable t) {
            t.printStackTrace();
            is24HoursTime = false;
        }
    }
}

