/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.web.LiteSite;
import com.blisscloud.ezuc.bean.web.LiteTeleNumber;
import com.blisscloud.ezuc.bean.web.LiteTeleNumberType;
import com.blisscloud.ezuc.client.annotation.MigratedFromMobileApp;
import com.blisscloud.ezuc.client.bean.ActionNode;
import com.blisscloud.ezuc.client.bean.ExtenNode;
import com.blisscloud.ezuc.client.bean.Node;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.db.UCDBSite;
import com.blisscloud.mobile.ezuc.manager.SiteManager;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@MigratedFromMobileApp
public class LiteContactHelper {
    public static void initSiteList(Context ctx, ArrayList<String> siteList, ArrayList<Long> siteIdList) {
        List<LiteSite> sites = UCDBSite.getAllSites(ctx);
        if (sites != null) {
            for (LiteSite i : sites) {
                siteList.add(i.getName());
                siteIdList.add(i.getId());
            }
        }
    }

    public static void addExtNoByContact(Context ctx, ArrayList<Node> data, boolean hasDefaultNode, LiteContact contact) {
        String unknown = I18NUtil.getString("common_not_yet_setting");
        ArrayList<String> extList = contact.getExtList();
        boolean empty = true;
        if (extList != null) {
            for (String extItem : extList) {
                String[] contentPair = extItem.split("_", 2);
                if (contentPair != null && contentPair.length == 2) {
                    String sitePrefix = contentPair[0];
                    LiteSite site = SiteManager.getSiteByPrefix(ctx, sitePrefix);
                    String exten = contentPair[1];
                    String label = "";
                    long siteId = -1L;
                    if (site != null) {
                        siteId = site.getId();
                    }
                    label = I18NUtil.getString("abook_extension");
                    ExtenNode ext = null;
                    if (TextUtils.isBlank((CharSequence)exten)) {
                        if (!hasDefaultNode) continue;
                        ext = new ExtenNode(contact.getJid(), label, unknown, true, siteId);
                    } else {
                        ext = new ExtenNode(contact.getJid(), label, exten, false, siteId);
                    }
                    data.add(ext);
                    empty = false;
                    continue;
                }
                empty = true;
                Log.e(LiteContactHelper.class.getSimpleName(), "invalid ext content:" + extItem);
            }
        }
        if (empty && hasDefaultNode) {
            ExtenNode ext = new ExtenNode(contact.getJid(), I18NUtil.getString("abook_extension"), unknown, true, -1L);
            data.add(ext);
        }
    }

    public static ActionNode getActionNode(Context ctx, LiteTeleNumber i, String label, int type, String jid) {
        String number = i.getNumber();
        if (TextUtils.isBlank((CharSequence)number)) {
            return null;
        }
        return new ActionNode(jid, label, number, false, type);
    }

    public static void addTelephonesByContact(Context ctx, List<Node> data, List<LiteTeleNumber> mobile, List<LiteTeleNumber> home, String jid) {
        String mobilelabel = I18NUtil.getString("abook_mobile");
        if (mobile != null && !mobile.isEmpty()) {
            for (LiteTeleNumber i : mobile) {
                ActionNode node = LiteContactHelper.getActionNode(ctx, i, mobilelabel, 3, jid);
                if (node == null) continue;
                data.add(node);
            }
        }
        String homelabel = I18NUtil.getString("abook_home");
        if (home != null && !home.isEmpty()) {
            for (LiteTeleNumber i : home) {
                ActionNode node = LiteContactHelper.getActionNode(ctx, i, homelabel, 4, jid);
                if (node == null) continue;
                data.add(node);
            }
        }
    }

    public static void addTelephonesByMyContact(Context ctx, List<Node> data, List<LiteTeleNumber> office, List<LiteTeleNumber> mobile, List<LiteTeleNumber> home, String jid) {
        String officelabel = I18NUtil.getString("abook_office");
        if (office != null && !office.isEmpty()) {
            for (LiteTeleNumber liteTeleNumber : office) {
                ActionNode node = LiteContactHelper.getActionNode(ctx, liteTeleNumber, officelabel, 2, jid);
                if (node == null) continue;
                data.add(node);
            }
        }
        String mobilelabel = I18NUtil.getString("abook_mobile");
        if (mobile != null && !mobile.isEmpty()) {
            for (LiteTeleNumber i : mobile) {
                ActionNode node = LiteContactHelper.getActionNode(ctx, i, mobilelabel, 3, jid);
                if (node == null) continue;
                data.add(node);
            }
        }
        String string = I18NUtil.getString("abook_home");
        if (home != null && !home.isEmpty()) {
            for (LiteTeleNumber i : home) {
                ActionNode node = LiteContactHelper.getActionNode(ctx, i, string, 4, jid);
                if (node == null) continue;
                data.add(node);
            }
        }
    }

    public static List<LiteTeleNumber> getPhoneDatas(String numbers) {
        ArrayList<LiteTeleNumber> data = new ArrayList<LiteTeleNumber>();
        JSONArray jarr = null;
        try {
            if (TextUtils.isNotBlank((CharSequence)numbers) && (jarr = new JSONArray(numbers)) != null && jarr.length() > 0) {
                int size = jarr.length();
                for (int i = 0; i < size; ++i) {
                    JSONObject obj = (JSONObject)jarr.get(i);
                    LiteTeleNumber temp = new LiteTeleNumber();
                    temp.setNumber(obj.getString("number"));
                    temp.setType(LiteTeleNumberType.valueOf(obj.getString("type")));
                    data.add(temp);
                }
            }
        }
        catch (JSONException e) {
            Log.e(LiteContactHelper.class.getSimpleName(), "getPhoneParams", e);
        }
        return data;
    }

    public static String getNumbers(List<LiteTeleNumber> list) {
        JSONArray jarr = new JSONArray();
        if (list != null && list.size() > 0) {
            for (LiteTeleNumber i : list) {
                JSONObject temp = new JSONObject();
                if (TextUtils.isBlank((CharSequence)i.getNumber()) || i.getType() == null) continue;
                try {
                    temp.put("number", i.getNumber());
                    temp.put("type", i.getType().toString());
                }
                catch (JSONException e) {
                    Log.e(LiteContactHelper.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
                }
                jarr.put(temp);
            }
        }
        return jarr.toString();
    }

    public static String getMatchSite(long site, List<LiteSite> siteList) {
        for (LiteSite i : siteList) {
            if (i.getId() != site) continue;
            return i.getName();
        }
        return "";
    }
}

