/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteCustomer;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.roomimpl.MsgPhoneFormatter;
import com.blisscloud.ezuc.client.component.UCUploadFileChooser;
import com.blisscloud.ezuc.client.emoticons.EmoticonUtils;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ChatRoomUtil;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.FaxUtil;
import com.blisscloud.ezuc.client.util.LastMsg;
import com.blisscloud.ezuc.client.util.MessageContentUtil;
import com.blisscloud.ezuc.client.util.QuoteItem;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.MessageChannel;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.db.UCDBMessageChannel;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.CustomerManager;
import com.blisscloud.mobile.ezuc.manager.MessageChannelManager;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PhoneNoUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class MsgUtil {
    public static long getMsgDuration(Message message) {
        if (message == null) {
            return 0L;
        }
        long msgDuration = message.getDuration();
        if (message.getContent() != null) {
            JSONObject voiceMailJSON = null;
            try {
                voiceMailJSON = new JSONObject(message.getContent());
                msgDuration = voiceMailJSON.optLong("duration", 0L) * 1000L;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return msgDuration;
    }

    public static int getReadCount(Message message) {
        int readCount = 0;
        Long userEmpId = PreferencesUtil.getUserId(UCChatClient.context);
        if (message.getReaderList() != null) {
            String[] readerIdStrList = message.getReaderList().split(",");
            for (int i = 0; readerIdStrList != null && i < readerIdStrList.length; ++i) {
                if (TextUtils.isBlank((CharSequence)readerIdStrList[i])) continue;
                try {
                    long readerEmpId = Long.parseLong(readerIdStrList[i]);
                    if (readerEmpId == userEmpId) continue;
                    ++readCount;
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return readCount;
    }

    public static boolean isSystemMsg(int msgType) {
        return msgType == 201 || msgType == 311 || msgType == 312 || msgType == 313 || msgType == 314 || msgType == 315 || msgType == 316 || msgType == 317 || msgType == 318 || msgType == 213 || msgType == 210 || msgType == 211 || msgType == 212 || msgType == 214 || msgType == 215 || msgType == 216 || msgType == 231 || msgType == 232 || msgType == 233 || msgType == 234 || msgType == 200 || msgType == 251 || msgType == 252 || msgType == 253 || msgType == 254 || msgType == 255 || msgType == 256 || msgType == 257 || msgType == 258 || msgType == 259 || msgType == 261 || msgType == 262 || msgType == 263 || msgType == 264 || msgType == 265 || msgType == 266 || msgType == 267 || msgType == 268 || msgType == 269;
    }

    public static QuoteItem getQuoteItem(Context ctx, Message quoteMsg) {
        if (quoteMsg == null) {
            return null;
        }
        String timeStr = "NA";
        if (quoteMsg.getMsgType() != 20) {
            timeStr = DateTimeUtil.getTimeStr(quoteMsg.getServerTime(), false);
        }
        HashMap<String, LiteContact> contactsMap = new HashMap<String, LiteContact>();
        LastMsg msgInfo = MsgUtil.getLastMsgUtil(ctx, quoteMsg, contactsMap, false, false);
        String ownerName = "";
        if (JidUtil.isAPIUserJid(quoteMsg.getFromJid())) {
            MessageChannel channel = UCDBMessageChannel.getMessageChannelByJid(ctx, quoteMsg.getFromJid());
            ChatRoomInfo roomInfo = ChatRoomManager.getChatRoom(ctx, quoteMsg.getFromJid());
            ownerName = ChatRoomUtil.getMessageChannelRoomTitle(ctx, roomInfo, channel, quoteMsg.getFromJid());
        } else {
            ownerName = ContactManager.getContactFullName(ctx, contactsMap, quoteMsg.getFromJid());
        }
        QuoteItem item = new QuoteItem();
        item.setTime(timeStr);
        item.setOwnerName(ownerName);
        StringBuilder builder = new StringBuilder();
        int msgType = quoteMsg.getMsgType();
        if (msgType == 1 || msgType == 6) {
            builder.append(msgInfo.getDispContent());
            builder.append(" ");
            builder.append(CommonUtil.getDurationMilliSeconds(quoteMsg.getDuration()));
        } else if (msgType == 8) {
            builder.append("[" + I18NUtil.getString("chat_msg_type_location") + "] ");
            String title = quoteMsg.getTitle();
            if (StringUtils.isNotBlank((CharSequence)title)) {
                builder.append(title);
                builder.append(" ");
            }
            builder.append(quoteMsg.getContent());
        } else if (msgType == 5) {
            builder.append(msgInfo.getDispContent());
        } else if (msgType == 4) {
            builder.append(msgInfo.getDispContent());
            long videoDuration = quoteMsg.getDuration();
            builder.append(" ");
            builder.append(CommonUtil.getDurationMilliSeconds(videoDuration));
        } else if (msgType == 11) {
            builder.append(msgInfo.getDispContent());
            long fileSize = quoteMsg.getFileSizeToCal();
            builder.append(" ");
            builder.append(FileUtil.getFileSizeText(fileSize));
        } else if (msgType == 2) {
            String fileExt = quoteMsg.getFileExtension();
            if (UCUploadFileChooser.IMAGE_TYPES.contains(fileExt)) {
                builder.append(msgInfo.getDispContent());
            } else if (UCUploadFileChooser.VIDEO_TYPES.contains(fileExt)) {
                builder.append(msgInfo.getDispContent());
                long videoDuration = quoteMsg.getDuration();
                builder.append(" ");
                builder.append(CommonUtil.getDurationMilliSeconds(videoDuration));
            } else if (UCUploadFileChooser.DOCUMENT_TYPES.contains(fileExt) || UCUploadFileChooser.AUDIO_TYPES.contains(fileExt)) {
                builder.append(msgInfo.getDispContent());
                long fileSize = quoteMsg.getFileSizeToCal();
                builder.append(" ");
                builder.append(FileUtil.getFileSizeText(fileSize));
            }
        } else {
            builder.append(msgInfo.getDispContent());
        }
        item.setMsgContent(builder.toString());
        item.setExtraInfo(quoteMsg.getExtraMsgInfo());
        return item;
    }

    public static LastMsg getLastMsgUtil(Context ctx, Message msg, Map<String, LiteContact> contactCache, boolean isConfRoom, boolean encrypted) {
        if (msg == null) {
            return null;
        }
        int msgType = msg.getMsgType();
        Message.ContentType contentType = msg.getContentType();
        Object content = "";
        boolean showMsgSenderName = false;
        if (msgType == 20) {
            content = "[" + I18NUtil.getString("chat_msg_type_fax_none") + "] ";
        } else if (msgType == 21) {
            content = "[" + I18NUtil.getString("chat_msg_type_fax_in") + "] " + msg.getContent();
        } else if (msgType == 22) {
            String status = FaxUtil.getFaxOutMsg(Integer.parseInt(msg.getStatus()));
            content = "[" + I18NUtil.getString("chat_msg_type_fax_out") + "] " + msg.getContent() + " " + status;
        } else if (msgType == 13 || msgType == 1006) {
            long duration = msg.getDuration();
            try {
                JSONObject obj = new JSONObject(msg.getContent());
                duration = obj.getLong("duration");
            }
            catch (Exception exception) {
                // empty catch block
            }
            content = "[" + I18NUtil.getString("chat_msg_type_recording") + "] " + CommonUtil.getDurationMilliSeconds(duration);
        } else if (msgType == 12 || msgType == 1005) {
            content = "[" + I18NUtil.getString("chat_msg_type_voicemail") + "]";
        } else if (MsgUtil.isSystemMsg(msgType)) {
            content = MessageContentUtil.convertMessage(ctx, msg, contactCache, isConfRoom);
        } else if (msgType == 221) {
            content = MsgPhoneFormatter.convertOutboundTalkingContent(ctx, msg.getContent(), I18NUtil.getString("call_status_dialout"), " ", encrypted);
        } else if (msgType == 223) {
            content = MsgPhoneFormatter.convertInboundTalkingContent(ctx, msg.getContent(), I18NUtil.getString("call_status_dialin"), " ");
        } else if (msgType == 225) {
            content = MsgPhoneFormatter.convertInboundMissCallContent(ctx, msg.getContent(), " ");
        } else if (msgType == 222) {
            content = MsgPhoneFormatter.convertOutboundMissCallContent(ctx, msg.getContent(), " ", encrypted);
        } else if (contentType == Message.ContentType.FILE) {
            showMsgSenderName = true;
            if (msg.getMsgType() == 4) {
                content = "[" + I18NUtil.getString("chat_msg_type_video") + "]";
            } else if (msg.getMsgType() == 5) {
                content = "[" + I18NUtil.getString("chat_msg_type_image") + "]";
            } else {
                String mimeType = msg.getMimeType();
                if (mimeType == null) {
                    mimeType = FileUtil.getFileMimeType(msg.getFileNameForDisp());
                }
                content = mimeType != null && mimeType.startsWith("image/tiff") ? "[" + I18NUtil.getString("chat_msg_type_fax") + "]" : (mimeType != null && mimeType.startsWith("image/") ? "[" + I18NUtil.getString("chat_msg_type_image") + "]" : (mimeType != null && mimeType.startsWith("video/") ? "[" + I18NUtil.getString("chat_msg_type_video") + "]" : "[" + I18NUtil.getString("chat_msg_type_file") + "] " + msg.getFileNameForDisp()));
            }
            if (StringUtils.isNotBlank((CharSequence)msg.getExtraMsgInfo())) {
                content = (String)content + " " + msg.getExtraMsgInfo();
            }
        } else {
            showMsgSenderName = true;
            if (msgType == 1 || msgType == 6) {
                content = "[" + I18NUtil.getString("chat_msg_type_audio") + "]";
            } else if (msgType == 8) {
                content = "[" + I18NUtil.getString("chat_msg_type_location") + "] ";
                content = TextUtils.isNotBlank((CharSequence)msg.getTitle()) ? (String)content + msg.getTitle() : (String)content + msg.getContent();
            } else if (msgType == 9) {
                content = "[" + I18NUtil.getString("chat_msg_type_punchcard") + "] ";
                if (!TextUtils.isEmpty((CharSequence)msg.getContent())) {
                    content = (String)content + msg.getContent();
                }
            } else {
                content = msg.getContent();
                if (EmoticonUtils.isStickerContent((String)content)) {
                    content = "[" + I18NUtil.getString("chat_msg_type_sticker") + "]";
                }
            }
        }
        LastMsg result = new LastMsg();
        result.setContent((String)content);
        result.setShowMsgSenderName(showMsgSenderName);
        return result;
    }

    public static String getFromName(Context ctx, String fromJid, Map<String, LiteContact> contactCache) {
        Object dispName = null;
        if (fromJid == null) {
            return dispName;
        }
        if (JidUtil.isPhoneNumberOld(fromJid)) {
            dispName = JidUtil.trimPhoneNumberOld(fromJid) + " ";
        } else if (JidUtil.isPhoneNumberJid(fromJid)) {
            dispName = JidUtil.trimPhoneNumber(fromJid) + " ";
        } else if (JidUtil.isPhoneNumberJid2(fromJid)) {
            dispName = fromJid;
            String[] keys = fromJid.split("_@@_");
            if (keys != null && keys.length == 2) {
                String siteId = keys[0];
                String phoneNum = keys[1];
                dispName = PhoneNoUtil.getPhoneNumDisp(ctx, siteId, phoneNum);
            }
        } else if (JidUtil.isCustomerJid(fromJid)) {
            LiteCustomer customer = CustomerManager.getCustomerInfo(ctx, JidUtil.convertKey(fromJid));
            if (customer != null) {
                dispName = customer.getNickname();
            }
        } else if (JidUtil.isMyContactJid(fromJid)) {
            long myContactId = JidUtil.trimExternalContactId(fromJid);
            LiteMyContact myContact = UCDBExternalContact.getExternalContactById(ctx, myContactId);
            if (myContact != null) {
                dispName = myContact.getName();
            }
        } else if (JidUtil.isAPIUserJid(fromJid)) {
            MessageChannel channel = UCDBMessageChannel.getMessageChannelByJid(ctx, fromJid);
            dispName = MessageChannelManager.getFullName(ctx, channel, fromJid);
        } else if (JidUtil.isEmployeeJid(fromJid)) {
            dispName = ContactManager.getContactShortName(ctx, contactCache, fromJid);
        } else if (JidUtil.isLocationJid(fromJid)) {
            LiteContact contact = ContactManager.getContact(ctx, contactCache, fromJid);
            dispName = ContactManager.getContactFullName(ctx, contact, fromJid);
        }
        return dispName;
    }
}

