/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteCustomer;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.annotation.MigratedFromMobileApp;
import com.blisscloud.ezuc.client.util.ExImage;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.CustomerKey;
import com.blisscloud.mobile.ezuc.bean.EmpKey;
import com.blisscloud.mobile.ezuc.bean.MessageChannel;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.CustomerManager;
import com.blisscloud.mobile.ezuc.manager.MessageChannelManager;
import com.blisscloud.mobile.ezuc.manager.PhotoType;
import com.blisscloud.mobile.ezuc.util.KeyUtil;
import java.awt.Image;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@MigratedFromMobileApp
public class PhotoCache {
    protected int mMaxCache;
    protected int mClearCount;
    private HashSet<Object> mReferenceSet;
    private Map<Object, ExImage> mThumbnailMap;
    private Image mDefaultImg;
    private Image mNoticeImg;

    protected PhotoCache(int maxcache, int clearCount) {
        this.mMaxCache = maxcache;
        this.mClearCount = clearCount;
        this.mReferenceSet = new HashSet();
        this.mThumbnailMap = new LinkedHashMap<Object, ExImage>(maxcache);
    }

    public synchronized void register(Object obj) {
        if (!this.mReferenceSet.contains(obj)) {
            this.mReferenceSet.add(obj);
        }
        Log.i(this.getClass().getSimpleName(), "register count " + this.mReferenceSet.size() + " obj:" + String.valueOf(obj));
    }

    public synchronized void unregister(Object obj) {
        if (this.mReferenceSet.contains(obj)) {
            this.mReferenceSet.remove(obj);
        }
        Log.i(this.getClass().getSimpleName(), "unregister count" + this.mReferenceSet.size() + "obj :" + String.valueOf(obj));
        if (this.mReferenceSet.isEmpty()) {
            Log.i(this.getClass().getSimpleName(), "unregister destroy ....................................");
            this.destroy();
        }
    }

    public synchronized Image getDefaultImage(Context ctx) {
        if (this.mReferenceSet == null || this.mReferenceSet.isEmpty()) {
            Log.i(this.getClass().getSimpleName(), "getDefaultImage already destory");
            return null;
        }
        if (this.mDefaultImg == null) {
            this.mDefaultImg = UIConstants.ICON_USER_NONAME.getImage();
        }
        return this.mDefaultImg;
    }

    public synchronized Image getNoticeImage(Context ctx) {
        if (this.mReferenceSet == null || this.mReferenceSet.isEmpty()) {
            Log.i(this.getClass().getSimpleName(), "getDefaultImage already destory");
            return null;
        }
        if (this.mNoticeImg == null) {
            this.mNoticeImg = UIConstants.ICON_LOGO64.getImage();
        }
        return this.mNoticeImg;
    }

    public synchronized void clearThumbnail(LiteCustomer customer) {
        ExImage bitMap;
        if (customer != null && (bitMap = this.mThumbnailMap.remove(KeyUtil.genCustomerKey(customer))) != null) {
            bitMap.destroy();
        }
    }

    public synchronized void clearThumbnail(LiteContact contact) {
        ExImage bitMap;
        if (contact != null && (bitMap = this.mThumbnailMap.remove(KeyUtil.genEmpKey(contact))) != null) {
            bitMap.destroy();
        }
    }

    public synchronized void clearThumbnail(LiteMyContact contact) {
        ExImage bitMap;
        if (contact != null && (bitMap = this.mThumbnailMap.remove(contact.getId())) != null) {
            bitMap.destroy();
        }
    }

    public synchronized Image getThumbnail(Context context, LiteContact contact) {
        if (this.mReferenceSet == null || this.mReferenceSet.isEmpty()) {
            Log.i(this.getClass().getSimpleName(), "getThumbnail already destory");
            return null;
        }
        if (contact == null) {
            return null;
        }
        EmpKey empKey = KeyUtil.genEmpKey(contact);
        ExImage exbitmap = null;
        Image bitmap = null;
        if (contact.isPhotoFlag()) {
            if (this.mThumbnailMap.containsKey(empKey)) {
                exbitmap = this.mThumbnailMap.get(empKey);
                bitmap = exbitmap.getImage();
            } else {
                bitmap = ContactManager.getContactPhotoWithType(context, PhotoType.SMALL, empKey);
                if (bitmap != null) {
                    exbitmap = new ExImage(bitmap);
                    this.mThumbnailMap.put(empKey, exbitmap);
                }
            }
        }
        if (bitmap != null) {
            exbitmap.setCount(exbitmap.getCount() + 1);
        }
        return bitmap;
    }

    public synchronized Image getThumbnail(Context ctx, MessageChannel channel) {
        if (this.mReferenceSet == null || this.mReferenceSet.isEmpty()) {
            Log.i(this.getClass().getSimpleName(), "getThumbnail already destory");
            return null;
        }
        if (channel == null) {
            return null;
        }
        Long channelId = channel.getId();
        String jid = channel.getJid();
        ExImage exbitmap = null;
        Image bitmap = null;
        if (channel.isPhotoFlag()) {
            if (this.mThumbnailMap.containsKey(jid)) {
                exbitmap = this.mThumbnailMap.get(jid);
                bitmap = exbitmap.getImage();
            } else {
                bitmap = MessageChannelManager.getPhotoWithRefresh(ctx, channelId);
                if (bitmap != null) {
                    exbitmap = new ExImage(bitmap);
                    this.mThumbnailMap.put(jid, exbitmap);
                }
            }
        }
        if (bitmap != null) {
            exbitmap.setCount(exbitmap.getCount() + 1);
        }
        return bitmap;
    }

    public synchronized void removeReference(Object key) {
        ExImage bitmap = this.mThumbnailMap.get(key);
        if (bitmap != null) {
            bitmap.setCount(bitmap.getCount() - 1);
        }
    }

    public synchronized Image getThumbnail(Context context, LiteCustomer customer) {
        if (this.mReferenceSet == null || this.mReferenceSet.isEmpty()) {
            Log.i(this.getClass().getSimpleName(), "LiteCustomer getThumbnail already destory");
            return null;
        }
        if (customer == null) {
            return null;
        }
        CustomerKey customerKey = KeyUtil.genCustomerKey(customer);
        ExImage exbitmap = null;
        Image bitmap = null;
        if (customer.isPersonalPhoto()) {
            if (this.mThumbnailMap.containsKey(customerKey)) {
                exbitmap = this.mThumbnailMap.get(customerKey);
                bitmap = exbitmap.getImage();
            } else {
                bitmap = CustomerManager.getContactPhotoWithType(context, PhotoType.SMALL, customerKey);
                if (bitmap != null) {
                    exbitmap = new ExImage(bitmap);
                    this.mThumbnailMap.put(customerKey, exbitmap);
                }
            }
        }
        return bitmap;
    }

    public synchronized Image getThumbnail(Context context, LiteMyContact contact) {
        if (this.mReferenceSet == null || this.mReferenceSet.isEmpty()) {
            Log.i(this.getClass().getSimpleName(), "getThumbnail already destory");
            return null;
        }
        if (contact == null) {
            return null;
        }
        Long empKey = contact.getId();
        ExImage exbitmap = null;
        Image bitmap = null;
        if (contact.isPhotoFlag()) {
            if (this.mThumbnailMap.containsKey(empKey)) {
                exbitmap = this.mThumbnailMap.get(empKey);
                bitmap = exbitmap.getImage();
            } else {
                bitmap = ContactManager.getExternalContactPhotoWithType(context, PhotoType.SMALL, empKey);
                if (bitmap != null) {
                    exbitmap = new ExImage(bitmap);
                    this.mThumbnailMap.put(empKey, exbitmap);
                }
            }
        }
        if (bitmap != null) {
            exbitmap.setCount(exbitmap.getCount() + 1);
        }
        return bitmap;
    }

    public synchronized void clearCache() {
        if (this.mThumbnailMap != null && this.mThumbnailMap.size() >= this.mMaxCache) {
            Log.i(this.getClass().getSimpleName(), "cache is rearch max count do clear");
            ArrayList<Object> removeList = new ArrayList<Object>();
            Set<Map.Entry<Object, ExImage>> keyValue = this.mThumbnailMap.entrySet();
            for (Map.Entry<Object, ExImage> entry : keyValue) {
                ExImage exImage = entry.getValue();
                if (exImage.getCount() > 0) continue;
                removeList.add(entry.getKey());
            }
            for (Object e : removeList) {
                ExImage data = this.mThumbnailMap.remove(e);
                if (data == null) continue;
                data.destroy();
            }
            Log.i(this.getClass().getSimpleName(), "cache is rearch max count do clear:" + this.mThumbnailMap.size() + " remove count:" + removeList.size());
        }
    }

    private void clearMap(Map<Object, ExImage> map) {
        if (map == null) {
            return;
        }
        Set<Object> keyset = map.keySet();
        for (Object key : keyset) {
            ExImage bitmap = map.get(key);
            bitmap.destroy();
        }
        map.clear();
        map = null;
    }

    protected void destroy() {
        Log.i(this.getClass().getSimpleName(), "destroy ");
        this.mReferenceSet = null;
        this.clearMap(this.mThumbnailMap);
        this.mThumbnailMap = null;
        if (this.mDefaultImg != null) {
            this.mDefaultImg = null;
        }
        if (this.mNoticeImg != null) {
            this.mNoticeImg = null;
        }
    }
}

