/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import it.sauronsoftware.jave.AudioAttributes;
import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.EncodingAttributes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;

public class PlayAudioUtils {
    public static File getAudioFile(String content, int type) throws FileNotFoundException, IOException {
        Log.d(PlayAudioUtils.class.getSimpleName(), content);
        byte[] data = Base64.decodeBase64((String)content);
        File tempDir = FileUtil.getTempDir();
        File originalFile = new File(tempDir, "playAudio");
        if (originalFile.exists()) {
            originalFile.delete();
        }
        originalFile.createNewFile();
        PlayAudioUtils.writeDataToFile(originalFile, data);
        File audioFile = new File(tempDir, "playAudio.mp3");
        if (audioFile.exists()) {
            audioFile.delete();
        }
        PlayAudioUtils.changeToMp3(originalFile, audioFile);
        if (!audioFile.exists() || audioFile.length() == 0L) {
            audioFile = new File(tempDir, "playAudio.mp3");
            if (audioFile.exists()) {
                audioFile.delete();
            }
            audioFile.createNewFile();
            originalFile.renameTo(audioFile);
        } else {
            originalFile.delete();
        }
        Log.i(PlayAudioUtils.class.getSimpleName(), audioFile.toURI().toString());
        return audioFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDataToFile(File file, byte[] data) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, false);
            fos.write(data);
            fos.flush();
            fos.close();
        }
        catch (Throwable t) {
            Log.e(PlayAudioUtils.class.getSimpleName(), t.getMessage(), t);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void waveToMp3(File source, File target) {
        try {
            AudioAttributes audioAttributes = new AudioAttributes();
            audioAttributes.setCodec("libmp3lame");
            audioAttributes.setBitRate(Integer.valueOf(256000));
            audioAttributes.setChannels(Integer.valueOf(1));
            audioAttributes.setSamplingRate(Integer.valueOf(16000));
            EncodingAttributes encodingAttributes = new EncodingAttributes();
            encodingAttributes.setFormat("mp3");
            encodingAttributes.setAudioAttributes(audioAttributes);
            Encoder encoder = new Encoder();
            encoder.encode(source, target, encodingAttributes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void changeToMp3(File source, File target) {
        AudioAttributes audio = new AudioAttributes();
        Encoder encoder = new Encoder();
        audio.setCodec("libmp3lame");
        EncodingAttributes attrs = new EncodingAttributes();
        attrs.setFormat("mp3");
        attrs.setAudioAttributes(audio);
        audio.setChannels(Integer.valueOf(1));
        try {
            encoder.encode(source, target, attrs);
        }
        catch (Throwable e) {
            Log.e(PlayAudioUtils.class.getSimpleName(), e.getLocalizedMessage());
        }
    }
}

