/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import javax.swing.SwingUtilities;

public class ToastUtil {
    public static final int DURATION_SHORT = 1500;
    public static final int DURATION_LONG = 3500;
    public static final int DURATION_VERY_VERY_LONG = 20000;

    public static void showShort(final String content) {
        Log.i(ToastUtil.class.getSimpleName(), content);
        if (SwingUtilities.isEventDispatchThread()) {
            UCChatClient.getInstance().showToastPanel(content, 1500);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UCChatClient.getInstance().showToastPanel(content, 1500);
                }
            });
        }
    }

    public static void hide() {
        if (SwingUtilities.isEventDispatchThread()) {
            UCChatClient.getInstance().hideToastPanel();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UCChatClient.getInstance().hideToastPanel();
                }
            });
        }
    }

    public static void showLong(final String content) {
        Log.i(ToastUtil.class.getSimpleName(), content);
        if (SwingUtilities.isEventDispatchThread()) {
            UCChatClient.getInstance().showToastPanel(content, 3500);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UCChatClient.getInstance().showToastPanel(content, 3500);
                }
            });
        }
    }

    public static void showErrorShort(final String content) {
        Log.i(ToastUtil.class.getSimpleName(), content);
        if (SwingUtilities.isEventDispatchThread()) {
            UCChatClient.getInstance().showErrorToastPanel(content == null ? I18NUtil.getString("common_title_error") : content, 1500);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UCChatClient.getInstance().showErrorToastPanel(content == null ? I18NUtil.getString("common_title_error") : content, 1500);
                }
            });
        }
    }

    public static void showErrorLong(final String content) {
        Log.i(ToastUtil.class.getSimpleName(), content);
        if (SwingUtilities.isEventDispatchThread()) {
            UCChatClient.getInstance().showErrorToastPanel(content == null ? I18NUtil.getString("common_title_error") : content, 3500);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UCChatClient.getInstance().showErrorToastPanel(content == null ? I18NUtil.getString("common_title_error") : content, 3500);
                }
            });
        }
    }

    public static void show(Context context, final String content, final int type) {
        Log.i(ToastUtil.class.getSimpleName(), content);
        if (SwingUtilities.isEventDispatchThread()) {
            if (type == 10) {
                UCChatClient.getInstance().showToastPanel(content, 1500);
            } else if (type == 20) {
                UCChatClient.getInstance().showToastPanel(content, 3500);
            } else if (type == 30) {
                UCChatClient.getInstance().showToastPanel(content, 20000);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (type == 10) {
                        UCChatClient.getInstance().showToastPanel(content, 1500);
                    } else if (type == 20) {
                        UCChatClient.getInstance().showToastPanel(content, 3500);
                    } else if (type == 30) {
                        UCChatClient.getInstance().showToastPanel(content, 20000);
                    }
                }
            });
        }
    }

    public static void debug(String content) {
        Log.d(ToastUtil.class.getSimpleName(), content);
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
    }

    public static void debug(Context context, String content) {
        Log.d(ToastUtil.class.getSimpleName(), content);
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
    }

    public static void debug(Context context, String content, final int type) {
        Log.d(ToastUtil.class.getSimpleName(), content);
        if (SwingUtilities.isEventDispatchThread()) {
            if (type == 10) {
                // empty if block
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (type == 10) {
                        // empty if block
                    }
                }
            });
        }
    }
}

