/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import com.blisscloud.ezuc.client.util.simulate.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class URLFileSystem {
    private static final Method urlSet;

    public static void main(String[] args) {
    }

    public static String getContents(URL url) {
        try {
            return URLFileSystem.getContents(url.openStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getContents(InputStream is) {
        byte[] buffer = new byte[2048];
        StringBuffer sb = new StringBuffer();
        try {
            int length;
            while ((length = is.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, length));
            }
            return sb.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getContents(File file) {
        try {
            return URLFileSystem.getContents(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(URL src, File dst) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = src.openStream();
            out = new FileOutputStream(dst);
            dst.mkdirs();
            URLFileSystem.copy(in, out);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, bytesRead);
        }
        out.flush();
    }

    public static String getSuffix(URL url) {
        String path = url.getPath();
        int lastDot = path.lastIndexOf(46);
        return lastDot >= 0 ? path.substring(lastDot) : "";
    }

    public static String getSuffix(File file) {
        String path = file.getAbsolutePath();
        int lastDot = path.lastIndexOf(46);
        return lastDot >= 0 ? path.substring(lastDot) : "";
    }

    public URL canonicalize(URL url) {
        return url;
    }

    public boolean canRead(URL url) {
        try {
            URLConnection urlConnection = url.openConnection();
            return urlConnection.getDoInput();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean canWrite(URL url) {
        try {
            URLConnection urlConnection = url.openConnection();
            return urlConnection.getDoOutput();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean canCreate(URL url) {
        return true;
    }

    public boolean isValid(URL url) {
        if (URLFileSystem.exists(url)) {
            return true;
        }
        return this.canCreate(url);
    }

    public static boolean exists(URL url) {
        return URLFileSystem.url2File(url).exists();
    }

    public static boolean mkdirs(URL url) {
        File file = URLFileSystem.url2File(url);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static String getFileName(URL url) {
        if (url == null) {
            return "";
        }
        String path = url.getPath();
        if (path.equals("/")) {
            return "/";
        }
        int lastSep = path.lastIndexOf(47);
        if (lastSep == path.length() - 1) {
            int lastSep2 = path.lastIndexOf(47, lastSep - 1);
            return path.substring(lastSep2 + 1, lastSep);
        }
        return path.substring(lastSep + 1);
    }

    public long getLength(URL url) {
        try {
            URLConnection urlConnection = url.openConnection();
            return urlConnection.getContentLength();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static String getName(URL url) {
        String fileName = URLFileSystem.getFileName(url);
        int firstDot = fileName.lastIndexOf(46);
        return firstDot > 0 ? fileName.substring(0, firstDot) : fileName;
    }

    public String getPath(URL url) {
        return url.getPath();
    }

    public String getPathNoExt(URL url) {
        String path = this.getPath(url);
        int lastSlash = path.lastIndexOf("/");
        int lastDot = path.lastIndexOf(".");
        if (lastDot <= lastSlash) {
            return path;
        }
        return path.substring(0, lastDot);
    }

    public String getPlatformPathName(URL url) {
        return url != null ? url.toString() : "";
    }

    public static URL newFileURL(File file) {
        String filePath = file.getPath();
        if (filePath == null) {
            return null;
        }
        String path = URLFileSystem.sanitizePath(filePath);
        return URLFileSystem.newURL("file", path);
    }

    public static URL newFileURL(String filePath) {
        if (filePath == null) {
            return null;
        }
        String path = URLFileSystem.sanitizePath(filePath);
        return URLFileSystem.newURL("file", path);
    }

    private static String sanitizePath(String path) {
        if (File.separatorChar != '/') {
            path = ((String)path).replace(File.separatorChar, '/');
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return path;
    }

    public static URL newURL(String protocol, String path) {
        return URLFileSystem.newURL(protocol, null, null, -1, path, null, null);
    }

    public static URL newURL(String protocol, String userinfo, String host, int port, String path, String query, String ref) {
        try {
            URL seed = new URL(protocol, "", -1, "");
            String authority = port < 0 ? host : host + ":" + port;
            Object[] args = new Object[]{protocol, host, port, authority, userinfo, path, query, ref};
            urlSet.invoke((Object)seed, args);
            return seed;
        }
        catch (Exception e) {
            Log.e(URLFileSystem.class.getSimpleName(), e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static File url2File(URL url) {
        String path = url.getPath();
        return new File(path);
    }

    public static URL getParent(URL url) {
        File file = URLFileSystem.url2File(url);
        File parentFile = file.getParentFile();
        if (parentFile != null && !file.equals(parentFile)) {
            try {
                return parentFile.toURI().toURL();
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public static void copyDir(File src, File dst) throws IOException {
        File[] files;
        dst.mkdirs();
        for (File file : files = src.listFiles()) {
            if (file.isFile()) {
                URLFileSystem.copyFile(file, new File(dst, file.getName()));
                continue;
            }
            if (!file.isDirectory()) continue;
            URLFileSystem.copyDir(file, new File(dst, file.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File src, File dst) throws IOException {
        FileInputStream inStream = null;
        AbstractInterruptibleChannel in = null;
        FileOutputStream outStream = null;
        AbstractInterruptibleChannel out = null;
        try {
            inStream = new FileInputStream(src);
            in = inStream.getChannel();
            outStream = new FileOutputStream(dst);
            out = outStream.getChannel();
            ((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), (WritableByteChannel)((Object)out));
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    static {
        Class<String> str = String.class;
        try {
            urlSet = URL.class.getDeclaredMethod("set", str, str, Integer.TYPE, str, str, str, str, str);
            urlSet.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException();
        }
    }
}

