/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.bean.web.LiteConferenceUserStatus;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.consts.Consts;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBConf;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.apache.http.client.ClientProtocolException;

public class Utils {
    public static final Pattern HAS_HTTP_PREFIX_URL = Pattern.compile("https?://[[\u4e00-\u9fa5]\\w\\.\\-]+(:[\\d]*)?(/[[\u4e00-\u9fa5]\\w#@%:;$()~_?!\\+\\-\\=\\.\\&]+)*(/?)", 2);
    public static final Pattern NO_HTTP_PREFIX_URL = Pattern.compile("[[\u4e00-\u9fa5]\\w#@%:;$()~_?!\\+\\-\\=\\.\\&]+\\.((areo)|(asia)|(arpa)|(biz)|(com)|(cat)|(coop)|(edu)|(firm)|(gov)|(info)|(int)|(jobs)|(mil)|(museum)|(mobi)|(name)|(nato)|(net)|(nom)|(org)|(post)|(pro)|(store)|(tel)|(travel)|(web)|(xxx)|(ac)|(uk)|(ad)|(ae)|(af)|(ag)|(ai)|(al)|(am)|(an)|(ao)|(aq)|(ar)|(as)|(at)|(au)|(aw)|(ax)|(az)|(ba)|(bb)|(bd)|(be)|(bf)|(bg)|(bh)|(bi)|(bl)|(bj)|(bm)|(bn)|(bo)|(bq)|(br)|(bs)|(bt)|(bv)|(bw)|(by)|(bz)|(ca)|(cc)|(cd)|(cf)|(cg)|(ch)|(ci)|(ck)|(cl)|(cm)|(cn)|(co)|(cr)|(cs)|(cu)|(cv)|(cx)|(cy)|(cz)|(cw)|(dd)|(de)|(dj)|(dk)|(dm)|(do)|(dz)|(ec)|(ee)|(eg)|(eh)|(er)|(es)|(et)|(eu)|(fi)|(fj)|(fk)|(fm)|(fo)|(fr)|(fx)|(ga)|(gb)|(gd)|(ge)|(gf)|(gh)|(gi)|(gg)|(gl)|(gm)|(gn)|(gp)|(gq)|(gr)|(gs)|(gt)|(gu)|(gw)|(gy)|(hk)|(hm)|(hn)|(hr)|(hu)|(ht)|(ic)|(id)|(ie)|(il)|(im)|(in)|(io)|(iq)|(ir)|(is)|(it)|(je)|(jm)|(jo)|(jp)|(ke)|(kg)|(kh)|(ki)|(km)|(kn)|(kp)|(kr)|(kw)|(ky)|(kz)|(la)|(lb)|(lc)|(li)|(lk)|(lr)|(ls)|(lt)|(lu)|(lv)|(ly)|(ma)|(mc)|(md)|(me)|(mg)|(mh)|(mk)|(ml)|(mm)|(mn)|(mo)|(mp)|(mq)|(mr)|(ms)|(mt)|(mu)|(mv)|(mw)|(mx)|(my)|(mz)|(na)|(nc)|(ne)|(nf)|(ng)|(ni)|(nl)|(no)|(np)|(nr)|(nt)|(nu)|(nz)|(om)|(pa)|(pe)|(pf)|(pg)|(ph)|(pk)|(pl)|(pm)|(pn)|(pr)|(ps)|(pt)|(pw)|(py)|(qa)|(re)|(ro)|(rs)|(ru)|(rw)|(sa)|(sb)|(sc)|(sd)|(se)|(sg)|(sh)|(si)|(sj)|(sk)|(sl)|(sm)|(sn)|(so)|(sr)|(ss)|(st)|(su)|(sv)|(sx)|(sy)|(sz)|(tc)|(td)|(tf)|(tg)|(th)|(tj)|(tk)|(tl)|(tm)|(tn)|(to)|(tp)|(tr)|(tt)|(tv)|(tw)|(tz)|(ua)|(ug)|(uk)|(um)|(us)|(uy)|(uz)|(va)|(vc)|(ve)|(vg)|(vi)|(vn)|(vu)|(wf)|(ws)|(xk)|(ye)|(yt)|(yu)|(za)|(zm)|(zr)|(zw))(/[[\u4e00-\u9fa5]\\w#@%:;$()~_?!\\+\\-\\=\\.\\&]+)*(/?)", 2);
    public static final Pattern HAS_WWW_AS_PREFIX_URL = Pattern.compile("www\\.[[\u4e00-\u9fa5]\\w#@%:;$()~_?!\\+\\-\\=\\.\\&]+\\.((areo)|(asia)|(arpa)|(biz)|(com)|(cat)|(coop)|(edu)|(firm)|(gov)|(info)|(int)|(jobs)|(mil)|(museum)|(mobi)|(name)|(nato)|(net)|(nom)|(org)|(post)|(pro)|(store)|(tel)|(travel)|(web)|(xxx)|(ac)|(uk)|(ad)|(ae)|(af)|(ag)|(ai)|(al)|(am)|(an)|(ao)|(aq)|(ar)|(as)|(at)|(au)|(aw)|(ax)|(az)|(ba)|(bb)|(bd)|(be)|(bf)|(bg)|(bh)|(bi)|(bl)|(bj)|(bm)|(bn)|(bo)|(bq)|(br)|(bs)|(bt)|(bv)|(bw)|(by)|(bz)|(ca)|(cc)|(cd)|(cf)|(cg)|(ch)|(ci)|(ck)|(cl)|(cm)|(cn)|(co)|(cr)|(cs)|(cu)|(cv)|(cx)|(cy)|(cz)|(cw)|(dd)|(de)|(dj)|(dk)|(dm)|(do)|(dz)|(ec)|(ee)|(eg)|(eh)|(er)|(es)|(et)|(eu)|(fi)|(fj)|(fk)|(fm)|(fo)|(fr)|(fx)|(ga)|(gb)|(gd)|(ge)|(gf)|(gh)|(gi)|(gg)|(gl)|(gm)|(gn)|(gp)|(gq)|(gr)|(gs)|(gt)|(gu)|(gw)|(gy)|(hk)|(hm)|(hn)|(hr)|(hu)|(ht)|(ic)|(id)|(ie)|(il)|(im)|(in)|(io)|(iq)|(ir)|(is)|(it)|(je)|(jm)|(jo)|(jp)|(ke)|(kg)|(kh)|(ki)|(km)|(kn)|(kp)|(kr)|(kw)|(ky)|(kz)|(la)|(lb)|(lc)|(li)|(lk)|(lr)|(ls)|(lt)|(lu)|(lv)|(ly)|(ma)|(mc)|(md)|(me)|(mg)|(mh)|(mk)|(ml)|(mm)|(mn)|(mo)|(mp)|(mq)|(mr)|(ms)|(mt)|(mu)|(mv)|(mw)|(mx)|(my)|(mz)|(na)|(nc)|(ne)|(nf)|(ng)|(ni)|(nl)|(no)|(np)|(nr)|(nt)|(nu)|(nz)|(om)|(pa)|(pe)|(pf)|(pg)|(ph)|(pk)|(pl)|(pm)|(pn)|(pr)|(ps)|(pt)|(pw)|(py)|(qa)|(re)|(ro)|(rs)|(ru)|(rw)|(sa)|(sb)|(sc)|(sd)|(se)|(sg)|(sh)|(si)|(sj)|(sk)|(sl)|(sm)|(sn)|(so)|(sr)|(ss)|(st)|(su)|(sv)|(sx)|(sy)|(sz)|(tc)|(td)|(tf)|(tg)|(th)|(tj)|(tk)|(tl)|(tm)|(tn)|(to)|(tp)|(tr)|(tt)|(tv)|(tw)|(tz)|(ua)|(ug)|(uk)|(um)|(us)|(uy)|(uz)|(va)|(vc)|(ve)|(vg)|(vi)|(vn)|(vu)|(wf)|(ws)|(xk)|(ye)|(yt)|(yu)|(za)|(zm)|(zr)|(zw))(/[[\u4e00-\u9fa5]\\w#@%:;$()~_?!\\+\\-\\=\\.\\&]+)*(/?)", 2);
    public static final Pattern PATTERN_TAG = Pattern.compile("(?i)<a([^>]+)>(.+?)</a>", 2);
    public static final Pattern PATTERN_LINK = Pattern.compile("\\s*(?i)href\\s*=\\s*(\"([^\"]*\")|'[^']*'|([^'\">\\s]+))", 2);
    public static final Pattern EMOJI_PATTERN = Pattern.compile("[\ud83c\udffb-\ud83c\udfff]|[\ufe0e]|[\ufe0f]|[\ud83c\udde6-\ud83c\uddff]|[\ud83d\ude00-\ud83d\ude4f]|[\u2700-\u27bf]|[\ud83d\ude80-\ud83d\udec0]|[\u2460-\u24ff]|[\ud83c\udd70-\ud83c\uddff]|[\ud83c\ude00-\ud83c\udeff]|[\u0080-\u00ff]|[\u2000-\u206f]|[\u2100-\u214f]|[\u2190-\u21ff]|[\u2300-\u23ff]|[\u25a0-\u25ff]|[\u2500-\u26ff]|[\u2900-\u297f]|[\u2b00-\u2bff]|[\u3000-\u303f]|[\u3200-\u32ff]|[\ud83c\udc00-\ud83c\udc2f]|[\ud83c\udca0-\ud83c\udcff]|[\ud83c\udf00-\ud83d\uddff]|[\u2100-\u214f]|[\u2190-\u21ff]|[\u25a0-\u25ff]|[\u2300-\u23ff]|[\u2000-\u206f]|[\ud83d\ude01-\ud83d\udeff]|[\ud83d\ude81-\ud83d\udec5]|[\ud83c\udf0d-\ud83d\udd67]|[\ud83e\udd01-\ud83e\uddff]", 66);
    public static final Pattern EMOJI_2WORD_PATTERN = Pattern.compile(Consts.EMOJI_2WORD, 66);

    public static void sendMail(String address) {
        if (TextUtils.isNotBlank((CharSequence)address)) {
            try {
                Desktop.getDesktop().mail(new URI("mailto:" + address));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    public static String convertKey(String key) {
        if (key == null) {
            return key;
        }
        if (!key.contains("@")) {
            return key;
        }
        String[] sp = key.split("@");
        return sp[0];
    }

    public static void doAddMyFavorite(Context ctx, String id, int type) {
        if (ctx != null && TextUtils.isNotBlank((CharSequence)id)) {
            if (!WebAgent.isLogin) {
                ToastUtil.showErrorShort(String.format(I18NUtil.getString("network_server_connect_fail_try_later"), I18NUtil.getAppName()));
                return;
            }
            WebAgent.getInstance().addFavorite(id, type);
        }
    }

    public static void doRemoveMyFavorite(Context ctx, String id, int type) {
        if (ctx != null && TextUtils.isNotBlank((CharSequence)id)) {
            if (!WebAgent.isLogin) {
                ToastUtil.showErrorShort(String.format(I18NUtil.getString("network_server_connect_fail_try_later"), I18NUtil.getAppName()));
                return;
            }
            WebAgent.getInstance().removeFavorite(id, type);
        }
    }

    public static void startChatConference(Activity act, final String jid, String role) {
        if (TextUtils.isNotBlank((CharSequence)jid)) {
            Intent intent = new Intent("com.blisscloud.mobile.ezphone.chatroom");
            Bundle bundle = new Bundle();
            bundle.putString("chatId", jid);
            if (TextUtils.isNotBlank((CharSequence)role)) {
                bundle.putString("role", role);
            }
            intent.putExtras(bundle);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UCChatClient.getInstance().getMainPanel().showChatroom(jid);
                }
            });
        } else {
            Log.e(Utils.class.getSimpleName(), "Invalid parameters for chat!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fetchDownloadURL(String url) {
        String result = null;
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)new URL(url).openConnection();
            con.setInstanceFollowRedirects(false);
            con.connect();
            int responseCode = con.getResponseCode();
            Log.i(Utils.class.getSimpleName(), "responseCode:" + responseCode);
            result = con.getHeaderField("Location");
            Log.i(Utils.class.getSimpleName(), "location:" + result);
        }
        catch (UnsupportedEncodingException e) {
            Log.e(Utils.class.getSimpleName(), "fetchDownloadURL", e);
        }
        catch (ClientProtocolException e) {
            Log.e(Utils.class.getSimpleName(), "fetchDownloadURL", e);
        }
        catch (IOException e) {
            Log.e(Utils.class.getSimpleName(), "fetchDownloadURL", e);
        }
        finally {
            if (con != null) {
                con.disconnect();
                con = null;
            }
        }
        return result;
    }

    public static List<Object> doFilterContactData(List<Object> dataList, String searchKey) {
        ArrayList<Object> data = new ArrayList<Object>();
        if (TextUtils.isBlank((CharSequence)searchKey)) {
            if (dataList != null) {
                data.addAll(dataList);
            }
            return data;
        }
        searchKey = searchKey.trim().toUpperCase();
        String regex = String.format(".*%s.*", searchKey);
        if (dataList != null) {
            for (Object i : dataList) {
                LiteConferenceRoom confRoom;
                boolean match;
                String name;
                Object contact;
                if (i instanceof LiteContact) {
                    contact = (LiteContact)i;
                    name = ContactManager.getContactFullName((LiteContact)contact).toUpperCase();
                    match = name.matches(regex);
                    if (!match) continue;
                    data.add(contact);
                    continue;
                }
                if (i instanceof LiteMyContact) {
                    contact = (LiteMyContact)i;
                    name = ((LiteMyContact)contact).getName().toUpperCase();
                    match = name.matches(regex);
                    if (!match) continue;
                    data.add(contact);
                    continue;
                }
                if (!(i instanceof LiteConferenceRoom) || !(match = (name = (confRoom = (LiteConferenceRoom)i).getName().toUpperCase()).matches(regex))) continue;
                data.add(confRoom);
            }
        }
        return data;
    }

    public static void clearFolder(File dir) {
        if (dir.exists()) {
            File[] lists;
            for (File f : lists = dir.listFiles()) {
                f.delete();
            }
            dir.delete();
        }
    }

    public static void closeStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                Log.e(Utils.class.getSimpleName(), "closeStream", e);
            }
            finally {
                in = null;
            }
        }
    }

    public static void closeStream(OutputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                Log.e(Utils.class.getSimpleName(), "closeStream", e);
            }
            finally {
                in = null;
            }
        }
    }

    public static Map<String, Integer> getConferenceRoomCount(Context ctx, Map<String, LiteConferenceRoom> chatRoomConfRoomMap, Map<String, List<String>> participantJidMap, Map<String, LiteContact> contactsMap) {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        HashSet<Long> confRoomIdSet = new HashSet<Long>();
        for (String key : chatRoomConfRoomMap.keySet()) {
            LiteConferenceRoom conf = chatRoomConfRoomMap.get(key);
            confRoomIdSet.add(conf.getRoomId());
        }
        Map<Long, List<LiteConferenceUserStatus>> meetmeUsersMap = UCDBConf.getConfRoomUsersByRoomIdSet(ctx, confRoomIdSet);
        for (String chatRoomJid : chatRoomConfRoomMap.keySet()) {
            LiteConferenceRoom conf = chatRoomConfRoomMap.get(chatRoomJid);
            int count = 0;
            HashSet<Long> employeeSet = new HashSet<Long>();
            List<LiteConferenceUserStatus> meetmeUsers = meetmeUsersMap.get(conf.getRoomId());
            if (meetmeUsers != null) {
                count += meetmeUsers.size();
            }
            for (int i = 0; meetmeUsers != null && i < meetmeUsers.size(); ++i) {
                LiteConferenceUserStatus meetmeUser = meetmeUsers.get(i);
                if (meetmeUser.getCallerDbId() == null || meetmeUser.getCallerDbId().length() <= 0 || !meetmeUser.getCallerType().equals("EMPLOYEE") || meetmeUser.getCallerDbId() == null) continue;
                employeeSet.add(Long.parseLong(meetmeUser.getCallerDbId()));
            }
            List<String> participants = participantJidMap.get(chatRoomJid);
            for (int i = 0; participants != null && i < participants.size(); ++i) {
                String jid = participants.get(i);
                LiteContact contact = contactsMap.get(jid);
                if (contact == null || employeeSet.contains(contact.getId())) continue;
                ++count;
            }
            countMap.put(chatRoomJid, count);
        }
        return countMap;
    }

    public static int getConferenceRoomCount(Context context, Long conferenceRoomId, String chatRoomId) {
        HashSet<Long> employeeSet = new HashSet<Long>();
        int count = 0;
        List<LiteConferenceUserStatus> meetmeUsers = MeetmeManager.getMeetmeUserList(context, conferenceRoomId);
        if (meetmeUsers != null) {
            count += meetmeUsers.size();
        }
        for (int i = 0; meetmeUsers != null && i < meetmeUsers.size(); ++i) {
            LiteConferenceUserStatus meetmeUser = meetmeUsers.get(i);
            if (meetmeUser.getCallerDbId() == null || meetmeUser.getCallerDbId().length() <= 0 || !meetmeUser.getCallerType().equals("EMPLOYEE") || meetmeUser.getCallerDbId() == null) continue;
            employeeSet.add(Long.parseLong(meetmeUser.getCallerDbId()));
        }
        ArrayList<String> participants = UCDBChatRoom.findChatRoomParticipants(context, chatRoomId);
        Map<String, LiteContact> contactsMap = UCDBContact.findAllRelatedContactsByJid(context, chatRoomId);
        if (participants != null) {
            for (int i = 0; i < participants.size(); ++i) {
                String jid = participants.get(i);
                LiteContact contact = contactsMap.get(jid);
                if (contact == null) {
                    Log.i(Utils.class.getSimpleName(), "chatRoomId:" + chatRoomId + ", jid:" + jid + ", contact: " + String.valueOf(contact));
                    continue;
                }
                if (employeeSet.contains(contact.getId())) continue;
                ++count;
            }
        }
        return count;
    }

    public static String twoDigitString(int number) {
        if (number == 0) {
            return "00";
        }
        if (number / 10 == 0) {
            return "0" + number;
        }
        return String.valueOf(number);
    }

    public static boolean checkFileExist(String fileRoot, String fileFolder, String fileName) {
        File file;
        File dir = new File(fileRoot, fileFolder);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                return false;
            }
        } else {
            String[] files;
            for (String i : files = dir.list()) {
                Log.i(Utils.class.getSimpleName(), "checkFileExist:" + i);
            }
        }
        return (file = new File(dir, fileName)).exists();
    }
}

