/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.annotation.MigratedFromMobileApp;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.PackageInfo;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.VersionCheckUtils;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.AppConstUtil;
import com.blisscloud.mobile.ezuc.util.ICheckCompleteListener;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.mobile.ezuc.util.RequestHelperBase;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@MigratedFromMobileApp
public class VersionCheckHelper
extends RequestHelperBase {
    public VersionCheckHelper(Context ctx, String enterpriseNo, ICheckCompleteListener listener) {
        super(ctx, enterpriseNo, "https://%s", "/ucds/mobileAppVersion/getAvailableVersion", VersionCheckHelper.getJOParam(ctx), VersionCheckHelper.getPostParam(), listener, true);
    }

    @Override
    public void onRequestCompleted(String result) {
        String languageField = "changeLogEn";
        Locale locale = I18NUtil.getAppLocale();
        if (Locale.TAIWAN.equals(locale)) {
            languageField = "changeLogTw";
        } else if (Locale.CHINA.equals(locale) || Locale.CHINESE.equals(locale)) {
            languageField = "changeLogCn";
        }
        Bundle data = VersionCheckHelper.parseVersionCheckResult(result, languageField);
        ICheckCompleteListener listener = this.getListener();
        if (listener != null) {
            listener.onCheckCompleted(data, 0);
        }
    }

    public static Bundle parseVersionCheckResult(String reuslt, String field) {
        Log.i(VersionCheckHelper.class.getSimpleName(), " parseResult " + reuslt);
        JSONObject obj = null;
        Bundle versionInfo = new Bundle();
        try {
            if (TextUtils.isBlank((CharSequence)reuslt)) {
                versionInfo.putBoolean("error", true);
            } else {
                obj = new JSONObject(reuslt);
                int retCode = obj.getInt("returnCode");
                if (retCode == 0) {
                    JSONArray jArr = obj.getJSONArray("returnData");
                    if (jArr.length() > 0) {
                        Log.i(VersionCheckHelper.class.getSimpleName(), " jArr " + jArr.length());
                        JSONObject json = (JSONObject)jArr.get(0);
                        String version = json.getString("versionName");
                        String url = json.optString("downloadUrl", null);
                        String filesize = json.optString("fileSize", "0");
                        String urlForMac = json.optString("downloadUrlForMac", null);
                        String filesizeForMac = json.optString("fileSizeForMac", "0");
                        String urlForArm64 = json.optString("downloadUrlForArm64", null);
                        String filesizeForArm64 = json.optString("fileSizeForArm64", "0");
                        String details = "";
                        if (json.has(field)) {
                            details = json.getString(field);
                        }
                        String releasedate = json.getString("releaseDate");
                        int versionCode = json.getInt("versionCode");
                        versionInfo.putString("versionName", version);
                        versionInfo.putString("downloadUrl", url);
                        versionInfo.putString("fileSize", filesize);
                        versionInfo.putString("downloadUrlForMac", urlForMac);
                        versionInfo.putString("fileSizeForMac", filesizeForMac);
                        versionInfo.putString("downloadUrlForArm64", urlForArm64);
                        versionInfo.putString("fileSizeForArm64", filesizeForArm64);
                        versionInfo.putString("details", details);
                        versionInfo.putString("releaseDate", releasedate);
                        versionInfo.putInt("versionCode", versionCode);
                    }
                } else {
                    Log.e(VersionCheckHelper.class.getSimpleName(), " parseVersionCheckResult failed:" + retCode);
                    versionInfo.putBoolean("inputerror", true);
                }
            }
        }
        catch (JSONException e) {
            Log.e(VersionCheckHelper.class.getSimpleName(), " parseVersionCheckResult failed:" + e.getLocalizedMessage(), e);
            versionInfo.putBoolean("inputerror", true);
        }
        return versionInfo;
    }

    private static JSONObject getJOParam(Context ctx) {
        JSONObject jo = new JSONObject();
        try {
            jo.put("appType", PreferencesUtil.getInt(ctx, "APPTYPE", 0));
            jo.put("deviceName", PreferencesUtil.getString(ctx, "DEVICENAME", ""));
            jo.put("deviceOs", PreferencesUtil.getString(ctx, "DEVICEOS", ""));
            jo.put("deviceUniqueId", PreferencesUtil.getString(ctx, "DEVICEID", ""));
            jo.put("macAddr", PreferencesUtil.getString(ctx, "MACADDRESS", ""));
            jo.put("account", PreferencesUtil.getLoginID(ctx));
            PackageInfo versioninfo = VersionCheckUtils.getVersionInfo(UCChatClient.context);
            jo.put("appVersionCode", versioninfo.getVersionCode());
            AppConstUtil.addExtraVersionCheckParam(jo);
        }
        catch (JSONException e) {
            Log.e(VersionCheckHelper.class.getSimpleName(), "getJOParam", e);
        }
        return jo;
    }

    private static HashMap<String, String> getPostParam() {
        Locale locale = I18NUtil.getAppLocale();
        String language = "en";
        if (Locale.TAIWAN.equals(locale)) {
            language = "tw";
        } else if (Locale.CHINA.equals(locale) || Locale.CHINESE.equals(locale)) {
            language = "cn";
        }
        HashMap<String, String> postParams = new HashMap<String, String>(1);
        postParams.put("changeLogLanguage", language);
        return postParams;
    }
}

