/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util.simulate.sqlite;

import com.blisscloud.ezuc.client.annotation.SimulateAndroid;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.ezuc.client.util.simulate.Pair;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@SimulateAndroid(androidClassName="android.database.sqlite.SQLiteDatabase")
public class SQLiteDatabaseImpl
implements SQLiteDatabase {
    Connection connection;
    boolean readonly;
    Map<String, PreparedStatement> psMap = new HashMap<String, PreparedStatement>();

    public SQLiteDatabaseImpl(String databaseURL, Properties prop, boolean readonly) throws Exception {
        this.connection = DriverManager.getConnection("jdbc:hsqldb:file:" + databaseURL, prop);
        this.readonly = readonly;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void close() {
    }

    @Override
    public void closeDatabase() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            Log.e(SQLiteDatabaseImpl.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void beginTransaction() {
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            Log.e(SQLiteDatabaseImpl.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void endTransaction() {
        try {
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            Log.e(SQLiteDatabaseImpl.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    public void setTransactionSuccessful() {
    }

    @Override
    public void execSQL(String sql) {
        try {
            Statement statement = this.connection.createStatement(1004, 1008);
            statement.setQueryTimeout(30);
            statement.execute(sql);
            statement.close();
        }
        catch (SQLException e) {
            Log.e(SQLiteDatabaseImpl.class.getSimpleName(), "execSQL failed: " + sql, e);
        }
    }

    private PreparedStatement createPreparedStatement(String sql) {
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareStatement(sql, 1004, 1008);
            statement.setQueryTimeout(30);
        }
        catch (SQLException e) {
            Log.e(SQLiteDatabaseImpl.class.getSimpleName(), "createaPreparedStatement failed: " + sql, e);
        }
        return statement;
    }

    @Override
    public Cursor rawQuery(String sql, String[] selectionArgs) {
        try {
            PreparedStatement statement = this.createPreparedStatement(sql);
            if (selectionArgs != null) {
                for (int i = 0; i < selectionArgs.length; ++i) {
                    statement.setString(i + 1, selectionArgs[i]);
                }
            }
            ResultSet rs = statement.executeQuery();
            return new Cursor(statement, rs);
        }
        catch (Exception e) {
            Log.e(SQLiteDatabaseImpl.class.getSimpleName(), "--- rawQuery failed: " + sql, e);
            return null;
        }
    }

    public Cursor query(String table, String selection, String[] selectionArgs) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM ").append(table);
        if (TextUtils.isNotBlank((CharSequence)selection)) {
            sb.append(" WHERE ").append(selection);
        }
        String sql = sb.toString();
        try {
            PreparedStatement statement = this.createPreparedStatement(sql);
            if (selectionArgs != null) {
                for (int i = 0; i < selectionArgs.length; ++i) {
                    statement.setString(i + 1, selectionArgs[i]);
                }
            }
            ResultSet rs = statement.executeQuery();
            return new Cursor(statement, rs);
        }
        catch (Exception e) {
            Log.e(SQLiteDatabaseImpl.class.getSimpleName(), "--- query failed: " + sql, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long queryNumEntries(String table, String selection, String[] selectionArgs) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT count(*) FROM ").append(table);
        if (TextUtils.isNotBlank((CharSequence)selection)) {
            sb.append(" WHERE ").append(selection);
        }
        String sql = sb.toString();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.createPreparedStatement(sql);
            if (selectionArgs != null) {
                for (int i = 0; i < selectionArgs.length; ++i) {
                    statement.setString(i + 1, selectionArgs[i]);
                }
            }
            if ((rs = statement.executeQuery()) != null && rs.first()) {
                long i = rs.getLong(1);
                return i;
            }
        }
        catch (Exception e) {
            Log.e(SQLiteDatabaseImpl.class.getSimpleName(), "--- query failed: " + sql, e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                Log.e(SQLiteDatabaseImpl.class.getSimpleName(), "--- query failed: " + sql, e);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                Log.e(SQLiteDatabaseImpl.class.getSimpleName(), "--- query failed: " + sql, e);
            }
        }
        return 0L;
    }

    @Override
    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, null);
    }

    @Override
    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.query(false, table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    @Override
    public Cursor query(boolean distinct, String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append(distinct ? "DISTINCT " : "").append(SQLiteDatabaseImpl.getColumns(columns)).append(" FROM ").append(table);
        if (TextUtils.isNotBlank((CharSequence)selection)) {
            sb.append(" WHERE ").append(selection);
        }
        if (TextUtils.isNotBlank((CharSequence)groupBy)) {
            sb.append(" GROUP BY ").append(groupBy);
        }
        if (TextUtils.isNotBlank((CharSequence)having)) {
            sb.append(" HAVING ").append(having);
        }
        if (TextUtils.isNotBlank((CharSequence)orderBy)) {
            sb.append(" ORDER BY ").append(orderBy);
        }
        if (TextUtils.isNotBlank((CharSequence)limit)) {
            sb.append(" LIMIT ").append(limit);
        }
        String sql = sb.toString();
        try {
            PreparedStatement statement = this.createPreparedStatement(sql);
            if (selectionArgs != null) {
                for (int i = 0; i < selectionArgs.length; ++i) {
                    statement.setString(i + 1, selectionArgs[i]);
                }
            }
            ResultSet rs = statement.executeQuery();
            return new Cursor(statement, rs);
        }
        catch (Exception e) {
            Log.e(SQLiteDatabaseImpl.class.getSimpleName(), "--- query failed: " + sql, e);
            return null;
        }
    }

    @Override
    public long update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ").append(table).append(" SET ").append(SQLiteDatabaseImpl.getEntries(values));
        if (TextUtils.isNotBlank((CharSequence)whereClause)) {
            sb.append(" WHERE ").append(whereClause);
        }
        String sql = sb.toString();
        try {
            PreparedStatement statement = this.createPreparedStatement(sql);
            int index = 1;
            if (values != null) {
                List<Pair> keyList = values.getValues();
                for (int i = 0; keyList != null && i < keyList.size(); ++i) {
                    Pair p = keyList.get(i);
                    String key = p.getKey();
                    Object value = p.getValue();
                    if (value instanceof String) {
                        statement.setString(index, (String)value);
                    } else if (value instanceof Long) {
                        statement.setLong(index, (Long)value);
                    } else if (value instanceof Integer) {
                        statement.setInt(index, (Integer)value);
                    } else if (value instanceof Boolean) {
                        statement.setBoolean(index, (Boolean)value);
                    } else if (value instanceof Float) {
                        statement.setFloat(index, ((Float)value).floatValue());
                    } else if (value instanceof Byte) {
                        statement.setByte(index, (Byte)value);
                    } else if (value instanceof Double) {
                        statement.setDouble(index, (Double)value);
                    } else if (value instanceof byte[]) {
                        statement.setBytes(index, (byte[])value);
                    } else {
                        statement.setObject(index, value);
                    }
                    ++index;
                }
            }
            if (whereArgs != null) {
                for (int i = 0; i < whereArgs.length; ++i) {
                    statement.setString(index, whereArgs[i]);
                    ++index;
                }
            }
            return statement.executeUpdate();
        }
        catch (Exception e) {
            Log.e(SQLiteDatabaseImpl.class.getSimpleName(), "--- query failed: " + sql, e);
            return -1L;
        }
    }

    @Override
    public long insert(String table, String nullColumnHack, ContentValues values) {
        StringBuilder sb = new StringBuilder();
        if (values == null || values.size() == 0) {
            sb.append("INSERT INTO ").append(table).append(" (").append(nullColumnHack).append(") VALUES (NULL)");
        } else {
            sb.append("INSERT INTO ").append(table).append(" (").append(SQLiteDatabaseImpl.getColumns(values.getValues())).append(") VALUES (").append(SQLiteDatabaseImpl.getValues(values.getValues())).append(")");
        }
        String sql = sb.toString();
        try {
            PreparedStatement statement = this.createPreparedStatement(sql);
            if (values != null) {
                for (int i = 0; i < values.getValues().size(); ++i) {
                    Pair p = values.getValues().get(i);
                    Object value = p.getValue();
                    if (value == null) {
                        statement.setObject(i + 1, null);
                        continue;
                    }
                    if (value instanceof String) {
                        statement.setString(i + 1, (String)value);
                        continue;
                    }
                    if (value instanceof Long) {
                        statement.setLong(i + 1, (Long)value);
                        continue;
                    }
                    if (value instanceof Integer) {
                        statement.setInt(i + 1, (Integer)value);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        statement.setBoolean(i + 1, (Boolean)value);
                        continue;
                    }
                    if (value instanceof Float) {
                        statement.setFloat(i + 1, ((Float)value).floatValue());
                        continue;
                    }
                    if (value instanceof Byte) {
                        statement.setByte(i + 1, (Byte)value);
                        continue;
                    }
                    if (value instanceof Double) {
                        statement.setDouble(i + 1, (Double)value);
                        continue;
                    }
                    if (value instanceof byte[]) {
                        statement.setBytes(i + 1, (byte[])value);
                        continue;
                    }
                    statement.setObject(i + 1, value);
                }
            }
            return statement.executeUpdate();
        }
        catch (Exception e) {
            Log.e(SQLiteDatabaseImpl.class.getSimpleName(), "--- query failed: " + sql, e);
            return -1L;
        }
    }

    @Override
    public long insertOrThrow(String table, String nullColumnHack, ContentValues values) throws SQLException {
        StringBuilder sb = new StringBuilder();
        if (values == null || values.size() == 0) {
            sb.append("INSERT INTO ").append(table).append(" (").append(nullColumnHack).append(") VALUES (NULL)");
        } else {
            sb.append("INSERT INTO ").append(table).append(" (").append(SQLiteDatabaseImpl.getColumns(values.getValues())).append(") VALUES (").append(SQLiteDatabaseImpl.getValues(values.getValues())).append(")");
        }
        String sql = sb.toString();
        PreparedStatement statement = this.createPreparedStatement(sql);
        if (values != null) {
            for (int i = 0; i < values.getValues().size(); ++i) {
                Pair p = values.getValues().get(i);
                Object value = p.getValue();
                if (value instanceof String) {
                    statement.setString(i + 1, (String)value);
                    continue;
                }
                if (value instanceof Long) {
                    statement.setLong(i + 1, (Long)value);
                    continue;
                }
                if (value instanceof Integer) {
                    statement.setInt(i + 1, (Integer)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    statement.setBoolean(i + 1, (Boolean)value);
                    continue;
                }
                if (value instanceof Float) {
                    statement.setFloat(i + 1, ((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Byte) {
                    statement.setByte(i + 1, (Byte)value);
                    continue;
                }
                if (value instanceof Double) {
                    statement.setDouble(i + 1, (Double)value);
                    continue;
                }
                if (value instanceof byte[]) {
                    statement.setBytes(i + 1, (byte[])value);
                    continue;
                }
                statement.setObject(i + 1, value);
            }
        }
        return statement.executeUpdate();
    }

    @Override
    public int delete(String table, String whereClause, String[] whereArgs) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ").append(table);
        if (TextUtils.isNotBlank((CharSequence)whereClause)) {
            sb.append(" WHERE ").append(whereClause);
        }
        String sql = sb.toString();
        try {
            PreparedStatement statement = this.createPreparedStatement(sql);
            if (whereArgs != null) {
                for (int i = 0; i < whereArgs.length; ++i) {
                    statement.setString(i + 1, whereArgs[i]);
                }
            }
            return statement.executeUpdate();
        }
        catch (Exception e) {
            Log.e(SQLiteDatabaseImpl.class.getSimpleName(), "--- delete failed: " + sql, e);
            return -1;
        }
    }

    private static String getEntries(ContentValues values) {
        StringBuilder sb = new StringBuilder();
        List<Pair> keyList = values.getValues();
        for (int i = 0; keyList != null && i < keyList.size(); ++i) {
            Pair p = keyList.get(i);
            if (i != 0) {
                sb.append(',');
            }
            sb.append(p.getKey()).append("= ?");
        }
        return sb.toString();
    }

    private static String getColumns(String[] columns) {
        if (columns == null) {
            return " * ";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            sb.append(columns[i]);
            if (i + 1 >= columns.length) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private static String getColumns(List<Pair> columns) {
        if (columns == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Pair p = columns.get(i);
            sb.append(p.getKey());
            if (i + 1 >= size) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private static String getValues(List<Pair> values) {
        StringBuilder sb = new StringBuilder();
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            sb.append("?");
            if (i + 1 >= size) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

