/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.wechat;

import com.blisscloud.ezuc.bean.LiteCustomer;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.component.UCPopupWindow;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.ezuc.client.wechat.WechatLevelPopup;
import com.blisscloud.ezuc.client.wechat.WechatLevelPopupCallback;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.manager.CustomerManager;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class WechatInfoPopup
extends UCPopupWindow
implements WechatLevelPopupCallback {
    private JPanel panelContent;
    private JPanel panelTitle;
    private JPanel panelLevel;
    private JLabel lblServname;
    private JLabel lblLevel;
    private JLabel lblStatusHeader;
    private JLabel lblStatus;
    private JLabel lblGenderHeader;
    private JLabel lblGender;
    private JLabel lblLocationHeader;
    private JLabel lblLocation;
    private JLabel lblLanguageHeader;
    private JLabel lblLanguage;
    private JLabel lblCreateTimeHeader;
    private JLabel lblCreateTime;
    private JLabel jLabel1;
    private JSeparator jSeparator5;
    private JSeparator jSeparator4;
    private JSeparator jSeparator3;
    private JSeparator jSeparator2;
    private JSeparator jSeparator1;
    private WechatLevelPopup wechatLevelPopup;
    private String wechatJID;
    private LiteCustomer liteCustomer;
    BroadcastReceiver receiver = null;
    IntentFilter filter = null;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                WechatInfoPopup inst = new WechatInfoPopup(frame);
                inst.setVisible(true);
            }
        });
    }

    public WechatInfoPopup(JFrame frame) {
        super(frame);
        this.initGUI();
        this.initReceiver();
    }

    private void initGUI() {
        try {
            this.panelContent = new RoundedCornerPanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setLayout(panelContentLayout);
            this.panelContent.setBackground(new Color(233, 248, 255));
            this.panelTitle = new JPanel();
            BorderLayout panelTitleLayout = new BorderLayout();
            this.panelTitle.setLayout(panelTitleLayout);
            this.panelContent.add((Component)this.panelTitle, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(7, 15, 7, 15), 0, 0));
            this.panelTitle.setOpaque(false);
            this.lblServname = new JLabel();
            this.panelTitle.add((Component)this.lblServname, "Center");
            this.lblServname.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 30));
            this.panelLevel = new JPanel();
            this.panelTitle.add((Component)this.panelLevel, "East");
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setVgap(0);
            this.panelLevel.setLayout(jPanel1Layout);
            this.panelLevel.setOpaque(false);
            this.panelLevel.setCursor(UIConstants.CURSOR_HAND);
            this.panelLevel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (evt.getButton() == 1) {
                        WechatInfoPopup.this.showWechatLevelPopup(evt);
                    }
                }
            });
            this.jLabel1 = new JLabel();
            this.panelLevel.add(this.jLabel1);
            this.jLabel1.setIcon(UIConstants.ICON_WECHAT_LEVEL);
            this.lblLevel = new JLabel();
            this.panelLevel.add(this.lblLevel);
            this.lblLevel.setText(I18NUtil.getString("wechat_level"));
            this.lblLevel.setForeground(Color.GRAY);
            this.lblLevel.setIcon(UIConstants.ICON_ARROW_DOWN);
            this.lblLevel.setHorizontalTextPosition(10);
            this.jSeparator1 = new JSeparator();
            this.panelContent.add((Component)this.jSeparator1, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator1.setForeground(Color.LIGHT_GRAY);
            this.lblStatusHeader = new JLabel();
            this.panelContent.add((Component)this.lblStatusHeader, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 15, 7, 25), 0, 0));
            this.lblStatusHeader.setText(I18NUtil.getString("wechat_subscribe"));
            this.lblStatus = new JLabel();
            this.panelContent.add((Component)this.lblStatus, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(7, 0, 7, 15), 0, 0));
            this.lblStatus.setText("\u662f");
            this.lblStatus.setForeground(Color.GRAY);
            this.jSeparator2 = new JSeparator();
            this.panelContent.add((Component)this.jSeparator2, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator2.setForeground(Color.LIGHT_GRAY);
            this.lblGenderHeader = new JLabel();
            this.panelContent.add((Component)this.lblGenderHeader, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 15, 7, 25), 0, 0));
            this.lblGenderHeader.setText("\u6027\u5225");
            this.lblGender = new JLabel();
            this.panelContent.add((Component)this.lblGender, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(7, 0, 7, 15), 0, 0));
            this.lblGender.setText("\u5973");
            this.lblGender.setForeground(Color.GRAY);
            this.jSeparator3 = new JSeparator();
            this.panelContent.add((Component)this.jSeparator3, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator3.setForeground(Color.LIGHT_GRAY);
            this.lblLocationHeader = new JLabel();
            this.panelContent.add((Component)this.lblLocationHeader, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 15, 7, 25), 0, 0));
            this.lblLocationHeader.setText(I18NUtil.getString("wechat_location"));
            this.lblLocation = new JLabel();
            this.panelContent.add((Component)this.lblLocation, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(7, 0, 7, 15), 0, 0));
            this.lblLocation.setText("\u53f0\u7063 \u53f0\u5317\u5e02");
            this.lblLocation.setForeground(Color.GRAY);
            this.jSeparator4 = new JSeparator();
            this.panelContent.add((Component)this.jSeparator4, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator4.setForeground(Color.LIGHT_GRAY);
            this.lblLanguageHeader = new JLabel();
            this.panelContent.add((Component)this.lblLanguageHeader, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 15, 7, 25), 0, 0));
            this.lblLanguageHeader.setText(I18NUtil.getString("wechat_language"));
            this.lblLanguage = new JLabel();
            this.panelContent.add((Component)this.lblLanguage, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(7, 0, 7, 15), 0, 0));
            this.lblLanguage.setText("\u4e2d\u6587");
            this.lblLanguage.setForeground(Color.GRAY);
            this.jSeparator5 = new JSeparator();
            this.panelContent.add((Component)this.jSeparator5, new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator5.setForeground(Color.LIGHT_GRAY);
            this.lblCreateTimeHeader = new JLabel();
            this.panelContent.add((Component)this.lblCreateTimeHeader, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 15, 7, 25), 0, 0));
            this.lblCreateTimeHeader.setText(I18NUtil.getString("wechat_createtime"));
            this.lblCreateTime = new JLabel();
            this.panelContent.add((Component)this.lblCreateTime, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 13, 0, new Insets(7, 0, 7, 15), 0, 0));
            this.lblCreateTime.setText("2014-05-05 15:50");
            this.lblCreateTime.setForeground(Color.GRAY);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    Log.d(WechatInfoPopup.class.getSimpleName(), "ContactHistoryPanel \u6536\u5230\u5ee3\u64ad:" + action);
                    if ("ezphone.intent.action.event.EXE_CUSTOMER_LEVEL_UPDATE_FAILED".equals(action)) {
                        ToastUtil.showErrorShort(I18NUtil.getString("common_notice_update_failed"));
                    } else if ("ezphone.intent.action.event.CUSTOMER_STATUS_CHANGED".equals(action)) {
                        WechatInfoPopup.this.liteCustomer = CustomerManager.getCustomerInfo(UCChatClient.context, JidUtil.convertKey(WechatInfoPopup.this.wechatJID));
                        WechatInfoPopup.this.updateCustomer();
                    }
                }
                catch (Throwable t) {
                    Log.e(WechatInfoPopup.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezphone.intent.action.event.EXE_CUSTOMER_LEVEL_UPDATE_FAILED");
        this.filter.addAction("ezphone.intent.action.event.CUSTOMER_STATUS_CHANGED");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    private void showWechatLevelPopup(MouseEvent e) {
        if (this.wechatLevelPopup == null) {
            this.wechatLevelPopup = new WechatLevelPopup(UCChatClient.getInstance(), this);
        }
        Component comp = e.getComponent();
        this.wechatLevelPopup.setLevel(this.liteCustomer.getLevel());
        this.wechatLevelPopup.show(comp, 0, 3 + comp.getHeight());
    }

    public void setWechatJID(String wechatJID) {
        this.wechatJID = wechatJID;
        this.liteCustomer = CustomerManager.getCustomerInfo(UCChatClient.context, JidUtil.convertKey(wechatJID));
        this.updateCustomer();
    }

    private void updateCustomer() {
        if (this.liteCustomer != null) {
            if (this.liteCustomer.getType() == 0) {
                this.lblServname.setIcon(UIConstants.ICON_WECHAT_GREEN);
            } else if (this.liteCustomer.getType() == 1) {
                this.lblServname.setIcon(UIConstants.ICON_LINE_GREEN);
            } else if (this.liteCustomer.getType() == 2) {
                this.lblServname.setIcon(UIConstants.ICON_WEBCHAT_BLUE);
            }
            this.lblServname.setText(this.liteCustomer.getServName());
            this.lblLevel.setText(I18NUtil.getString("wechat_level") + this.liteCustomer.getLevel());
            this.lblStatus.setText(this.liteCustomer.getStatus() == 1 ? I18NUtil.getString("common_btn_yes") : I18NUtil.getString("common_btn_no"));
            if (this.liteCustomer.getSex() == 1) {
                this.lblGender.setText(I18NUtil.getString("abook_gender_man"));
            } else if (this.liteCustomer.getSex() == 2) {
                this.lblGender.setText(I18NUtil.getString("abook_gender_woman"));
            } else {
                this.lblGender.setText(I18NUtil.getString("abook_gender_other"));
            }
            String strArea = this.liteCustomer.getCountry() + " " + this.liteCustomer.getProvince() + " " + this.liteCustomer.getCity();
            this.lblLocation.setText(strArea);
            Locale locale = I18NUtil.getAppLocale();
            Locale dispLocale = Locale.CHINA;
            if ("zh_CN".equals(this.liteCustomer.getLanguage())) {
                dispLocale = Locale.CHINA;
            } else if ("zh_TW".equals(this.liteCustomer.getLanguage())) {
                dispLocale = Locale.TAIWAN;
            } else if ("en".equals(this.liteCustomer.getLanguage())) {
                dispLocale = Locale.ENGLISH;
            }
            this.lblLanguage.setText(TextUtils.isBlank((CharSequence)this.liteCustomer.getLanguage()) ? "" : locale.getDisplayLanguage(dispLocale));
            String createTimeDate = this.liteCustomer.getCreateTime();
            this.lblCreateTime.setText(createTimeDate.substring(0, createTimeDate.lastIndexOf(":")));
        }
    }

    @Override
    public void wechatLevelSelected(int level) {
        this.lblLevel.setText(I18NUtil.getString("wechat_level") + level);
        WebAgent.getInstance().updateCustomerLevel(this.liteCustomer.getAccount(), level);
    }
}

