/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.wechat;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.component.UCPopupWindow;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.wechat.WechatLevelPopupCallback;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class WechatLevelPopup
extends UCPopupWindow {
    private static final Color COLOR_LEVEL = new Color(32, 32, 32);
    private JPanel panelContent;
    private JLabel lblTitle;
    private JRadioButton btnLevel1;
    private JRadioButton btnLevel2;
    private JRadioButton btnLevel3;
    private JRadioButton btnLevel4;
    private JRadioButton btnLevel5;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private WechatLevelPopupCallback wechatInfoPopupCallback;
    private HashMap<Integer, JRadioButton> rbMap = new HashMap();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                WechatLevelPopup inst = new WechatLevelPopup(frame, null);
                inst.setVisible(true);
            }
        });
    }

    public WechatLevelPopup(JFrame frame, WechatLevelPopupCallback wechatInfoPopupCallback) {
        super(frame);
        this.initGUI();
        this.wechatInfoPopupCallback = wechatInfoPopupCallback;
        ButtonGroup group = new ButtonGroup();
        group.add(this.btnLevel1);
        group.add(this.btnLevel2);
        group.add(this.btnLevel3);
        group.add(this.btnLevel4);
        group.add(this.btnLevel5);
        this.rbMap.put(1, this.btnLevel1);
        this.rbMap.put(2, this.btnLevel2);
        this.rbMap.put(3, this.btnLevel3);
        this.rbMap.put(4, this.btnLevel4);
        this.rbMap.put(5, this.btnLevel5);
    }

    private void initGUI() {
        try {
            this.panelContent = new RoundedCornerPanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setLayout(panelContentLayout);
            this.panelContent.setBackground(new Color(236, 236, 236));
            this.lblTitle = new JLabel();
            this.panelContent.add((Component)this.lblTitle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 12, 5, 0), 0, 0));
            this.lblTitle.setText(I18NUtil.getString("wechat_cust_level"));
            this.lblTitle.setFont(UIConstants.FONT_14_BOLD);
            this.lblTitle.setForeground(new Color(0, 128, 192));
            this.jSeparator1 = new JSeparator();
            this.panelContent.add((Component)this.jSeparator1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnLevel1 = new JRadioButton();
            this.panelContent.add((Component)this.btnLevel1, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 12, 5, 0), 0, 0));
            this.btnLevel1.setText("Level 1");
            this.btnLevel1.setFont(UIConstants.FONT_12_PLAIN);
            this.btnLevel1.setForeground(COLOR_LEVEL);
            this.btnLevel1.setFocusPainted(false);
            this.btnLevel1.setOpaque(false);
            this.btnLevel1.setHorizontalAlignment(2);
            this.btnLevel1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WechatLevelPopup.this.btnLevel1ActionPerformed(evt);
                }
            });
            this.jSeparator2 = new JSeparator();
            this.panelContent.add((Component)this.jSeparator2, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnLevel2 = new JRadioButton();
            this.panelContent.add((Component)this.btnLevel2, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 12, 5, 0), 0, 0));
            this.btnLevel2.setText("Level 2");
            this.btnLevel2.setFont(UIConstants.FONT_12_PLAIN);
            this.btnLevel2.setForeground(COLOR_LEVEL);
            this.btnLevel2.setFocusPainted(false);
            this.btnLevel2.setOpaque(false);
            this.btnLevel2.setHorizontalAlignment(2);
            this.btnLevel2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WechatLevelPopup.this.btnLevel2ActionPerformed(evt);
                }
            });
            this.jSeparator3 = new JSeparator();
            this.panelContent.add((Component)this.jSeparator3, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnLevel3 = new JRadioButton();
            this.panelContent.add((Component)this.btnLevel3, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 12, 5, 0), 0, 0));
            this.btnLevel3.setText("Level 3");
            this.btnLevel3.setFont(UIConstants.FONT_12_PLAIN);
            this.btnLevel3.setForeground(COLOR_LEVEL);
            this.btnLevel3.setFocusPainted(false);
            this.btnLevel3.setOpaque(false);
            this.btnLevel3.setHorizontalAlignment(2);
            this.btnLevel3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WechatLevelPopup.this.btnLevel3ActionPerformed(evt);
                }
            });
            this.jSeparator4 = new JSeparator();
            this.panelContent.add((Component)this.jSeparator4, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnLevel4 = new JRadioButton();
            this.panelContent.add((Component)this.btnLevel4, new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 12, 5, 0), 0, 0));
            this.btnLevel4.setText("Level 4");
            this.btnLevel4.setFont(UIConstants.FONT_12_PLAIN);
            this.btnLevel4.setForeground(COLOR_LEVEL);
            this.btnLevel4.setFocusPainted(false);
            this.btnLevel4.setOpaque(false);
            this.btnLevel4.setHorizontalAlignment(2);
            this.btnLevel4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WechatLevelPopup.this.btnLevel4ActionPerformed(evt);
                }
            });
            this.jSeparator5 = new JSeparator();
            this.panelContent.add((Component)this.jSeparator5, new GridBagConstraints(0, 9, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnLevel5 = new JRadioButton();
            this.panelContent.add((Component)this.btnLevel5, new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 12, 5, 0), 0, 0));
            this.btnLevel5.setText("Level 5");
            this.btnLevel5.setFont(UIConstants.FONT_12_PLAIN);
            this.btnLevel5.setForeground(COLOR_LEVEL);
            this.btnLevel5.setFocusPainted(false);
            this.btnLevel5.setOpaque(false);
            this.btnLevel5.setHorizontalAlignment(2);
            this.btnLevel5.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WechatLevelPopup.this.btnLevel5ActionPerformed(evt);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setLevel(int level) {
        JRadioButton rb = this.rbMap.get(level);
        if (rb != null) {
            rb.setSelected(true);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        prefSize.width = 130;
        return prefSize;
    }

    private void btnLevel1ActionPerformed(ActionEvent evt) {
        this.wechatInfoPopupCallback.wechatLevelSelected(1);
        this.setVisible(false);
    }

    private void btnLevel2ActionPerformed(ActionEvent evt) {
        this.wechatInfoPopupCallback.wechatLevelSelected(2);
        this.setVisible(false);
    }

    private void btnLevel3ActionPerformed(ActionEvent evt) {
        this.wechatInfoPopupCallback.wechatLevelSelected(3);
        this.setVisible(false);
    }

    private void btnLevel4ActionPerformed(ActionEvent evt) {
        this.wechatInfoPopupCallback.wechatLevelSelected(4);
        this.setVisible(false);
    }

    private void btnLevel5ActionPerformed(ActionEvent evt) {
        this.wechatInfoPopupCallback.wechatLevelSelected(5);
        this.setVisible(false);
    }
}

