/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.agent;

import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.ChatUploadSendFileTask;
import com.blisscloud.mobile.ezuc.agent.ChatUploadTask;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.callback.FileConnectionListener;
import com.blisscloud.mobile.ezuc.connection.file.FileTransferConnection;
import com.blisscloud.mobile.ezuc.connection.web.ActionObj;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ChatMsgQueueController
extends Thread {
    private volatile boolean running = true;
    private static String TAG = ChatMsgQueueController.class.getSimpleName();
    private Context mCtx;
    private static final int MAX_COUNT = 3;
    private static final long TASK_TIMEOUT_WAIT = 60000L;
    private static final long TASK_TIMEOUT_CATCHALL = 200000L;
    private static ChatMsgQueueController mInstance;
    private FileTransferConnection ftConn = null;
    private ConcurrentLinkedQueue<ChatUploadTask> mQueue = new ConcurrentLinkedQueue();
    private List<ChatUploadTask> mRunningTaskList = Collections.synchronizedList(new ArrayList());
    private Timer mUploadTimer = new Timer("ChatMsgQueueControllerUploadTimer");
    private Timer mSuspendTimer = new Timer("ChatMsgQueueControllerSuspendTimer");
    private SuspendCancelExpiredTask mCancelExpiredTask = null;
    private ChatSendingTimerTask mChatSendingTimerTask = null;
    private boolean mSuspend = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(boolean isRunning) {
        this.running = isRunning;
        ConcurrentLinkedQueue<ChatUploadTask> concurrentLinkedQueue = this.mQueue;
        synchronized (concurrentLinkedQueue) {
            this.mQueue.notifyAll();
        }
    }

    public static ChatMsgQueueController getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new ChatMsgQueueController(context);
        }
        return mInstance;
    }

    public static void stopInstance() {
        if (mInstance != null) {
            mInstance.setRunning(false);
            mInstance = null;
        }
    }

    public static void suspendInstance(boolean s) {
        if (mInstance != null) {
            mInstance.setSuspend(s);
        }
    }

    public ChatMsgQueueController(Context context) {
        super.setName(this.getClass().getSimpleName());
        this.mCtx = context;
        Log.i(TAG, "service isLogin:" + WebAgent.isLogin);
        this.setSuspend(!WebAgent.isLogin);
        this.start();
    }

    @Override
    public String toString() {
        return "ChatMsgQueueController - " + super.toString();
    }

    private void cancelCancellExpiredTask() {
        if (this.mCancelExpiredTask != null) {
            this.mCancelExpiredTask.cancel();
            this.mSuspendTimer.purge();
            this.mCancelExpiredTask = null;
        }
    }

    private void cancelChatSendingTask() {
        if (this.mChatSendingTimerTask != null) {
            this.mChatSendingTimerTask.cancel();
            this.mUploadTimer.purge();
            this.mChatSendingTimerTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSuspend(boolean suspend) {
        Log.i(TAG, "setSuspend:" + suspend);
        this.mSuspend = suspend;
        this.cancelCancellExpiredTask();
        ConcurrentLinkedQueue<ChatUploadTask> concurrentLinkedQueue = this.mQueue;
        synchronized (concurrentLinkedQueue) {
            if (this.mSuspend) {
                if (this.ftConn != null) {
                    this.ftConn.cancel();
                }
                this.checkEnableCancelExpiredTask();
            } else {
                this.mQueue.notifyAll();
            }
        }
    }

    private void checkEnableCancelExpiredTask() {
        boolean readyToRunTask = this.mCancelExpiredTask == null && this.mSuspend && !this.mQueue.isEmpty();
        Log.i(TAG, "checkEnableCancelExpiredTask ...suspend:" + this.mSuspend + ", queue empty:" + this.mQueue.isEmpty() + " readyToRunTask:" + readyToRunTask);
        if (readyToRunTask) {
            this.mCancelExpiredTask = new SuspendCancelExpiredTask();
            this.mSuspendTimer.schedule((TimerTask)this.mCancelExpiredTask, 10000L, 10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEnableChatSendingTask() {
        List<ChatUploadTask> list = this.mRunningTaskList;
        synchronized (list) {
            boolean readyToRunTask = this.mChatSendingTimerTask == null && !this.mRunningTaskList.isEmpty();
            Log.i(TAG, "checkEnableChatSendingTask ...mRunningTaskList empty:" + this.mRunningTaskList.isEmpty() + " readyToRunTask:" + readyToRunTask);
            if (readyToRunTask) {
                this.mChatSendingTimerTask = new ChatSendingTimerTask();
                this.mUploadTimer.schedule((TimerTask)this.mChatSendingTimerTask, 10000L, 10000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(ChatUploadTask msgTask) {
        if (msgTask == null) {
            Log.e(TAG, "empTask is null");
            return;
        }
        msgTask.setStatus(0);
        msgTask.setEnqueueTime(System.currentTimeMillis());
        Log.i(TAG, "pre addTask:" + String.valueOf(msgTask));
        this.mQueue.add(msgTask);
        Log.i(TAG, "post addTask:" + String.valueOf(msgTask));
        ConcurrentLinkedQueue<ChatUploadTask> concurrentLinkedQueue = this.mQueue;
        synchronized (concurrentLinkedQueue) {
            if (this.mSuspend) {
                this.checkEnableCancelExpiredTask();
            } else {
                this.mQueue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block24: {
            ConcurrentLinkedQueue<ChatUploadTask> concurrentLinkedQueue;
            block19: while (true) {
                while (this.running) {
                    concurrentLinkedQueue = this.mQueue;
                    synchronized (concurrentLinkedQueue) {
                        if (this.mSuspend || this.mQueue.isEmpty()) {
                            try {
                                Log.d(TAG, "run() wait ...");
                                this.mQueue.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    Log.i(TAG, "run() queue size:" + this.mQueue.size());
                    ChatUploadTask chatTask = null;
                    ConcurrentLinkedQueue<ChatUploadTask> concurrentLinkedQueue2 = this.mQueue;
                    synchronized (concurrentLinkedQueue2) {
                        if (!this.mSuspend && !this.mQueue.isEmpty()) {
                            chatTask = this.mQueue.poll();
                        }
                    }
                    if (chatTask == null) continue;
                    try {
                        chatTask.setStatus(1);
                        chatTask.setDequeueTime(System.currentTimeMillis());
                        Log.i(TAG, "run() dequeue task: " + chatTask.getInfo());
                        this.mRunningTaskList.add(chatTask);
                        this.checkEnableChatSendingTask();
                        if (chatTask instanceof ChatUploadSendFileTask) {
                            this.ftConn = new FileTransferConnection(this.mCtx, (ChatUploadSendFileTask)chatTask, new FileConnectionListener(this.mCtx));
                            this.ftConn.start();
                            this.ftConn = null;
                            continue block19;
                        }
                        this.doSendMsgOut(chatTask);
                        continue block19;
                    }
                    catch (Throwable t) {
                        Log.e(ChatMsgQueueController.class.getSimpleName(), t.getMessage(), t);
                    }
                }
                break block24;
                {
                    continue block19;
                    break;
                }
                break;
            }
            finally {
                Log.i(this.getClass().getSimpleName(), "Clear instance");
                this.cancelCancellExpiredTask();
                concurrentLinkedQueue = this.mQueue;
                synchronized (concurrentLinkedQueue) {
                    this.mQueue.clear();
                }
                mInstance = null;
            }
        }
    }

    public void doSendMsgOut(ChatUploadTask chatTask) {
        Log.i(TAG, "doSendMsgOut task:" + chatTask.getInfo());
        chatTask.setStatus(3);
        chatTask.setMsgSendingTime(System.currentTimeMillis());
        for (String packetId : chatTask.getPacketIdList()) {
            UCDBMessage.updateChatMsgStatus(this.mCtx, packetId, "N");
        }
        if (ApiVersion.isApi20Later()) {
            ActionObj action = chatTask.getMultiReceiverMsgAction(this.mCtx);
            WebAgent.getInstance().sendAction(action);
        } else {
            List<ActionObj> actionList = chatTask.getMsgAction(this.mCtx);
            for (ActionObj action : actionList) {
                WebAgent.getInstance().sendAction(action);
            }
        }
    }

    private boolean checkTaskAllDone(ChatUploadTask msgTask) {
        List<Message> msgList = UCDBMessage.findSendingUploadingMsgByPacketIdList(this.mCtx, msgTask.getPacketIdList());
        return msgList.size() == 0;
    }

    private void checkTaskCancelRequired(ChatUploadTask msgTask, String place) {
        List<Message> msgList = UCDBMessage.findSendingUploadingMsgByPacketIdList(this.mCtx, msgTask.getPacketIdList());
        Log.i(TAG, "checkTaskCancelRequired for " + place + ", msgTask:" + msgTask.getInfo() + " sending/uploading msg size is " + msgList.size());
        for (Message msg : msgList) {
            this.markMsgStatusError(msg);
        }
    }

    private void checkTaskCancelRequired(String packetId, String place) {
        ArrayList<String> packetList = new ArrayList<String>();
        packetList.add(packetId);
        List<Message> msgList = UCDBMessage.findSendingUploadingMsgByPacketIdList(this.mCtx, packetList);
        Log.i(TAG, "checkTaskCancelRequired for " + place + ", packetId:" + packetId + " sending/uploading msg size is " + msgList.size());
        for (Message msg : msgList) {
            this.markMsgStatusError(msg);
        }
    }

    private void markMsgStatusError(Message msg) {
        if (msg == null) {
            return;
        }
        if ("N".equals(msg.getStatus())) {
            ChatRoomManager.updateMessageStatusWithEvent(this.mCtx, msg.getToJid(), msg.getPacketId(), "Connection error", "E", false);
        } else if ("UPLOADING".equals(msg.getStatus())) {
            ChatRoomManager.updateMessageStatusWithEvent(this.mCtx, msg.getToJid(), msg.getPacketId(), "Connection error", "UPLOAD_FAILED", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelMsg(String packetId) {
        ArrayList<ChatUploadTask> toRemoveList;
        boolean hasMsg;
        if (this.ftConn != null && (hasMsg = this.ftConn.cancelMsg(packetId))) {
            return;
        }
        Collection<ChatUploadTask> collection = this.mRunningTaskList;
        synchronized (collection) {
            toRemoveList = new ArrayList<ChatUploadTask>();
            for (ChatUploadTask chatUploadTask : this.mRunningTaskList) {
                if (!chatUploadTask.cancelReceiver(packetId)) continue;
                this.checkTaskCancelRequired(packetId, "cancelMsg");
                if (chatUploadTask.hasActiveReceiver()) continue;
                toRemoveList.add(chatUploadTask);
            }
            for (ChatUploadTask chatUploadTask : toRemoveList) {
                this.mRunningTaskList.remove(chatUploadTask);
            }
        }
        collection = this.mQueue;
        synchronized (collection) {
            toRemoveList = new ArrayList();
            for (ChatUploadTask chatUploadTask : this.mQueue) {
                if (!chatUploadTask.cancelReceiver(packetId)) continue;
                this.checkTaskCancelRequired(packetId, "cancelMsg");
                if (chatUploadTask.hasActiveReceiver()) continue;
                toRemoveList.add(chatUploadTask);
            }
            for (ChatUploadTask chatUploadTask : toRemoveList) {
                this.mQueue.remove(chatUploadTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanAllTask() {
        if (this.ftConn != null) {
            this.ftConn.cancel();
        }
        Collection<ChatUploadTask> collection = this.mRunningTaskList;
        synchronized (collection) {
            while (!this.mRunningTaskList.isEmpty()) {
                ChatUploadTask lastTask = this.mRunningTaskList.get(this.mRunningTaskList.size() - 1);
                this.checkTaskCancelRequired(lastTask, "cleanAllTask");
                this.mRunningTaskList.remove(lastTask);
            }
        }
        collection = this.mQueue;
        synchronized (collection) {
            while (!this.mQueue.isEmpty()) {
                ChatUploadTask task = this.mQueue.poll();
                if (task == null) continue;
                this.checkTaskCancelRequired(task, "cleanAllTask");
            }
        }
    }

    class SuspendCancelExpiredTask
    extends UCTimerTask {
        private String TAG2 = SuspendCancelExpiredTask.class.getSimpleName();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doRun() {
            if (!ChatMsgQueueController.this.mSuspend) {
                Log.i(this.TAG2, "mSuspend is false skip!");
                return;
            }
            ConcurrentLinkedQueue<ChatUploadTask> concurrentLinkedQueue = ChatMsgQueueController.this.mQueue;
            synchronized (concurrentLinkedQueue) {
                ArrayList<ChatUploadTask> toRemoveList = new ArrayList<ChatUploadTask>();
                for (ChatUploadTask task : ChatMsgQueueController.this.mQueue) {
                    long diff = System.currentTimeMillis() - task.getCreateTime();
                    if (diff > 60000L) {
                        Log.i(this.TAG2, task.getInfo() + " diff: " + diff + " cancel now ...");
                        toRemoveList.add(task);
                        continue;
                    }
                    Log.i(this.TAG2, task.getInfo() + " diff: " + diff + " keep for next round ...");
                }
                for (ChatUploadTask task : toRemoveList) {
                    ChatMsgQueueController.this.mQueue.remove(task);
                    ChatMsgQueueController.this.checkTaskCancelRequired(task, "suspendExpiredTask");
                }
                if (ChatMsgQueueController.this.mQueue.isEmpty()) {
                    Log.i(this.TAG2, "mQueue is empty now, cancel SuspendCancelExpiredTask ...");
                    ChatMsgQueueController.this.cancelCancellExpiredTask();
                }
            }
        }
    }

    class ChatSendingTimerTask
    extends UCTimerTask {
        private String TAG2 = ChatSendingTimerTask.class.getSimpleName();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doRun() {
            List<ChatUploadTask> list = ChatMsgQueueController.this.mRunningTaskList;
            synchronized (list) {
                this.cleanTaskDone();
                if (ChatMsgQueueController.this.mSuspend) {
                    this.suspendTimeoutCheck();
                } else {
                    this.checkNoResponseResend();
                }
                if (ChatMsgQueueController.this.mRunningTaskList.isEmpty()) {
                    Log.i(this.TAG2, "mRunningTaskList is empty now, cancel ChatSendingTimerTask ...");
                    ChatMsgQueueController.this.cancelChatSendingTask();
                }
            }
        }

        private void checkNoResponseResend() {
            ArrayList<ChatUploadTask> toRemoveList = new ArrayList<ChatUploadTask>();
            for (ChatUploadTask task : ChatMsgQueueController.this.mRunningTaskList) {
                long diff;
                Log.i(this.TAG2, "checkNoResponseResend .... task:" + task.getInfo() + ", status:" + task.getStatus() + ", tryCount:" + task.getRetryCount());
                if (task.getStatus() == 3) {
                    diff = System.currentTimeMillis() - task.getMsgSendingTime();
                    if (diff <= 60000L) continue;
                    if (task.getRetryCount() < 3) {
                        Log.i(this.TAG2, "checkNoResponseResend .... task:" + task.getInfo() + " diff: " + diff + " resend file now ...");
                        this.resendMsg(task);
                        continue;
                    }
                    toRemoveList.add(task);
                    continue;
                }
                diff = System.currentTimeMillis() - task.getDequeueTime();
                if (diff <= 200000L) continue;
                Log.e(this.TAG2, "checkNoResponseResend .... task:" + task.getInfo() + " diff: " + diff + ", status " + task.getStatus() + ", catch all clean ...");
                toRemoveList.add(task);
            }
            for (ChatUploadTask task : toRemoveList) {
                ChatMsgQueueController.this.mRunningTaskList.remove(task);
                ChatMsgQueueController.this.checkTaskCancelRequired(task, "suspendExpiredTask");
            }
        }

        private void resendMsg(ChatUploadTask task) {
            task.increaseTryCount();
            if (!ChatMsgQueueController.this.checkTaskAllDone(task)) {
                ChatMsgQueueController.this.doSendMsgOut(task);
            }
        }

        private void cleanTaskDone() {
            ArrayList<ChatUploadTask> toRemoveList = new ArrayList<ChatUploadTask>();
            for (ChatUploadTask task : ChatMsgQueueController.this.mRunningTaskList) {
                if (!ChatMsgQueueController.this.checkTaskAllDone(task)) continue;
                toRemoveList.add(task);
            }
            for (ChatUploadTask task : toRemoveList) {
                ChatMsgQueueController.this.mRunningTaskList.remove(task);
                Log.i(this.TAG2, "cleanTaskDone ...." + task.getInfo() + " has finished, remove from running list now ...");
            }
        }

        private void suspendTimeoutCheck() {
            ArrayList<ChatUploadTask> toRemoveList = new ArrayList<ChatUploadTask>();
            for (ChatUploadTask task : ChatMsgQueueController.this.mRunningTaskList) {
                long diff = System.currentTimeMillis() - task.getDequeueTime();
                if (diff > 60000L) {
                    toRemoveList.add(task);
                    Log.i(this.TAG2, "suspendTimeoutCheck for runningTaskList ...." + task.getInfo() + " diff: " + diff + " cancel now ...");
                    continue;
                }
                Log.i(this.TAG2, "suspendTimeoutCheck for runningTaskList ...." + task.getInfo() + " diff: " + diff + " keep for next round ...");
            }
            for (ChatUploadTask task : toRemoveList) {
                ChatMsgQueueController.this.mRunningTaskList.remove(task);
                ChatMsgQueueController.this.checkTaskCancelRequired(task, "suspendExpiredTask");
            }
        }
    }
}

