/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.agent;

import com.blisscloud.ezuc.bean.LiteCustomer;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.agent.ChatReceiver;
import com.blisscloud.mobile.ezuc.agent.ChatTaskBase;
import com.blisscloud.mobile.ezuc.agent.ChatUploadTask;
import com.blisscloud.mobile.ezuc.connection.web.ActionObj;
import com.blisscloud.mobile.ezuc.manager.CustomerManager;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ChatSendMsgTask
extends ChatTaskBase
implements ChatUploadTask {
    private String encodeText = null;
    private String originalContent = null;
    private int type = -1;
    private Long duration = null;
    private Double latitude = null;
    private Double longitude = null;
    private String title = null;
    private String quotePackageId = null;

    public ChatSendMsgTask(String quotePackageId, List<ChatReceiver> chatReceiverList, String encodeText, String originalContent, int type) {
        this.encodeText = encodeText;
        this.originalContent = originalContent;
        this.type = type;
        this.chatReceiverList = chatReceiverList;
        this.quotePackageId = quotePackageId;
    }

    @Override
    public String getInfo() {
        return "ChatMsgTask(" + this.type + ") to " + this.getReceiverJidStr();
    }

    public String getEncodeText() {
        return this.encodeText;
    }

    public String getOriginalContent() {
        return this.originalContent;
    }

    public int getType() {
        return this.type;
    }

    public void setEncodeText(String encodeText) {
        this.encodeText = encodeText;
    }

    public void setOriginalContent(String originalContent) {
        this.originalContent = originalContent;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public String getTitle() {
        return this.title;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public List<ActionObj> getMsgAction(Context context) {
        ArrayList<ActionObj> actionList = new ArrayList<ActionObj>();
        for (ChatReceiver receiver : this.chatReceiverList) {
            LiteCustomer customer;
            ActionObj action = null;
            if (JidUtil.isChatConfJid(receiver.getReceiverJid())) {
                action = new ActionObj("multiChat.sendRoomTextMsg");
                action.setValue("roomJid", receiver.getReceiverJid());
            } else {
                action = new ActionObj("chat.sendTextMsg");
                action.setValue("receiverJid", receiver.getReceiverJid());
            }
            action.setValue("packetId", receiver.getPacketId());
            if (JidUtil.isCustomerJid(receiver.getReceiverJid()) && (customer = CustomerManager.getCustomerInfo(context, JidUtil.convertKey(receiver.getReceiverJid()))) != null && StringUtils.isNotBlank((CharSequence)customer.getSessionId())) {
                action.setValue("sessionId", customer.getSessionId());
            }
            if (StringUtils.isNotBlank((CharSequence)this.quotePackageId)) {
                action.setValue("refPacketId", this.quotePackageId);
            }
            this.getMessageCommon(action);
            actionList.add(action);
        }
        return actionList;
    }

    @Override
    public ActionObj getMultiReceiverMsgAction(Context context) {
        ActionObj action = new ActionObj("chat.sendMultiTextMsg");
        ArrayList receiverInfoList = new ArrayList();
        for (ChatReceiver receiver : this.chatReceiverList) {
            LiteCustomer customer;
            HashMap<String, String> receiverMap = new HashMap<String, String>();
            receiverMap.put("packetId", receiver.getPacketId());
            receiverMap.put("receiverJid", receiver.getReceiverJid());
            if (JidUtil.isCustomerJid(receiver.getReceiverJid()) && (customer = CustomerManager.getCustomerInfo(context, JidUtil.convertKey(receiver.getReceiverJid()))) != null && StringUtils.isNotBlank((CharSequence)customer.getSessionId())) {
                receiverMap.put("sessionId", customer.getSessionId());
            }
            receiverInfoList.add(receiverMap);
        }
        action.setValue("receiverInfo", receiverInfoList);
        if (StringUtils.isNotBlank((CharSequence)this.quotePackageId)) {
            action.setValue("refPacketId", this.quotePackageId);
        }
        this.getMessageCommon(action);
        return action;
    }

    public ActionObj getMessageCommon(ActionObj action) {
        boolean encode = this.getType() == 0 || this.getType() == 9 || this.getType() == 8;
        action.setValue("content", this.getEncodeText());
        action.setValue("type", this.getType());
        if (this.getDuration() != null) {
            action.setValue("duration", this.getDuration());
        }
        if (this.getLatitude() != null) {
            action.setValue("latitude", this.getLatitude());
        }
        if (this.getLongitude() != null) {
            action.setValue("longitude", this.getLongitude());
        }
        if (this.getTitle() != null) {
            action.setValue("title", this.getTitle());
        }
        action.setValue("base64Encode", encode);
        action.setValue("paraNoReturn", "content,type,base64Encode,duration,latitude,longitude,title,sessionId");
        return action;
    }

    public String toString() {
        return "ChatSendMsgTask [type=" + this.type + ", chatReceiverList=" + String.valueOf(this.chatReceiverList) + "]";
    }

    public String getQuotePackageId() {
        return this.quotePackageId;
    }

    public void setQuotePackageId(String quotePackageId) {
        this.quotePackageId = quotePackageId;
    }
}

