/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.agent;

import com.blisscloud.mobile.ezuc.agent.ChatReceiver;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;

public abstract class ChatTaskBase {
    private long createTime = System.currentTimeMillis();
    private long enqueueTime = 0L;
    private long dequeueTime = 0L;
    private long fileUploadingTime = 0L;
    private long msgSendingTime = 0L;
    private int status = 0;
    private int retryCount = 1;
    protected List<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();

    public List<ChatReceiver> getChatReceiverList() {
        return this.chatReceiverList;
    }

    public void setChatReceiverList(List<ChatReceiver> chatReceiverList) {
        this.chatReceiverList = chatReceiverList;
    }

    public JSONArray getReceiverJidList() {
        JSONArray array = new JSONArray();
        for (ChatReceiver receiver : this.chatReceiverList) {
            array.put(receiver.getReceiverJid());
        }
        return array;
    }

    public List<String> getPacketIdList() {
        ArrayList<String> packetIdList = new ArrayList<String>();
        for (ChatReceiver receiver : this.chatReceiverList) {
            packetIdList.add(receiver.getPacketId());
        }
        return packetIdList;
    }

    public String getReceiverJidStr() {
        StringBuffer b = new StringBuffer();
        for (ChatReceiver receiver : this.chatReceiverList) {
            if (b.length() != 0) {
                b.append(",");
            }
            b.append(receiver.getReceiverJid());
        }
        return b.toString();
    }

    public boolean cancelReceiver(String packetId) {
        boolean hasMsg = false;
        for (ChatReceiver receiver : this.chatReceiverList) {
            if (!receiver.getPacketId().equals(packetId)) continue;
            receiver.setCancel(true);
            hasMsg = true;
        }
        return hasMsg;
    }

    public boolean hasActiveReceiver() {
        for (ChatReceiver receiver : this.chatReceiverList) {
            if (receiver.isCancel()) continue;
            return true;
        }
        return false;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getDequeueTime() {
        return this.dequeueTime;
    }

    public void setDequeueTime(long dequeueTime) {
        this.dequeueTime = dequeueTime;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    public long getFileUploadingTime() {
        return this.fileUploadingTime;
    }

    public long getMsgSendingTime() {
        return this.msgSendingTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public void setEnqueueTime(long enqueueTime) {
        this.enqueueTime = enqueueTime;
    }

    public void setFileUploadingTime(long fileUploadingTime) {
        this.fileUploadingTime = fileUploadingTime;
    }

    public void setMsgSendingTime(long msgSendingTime) {
        this.msgSendingTime = msgSendingTime;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void increaseTryCount() {
        ++this.retryCount;
    }
}

