/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.agent;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ChatRoomUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.PhoneLineInfo;
import com.blisscloud.mobile.ezuc.db.UCDBConf;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcher;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcherResult;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class IncomingDataHelper {
    private static final String ASTERISK = "asterisk";

    public static void prepareInviteJoinConfInfo(Context ctx, PhoneLineInfo incomingLineInfo, String roomId, String roomName, String roomNo, String roomJid) {
        LiteConferenceRoom confRoom;
        String meetmePrefix = OutboundPrefixManager.getMeetmePrefix(ctx);
        String roomNoWithPrefix = meetmePrefix + roomNo;
        if (JidUtil.isConfJid(roomJid)) {
            incomingLineInfo.setType(5);
        } else {
            incomingLineInfo.setType(4);
        }
        incomingLineInfo.setNumberWithClean(roomNoWithPrefix);
        incomingLineInfo.setJid(roomJid);
        String name = "";
        if (roomName != null) {
            if ("i18n.three.way.calling".equalsIgnoreCase(roomName)) {
                name = I18NUtil.getString("call_type_three_way_calling");
            } else if ("i18n.multi.conference".equalsIgnoreCase(roomName)) {
                name = I18NUtil.getString("call_type_three_way_calling");
            } else if (roomName.startsWith("Dyna-")) {
                name = I18NUtil.getString("call_type_three_way_calling");
            }
        }
        ChatRoomInfo chatRoom = ChatRoomManager.getChatRoom(ctx, roomJid);
        if (JidUtil.isConfJid(roomJid)) {
            LiteConferenceRoom room = MeetmeManager.getStaticMeetme(ctx, roomJid);
            if (room != null) {
                name = ChatRoomUtil.getConfRoomTitle(ctx, chatRoom, room, false, false);
            }
        } else if (JidUtil.isChatJid(roomJid)) {
            name = ChatRoomUtil.getChatRoomTitle(ctx, chatRoom);
        }
        incomingLineInfo.setName1(name);
        incomingLineInfo.setName2(null);
        if (TextUtils.isNotBlank((CharSequence)roomId) && (confRoom = UCDBConf.getConfRoomByChatRoomId(ctx, roomId.trim())) == null) {
            WebAgent.getInstance().getOneMeetMe(Long.parseLong(roomId));
        }
    }

    public static void prepareConferenceInfo(Context ctx, PhoneLineInfo incomingLineInfo, Map<String, Object> blInfoMap) {
        LiteConferenceRoom confRoom;
        Object callerExt = (String)blInfoMap.get("BL_CALLER_EXT");
        String callerDbId = (String)blInfoMap.get("BL_CALLER_DBID");
        String meetmePrefix = OutboundPrefixManager.getMeetmePrefix(ctx);
        try {
            callerExt = ((String)callerExt).substring(6);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        callerExt = meetmePrefix + (String)callerExt;
        incomingLineInfo.setNumberWithClean((String)callerExt);
        if (TextUtils.isNotBlank((CharSequence)callerDbId) && (confRoom = UCDBConf.getConfRoomByChatRoomId(ctx, callerDbId.trim())) == null) {
            WebAgent.getInstance().getOneMeetMe(Long.parseLong(callerDbId));
        }
    }

    public static void prepareEmployeeInfo(Context ctx, PhoneLineInfo incomingLineInfo, HashMap<String, Object> blInfoMap) {
        String callerExt = (String)blInfoMap.get("BL_CALLER_EXT");
        String callerDbId = (String)blInfoMap.get("BL_CALLER_DBID");
        String callerSiteId = (String)blInfoMap.get("BL_CALLER_SITE");
        String callerName = (String)blInfoMap.get("BL_CALLER_NAME");
        boolean hasEmpConfigured = false;
        if (TextUtils.isNotBlank((CharSequence)callerDbId)) {
            long empId = Long.parseLong(callerDbId.trim());
            LiteContact contact = UCDBContact.getContactByEmpId(ctx, empId);
            hasEmpConfigured = true;
            if (contact != null) {
                incomingLineInfo.setType(1);
                incomingLineInfo.setJid(contact.getJid());
                incomingLineInfo.setSiteId(TextUtils.isBlank((CharSequence)callerSiteId) ? null : Long.valueOf(Long.parseLong(callerSiteId.trim())));
                incomingLineInfo.setNumberBySite(callerSiteId, callerExt);
                incomingLineInfo.setName1(ContactManager.getNonEnglishName(contact));
                incomingLineInfo.setName2(ContactManager.getFullEnglishName(contact));
            } else {
                String token = CommonUtil.randomString(20);
                incomingLineInfo.setType(8);
                incomingLineInfo.setJid(null);
                incomingLineInfo.setSiteId(TextUtils.isBlank((CharSequence)callerSiteId) ? null : Long.valueOf(Long.parseLong(callerSiteId.trim())));
                incomingLineInfo.setNumberBySite(callerSiteId, callerExt);
                incomingLineInfo.setName1(null);
                incomingLineInfo.setName2(null);
                incomingLineInfo.setToken(token);
                HashSet<Long> empIdSet = new HashSet<Long>();
                empIdSet.add(empId);
                WebAgent.getInstance().queryEmployeeListByIds(token, empIdSet);
            }
        }
        if (!hasEmpConfigured) {
            incomingLineInfo.setType(8);
            incomingLineInfo.setJid(null);
            incomingLineInfo.setSiteId(TextUtils.isBlank((CharSequence)callerSiteId) ? null : Long.valueOf(Long.parseLong(callerSiteId)));
            incomingLineInfo.setNumberBySite(callerSiteId, callerExt);
            incomingLineInfo.setName1(callerName);
            incomingLineInfo.setName2(null);
        }
    }

    public static void prepareLocationInfo(Context ctx, PhoneLineInfo incomingLineInfo, HashMap<String, Object> blInfoMap) {
        String callerExt = (String)blInfoMap.get("BL_CALLER_EXT");
        String callerSiteId = (String)blInfoMap.get("BL_CALLER_SITE");
        String callerName = (String)blInfoMap.get("BL_CALLER_NAME");
        LiteContact contact = null;
        if (TextUtils.isNotBlank((CharSequence)callerSiteId) && TextUtils.isNotBlank((CharSequence)callerExt)) {
            contact = UCDBContact.getContactByLodId(ctx, callerSiteId.trim(), callerExt.trim());
        }
        incomingLineInfo.setType(2);
        if (contact != null) {
            incomingLineInfo.setJid(contact.getJid());
            incomingLineInfo.setSiteId(TextUtils.isBlank((CharSequence)callerSiteId) ? null : Long.valueOf(Long.parseLong(callerSiteId.trim())));
            incomingLineInfo.setNumberBySite(callerSiteId, callerExt);
            incomingLineInfo.setName1(ContactManager.getContactFullName(contact));
            incomingLineInfo.setName2(null);
        } else {
            incomingLineInfo.setType(8);
            incomingLineInfo.setJid(null);
            incomingLineInfo.setSiteId(TextUtils.isBlank((CharSequence)callerSiteId) ? null : Long.valueOf(Long.parseLong(callerSiteId.trim())));
            incomingLineInfo.setNumberBySite(callerSiteId, callerExt);
            incomingLineInfo.setName1(callerName);
            incomingLineInfo.setName2(null);
        }
    }

    public static void prepareInboundInfo(Context ctx, PhoneLineInfo incomingLineInfo, HashMap<String, Object> blInfoMap, String sipCallerInfo, String blRuleInfo, String blPattern) {
        String callerNumber = (String)blInfoMap.get("BL_CALLER_EXT");
        String callerSiteId = (String)blInfoMap.get("BL_CALLER_SITE");
        if (TextUtils.isBlank((CharSequence)callerNumber)) {
            callerNumber = IncomingDataHelper.getCallerNumberFromSipInfo(sipCallerInfo);
        }
        String callerName = IncomingDataHelper.getCallerName(sipCallerInfo);
        if (TextUtils.isBlank((CharSequence)callerNumber) && TextUtils.isBlank((CharSequence)callerName)) {
            incomingLineInfo.setType(10);
            incomingLineInfo.setJid(null);
            incomingLineInfo.setSiteId(TextUtils.isBlank((CharSequence)callerSiteId) ? null : Long.valueOf(Long.parseLong(callerSiteId.trim())));
            incomingLineInfo.setNumberWithClean(null);
            incomingLineInfo.setName1(I18NUtil.getString("call_caller_unknown"));
            incomingLineInfo.setName2(null);
            return;
        }
        PhoneMatcherResult result = PhoneMatcher.match(ctx, callerNumber, false);
        if (result == null) {
            String token = CommonUtil.randomString(20);
            incomingLineInfo.setType(8);
            incomingLineInfo.setJid(null);
            incomingLineInfo.setSiteId(TextUtils.isBlank((CharSequence)callerSiteId) ? null : Long.valueOf(Long.parseLong(callerSiteId.trim())));
            incomingLineInfo.setNumberBySite(callerSiteId, callerNumber);
            incomingLineInfo.setName1(null);
            incomingLineInfo.setName2(null);
            incomingLineInfo.setToken(token);
            incomingLineInfo.setRuleInfo(blRuleInfo);
            incomingLineInfo.setRulePattern(blPattern);
            long mySiteId = PreferencesUtil.getSipUsePbxSite(ctx);
            WebAgent.getInstance().matchEmployeeByIncomingPhoneNo(token, mySiteId, callerNumber);
        } else if (result.getMatchType() == 0 || result.getMatchType() == 4) {
            incomingLineInfo.setType(1);
            incomingLineInfo.setJid(result.getTargetJid());
            incomingLineInfo.setSiteId(result.getTargetSiteId());
            incomingLineInfo.setNumberBySite(callerSiteId, callerNumber);
            incomingLineInfo.setName1(result.getTargetName());
            incomingLineInfo.setName2(result.getTargetEngName());
        } else if (result.getMatchType() == 1) {
            incomingLineInfo.setType(2);
            incomingLineInfo.setJid(result.getTargetJid());
            incomingLineInfo.setSiteId(result.getTargetSiteId());
            incomingLineInfo.setNumberBySite(callerSiteId, callerNumber);
            incomingLineInfo.setName1(result.getTargetName());
            incomingLineInfo.setName2(null);
        } else if (result.getMatchType() == 5) {
            incomingLineInfo.setType(6);
            incomingLineInfo.setJid(result.getTargetJid());
            incomingLineInfo.setSiteId(result.getTargetSiteId());
            incomingLineInfo.setNumberBySite(callerSiteId, callerNumber);
            incomingLineInfo.setName1(result.getTargetName());
            incomingLineInfo.setName2(null);
        }
    }

    public static String getCallerName(String sipCallInfo) {
        if (TextUtils.isBlank((CharSequence)sipCallInfo)) {
            return null;
        }
        String callerName = sipCallInfo.toString();
        if (callerName.indexOf("\"") >= 0) {
            callerName = callerName.substring(callerName.indexOf("\"") + 1, callerName.lastIndexOf("\""));
        }
        if (!ASTERISK.equalsIgnoreCase(callerName)) {
            return callerName;
        }
        return null;
    }

    public static String getCallerNumberFromSipInfo(String sipCallInfo) {
        if (TextUtils.isBlank((CharSequence)sipCallInfo)) {
            return null;
        }
        String callerNo = sipCallInfo.toString();
        if (callerNo.indexOf("sip:") >= 0 && callerNo.indexOf("@") >= 0) {
            callerNo = callerNo.substring(callerNo.indexOf("sip:") + 4, callerNo.indexOf("@"));
        }
        if (!ASTERISK.equalsIgnoreCase(callerNo)) {
            return callerNo;
        }
        return null;
    }
}

