/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.agent;

import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.main.MainPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.PhoneLineInfo;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBConf;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import org.apache.commons.lang3.StringUtils;

public class MultiDialDirectHelper {
    private final Context mCtx;
    private final String mChatId;
    private EventBroadcastReceiver mEventReceiver;
    private IntentFilter mIntentFilter;
    private PhoneLineInfo mLineInfoForMeetmeDial = null;

    public MultiDialDirectHelper(Context ctx, String chatId, PhoneLineInfo lineInfoForMeetmeDial) {
        this.mChatId = chatId;
        this.mCtx = ctx;
        this.mLineInfoForMeetmeDial = lineInfoForMeetmeDial;
        this.mEventReceiver = new EventBroadcastReceiver();
        this.mIntentFilter = new IntentFilter("ezphone.intent.action.event.FIND_DYNC_CONF_ROOM");
        this.mCtx.registerReceiver(this.mEventReceiver, this.mIntentFilter);
    }

    public synchronized void destroy() {
        if (this.mEventReceiver != null) {
            this.mCtx.unregisterReceiver(this.mEventReceiver);
            this.mEventReceiver = null;
        }
    }

    public void doDial() {
        ToastUtil.show(this.mCtx, I18NUtil.getString("call_label_dialing"), 30);
        LiteConferenceRoom confRoom = MeetmeManager.getMeetme(this.mCtx, this.mChatId);
        String roomName = null;
        if (confRoom != null) {
            roomName = confRoom.getName();
        } else {
            ChatRoomInfo roomInfo = UCDBChatRoom.getChatRoom(this.mCtx, this.mChatId);
            if (roomInfo != null && ChatRoomManager.nameExist(roomInfo)) {
                roomName = roomInfo.getSubject();
            }
            if (roomName == null) {
                roomName = I18NUtil.getString("chatroom_label");
            }
        }
        WebAgent.getInstance().findDyncConfRoom(PreferencesUtil.getSipUsePbxSite(this.mCtx), this.mChatId, roomName);
    }

    private class EventBroadcastReceiver
    extends BroadcastReceiver {
        private EventBroadcastReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            Log.i(this.getClass().getSimpleName(), "onReceive\uff1a" + action);
            if ("ezphone.intent.action.event.FIND_DYNC_CONF_ROOM".equals(action)) {
                ToastUtil.hide();
                LiteConferenceRoom confRoom = UCDBConf.getConfRoomByChatRoomId(MultiDialDirectHelper.this.mCtx, MultiDialDirectHelper.this.mChatId);
                String ext = null;
                if (confRoom != null) {
                    String prefix = OutboundPrefixManager.getMeetmePrefix(MultiDialDirectHelper.this.mCtx);
                    ext = prefix + confRoom.getRoomNo();
                }
                if (StringUtils.isEmpty(ext)) {
                    Log.e(MultiDialDirectHelper.class.getSimpleName(), "findDyncRoomNoResultBack exten is still null");
                    return;
                }
                int lineId = PhoneAgent.getInstance().callChatRoomDir(ext, MultiDialDirectHelper.this.mLineInfoForMeetmeDial);
                if (lineId != -1) {
                    MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
                    mainPanel.getViewContainer().showPhonePanel(lineId);
                } else {
                    ToastUtil.show(MultiDialDirectHelper.this.mCtx, I18NUtil.getString("phone_notice_in_call_now"), 10);
                }
            }
        }
    }
}

