/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.agent;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.PlayAudioUtils;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.ToneUtil;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.ComponentName;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Handler;
import com.blisscloud.ezuc.client.util.simulate.IBinder;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.ezuc.client.util.simulate.Message;
import com.blisscloud.ezuc.client.util.simulate.RemoteException;
import com.blisscloud.ezuc.client.util.simulate.ServiceConnection;
import com.blisscloud.mobile.ezuc.agent.BaseAgent;
import com.blisscloud.mobile.ezuc.agent.CallLine;
import com.blisscloud.mobile.ezuc.agent.ConnectionAgent;
import com.blisscloud.mobile.ezuc.agent.IncomingDataHelper;
import com.blisscloud.mobile.ezuc.agent.MultiDialDirectHelper;
import com.blisscloud.mobile.ezuc.agent.NetworkService;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.PhoneLineInfo;
import com.blisscloud.mobile.ezuc.bean.VoiceItem;
import com.blisscloud.mobile.ezuc.db.UCDBVoiceMsg;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import com.blisscloud.mobile.ezuc.phone.CallState;
import com.blisscloud.mobile.ezuc.util.AppUtils;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PhoneNoUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import com.blisscloud.sip.Messenger;
import com.blisscloud.sip.SipPhoneService;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class PhoneAgent
extends BaseAgent
implements ServiceConnection {
    private static final int MSG_DELAY_ANSWER_CALL = 10;
    private static final int MSG_DELAY_REJECT_CALL = 11;
    private static final int MSG_PLAY_BUSY_TONE = 21;
    public static final String PSTN_STATE_IDLE = "IDLE";
    public static final String PSTN_STATE_INCALL = "OFFHOOK";
    public static final String PSTN_STATE_RINGING = "RINGING";
    private static volatile PhoneAgent instance;
    Messenger mSipMsgService = null;
    int mSipPhoneBound = STAT_NOT_BOUNDED;
    public static int STAT_NOT_BOUNDED;
    public static int STAT_BOUNDING;
    public static int STAT_BOUNDED;
    private Handler msgActionHandler;
    public static String pstnState;
    public static int STAT_NOT_REGISTERED;
    public static int STAT_PROCESSING;
    public static int STAT_REGISTERED;
    public static int isRegistered;
    public static boolean isUpdateLoginSip;
    public static boolean isWiredHeadsetOn;
    public static int LINE_COUNT;
    private static CallLine[] callLineAry;
    private MultiDialDirectHelper mMultiDialDirectHelper;
    private static int currentLine;
    private static Object lock;
    private Timer checkLocalTimer = new Timer("PhoneAgentTimer");
    private int registrationFailureCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhoneAgent getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    Log.w(NetworkService.class.getSimpleName(), "PhoneAgent service instance is null, recreate now !");
                    instance = new PhoneAgent(UCChatClient.context);
                }
            }
        }
        return instance;
    }

    public static void stopInstance() {
        Log.w(PhoneAgent.class.getSimpleName(), "PhoneAgent onDestroy!!! " + Thread.currentThread().getName());
        if (instance != null) {
            instance.onAgentDestroy();
            instance = null;
        }
    }

    private PhoneAgent(Context context) {
        super(context);
        context.bindService(new Intent(context, SipPhoneService.class), this, 1);
        this.initActionHandler();
    }

    private void initActionHandler() {
        this.msgActionHandler = new Handler("PhoneAgentMsgHandler"){

            @Override
            public void handleMessage(Message msg) {
                Log.i(PhoneAgent.class.getSimpleName(), "actionHandler msg.what:" + msg.what);
                switch (msg.what) {
                    case 10: {
                        Bundle data = msg.getData();
                        PhoneAgent.this.answerLine(data.getInt("line", 0));
                        break;
                    }
                    case 11: {
                        Bundle data = msg.getData();
                        PhoneAgent.this.rejectLine(data.getInt("line", 0));
                        break;
                    }
                    case 21: {
                        break;
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPhoneEngine() {
        PhoneAgent phoneAgent = this;
        synchronized (phoneAgent) {
            this.unregisterAfterwork("success stopPhoneEngine");
            this.sendSipAction(2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceStopPhoneEngine() {
        PhoneAgent phoneAgent = this;
        synchronized (phoneAgent) {
            this.unregisterAfterwork("success forceStopPhoneEngine");
            this.sendSipAction(3, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPhoneEngine() {
        PhoneAgent phoneAgent = this;
        synchronized (phoneAgent) {
            Log.i(PhoneAgent.class.getSimpleName(), "startPhoneEngine()---> isRegistered:" + isRegistered);
            if (this.mSipPhoneBound == STAT_NOT_BOUNDED) {
                this.mSipPhoneBound = STAT_BOUNDING;
                Log.i(PhoneAgent.class.getSimpleName(), "startSipEngine() mSipPhoneBound:" + this.mSipPhoneBound);
                this.context.bindService(new Intent(this.context, SipPhoneService.class), this, 1);
                return;
            }
            if (this.mSipPhoneBound == STAT_BOUNDING) {
                Log.i(PhoneAgent.class.getSimpleName(), "startSipEngine() mSipPhoneBound:" + this.mSipPhoneBound);
                return;
            }
            if (isRegistered != STAT_NOT_REGISTERED) {
                Log.e(PhoneAgent.class.getSimpleName(), "startPhoneEngine() isRegistered return ");
                return;
            }
            String username = PreferencesUtil.getSipUserName(this.context);
            String password = PreferencesUtil.getSipPassword(this.context);
            String realm = PreferencesUtil.getSipRealm(this.context);
            String realmExternal = PreferencesUtil.getSipRealmExternal(this.context);
            if (TextUtils.isBlank((CharSequence)username) || TextUtils.isBlank((CharSequence)password) || TextUtils.isBlank((CharSequence)realm) || TextUtils.isBlank((CharSequence)realmExternal)) {
                WebAgent.getInstance().startSipRequestProcess("startPhoneEngine => account not ready");
                Log.w(PhoneAgent.class.getSimpleName(), "startPhoneEngine() login information is empty, try to request sip account now !!");
                return;
            }
            if (PreferencesUtil.serverDiff(this.context)) {
                ConnectionAgent.getInstance().checkInOfficePbxFlag("startPhoneEngine");
            }
            int tlsPort = PreferencesUtil.getSipTlsPort(this.context);
            int portExternal = PreferencesUtil.getSipExternalPort(this.context);
            boolean remoteMobileSrtpUsed = PreferencesUtil.getMobileSrtpUsed(this.context);
            isRegistered = STAT_PROCESSING;
            if (PreferencesUtil.isSipInternal(this.context)) {
                this.startSipEngine(username, password, realm, tlsPort, false, remoteMobileSrtpUsed);
            } else {
                this.startSipEngine(username, password, realmExternal, portExternal, true, remoteMobileSrtpUsed);
            }
        }
    }

    private void startSipEngine(String username, String passwd, String realm, int tlsPort, boolean pub, boolean remoteMobileSrtpUsed) {
        Log.i(PhoneAgent.class.getSimpleName(), "startSipEngine()");
        isUpdateLoginSip = false;
        Bundle data = new Bundle();
        data.putString("username", username);
        data.putString("passwd", passwd);
        data.putString("realm", realm);
        data.putInt("port", tlsPort);
        data.putBoolean("pub", pub);
        data.putBoolean("remoteMobileSrtpUsed", remoteMobileSrtpUsed);
        this.sendSipAction(1, data);
    }

    @Override
    public BroadcastReceiver createReceiver() {
        Log.d(PhoneAgent.class.getSimpleName(), "PhoneAgent .... registerReceiver()");
        return new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, final Intent intent) {
                Log.d(PhoneAgent.class.getSimpleName(), "PhoneAgent onReceive:" + intent.getAction());
                String action = intent.getAction();
                if ("ezphone.intent.action.event.PHONE_SERVICE_RELOAD_REQUEST".equals(action)) {
                    String place = intent.getStringExtra("PLACE");
                    Log.i(PhoneAgent.this.getClass().getSimpleName(), "[EVENT] phone service reload received ......" + place);
                    PhoneAgent.this.manualRegistSip();
                } else if ("ezphone.intent.action.event.SIP_EVENT_REG_STATE".equals(action)) {
                    String reason = intent.getStringExtra("KEY_SIP_REASON");
                    int statusCode = intent.getIntExtra("KEY_SIP_STATUS_CODE", 0);
                    if (statusCode == 200) {
                        PhoneAgent.this.onRegistrationSuccess();
                    } else {
                        PhoneAgent.this.onRegistrationFailure(statusCode, reason);
                    }
                } else if ("ezphone.intent.action.event.SIP_EVENT_CONNECTION_FAILED".equals(action)) {
                    PhoneAgent.this.onSipConnectionFailure();
                } else if ("ezphone.intent.action.event.SIP_EVENT_UNREG_STATE".equals(action)) {
                    PhoneAgent.this.onUnregistrationSuccess();
                } else if ("ezphone.intent.action.event.SIP_EVENT_INCOMING_CALL".equals(action)) {
                    String blinfoStr = intent.getStringExtra("KEY_SIP_BL_INFO");
                    String blRuleInfo = intent.getStringExtra("KEY_SIP_BL_RULE_INFO");
                    String blPattern = intent.getStringExtra("KEY_SIP_BL_PATTERN");
                    String sipCallId = intent.getStringExtra("KEY_SIP_CALL_ID");
                    int line = intent.getIntExtra("KEY_SIP_LINE", 0);
                    String callerId = intent.getStringExtra("KEY_SIP_CALLER");
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    if (blinfoStr != null) {
                        String[] items = blinfoStr.split("&");
                        for (int i = 0; items != null && i < items.length; ++i) {
                            String item = items[i];
                            String[] itemAry = item.split("=");
                            if (itemAry.length == 2) {
                                map.put(itemAry[0], itemAry[1]);
                                continue;
                            }
                            if (itemAry.length != 1) continue;
                            map.put(itemAry[0], "");
                        }
                    }
                    PhoneAgent.this.onIncomingCall(line, callerId, map, blRuleInfo, blPattern, sipCallId);
                } else if ("ezphone.intent.action.event.SIP_EVENT_IDLE".equals(action)) {
                    int line = intent.getIntExtra("KEY_SIP_LINE", 0);
                    Log.d(PhoneAgent.class.getSimpleName(), "SIP_EVENT_IDLE ...........................line:" + line);
                    String reason = intent.getStringExtra("KEY_SIP_REASON");
                    PhoneAgent.this.onIdle(line, reason);
                } else if ("ezphone.intent.action.event.SIP_EVENT_OUTGOING_CALL".equals(action)) {
                    int line = intent.getIntExtra("KEY_SIP_LINE", 0);
                    String sipCallId = intent.getStringExtra("KEY_SIP_CALL_ID");
                    PhoneAgent.this.onOutgoingCall(line, sipCallId);
                } else if ("ezphone.intent.action.event.SIP_EVENT_INCALL".equals(action)) {
                    PhoneAgent.this.onInCall(intent.getIntExtra("KEY_SIP_LINE", 0));
                } else if ("ezphone.intent.action.event.SIP_EVENT_HOLD".equals(action)) {
                    int line = intent.getIntExtra("KEY_SIP_LINE", 0);
                    PhoneAgent.this.onHold(line);
                } else if ("ezphone.intent.action.event.SIP_EVENT_MUTE".equals(action)) {
                    Log.d(PhoneAgent.class.getSimpleName(), "SIP_EVENT_MUTE:" + intent.getBooleanExtra("KEY_SIP_IS_MUTE", false));
                    boolean _isMute = intent.getBooleanExtra("KEY_SIP_IS_MUTE", false);
                    int line = intent.getIntExtra("KEY_SIP_LINE", 0);
                    PhoneAgent.this.onMute(line, _isMute);
                } else if ("ezphone.intent.action.event.SIP_EVENT_RECORDING".equals(action)) {
                    Log.d(PhoneAgent.class.getSimpleName(), "SIP_EVENT_RECORDING:" + intent.getBooleanExtra("KEY_SIP_IS_RECORDING", false));
                    boolean _isRecording = intent.getBooleanExtra("KEY_SIP_IS_RECORDING", false);
                    PhoneAgent.this.onRecording(intent.getIntExtra("KEY_SIP_LINE", 0), _isRecording);
                } else if ("ezphone.intent.action.event.SIP_EVENT_RECORDING_READY".equals(action)) {
                    PhoneAgent.this.checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                        @Override
                        public void doRun() {
                            int line = intent.getIntExtra("KEY_SIP_LINE", 0);
                            File file = (File)intent.getSerializableExtra("KEY_RECORDING_FILE_PATH");
                            long startTime = intent.getLongExtra("KEY_REC_START_TIME", 0L);
                            long endTime = intent.getLongExtra("KEY_REC_END_TIME", 0L);
                            PhoneLineInfo lineInfo = (PhoneLineInfo)intent.getSerializableExtra("KEY_SIP_LINE_INFO");
                            PhoneAgent.this.onLocalRecordingRedy(line, lineInfo, file, startTime, endTime);
                        }
                    }, 1000L);
                } else if ("ezphone.intent.action.event.SIP_EVENT_CALL_FAILED".equals(action)) {
                    int line = intent.getIntExtra("KEY_SIP_LINE", 0);
                    int result = intent.getIntExtra("KEY_SIP_CALL_FAILED_RESULT", 0);
                    PhoneAgent.this.onCallFailed(line, result);
                } else if ("ezphone.intent.action.event.SIP_EVENT_NOTIFY_TALK".equals(action)) {
                    int targetLine = intent.getIntExtra("KEY_SIP_LINE", 0);
                    CallLine callLine = callLineAry[targetLine];
                    if (callLine.getState() == CallState.INCOMING_CALL) {
                        PhoneAgent.this.answerLine(targetLine);
                    } else if (callLine.getState() == CallState.HOLD) {
                        if (PhoneAgent.this.isOtherLineDialingOut(targetLine)) {
                            return;
                        }
                        for (CallLine oCallLine : callLineAry) {
                            if (oCallLine.getLineId() == targetLine || oCallLine.getState() != CallState.INCALL) continue;
                            Bundle data = new Bundle();
                            data.putInt("KEY_SIP_LINE", oCallLine.getLineId());
                            PhoneAgent.this.sendSipAction(13, data);
                        }
                        Bundle data = new Bundle();
                        data.putInt("KEY_SIP_LINE", targetLine);
                        PhoneAgent.this.sendSipAction(14, data);
                    }
                } else if ("ezphone.intent.action.event.SIP_EVENT_NOTIFY_HOLD".equals(action)) {
                    int targetLine = intent.getIntExtra("KEY_SIP_LINE", 0);
                    CallLine callLine = callLineAry[targetLine];
                    if (callLine.getState() == CallState.INCALL) {
                        Bundle data = new Bundle();
                        data.putInt("KEY_SIP_LINE", targetLine);
                        PhoneAgent.this.sendSipAction(13, data);
                    }
                } else {
                    Log.e(PhoneAgent.class.getSimpleName(), "PhoneAgent \u6536\u5230\u672a\u77e5\u5ee3\u64ad\uff1a" + intent.getAction());
                }
            }
        };
    }

    @Override
    public IntentFilter createIntentFilter() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("ezphone.intent.action.event.SIP_EVENT_REG_STATE");
        filter.addAction("ezphone.intent.action.event.SIP_EVENT_UNREG_STATE");
        filter.addAction("ezphone.intent.action.event.SIP_EVENT_CONNECTION_FAILED");
        filter.addAction("ezphone.intent.action.event.SIP_EVENT_IDLE");
        filter.addAction("ezphone.intent.action.event.SIP_EVENT_INCOMING_CALL");
        filter.addAction("ezphone.intent.action.event.SIP_EVENT_OUTGOING_CALL");
        filter.addAction("ezphone.intent.action.event.SIP_EVENT_INCALL");
        filter.addAction("ezphone.intent.action.event.SIP_EVENT_HOLD");
        filter.addAction("ezphone.intent.action.event.SIP_EVENT_MUTE");
        filter.addAction("ezphone.intent.action.event.SIP_EVENT_RECORDING");
        filter.addAction("ezphone.intent.action.event.SIP_EVENT_RECORDING_READY");
        filter.addAction("ezphone.intent.action.event.SIP_EVENT_CALL_FAILED");
        filter.addAction("ezphone.intent.action.event.SIP_EVENT_NOTIFY_TALK");
        filter.addAction("ezphone.intent.action.event.SIP_EVENT_NOTIFY_HOLD");
        filter.addAction("ezphone.intent.action.event.PHONE_SERVICE_RELOAD_REQUEST");
        return filter;
    }

    public String getCallerName(String caller) {
        if (caller == null || caller.length() == 0) {
            return "";
        }
        String callerName = caller.toString();
        String result = "";
        if (callerName.indexOf("\"") >= 0) {
            result = callerName.substring(callerName.indexOf("\"") + 1, callerName.lastIndexOf("\""));
        }
        return result;
    }

    private CallLine getMeetmeLine(String roomNo) {
        String prefix = OutboundPrefixManager.getMeetmePrefix(this.context);
        for (CallLine line : callLineAry) {
            PhoneLineInfo lineInfo;
            if (line.getState() != CallState.INCALL && line.getState() != CallState.OUTGOING_CALL || (lineInfo = line.getLineInfo()) == null || !(prefix + roomNo).equals(lineInfo.getNumber())) continue;
            return line;
        }
        return null;
    }

    private CallLine getMeetmeLineByJid(String jid) {
        for (CallLine line : callLineAry) {
            PhoneLineInfo lineInfo;
            if (line.getState() != CallState.INCALL && line.getState() != CallState.OUTGOING_CALL || (lineInfo = line.getLineInfo()) == null || !jid.equals(lineInfo.getJid())) continue;
            return line;
        }
        return null;
    }

    private void sendEmptyMessageDelayed(int msgHaltSip, int i) {
        this.msgActionHandler.sendEmptyMessageDelayed(msgHaltSip, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(int line, String number, PhoneLineInfo lineInfo) {
        PhoneAgent phoneAgent = this;
        synchronized (phoneAgent) {
            this.multiDialCleanup();
            this.doHoldOtherLine(line);
            currentLine = line;
            CallLine callLine = callLineAry[line];
            callLine.setLineInfo(lineInfo);
            Log.d(PhoneAgent.class.getSimpleName(), "dial line:" + line + " number:" + number + " lineInfo:" + String.valueOf(lineInfo));
            String phoneNum = PhoneNoUtil.cleanPhoneNo(number);
            if (TextUtils.isBlank((CharSequence)phoneNum)) {
                return;
            }
            Bundle data = new Bundle();
            data.putString("phoneNum", phoneNum);
            data.putInt("KEY_SIP_LINE", line);
            if (lineInfo.getEmpId() != null) {
                data.putLong("empId", lineInfo.getEmpId());
            }
            if (lineInfo.getContactId() != null) {
                data.putLong("contactId", lineInfo.getContactId());
            }
            if (StringUtils.isNotBlank((CharSequence)lineInfo.getLinkId())) {
                data.putString("KEY_SIP_LINKID", lineInfo.getLinkId());
            }
            this.sendSipAction(10, data);
        }
    }

    public int call(String number, PhoneLineInfo lineInfo) {
        CallLine callLine = callLineAry[currentLine];
        if (callLine.getState() == CallState.IDLE) {
            this.call(callLine.getLineId(), number, lineInfo);
            return callLine.getLineId();
        }
        for (CallLine callLinex : callLineAry) {
            if (callLinex.getState() != CallState.IDLE) continue;
            this.call(callLinex.getLineId(), number, lineInfo);
            return callLinex.getLineId();
        }
        return -1;
    }

    public int callChatRoomDir(String number, PhoneLineInfo lineInfo) {
        CallLine callLine = callLineAry[currentLine];
        if (callLine.getState() == CallState.IDLE) {
            this.callChatRoomDir(callLine.getLineId(), number, lineInfo);
            return callLine.getLineId();
        }
        for (CallLine callLinex : callLineAry) {
            if (callLinex.getState() != CallState.IDLE) continue;
            this.callChatRoomDir(callLinex.getLineId(), number, lineInfo);
            return callLinex.getLineId();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callChatRoomDir(int line, String number, PhoneLineInfo lineInfo) {
        PhoneAgent phoneAgent = this;
        synchronized (phoneAgent) {
            Log.d(PhoneAgent.class.getSimpleName(), "dial line:" + line + " number:" + number + " lineInfo:" + String.valueOf(lineInfo));
            this.multiDialCleanup();
            this.doHoldOtherLine(line);
            currentLine = line;
            CallLine callLine = callLineAry[line];
            callLine.setLineInfo(lineInfo);
            Log.d(PhoneAgent.class.getSimpleName(), "dial line:" + line + " number:" + number + " lineInfo:" + String.valueOf(lineInfo));
            String phoneNum = PhoneNoUtil.cleanPhoneNo(number);
            if (TextUtils.isEmpty((CharSequence)phoneNum)) {
                return;
            }
            Bundle data = new Bundle();
            data.putString("phoneNum", phoneNum);
            data.putInt("KEY_SIP_LINE", line);
            if (lineInfo.getEmpId() != null) {
                data.putLong("empId", lineInfo.getEmpId());
            }
            if (lineInfo.getContactId() != null) {
                data.putLong("contactId", lineInfo.getContactId());
            }
            if (StringUtils.isNotBlank((CharSequence)lineInfo.getLinkId())) {
                data.putString("KEY_SIP_LINKID", lineInfo.getLinkId());
            }
            this.sendSipAction(10, data);
        }
    }

    private boolean makeSureLineHoldIfInUse(int line) {
        CallLine callLine = callLineAry[line];
        if (callLine.getState() == CallState.INCALL) {
            Bundle data = new Bundle();
            data.putInt("KEY_SIP_LINE", line);
            this.sendSipAction(13, data);
            return true;
        }
        return false;
    }

    private void makeSureLineUnoldIfHold(int line) {
        CallLine callLine = callLineAry[line];
        if (callLine.getState() == CallState.HOLD) {
            Bundle data = new Bundle();
            data.putInt("KEY_SIP_LINE", line);
            this.sendSipAction(14, data);
        }
    }

    public boolean isCallIdle() {
        for (CallLine callLine : callLineAry) {
            if (callLine.getState() == CallState.IDLE) continue;
            return false;
        }
        return true;
    }

    public boolean isOtherLineDialingOut(int line) {
        for (CallLine callLine : callLineAry) {
            if (callLine.getLineId() == line || callLine.getState() != CallState.OUTGOING_CALL) continue;
            return true;
        }
        return false;
    }

    public boolean toggleHold(int line) {
        CallLine callLine = callLineAry[line];
        Log.d(PhoneAgent.class.getSimpleName(), "togglehold:" + callLine.getState().getCode() + " line:" + line);
        if (callLine.getState() != CallState.INCALL && callLine.getState() != CallState.HOLD) {
            return false;
        }
        if (callLine.getState() == CallState.HOLD) {
            if (this.isOtherLineDialingOut(line)) {
                return false;
            }
            for (CallLine oCallLine : callLineAry) {
                if (oCallLine.getLineId() == line || oCallLine.getState() != CallState.INCALL) continue;
                Bundle data = new Bundle();
                data.putInt("KEY_SIP_LINE", oCallLine.getLineId());
                this.sendSipAction(13, data);
            }
        }
        Bundle data = new Bundle();
        data.putInt("KEY_SIP_LINE", line);
        if (callLine.getState() == CallState.INCALL) {
            this.sendSipAction(13, data);
        } else if (callLine.getState() == CallState.HOLD) {
            this.sendSipAction(14, data);
        }
        return true;
    }

    public void transfer(int line, String number) {
        Log.w(PhoneAgent.class.getSimpleName(), "transfer " + line + " to " + number);
        if (TextUtils.isNotBlank((CharSequence)number)) {
            Bundle data = new Bundle();
            data.putString("phoneNum", number);
            data.putInt("KEY_SIP_LINE", line);
            this.sendSipAction(17, data);
        } else {
            Log.w(PhoneAgent.class.getSimpleName(), "transfer to null");
        }
    }

    public void transferReplace(int line, int destLine) {
        Log.w(PhoneAgent.class.getSimpleName(), "transfer " + line + " to " + destLine);
        Bundle data = new Bundle();
        data.putInt("KEY_SIP_DEST_LINE", destLine);
        data.putInt("KEY_SIP_LINE", line);
        this.sendSipAction(19, data);
    }

    public void sendDTMF(int line, char c, int duration) {
        Bundle data = new Bundle();
        data.putInt("KEY_SIP_LINE", line);
        data.putString("KEY_SIP_DTMF", Character.toString(c));
        this.sendSipAction(9, data);
    }

    public void sendDTMF(final char c, int duration) {
        CallLine callLine;
        if (PreferencesUtil.isKeyboardTouchSound()) {
            this.checkLocalTimer.schedule((TimerTask)new UCTimerTask(this){

                @Override
                public void doRun() {
                    ToneUtil.generateTone(c);
                }
            }, 0L);
        }
        if ((callLine = callLineAry[currentLine]).getState() == CallState.IDLE) {
            Log.w(PhoneAgent.class.getSimpleName(), "state is idle, skip sending DTMF " + c);
            return;
        }
        this.sendDTMF(currentLine, c, duration);
    }

    public void setMuteOn(int line) {
        Bundle data = new Bundle();
        data.putInt("KEY_SIP_LINE", line);
        this.sendSipAction(15, data);
    }

    public boolean toggleMute(int line) {
        CallLine callLine = callLineAry[line];
        if (callLine.getState() == CallState.IDLE) {
            return false;
        }
        Bundle data = new Bundle();
        data.putInt("KEY_SIP_LINE", line);
        if (callLine.isMute()) {
            this.sendSipAction(16, data);
        } else {
            this.sendSipAction(15, data);
        }
        return true;
    }

    public boolean toggleRecording(int line) {
        CallLine callLine = callLineAry[line];
        if (callLine.getState() != CallState.INCALL && callLine.getState() != CallState.HOLD) {
            return false;
        }
        Bundle data = new Bundle();
        data.putInt("KEY_SIP_LINE", line);
        if (callLine.isRecordingFlag()) {
            this.sendSipAction(29, data);
        } else {
            PhoneLineInfo lineInfo = callLine.getLineInfo();
            if (lineInfo != null) {
                data.putSerializable("KEY_SIP_LINE_INFO", lineInfo);
            }
            this.sendSipAction(28, data);
        }
        return true;
    }

    public void stopRecording(int line) {
        try {
            Bundle data = new Bundle();
            data.putInt("KEY_SIP_LINE", line);
            this.sendSipAction(29, data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void manualRegistSip() {
        this.sendSipAction(30, null);
    }

    public void adjustVolumnGain(String type, String volumn) {
        if (this.isCallIdle()) {
            return;
        }
        for (CallLine callLine : callLineAry) {
            if (callLine.getState() == CallState.IDLE) continue;
            this.adjustVolumnGain(callLine.getLineId(), type, volumn);
        }
    }

    private void adjustVolumnGain(int line, String type, String volumn) {
        try {
            Bundle data = new Bundle();
            data.putInt("KEY_SIP_LINE", line);
            data.putString("KEY_VOLUMN_GAIN_TYPE", type);
            data.putFloat("KEY_VOLUMN_GAIN_VALUE", Float.valueOf(volumn));
            this.sendSipAction(20, data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onAgentDestroy() {
        Log.i(PhoneAgent.class.getSimpleName(), "stop SipPhoneService");
        this.context.unbindService(this);
        this.context.stopService(new Intent(this.context, SipPhoneService.class));
        if (this.checkLocalTimer != null) {
            this.checkLocalTimer.cancel();
        }
        super.onAgentDestroy();
        this.multiDialCleanup();
        Log.d(PhoneAgent.class.getSimpleName(), "onAgentDestroy");
        isRegistered = STAT_NOT_REGISTERED;
        this.cleanCallData(0, "onAgentDestroy");
        this.cleanCallData(1, "onAgentDestroy");
    }

    private void multiDialCleanup() {
        if (this.mMultiDialDirectHelper != null) {
            this.mMultiDialDirectHelper.destroy();
            this.mMultiDialDirectHelper = null;
        }
    }

    public CallLine getCallLine(int line) {
        return callLineAry[line];
    }

    public CallLine[] getCallLineAry() {
        return callLineAry;
    }

    public CallLine getCurrentCallLine() {
        return callLineAry[currentLine];
    }

    public int getCurrentLineIndex() {
        return currentLine;
    }

    public void onIncomingCall(int _line, String sipCaller, HashMap<String, Object> _blInfoMap, String blRuleInfo, String blPattern, String sipCallId) {
        Log.d(PhoneAgent.class.getSimpleName(), "STATE_INCOMING_CALL _line:" + _line + " blInfo:" + String.valueOf(_blInfoMap));
        CallLine callLine = callLineAry[_line];
        callLine.setState(CallState.INCOMING_CALL);
        callLine.setSipCallId(sipCallId);
        callLine.setFirstTimeInCall(true);
        String callerType = (String)_blInfoMap.get("BL_CALLER_TYPE");
        PhoneLineInfo incomingLineInfo = null;
        if ("EMPLOYEE".equals(callerType)) {
            incomingLineInfo = new PhoneLineInfo();
            incomingLineInfo.setIncomingCall(true);
            IncomingDataHelper.prepareEmployeeInfo(this.context, incomingLineInfo, _blInfoMap);
        } else if ("LOCATION".equals(callerType)) {
            incomingLineInfo = new PhoneLineInfo();
            incomingLineInfo.setIncomingCall(true);
            IncomingDataHelper.prepareLocationInfo(this.context, incomingLineInfo, _blInfoMap);
        } else {
            incomingLineInfo = new PhoneLineInfo();
            incomingLineInfo.setIncomingCall(true);
            IncomingDataHelper.prepareInboundInfo(this.context, incomingLineInfo, _blInfoMap, sipCaller, blRuleInfo, blPattern);
        }
        callLine.setLineInfo(incomingLineInfo);
        if (!WebAgent.isLogin || !PSTN_STATE_IDLE.equals(pstnState) || PreferencesUtil.isSyncDataNow(this.context)) {
            Log.d(PhoneAgent.class.getSimpleName(), "STATE_INCOMING_CALL rejectcall pstnState:" + pstnState);
            Message msg = Message.obtain(this.msgActionHandler, 11);
            Bundle data = new Bundle();
            data.putInt("line", _line);
            msg.setData(data);
            this.msgActionHandler.sendMessageDelayed(msg, 200L);
            return;
        }
        String autoAnswer = (String)_blInfoMap.get("BL_AUTO_ANSWER");
        if (TextUtils.isNotBlank((CharSequence)autoAnswer) && autoAnswer.equals("Y")) {
            this.doHoldOtherLine(_line);
            incomingLineInfo.setAutoAnswered(true);
            Bundle data0 = new Bundle();
            data0.putInt("KEY_SIP_LINE", _line);
            this.sendSipAction(50, data0);
            Message msg = Message.obtain(this.msgActionHandler, 10);
            Bundle data = new Bundle();
            data.putInt("line", _line);
            msg.setData(data);
            this.msgActionHandler.sendMessageDelayed(msg, 200L);
        } else {
            boolean shouldRing = true;
            for (CallLine oCallLine : callLineAry) {
                if (oCallLine.getLineId() == _line || oCallLine.getState() == CallState.IDLE) continue;
                shouldRing = false;
                break;
            }
            Bundle data0 = new Bundle();
            data0.putInt("KEY_SIP_LINE", _line);
            this.sendSipAction(50, data0);
            if (shouldRing) {
                Bundle data1 = new Bundle();
                data1.putInt("KEY_SIP_LINE", _line);
                this.sendSipAction(7, data1);
            }
            BroadcastUtil.sendPhoneStateChangedEvent(this.context, _line);
        }
    }

    public void hangupMeetme(String targetJid) {
        for (CallLine line : callLineAry) {
            PhoneLineInfo lineInfo = line.getLineInfo();
            if (lineInfo == null) continue;
            String jid = null;
            jid = lineInfo.getType() == 8 || lineInfo.getType() == 10 ? lineInfo.getNumber() : lineInfo.getJid();
            if (jid == null || !jid.equals(targetJid)) continue;
            this.hangupLine(line.getLineId());
            return;
        }
    }

    private void doHoldOtherLine(int line) {
        boolean doHold = false;
        for (int i = 0; i < LINE_COUNT; ++i) {
            boolean doHoldLine;
            if (i == line || !(doHoldLine = this.makeSureLineHoldIfInUse(i))) continue;
            doHold = true;
        }
        if (doHold) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void answerLine(int line) {
        this.doHoldOtherLine(line);
        Bundle data = new Bundle();
        data.putInt("KEY_SIP_LINE", line);
        instance.sendSipAction(11, data);
    }

    public void hangupLine(int line) {
        CallLine callLine = callLineAry[line];
        if (callLine.getState() == CallState.IDLE) {
            return;
        }
        Bundle data = new Bundle();
        data.putInt("KEY_SIP_LINE", line);
        instance.sendSipAction(12, data);
    }

    public void rejectLine(int line) {
        CallLine callLine = callLineAry[line];
        if (callLine.getState() == CallState.IDLE) {
            return;
        }
        Bundle data = new Bundle();
        data.putInt("KEY_SIP_LINE", line);
        instance.sendSipAction(18, data);
    }

    public void onOutgoingCall(int line, String sipCallId) {
        CallLine callLine = callLineAry[line];
        callLine.setState(CallState.OUTGOING_CALL);
        callLine.setSipCallId(sipCallId);
        callLine.setFirstTimeInCall(true);
        BroadcastUtil.sendPhoneStateChangedEvent(this.context, line);
    }

    public void onInCall(int line) {
        PhoneLineInfo info;
        CallLine callLine = callLineAry[line];
        callLine.setState(CallState.INCALL);
        if (callLine.isMute()) {
            this.setMuteOn(line);
        }
        if ((info = callLine.getLineInfo()) != null) {
            if (callLine.isFirstTimeInCall() || info.getCallerStartTime() == 0L) {
                callLine.setFirstTimeInCall(false);
                info.setCallerStartTime(System.currentTimeMillis());
            }
            info.setConfirmed(true);
        }
        BroadcastUtil.sendPhoneStateChangedEvent(this.context, line);
    }

    public void onHold(int line) {
        CallLine callLine = callLineAry[line];
        callLine.setState(CallState.HOLD);
        BroadcastUtil.sendPhoneStateChangedEvent(this.context, line);
    }

    public void onCallFailed(final int line, int result) {
        switch (result) {
            case -1: {
                ToastUtil.show(this.context, I18NUtil.getString("phone_notice_no_speaker_device"), 20);
                break;
            }
            case -2: {
                ToastUtil.show(this.context, I18NUtil.getString("phone_notice_no_cap_device"), 20);
                break;
            }
            case -3: {
                ToastUtil.show(this.context, I18NUtil.getString("phone_notice_no_cap_speaker_device"), 20);
            }
        }
        this.checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

            @Override
            public void doRun() {
                PhoneAgent.this.cleanCallData(line, "onidle");
                BroadcastUtil.sendPhoneStateChangedEvent(PhoneAgent.this.context, line);
            }
        }, 1000L);
    }

    public void onIdle(int line, String reason) {
        int targetLine;
        CallLine callLine = callLineAry[line];
        if (callLine.getState() == CallState.IDLE) {
            return;
        }
        CallState oldState = callLine.getState();
        callLine.setState(CallState.IDLE);
        if (this.isCallIdle() && (oldState == CallState.OUTGOING_CALL || oldState == CallState.INCALL || oldState == CallState.HOLD)) {
            this.playBusyTone();
        }
        currentLine = targetLine = this.findOtherBusyLine(line);
        if (targetLine != line) {
            this.makeSureLineUnoldIfHold(targetLine);
        }
        this.cleanCallData(line, "onidle");
        WebAgent.callAttachData = new JSONObject();
        BroadcastUtil.sendPhoneStateChangedEvent(this.context, line);
    }

    public void switchCurrentLine(int line) {
        currentLine = line;
    }

    private int findOtherBusyLine(int line) {
        for (CallLine callLine : callLineAry) {
            if (callLine.getLineId() == line || callLine.getState() == CallState.IDLE) continue;
            return callLine.getLineId();
        }
        return 0;
    }

    public void onMute(int line, boolean isMute) {
        CallLine callLine = callLineAry[line];
        callLine.setMute(isMute);
        BroadcastUtil.sendPhoneMuteChangedEvent(this.context, line);
    }

    public void onRecording(int line, boolean isRecording) {
        CallLine callLine = callLineAry[line];
        callLine.setRecordingFlag(isRecording);
        BroadcastUtil.sendPhoneRecordingChangedEvent(this.context, line);
    }

    public void timeoutCleanUp() {
        Log.i(PhoneAgent.class.getSimpleName(), "internalTimeoutCleanUp()");
        Log.i(PhoneAgent.class.getSimpleName(), "PhoneAgent internalTimeoutCleanUp");
        for (int line = 0; line < LINE_COUNT; ++line) {
            this.onIdle(line, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRegistrationSuccess() {
        if (isRegistered != STAT_REGISTERED) {
            Log.i(PhoneAgent.class.getSimpleName(), "PhoneAgent onRegistrationSuccess");
        }
        PhoneAgent phoneAgent = this;
        synchronized (phoneAgent) {
            this.registrationFailureCount = 0;
            isRegistered = STAT_REGISTERED;
            BroadcastUtil.sendPhoneRegistrationOKEvent(this.context);
            if (!isUpdateLoginSip) {
                Log.i(PhoneAgent.class.getSimpleName(), "do update login sip ...");
                WebAgent.getInstance().updateLoginSip();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRegistrationFailure(int statusCode, String result) {
        Log.i(PhoneAgent.class.getSimpleName(), "PhoneAgent onRegistrationFailure statusCode: " + statusCode);
        PhoneAgent phoneAgent = this;
        synchronized (phoneAgent) {
            ++this.registrationFailureCount;
            this.unregisterAfterwork("onRegistrationFailure");
            BroadcastUtil.sendPhoneRegistrationFailedEvent(this.context, result);
            if (statusCode == 403 || statusCode == 404 || statusCode == 502 || statusCode == 503 || statusCode == 504) {
                WebAgent.getInstance().getSipAccountOnRegFail(this.registrationFailureCount, "PhoneAgent onRegistrationFailure");
            } else {
                BroadcastUtil.sendPhoneRegistrationRequestEvent(this.context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSipConnectionFailure() {
        PhoneAgent phoneAgent = this;
        synchronized (phoneAgent) {
            if (isRegistered != STAT_NOT_REGISTERED) {
                this.unregisterAfterwork("onSipConnectionFailure");
                BroadcastUtil.sendPhoneConnectionFailedEvent(this.context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUnregistrationSuccess() {
        Log.i(PhoneAgent.class.getSimpleName(), "PhoneAgent onUnregistrationSuccess");
        PhoneAgent phoneAgent = this;
        synchronized (phoneAgent) {
            this.unregisterAfterwork("success onUnregistrationSuccess");
        }
    }

    private void unregisterAfterwork(String result) {
        Log.i(PhoneAgent.class.getSimpleName(), "PhoneAgent unregisterAfterwork:" + result);
        isRegistered = STAT_NOT_REGISTERED;
        for (CallLine callLine : callLineAry) {
            if (callLine.getState() == CallState.IDLE) continue;
            this.onIdle(callLine.getLineId(), result);
        }
        BroadcastUtil.sendPhoneUnregistrationDoneEvent(this.context, result);
    }

    private void cleanCallData(int line, String place) {
        Log.i(PhoneAgent.class.getSimpleName(), "clean line " + line + " data:" + place);
        CallLine callLine = callLineAry[line];
        callLine.setMute(false);
        callLine.setRecordingFlag(false);
        callLine.setFirstTimeInCall(false);
        callLine.setLineInfo(null);
        callLine.setState(CallState.IDLE);
        callLine.setSipCallId(null);
    }

    public void playBusyTone() {
        this.sendEmptyMessageDelayed(21, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findChatRoomNumThenDial(PhoneLineInfo phoneLineInfo, String chatRoomJid) {
        PhoneAgent phoneAgent = this;
        synchronized (phoneAgent) {
            if (this.mMultiDialDirectHelper != null) {
                this.mMultiDialDirectHelper.destroy();
                this.mMultiDialDirectHelper = null;
            }
            this.mMultiDialDirectHelper = new MultiDialDirectHelper(this.context, chatRoomJid, phoneLineInfo);
            this.mMultiDialDirectHelper.doDial();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceConnected(ComponentName className, IBinder service) {
        Log.d(PhoneAgent.class.getSimpleName(), "onServiceConnected");
        PhoneAgent phoneAgent = this;
        synchronized (phoneAgent) {
            this.mSipMsgService = new Messenger(service);
            this.mSipPhoneBound = STAT_BOUNDED;
            BroadcastUtil.sendPhoneServiceBoundedEvent(this.context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceDisconnected(ComponentName className) {
        Log.i(PhoneAgent.class.getSimpleName(), "onServiceDisconnected");
        PhoneAgent phoneAgent = this;
        synchronized (phoneAgent) {
            this.mSipMsgService = null;
            this.mSipPhoneBound = STAT_NOT_BOUNDED;
            this.unregisterAfterwork("success onServiceDisconnected");
        }
    }

    public void sendSipAction(int action, Bundle data) {
        Log.i(PhoneAgent.class.getSimpleName(), "sendSipAction() mSipPhoneBound:" + this.mSipPhoneBound);
        if (this.mSipPhoneBound != STAT_BOUNDED) {
            Log.e(PhoneAgent.class.getSimpleName(), "mSipPhoneBound false action:" + action);
            return;
        }
        Message msg = Message.obtain(null, action, 0, 0);
        if (data != null) {
            msg.setData(data);
        }
        try {
            this.mSipMsgService.send(msg);
        }
        catch (RemoteException e) {
            Log.e(PhoneAgent.class.getSimpleName(), "sendSipAction fail", e);
        }
    }

    public void onCallBridged(Context context, JSONObject dataObj) {
        try {
            CallLine callLine;
            JSONObject extra = dataObj.getJSONObject("extra");
            String sipCallId = null;
            if (extra.has("sipCallId")) {
                sipCallId = extra.getString("sipCallId");
            }
            if ((callLine = this.findCallLineBySipCallId(sipCallId)) == null) {
                return;
            }
            callLine.setBridged(true);
            PhoneLineInfo lineInfo = callLine.getLineInfo();
            if (lineInfo == null) {
                return;
            }
            String callerType = extra.getString("callerType");
            if ("EMPLOYEE".equals(callerType)) {
                map = new HashMap<String, Object>();
                map.put("BL_CALLER_EXT", extra.getString("callerExt"));
                map.put("BL_CALLER_SITE", extra.getString("callerSiteId"));
                map.put("BL_CALLER_DBID", extra.getString("callerDbId"));
                map.put("BL_CALLER_NAME", extra.getString("callerName"));
                IncomingDataHelper.prepareEmployeeInfo(context, lineInfo, map);
            } else if ("LOCATION".equals(callerType)) {
                map = new HashMap();
                map.put("BL_CALLER_EXT", extra.getString("callerExt"));
                map.put("BL_CALLER_SITE", extra.getString("callerSiteId"));
                map.put("BL_CALLER_NAME", extra.getString("callerName"));
                IncomingDataHelper.prepareLocationInfo(context, lineInfo, map);
            } else {
                map = new HashMap();
                map.put("BL_CALLER_EXT", extra.getString("callerExt"));
                String inboundInfo = extra.has("callerInboundInfo") ? extra.getString("callerInboundInfo") : null;
                String inboundPattern = extra.has("callerInboundPattern") ? extra.optString("callerInboundPattern") : null;
                IncomingDataHelper.prepareInboundInfo(context, lineInfo, map, null, inboundInfo, inboundPattern);
            }
            BroadcastUtil.sendPhoneTwoStepTransferEvent(context);
            Bundle data = new Bundle();
            data.putInt("KEY_SIP_LINE", callLine.getLineId());
            instance.sendSipAction(21, data);
        }
        catch (Exception ex) {
            Log.i(PhoneAgent.class.getSimpleName(), "onTwoStepTransfer", ex);
        }
    }

    public void onTwoStepTransfer(Context context, JSONObject dataObj) {
        try {
            PhoneLineInfo lineInfo;
            CallLine callLine;
            JSONObject extra = dataObj.getJSONObject("extra");
            String sipCallId = null;
            if (extra.has("sipCallId")) {
                sipCallId = extra.getString("sipCallId");
            }
            if ((callLine = this.findCallLineBySipCallId(sipCallId)).isRecordingFlag()) {
                this.stopRecording(callLine.getLineId());
            }
            if ((lineInfo = callLine.getLineInfo()) == null) {
                return;
            }
            lineInfo.setIncomingCall(true);
            lineInfo.setCallerStartTime(System.currentTimeMillis());
            String callerType = extra.getString("callerType");
            if ("EMPLOYEE".equals(callerType)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("BL_CALLER_EXT", extra.getString("callerExt"));
                map.put("BL_CALLER_DBID", extra.getString("callerDbId"));
                map.put("BL_CALLER_NAME", extra.getString("callerName"));
                IncomingDataHelper.prepareEmployeeInfo(context, lineInfo, map);
            } else if ("LOCATION".equals(callerType)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("BL_CALLER_EXT", extra.getString("callerExt"));
                map.put("BL_CALLER_DBID", extra.getString("callerDbId"));
                map.put("BL_CALLER_NAME", extra.getString("callerName"));
                IncomingDataHelper.prepareLocationInfo(context, lineInfo, map);
            } else {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("BL_CALLER_EXT", extra.getString("callerExt"));
                String inboundInfo = extra.has("callerInboundInfo") ? extra.getString("callerInboundInfo") : null;
                String inboundPattern = extra.has("callerInboundPattern") ? extra.optString("callerInboundPattern") : null;
                IncomingDataHelper.prepareInboundInfo(context, lineInfo, map, null, inboundInfo, inboundPattern);
            }
            BroadcastUtil.sendPhoneTwoStepTransferEvent(context);
        }
        catch (Exception ex) {
            Log.i(PhoneAgent.class.getSimpleName(), "onTwoStepTransfer", ex);
        }
    }

    public void onChatRoomTitleChanged(String roomJid, String subject) {
        CallLine currentLine = this.getMeetmeLineByJid(roomJid);
        if (currentLine == null) {
            return;
        }
        PhoneLineInfo lineInfo = currentLine.getLineInfo();
        if (lineInfo == null) {
            return;
        }
        if (roomJid.equalsIgnoreCase(lineInfo.getJid())) {
            String name = "";
            name = "i18n.three.way.calling".equalsIgnoreCase(subject) ? I18NUtil.getString("call_type_three_way_calling") : (ChatRoomManager.validateName(subject) ? subject : I18NUtil.getString("chatroom_label"));
            lineInfo.setName1(name);
        }
    }

    public void onConfRoomTitleChanged(String roomJid, String title, String roomNo) {
        CallLine currentLine = this.getMeetmeLine(roomNo);
        if (currentLine == null) {
            return;
        }
        PhoneLineInfo lineInfo = currentLine.getLineInfo();
        if (lineInfo == null) {
            return;
        }
        if (TextUtils.isNotBlank((CharSequence)title)) {
            lineInfo.setName1(title);
            lineInfo.setName2(null);
        }
    }

    public void onContactLoaded(LiteContact liteContact) {
        if (liteContact == null) {
            return;
        }
        for (CallLine callLine : callLineAry) {
            PhoneLineInfo lineInfo = callLine.getLineInfo();
            if (lineInfo == null || lineInfo.getJid() == null || !lineInfo.getJid().equalsIgnoreCase(liteContact.getJid())) continue;
            lineInfo.setName1(ContactManager.getNonEnglishName(liteContact));
            lineInfo.setName2(ContactManager.getFullEnglishName(liteContact));
            BroadcastUtil.sendPhoneInfoChanged(this.context, callLine.getLineId());
        }
    }

    public void onContactLoaded(String token, LiteContact liteContact) {
        if (liteContact == null) {
            return;
        }
        for (CallLine callLine : callLineAry) {
            PhoneLineInfo lineInfo = callLine.getLineInfo();
            if (lineInfo == null || lineInfo.getToken() == null || !lineInfo.getToken().equals(token)) continue;
            lineInfo.setType(1);
            lineInfo.setJid(liteContact.getJid());
            lineInfo.setSiteId(null);
            lineInfo.setName1(ContactManager.getNonEnglishName(liteContact));
            lineInfo.setName2(ContactManager.getFullEnglishName(liteContact));
            BroadcastUtil.sendPhoneInfoChanged(this.context, callLine.getLineId());
        }
    }

    public void onPhotoLoaded(String jid) {
        if (jid == null) {
            return;
        }
        for (CallLine callLine : callLineAry) {
            PhoneLineInfo lineInfo = callLine.getLineInfo();
            if (lineInfo == null || lineInfo.getJid() == null || !lineInfo.getJid().equalsIgnoreCase(jid)) continue;
            BroadcastUtil.sendPhoneInfoChanged(this.context, callLine.getLineId());
        }
    }

    private CallLine findCallLineBySipCallId(String sipCallId) {
        if (sipCallId != null) {
            for (CallLine callLine : callLineAry) {
                if (callLine.getSipCallId() == null || !callLine.getSipCallId().equalsIgnoreCase(sipCallId)) continue;
                return callLine;
            }
        }
        return callLineAry[currentLine];
    }

    public void onInviteThreeWayCalling(Context context, String roomId, String roomName, String roomNo, String chatRoomJid, String sipCallId) {
        PhoneLineInfo lineInfo;
        CallLine callLine = this.findCallLineBySipCallId(sipCallId);
        if (callLine.isRecordingFlag()) {
            this.stopRecording(callLine.getLineId());
        }
        if ((lineInfo = callLine.getLineInfo()) == null) {
            return;
        }
        try {
            lineInfo.setIncomingCall(false);
            IncomingDataHelper.prepareInviteJoinConfInfo(context, lineInfo, roomId, roomName, roomNo, chatRoomJid);
            CallState lineState = callLine.getState();
            if ((lineState == CallState.INCALL || lineState == CallState.HOLD) && JidUtil.isConfJid(chatRoomJid) && PreferencesUtil.isConfAutoMuteEnabled() && !callLine.isMute()) {
                this.setMuteOn(callLine.getLineId());
            }
            BroadcastUtil.sendPhoneTwoStepTransferEvent(context);
        }
        catch (Exception ex) {
            Log.i(PhoneAgent.class.getSimpleName(), "onTwoStepTransfer", ex);
        }
    }

    public void onInviteThreeWayCalling(Context context, JSONObject dataObj) {
        try {
            PhoneLineInfo lineInfo;
            CallLine callLine;
            JSONObject extra = dataObj.getJSONObject("extra");
            String sipCallId = null;
            if (extra.has("sipCallId")) {
                sipCallId = extra.getString("sipCallId");
            }
            if ((callLine = this.findCallLineBySipCallId(sipCallId)).isRecordingFlag()) {
                this.stopRecording(callLine.getLineId());
            }
            if ((lineInfo = callLine.getLineInfo()) == null) {
                return;
            }
            lineInfo.setIncomingCall(false);
            lineInfo.setCallerStartTime(System.currentTimeMillis());
            String roomId = extra.getString("roomId");
            String roomName = extra.getString("roomName");
            String roomNo = extra.getString("roomNo");
            String chatRoomJid = extra.getString("chatRoomId");
            IncomingDataHelper.prepareInviteJoinConfInfo(context, lineInfo, roomId, roomName, roomNo, chatRoomJid);
            BroadcastUtil.sendPhoneInviteJoinMeetmeEvent(context);
        }
        catch (Exception ex) {
            Log.i(PhoneAgent.class.getSimpleName(), "onTwoStepTransfer", ex);
        }
    }

    public void onInviteJoinMeetme(Context context, JSONObject dataObj) {
        CallLine callLine = callLineAry[0];
        PhoneLineInfo lineInfo = callLine.getLineInfo();
        if (lineInfo == null) {
            return;
        }
        try {
            lineInfo.setIncomingCall(false);
            lineInfo.setCallerStartTime(System.currentTimeMillis());
            JSONObject extra = dataObj.getJSONObject("extra");
            String roomId = extra.getString("roomId");
            String roomName = extra.getString("roomName");
            String roomNo = extra.getString("roomNo");
            String chatRoomJid = extra.getString("chatRoomId");
            IncomingDataHelper.prepareInviteJoinConfInfo(context, lineInfo, roomId, roomName, roomNo, chatRoomJid);
            BroadcastUtil.sendPhoneTwoStepTransferEvent(context);
        }
        catch (Exception ex) {
            Log.i(PhoneAgent.class.getSimpleName(), "onTwoStepTransfer", ex);
        }
    }

    private void onLocalRecordingRedy(int line, PhoneLineInfo lineInfo, File sfile, long recStartTime, long recStopTime) {
        Log.i(PhoneAgent.class.getSimpleName(), "onLocalRecordingRedy line:" + line + " filePath:" + sfile.getAbsolutePath() + " recStartTime:" + recStartTime + " recStopTime:" + recStopTime);
        try {
            if (lineInfo == null) {
                return;
            }
            Thread.sleep(1000L);
            long duration = AppUtils.getWavDuration(sfile);
            Log.i(PhoneAgent.class.getSimpleName(), "=============>" + duration);
            int index = sfile.getAbsolutePath().lastIndexOf(".");
            String mp3Path = sfile.getAbsolutePath().substring(0, index) + ".mp3";
            File mp3 = new File(mp3Path);
            mp3.createNewFile();
            PlayAudioUtils.waveToMp3(sfile, mp3);
            sfile.delete();
            sfile = mp3;
            long id = System.currentTimeMillis();
            VoiceItem item = new VoiceItem();
            item.setBeginTime(recStartTime);
            item.setEndTime(recStopTime);
            item.setGroup(2);
            item.setPlayed(false);
            item.setRead(true);
            item.setUrl(sfile.getAbsolutePath());
            item.setId(id);
            item.setType("LINE_TYPE_" + lineInfo.getType());
            item.setDBId(lineInfo.getJid());
            item.setNumber(lineInfo.getNumber());
            item.setSite(lineInfo.getSiteId() != null ? String.valueOf(lineInfo.getSiteId()) : null);
            item.setName(lineInfo.getName1());
            item.setDuration(duration);
            String packetId = null;
            JSONObject props = new JSONObject();
            JSONObject recordProp = new JSONObject();
            recordProp.put("callerSite", item.getSite());
            recordProp.put("startTime", recStartTime);
            recordProp.put("endTime", recStopTime);
            recordProp.put("callerIdNumber", item.getNumber());
            recordProp.put("callerIdName", item.getName());
            recordProp.put("read", item.isRead());
            recordProp.put("listen", item.isPlayed());
            recordProp.put("callerType", item.getType());
            recordProp.put("callerDbId", item.getDBId());
            recordProp.put("duration", item.getDuration() / 1000L);
            recordProp.put("url", item.getUrl());
            if (lineInfo.isTrunkOutbound()) {
                recordProp.put("ownerDialOutFlag", 1);
            }
            props.put("record", recordProp);
            if (lineInfo.isIncomingCall()) {
                if (lineInfo.getType() == 8 || lineInfo.getType() == 10) {
                    packetId = ChatRoomManager.newInboundNumRecordMsg(this.context, duration, item.getNumber(), item.getSite(), item.getEndTime(), item.isRead(), item.isPlayed(), 13, props, false);
                } else if (lineInfo.getType() != 4 && lineInfo.getType() != 5) {
                    packetId = ChatRoomManager.newInboundRecordMsg(this.context, duration, item.getNumber(), lineInfo.getName1(), lineInfo.getJid(), lineInfo.getJid(), item.getBeginTime(), item.isRead(), item.isPlayed(), 13, props, false);
                }
            } else if (lineInfo.getType() == 8 || lineInfo.getType() == 10) {
                if (lineInfo.isTrunkOutbound()) {
                    item.setOutboundTrunk(true);
                }
                packetId = ChatRoomManager.newOutboundNumRecordMsg(this.context, duration, item.getSite(), item.getNumber(), item.isOutboundTrunk(), item.getEndTime(), item.isPlayed(), 13, props, false);
            } else {
                packetId = lineInfo.getType() == 4 || lineInfo.getType() == 5 ? ChatRoomManager.newOutboundRecordMsg(this.context, duration, item.getNumber(), lineInfo.getName1(), lineInfo.getJid(), lineInfo.getJid(), item.getEndTime(), item.isPlayed(), 13, props, false) : ChatRoomManager.newOutboundRecordMsg(this.context, duration, item.getNumber(), lineInfo.getName1(), lineInfo.getJid(), lineInfo.getJid(), item.getEndTime(), item.isPlayed(), 13, props, false);
            }
            item.setPacketId(packetId);
            UCDBVoiceMsg.addVoiceItem(this.context, item);
            BroadcastUtil.sendVoiceRecordChangedEvent(this.context);
            BroadcastUtil.sendContactHistoryChangedEvent(this.context);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public int isInCall(String targetJid) {
        for (CallLine callLine : callLineAry) {
            PhoneLineInfo lineInfo = callLine.getLineInfo();
            if (lineInfo == null) continue;
            String jid = null;
            jid = lineInfo.getType() == 8 || lineInfo.getType() == 10 ? lineInfo.getNumber() : lineInfo.getJid();
            if (jid == null || !jid.equals(targetJid)) continue;
            return callLine.getLineId();
        }
        return -1;
    }

    public boolean checkConferenceferFuncAvailable(int line) {
        for (CallLine callLine : callLineAry) {
            if (callLine.getLineId() == line || callLine.getState() != CallState.INCALL && callLine.getState() != CallState.HOLD) continue;
            return true;
        }
        return false;
    }

    public boolean checkTransferFuncAvailable(int line) {
        PhoneLineInfo targetLineInfo = callLineAry[line].getLineInfo();
        return targetLineInfo == null || !targetLineInfo.isMeetme();
    }

    public List<CallLine> getOtherLineAbleToTransfer(int line) {
        ArrayList<CallLine> callList = new ArrayList<CallLine>();
        for (CallLine callLine : callLineAry) {
            PhoneLineInfo info;
            if (callLine.getLineId() == line || callLine.getState() != CallState.INCALL && callLine.getState() != CallState.HOLD || (info = callLine.getLineInfo()) == null || info.isMeetme()) continue;
            callList.add(callLine);
        }
        return callList;
    }

    public List<CallLine> getOtherLineAbleToNewConf(int line) {
        ArrayList<CallLine> callList = new ArrayList<CallLine>();
        for (CallLine callLine : callLineAry) {
            PhoneLineInfo info;
            if (callLine.getLineId() == line || callLine.getState() != CallState.INCALL && callLine.getState() != CallState.HOLD || (info = callLine.getLineInfo()) == null || info.isMeetme()) continue;
            callList.add(callLine);
        }
        return callList;
    }

    public List<CallLine> getOtherConferenceLine(int line) {
        ArrayList<CallLine> callList = new ArrayList<CallLine>();
        for (CallLine callLine : callLineAry) {
            PhoneLineInfo info;
            if (callLine.getLineId() == line || callLine.getState() != CallState.INCALL && callLine.getState() != CallState.HOLD || (info = callLine.getLineInfo()) == null || !info.isMeetme()) continue;
            callList.add(callLine);
        }
        return callList;
    }

    public LineAvailableType isAvailableToCall() {
        if (this.isCallIdle()) {
            return LineAvailableType.ALL;
        }
        for (CallLine callLine : callLineAry) {
            if (callLine.getState() != CallState.IDLE) continue;
            if (this.isOtherLineDialingOut(callLine.getLineId())) {
                return LineAvailableType.NONE;
            }
            if (callLine.getLineId() == 0) {
                return LineAvailableType.LINE_ONE;
            }
            if (callLine.getLineId() != 1) continue;
            return LineAvailableType.LINE_TWO;
        }
        return LineAvailableType.NONE;
    }

    static {
        STAT_NOT_BOUNDED = 0;
        STAT_BOUNDING = 1;
        STAT_BOUNDED = 2;
        pstnState = PSTN_STATE_IDLE;
        STAT_NOT_REGISTERED = 0;
        STAT_PROCESSING = 1;
        STAT_REGISTERED = 2;
        isRegistered = STAT_NOT_REGISTERED;
        isUpdateLoginSip = false;
        isWiredHeadsetOn = false;
        LINE_COUNT = 2;
        callLineAry = null;
        callLineAry = new CallLine[LINE_COUNT];
        for (int i = 0; i < LINE_COUNT; ++i) {
            PhoneAgent.callLineAry[i] = new CallLine(i);
        }
        currentLine = 0;
        lock = new Object();
    }

    public static enum LineAvailableType {
        NONE,
        LINE_ONE,
        LINE_TWO,
        ALL;

    }
}

