/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.bean;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FuzzyNumberUtil;
import com.blisscloud.mobile.ezuc.util.PhoneNoUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ExternalCallMessage
extends Message {
    private static int ICON_SIZE = 20;
    private long fileSize;
    private String encodedRecordKey;
    private long recordSiteId;
    private String targetPhoneNumber;
    private String targetNumberToDial;
    private String targetSuffix;
    private String targetDuration;
    private ImageIcon targetImageIcon;
    private boolean targetPlayed;
    private Long targetCallBackupId;
    private Long targetStartTime;
    private Long targetAnswerTime;
    private Long targetEndTime;
    private String sysRecordingDispName;
    private boolean init = false;

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getEncodedRecordKey() {
        return this.encodedRecordKey;
    }

    public long getRecordSiteId() {
        return this.recordSiteId;
    }

    public void setEncodedRecordKey(String encodedRecordKey) {
        this.encodedRecordKey = encodedRecordKey;
    }

    public void setRecordSiteId(long recordSiteId) {
        this.recordSiteId = recordSiteId;
    }

    public long getTargetStartTime() {
        this.checkInit();
        if (this.targetStartTime == null) {
            return this.getServerTime();
        }
        return this.targetStartTime;
    }

    public Long getTargetEndTime() {
        this.checkInit();
        return this.targetEndTime;
    }

    public Long getTargetAnswerTime() {
        this.checkInit();
        return this.targetAnswerTime;
    }

    public String getTargetPhoneNumber() {
        this.checkInit();
        return this.targetPhoneNumber;
    }

    public String getTargetNumberToDial() {
        this.checkInit();
        return this.targetNumberToDial;
    }

    public String getTargetDuration() {
        this.checkInit();
        return this.targetDuration;
    }

    public String getTargetSuffix() {
        this.checkInit();
        return this.targetSuffix;
    }

    public ImageIcon getTargetImageIcon() {
        this.checkInit();
        return this.targetImageIcon;
    }

    public boolean getTargetPlayed() {
        this.checkInit();
        return this.targetPlayed;
    }

    public Long getTargetCallBackupId() {
        this.checkInit();
        return this.targetCallBackupId;
    }

    public void checkInit() {
        if (!this.init) {
            this.calculatePhoneNum();
        }
    }

    public boolean isOutbound() {
        int msgType = this.getMsgType();
        return msgType == 221 || msgType == 222;
    }

    public boolean isSummaryEditable() {
        int msgType = this.getMsgType();
        return msgType == 221 || msgType == 222 || msgType == 223;
    }

    private void calculatePhoneNum() {
        int msgType = this.getMsgType();
        String propStr = this.getProps();
        if (StringUtils.isNotBlank((CharSequence)propStr)) {
            try {
                JSONObject recordObj;
                JSONObject props = new JSONObject(propStr);
                if (props.has("start")) {
                    this.targetStartTime = props.getLong("start");
                } else if (props.has("record")) {
                    recordObj = props.getJSONObject("record");
                    if (recordObj.has("startTime")) {
                        this.targetStartTime = recordObj.getLong("startTime");
                    }
                } else if (props.has("vm") && (recordObj = props.getJSONObject("vm")).has("startTime")) {
                    this.targetStartTime = recordObj.getLong("startTime");
                }
                if (props.has("end")) {
                    this.targetEndTime = props.getLong("end");
                }
                if (props.has("answer")) {
                    this.targetAnswerTime = props.getLong("answer");
                }
                if (props.has("contactRecordId")) {
                    this.targetCallBackupId = props.getLong("contactRecordId");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        boolean isPlayed = true;
        if (msgType == 225) {
            String[] comps;
            phoneIconPath = ChatRoomManager.getPhoneIconPath("[PHONE_CANCEL]");
            this.targetImageIcon = GraphicUtil.getScaledIcon(phoneIconPath, ICON_SIZE, ICON_SIZE);
            this.targetSuffix = I18NUtil.getString("call_status_miss");
            this.targetNumberToDial = this.targetPhoneNumber = this.getPhoneNumber() == null ? "" : this.getPhoneNumber();
            if (!"[PHONE_CANCEL_IN]".equals(this.getContent()) && this.getContent().startsWith("[PHONE_CANCEL_IN2]") && (comps = this.getContent().split("_@@_")).length >= 3) {
                String siteId = comps[1];
                if (TextUtils.isNotBlank((CharSequence)siteId) && TextUtils.isDigitsOnly(siteId)) {
                    this.targetPhoneNumber = PhoneNoUtil.getPhoneNumDisp(UCChatClient.context, siteId, comps[2]);
                    this.targetNumberToDial = comps[2];
                } else {
                    this.targetPhoneNumber = comps[2];
                    this.targetNumberToDial = comps[2];
                }
            }
            this.targetDuration = "";
        } else if (msgType == 223) {
            String[] comps;
            phoneIconPath = ChatRoomManager.getPhoneIconPath("[PHONE_TALKING]");
            this.targetImageIcon = GraphicUtil.getScaledIcon(phoneIconPath, ICON_SIZE, ICON_SIZE);
            this.targetSuffix = I18NUtil.getString("call_status_dialin");
            this.targetPhoneNumber = this.getPhoneNumber() == null ? "" : this.getPhoneNumber();
            this.targetDuration = this.getDuration() == 0L ? "" : CommonUtil.getDurationSeconds(this.getDuration());
            this.targetNumberToDial = this.targetPhoneNumber;
            if (!TextUtils.isBlank((CharSequence)this.getContent()) && this.getContent().indexOf("_@@_") != -1 && (comps = this.getContent().split("_@@_")).length >= 4) {
                String siteId = comps[1];
                if (TextUtils.isNotBlank((CharSequence)siteId) && TextUtils.isDigitsOnly(siteId)) {
                    this.targetPhoneNumber = PhoneNoUtil.getPhoneNumDisp(UCChatClient.context, siteId, comps[2]);
                    this.targetNumberToDial = comps[2];
                } else {
                    this.targetPhoneNumber = comps[2];
                    this.targetNumberToDial = comps[2];
                }
            }
        } else if (msgType == 221) {
            String[] comps;
            phoneIconPath = ChatRoomManager.getPhoneIconPath("[PHONE_TALKING]");
            this.targetImageIcon = GraphicUtil.getScaledIcon(phoneIconPath, ICON_SIZE, ICON_SIZE);
            this.targetSuffix = I18NUtil.getString("call_status_dialout");
            this.targetPhoneNumber = this.getPhoneNumber() == null ? "" : this.getPhoneNumber();
            this.targetDuration = this.getDuration() == 0L ? "" : CommonUtil.getDurationSeconds(this.getDuration());
            this.targetNumberToDial = this.targetPhoneNumber;
            if (!TextUtils.isBlank((CharSequence)this.getContent()) && this.getContent().indexOf("_@@_") != -1 && (comps = this.getContent().split("_@@_")).length >= 4) {
                String originalNum;
                String siteId = comps[1];
                String fuzzyNum = originalNum = comps[2];
                if (PreferencesUtil.isFuzzyOutboundNumber(UCChatClient.context)) {
                    fuzzyNum = FuzzyNumberUtil.convert(originalNum);
                }
                if (TextUtils.isNotBlank((CharSequence)siteId) && TextUtils.isDigitsOnly(siteId)) {
                    this.targetPhoneNumber = PhoneNoUtil.getPhoneNumDisp(UCChatClient.context, siteId, fuzzyNum);
                    this.targetNumberToDial = originalNum;
                } else {
                    this.targetPhoneNumber = fuzzyNum;
                    this.targetNumberToDial = originalNum;
                }
            }
        } else if (msgType == 222) {
            phoneIconPath = ChatRoomManager.getPhoneIconPath("[PHONE_CANCEL]");
            this.targetImageIcon = GraphicUtil.getScaledIcon(phoneIconPath, ICON_SIZE, ICON_SIZE);
            this.targetSuffix = I18NUtil.getString("call_status_cancel");
            this.targetNumberToDial = this.targetPhoneNumber = this.getPhoneNumber() == null ? "" : this.getPhoneNumber();
            if (!TextUtils.isBlank((CharSequence)this.getContent()) && this.getContent().indexOf("_@@_") != -1) {
                String[] comps = this.getContent().split("_@@_");
                this.targetSuffix = "[PHONE_CANCEL_OUT]".equals(comps[0]) ? I18NUtil.getString("call_status_cancel") : comps[3];
                if (comps.length >= 3) {
                    String originalNum;
                    String siteId = comps[1];
                    String fuzzyNum = originalNum = comps[2];
                    if (PreferencesUtil.isFuzzyOutboundNumber(UCChatClient.context)) {
                        fuzzyNum = FuzzyNumberUtil.convert(originalNum);
                    }
                    if (TextUtils.isNotBlank((CharSequence)siteId) && TextUtils.isDigitsOnly(siteId)) {
                        this.targetPhoneNumber = PhoneNoUtil.getPhoneNumDisp(UCChatClient.context, siteId, fuzzyNum);
                        this.targetNumberToDial = originalNum;
                    } else {
                        this.targetPhoneNumber = originalNum;
                        this.targetNumberToDial = comps[2];
                    }
                }
            }
            this.targetSuffix = this.targetSuffix + this.getDialResult();
            this.targetDuration = "";
        } else if (msgType == 1006 || msgType == 13) {
            phoneIconPath = ChatRoomManager.getPhoneIconPath("[PHONE_RECORDING]");
            this.targetImageIcon = GraphicUtil.getScaledIcon(phoneIconPath, ICON_SIZE, ICON_SIZE);
            this.targetSuffix = I18NUtil.getString("chat_msg_type_recording");
            this.targetPhoneNumber = this.getPhoneNumber() == null ? "" : this.getPhoneNumber();
            this.targetDuration = this.getDuration() == 0L ? "" : CommonUtil.getDurationMilliSeconds(this.getDuration());
            this.targetNumberToDial = this.targetPhoneNumber;
            boolean isOutbound = this.isOutboundRecording(UCChatClient.context);
            if (isOutbound && PreferencesUtil.isFuzzyOutboundNumber(UCChatClient.context)) {
                this.targetPhoneNumber = FuzzyNumberUtil.convert(this.targetPhoneNumber);
            }
            isPlayed = this.isPlayed();
        } else if (msgType == 1005 || msgType == 12) {
            phoneIconPath = ChatRoomManager.getPhoneIconPath("[PHONE_VOICEMAIL]");
            this.targetImageIcon = GraphicUtil.getScaledIcon(phoneIconPath, ICON_SIZE, ICON_SIZE);
            this.targetSuffix = I18NUtil.getString("chat_msg_type_voicemail");
            this.targetPhoneNumber = this.getPhoneNumber() == null ? "" : this.getPhoneNumber();
            this.targetDuration = this.getDuration() == 0L ? "" : CommonUtil.getDurationMilliSeconds(this.getDuration());
            this.targetNumberToDial = this.targetPhoneNumber;
            isPlayed = this.isPlayed();
        }
        this.targetPlayed = isPlayed;
        this.sysRecordingDispName = this.targetStartTime != null ? this.targetPhoneNumber + "-" + DateTimeUtil.getDateTimeStr(this.targetStartTime) + ".wav" : this.targetPhoneNumber + ".wav";
        this.init = true;
    }

    public void setTargetPhoneNumber(String targetPhoneNumber) {
        this.targetPhoneNumber = targetPhoneNumber;
    }

    public void setTargetNumberToDial(String targetNumberToDial) {
        this.targetNumberToDial = targetNumberToDial;
    }

    public void setTargetSuffix(String targetSuffix) {
        this.targetSuffix = targetSuffix;
    }

    public void setTargetDuration(String targetDuration) {
        this.targetDuration = targetDuration;
    }

    public void setTargetImageIcon(ImageIcon targetImageIcon) {
        this.targetImageIcon = targetImageIcon;
    }

    public void setTargetPlayed(boolean targetPlayed) {
        this.targetPlayed = targetPlayed;
    }

    public void setTargetStartTime(Long targetStartTime) {
        this.targetStartTime = targetStartTime;
    }

    public void setTargetAnswerTime(Long targetAnswerTime) {
        this.targetAnswerTime = targetAnswerTime;
    }

    public void setTargetEndTime(Long targetEndTime) {
        this.targetEndTime = targetEndTime;
    }

    public void setTargetCallBackupId(Long targetCallBackupId) {
        this.targetCallBackupId = targetCallBackupId;
    }

    public String getSysRecordingDispName() {
        return this.sysRecordingDispName;
    }
}

