/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.bean;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.bean.DialType;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FuzzyNumberUtil;
import com.blisscloud.mobile.ezuc.util.PhoneNoUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class PhoneLineInfo
implements Serializable {
    private static final long serialVersionUID = 949935897934552520L;
    private int type = 0;
    private String jid;
    private Long siteId;
    private String number;
    private String name1;
    private String name2;
    private long callerStartTime = 0L;
    private String token;
    private DialType dailType = DialType.NORMAL;
    private String linkId;
    private String ruleInfo;
    private String rulePattern;
    private boolean isConfirmed = false;
    private boolean isIncomingCall = false;
    private boolean autoAnswered;
    private Long empId;
    private Long contactId;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getJid() {
        return this.jid;
    }

    public void setJid(String jid) {
        this.jid = jid;
    }

    public Long getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    public String getNumber() {
        return this.number;
    }

    public void getNumberx(String number) {
        this.number = number;
    }

    public void setNumberWithClean(String number) {
        String xx = PhoneNoUtil.cleanPhoneNo(number);
        this.number = TextUtils.isNotEmpty((CharSequence)number) && TextUtils.isEmpty((CharSequence)xx) ? number : xx;
    }

    public void setNumberBySite(String siteId, String number) {
        this.number = TextUtils.isNotBlank((CharSequence)siteId) && TextUtils.isDigitsOnly(siteId) ? PhoneNoUtil.getPhoneNumDisp(UCChatClient.context, siteId, number) : number;
    }

    public void setNumber(String siteName, String number) {
        this.number = TextUtils.isBlank((CharSequence)siteName) ? number : siteName.trim() + " " + number;
    }

    public String getName1() {
        return this.name1;
    }

    public void setName1(String name1) {
        this.name1 = name1;
    }

    public String getName2() {
        return this.name2;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }

    public long getCallerStartTime() {
        return this.callerStartTime;
    }

    public void setCallerStartTime(long callerStartTime) {
        this.callerStartTime = callerStartTime;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public DialType getDailType() {
        return this.dailType;
    }

    public void setDailType(DialType dailType) {
        this.dailType = dailType;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public void setLinkId(String linkId) {
        this.linkId = linkId;
    }

    public String getRuleInfo() {
        return this.ruleInfo;
    }

    public String getRulePattern() {
        return this.rulePattern;
    }

    public void setRuleInfo(String ruleInfo) {
        this.ruleInfo = ruleInfo;
    }

    public void setRulePattern(String rulePattern) {
        this.rulePattern = rulePattern;
    }

    public boolean isTrunkInbound() {
        return this.type == 8 && this.isIncomingCall;
    }

    public boolean isTrunkOutbound() {
        return this.type == 8 && !this.isIncomingCall;
    }

    public String getCallDuration() {
        long spentTime = this.callerStartTime == 0L ? 0L : System.currentTimeMillis() - this.callerStartTime;
        long hour = spentTime / 1000L / 60L / 60L % 24L;
        long minius = spentTime / 1000L / 60L % 60L;
        long seconds = spentTime / 1000L % 60L;
        StringBuilder dislTime = new StringBuilder();
        if (hour > 0L) {
            dislTime.append(CommonUtil.getTimeFormat(hour));
            dislTime.append(":");
        }
        dislTime.append(CommonUtil.getTimeFormat(minius));
        dislTime.append(":");
        dislTime.append(CommonUtil.getTimeFormat(seconds));
        return dislTime.toString();
    }

    public boolean isMeetme() {
        return this.getType() == 4 || this.getType() == 5;
    }

    public String getMainDispName() {
        if (this.isTrunkInbound() && StringUtils.isNotBlank((CharSequence)this.rulePattern) && StringUtils.isNotBlank((CharSequence)this.ruleInfo)) {
            return String.format(this.rulePattern, this.number, this.ruleInfo);
        }
        Locale locale = I18NUtil.getAppLocale();
        Object targetNum = this.getFinalDispNumber();
        Object object = targetNum = !TextUtils.isEmpty((CharSequence)targetNum) ? " " + (String)targetNum : "";
        if (locale.equals(Locale.TAIWAN) || locale.equals(Locale.CHINA) || locale.equals(Locale.CHINESE)) {
            if (!TextUtils.isEmpty((CharSequence)this.name1) && !TextUtils.isEmpty((CharSequence)this.name2)) {
                return this.name1 + (String)targetNum;
            }
            if (!TextUtils.isEmpty((CharSequence)this.name1) && TextUtils.isEmpty((CharSequence)this.name2)) {
                return this.name1 + (String)targetNum;
            }
            if (TextUtils.isEmpty((CharSequence)this.name1) && !TextUtils.isEmpty((CharSequence)this.name2)) {
                return this.name2 + (String)targetNum;
            }
            return targetNum;
        }
        if (!TextUtils.isEmpty((CharSequence)this.name1) && !TextUtils.isEmpty((CharSequence)this.name2)) {
            return this.name2 + (String)targetNum;
        }
        if (!TextUtils.isEmpty((CharSequence)this.name1) && TextUtils.isEmpty((CharSequence)this.name2)) {
            return this.name1 + (String)targetNum;
        }
        if (TextUtils.isEmpty((CharSequence)this.name1) && !TextUtils.isEmpty((CharSequence)this.name2)) {
            return this.name2 + (String)targetNum;
        }
        return targetNum;
    }

    public String getFinalDispNumber() {
        if (this.isTrunkOutbound() && PreferencesUtil.isFuzzyOutboundNumber(UCChatClient.context)) {
            return FuzzyNumberUtil.convert(this.number);
        }
        return this.number;
    }

    public String[] getDispName() {
        if (this.isTrunkInbound() && StringUtils.isNotBlank((CharSequence)this.rulePattern) && StringUtils.isNotBlank((CharSequence)this.ruleInfo)) {
            String[] dispName = new String[3];
            dispName[0] = String.format(this.rulePattern, this.number, this.ruleInfo);
            return dispName;
        }
        Locale locale = I18NUtil.getAppLocale();
        String[] dispName = new String[3];
        String targetNum = this.getFinalDispNumber();
        if (locale.equals(Locale.TAIWAN) || locale.equals(Locale.CHINA) || locale.equals(Locale.CHINESE)) {
            if (!TextUtils.isEmpty((CharSequence)this.name1) && !TextUtils.isEmpty((CharSequence)this.name2)) {
                dispName[0] = this.name1;
                dispName[1] = this.name2;
                dispName[2] = targetNum;
            } else if (!TextUtils.isEmpty((CharSequence)this.name1) && TextUtils.isEmpty((CharSequence)this.name2)) {
                dispName[0] = this.name1;
                dispName[1] = "";
                dispName[2] = targetNum;
            } else if (TextUtils.isEmpty((CharSequence)this.name1) && !TextUtils.isEmpty((CharSequence)this.name2)) {
                dispName[0] = this.name2;
                dispName[1] = "";
                dispName[2] = targetNum;
            } else {
                dispName[0] = targetNum;
                dispName[1] = "";
                dispName[2] = "";
            }
        } else if (!TextUtils.isEmpty((CharSequence)this.name1) && !TextUtils.isEmpty((CharSequence)this.name2)) {
            dispName[0] = this.name2;
            dispName[1] = this.name1;
            dispName[2] = targetNum;
        } else if (!TextUtils.isEmpty((CharSequence)this.name1) && TextUtils.isEmpty((CharSequence)this.name2)) {
            dispName[0] = this.name1;
            dispName[1] = "";
            dispName[2] = targetNum;
        } else if (TextUtils.isEmpty((CharSequence)this.name1) && !TextUtils.isEmpty((CharSequence)this.name2)) {
            dispName[0] = this.name2;
            dispName[1] = "";
            dispName[2] = targetNum;
        } else {
            dispName[0] = targetNum;
            dispName[1] = "";
            dispName[2] = "";
        }
        return dispName;
    }

    public boolean isConfirmed() {
        return this.isConfirmed;
    }

    public void setConfirmed(boolean isConfirmed) {
        this.isConfirmed = isConfirmed;
    }

    public boolean isIncomingCall() {
        return this.isIncomingCall;
    }

    public void setIncomingCall(boolean isIncomingCall) {
        this.isIncomingCall = isIncomingCall;
    }

    public boolean isAutoAnswered() {
        return this.autoAnswered;
    }

    public void setAutoAnswered(boolean autoAnswered) {
        this.autoAnswered = autoAnswered;
    }

    public JSONObject convertToJson() throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put("type", this.type);
        if (StringUtils.isNotBlank((CharSequence)this.jid)) {
            obj.put("jid", this.jid);
        }
        if (this.siteId != null) {
            obj.put("siteId", this.siteId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.number)) {
            obj.put("number", this.number);
        }
        if (StringUtils.isNotBlank((CharSequence)this.name1)) {
            obj.put("name1", this.name1);
        }
        if (StringUtils.isNotBlank((CharSequence)this.name2)) {
            obj.put("name2", this.name2);
        }
        obj.put("callerStartTime", this.callerStartTime);
        if (StringUtils.isNotBlank((CharSequence)this.token)) {
            obj.put("token", this.token);
        }
        obj.put("dailType", this.dailType.getId());
        if (StringUtils.isNotBlank((CharSequence)this.linkId)) {
            obj.put("linkId", this.linkId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.ruleInfo)) {
            obj.put("ruleInfo", this.ruleInfo);
        }
        if (StringUtils.isNotBlank((CharSequence)this.rulePattern)) {
            obj.put("rulePattern", this.rulePattern);
        }
        if (this.empId != null) {
            obj.put("empId", this.empId);
        }
        if (this.contactId != null) {
            obj.put("contactId", this.contactId);
        }
        return obj;
    }

    public void convertToPhoneLineInfo(JSONObject obj) throws JSONException {
        this.type = obj.getInt("type");
        if (obj.has("jid")) {
            this.jid = obj.getString("jid");
        }
        if (obj.has("siteId")) {
            this.siteId = obj.getLong("siteId");
        }
        if (obj.has("number")) {
            this.number = obj.getString("number");
        }
        if (obj.has("name1")) {
            this.name1 = obj.getString("name1");
        }
        if (obj.has("name2")) {
            this.name2 = obj.getString("name2");
        }
        if (obj.has("callerStartTime")) {
            this.callerStartTime = obj.getLong("callerStartTime");
        }
        if (obj.has("token")) {
            this.token = obj.getString("token");
        }
        if (obj.has("dailType")) {
            this.dailType = DialType.getValue(obj.getInt("dailType"));
        }
        if (obj.has("linkId")) {
            this.linkId = obj.getString("linkId");
        }
        if (obj.has("ruleInfo")) {
            this.ruleInfo = obj.getString("ruleInfo");
        }
        if (obj.has("rulePattern")) {
            this.rulePattern = obj.getString("rulePattern");
        }
        if (obj.has("empId")) {
            this.empId = obj.getLong("empId");
        }
        if (obj.has("contactId")) {
            this.contactId = obj.getLong("contactId");
        }
        this.isIncomingCall = false;
        this.isConfirmed = false;
        this.autoAnswered = false;
    }

    public Long getEmpId() {
        return this.empId;
    }

    public void setEmpId(Long empId) {
        this.empId = empId;
    }

    public Long getContactId() {
        return this.contactId;
    }

    public void setContactId(Long contactId) {
        this.contactId = contactId;
    }

    public String toString() {
        return "PhoneLineInfo [type=" + this.type + ", jid=" + this.jid + ", siteId=" + this.siteId + ", number=" + this.number + ", name1=" + this.name1 + ", name2=" + this.name2 + ", callerStartTime=" + this.callerStartTime + ", token=" + this.token + ", dailType=" + String.valueOf((Object)this.dailType) + ", linkId=" + this.linkId + ", ruleInfo=" + this.ruleInfo + ", rulePattern=" + this.rulePattern + ", isConfirmed=" + this.isConfirmed + ", isIncomingCall=" + this.isIncomingCall + ", autoAnswered=" + this.autoAnswered + ", empId=" + this.empId + ", contactId=" + this.contactId + "]";
    }

    public static class LineInfoType {
        public static final int NONE = 0;
        public static final int EMPLOYEE = 1;
        public static final int LOCATION = 2;
        public static final int CHATROOM = 4;
        public static final int CONFERENCE = 5;
        public static final int MY_CONTACT = 6;
        public static final int MOBILE_CONTACT = 7;
        public static final int TRUNK = 8;
        public static final int UNKNOWN = 10;
    }
}

