/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.callback;

import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.ChatReceiver;
import com.blisscloud.mobile.ezuc.agent.ChatUploadSendFileTask;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.callback.FileTransferCallBack;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import java.io.File;

public class FileConnectionListener
implements FileTransferCallBack {
    private Context context = null;

    public FileConnectionListener(Context _context) {
        this.context = _context;
    }

    @Override
    public void notifyUploadFileSucceed(ChatUploadSendFileTask task) {
        boolean hasMsgToDeliver = false;
        for (ChatReceiver receiver : task.getChatReceiverList()) {
            if (receiver.isCancel()) {
                ChatRoomManager.updateMessageStatusWithEvent(this.context, receiver.getReceiverJid(), receiver.getPacketId(), "Connection error", "UPLOAD_FAILED", false);
                continue;
            }
            hasMsgToDeliver = true;
            UCDBMessage.updateChatMsgStatus(this.context, receiver.getPacketId(), "UPLOAD_SUCCEED", task.getFileDownloadUrl());
            BroadcastUtil.sendMsgOKStatusEvent(this.context, receiver.getReceiverJid(), receiver.getPacketId(), task.getFileName(), task.getThumbnail(), task.getFileDownloadUrl());
        }
        if (hasMsgToDeliver) {
            this.saveCache(task);
            WebAgent.getInstance().sendChatFileAfterUpload(task);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveCache(ChatUploadSendFileTask task) {
        try {
            File file = task.getFile();
            String tempDir = System.getProperty("java.io.tmpdir");
            String parentPath = file.getParent();
            if (parentPath != null && !tempDir.startsWith(parentPath)) return;
        }
        catch (Exception e) {
            Log.e(FileConnectionListener.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
        }
    }

    @Override
    public void notifyUploadFileFailed(ChatUploadSendFileTask task, String errorMsg) {
        for (ChatReceiver receiver : task.getChatReceiverList()) {
            String packetId = receiver.getPacketId();
            String receiverJID = receiver.getReceiverJid();
            Log.e(FileConnectionListener.class.getSimpleName(), "notifyUploadFileFailed [" + task.getFileName() + "] msg:" + errorMsg + " packetId:" + packetId);
            UCDBMessage.updateChatMsgStatus(this.context, packetId, "UPLOAD_FAILED");
            BroadcastUtil.sendMsgFailedEvent(this.context, receiverJID, packetId, task.getFileName(), errorMsg);
        }
    }

    @Override
    public void notifyUploadFileProgress(ChatUploadSendFileTask task, int percent) {
        for (ChatReceiver receiver : task.getChatReceiverList()) {
            String packetId = receiver.getPacketId();
            String receiverJID = receiver.getReceiverJid();
            Log.d(FileConnectionListener.class.getSimpleName(), "notifyUploadFileProgress [" + task.getFileName() + "] " + percent + "%");
            BroadcastUtil.sendMsgProgressingEvent(this.context, receiverJID, packetId, task.getFileName(), percent);
        }
    }
}

