/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.connection.file;

import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.ChatUploadSendFileTask;
import com.blisscloud.mobile.ezuc.callback.FileTransferCallBack;
import com.blisscloud.mobile.ezuc.connection.file.CustomMultiPartEntity;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class FileTransferConnection
implements CustomMultiPartEntity.ProgressListener {
    private FileTransferCallBack callBack;
    private ChatUploadSendFileTask task;
    private String serverURI;
    private long totalSize;
    private Context context;
    private int lastPercent = -1;
    private HttpGet mHttpGet = null;
    private HttpPost mHttpPost = null;
    private boolean isDone = false;

    public FileTransferConnection(Context context, ChatUploadSendFileTask task, FileTransferCallBack callBack) {
        this.context = context.getApplicationContext();
        this.callBack = callBack;
        this.task = task;
        this.serverURI = "https://" + CommonUtil.getHttpsIpPort(context) + "/ucrm/fileTransfer/uploadFile";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.task.setStatus(2);
        this.task.setDequeueTime(System.currentTimeMillis());
        HttpClient mHttpClient = CommonUtil.getHttpsClient(this.context, true);
        this.mHttpGet = new HttpGet();
        this.mHttpPost = new HttpPost();
        try {
            String accessKey = PreferencesUtil.getAccessKey(this.context);
            this.mHttpGet.setURI(new URI(this.serverURI + "?tenantId=" + PreferencesUtil.getTenantId(this.context) + "&employeeId=" + PreferencesUtil.getUserId(this.context) + "&accessKey=" + accessKey));
            this.mHttpPost.setURI(new URI(this.serverURI));
            HttpResponse response1 = mHttpClient.execute((HttpUriRequest)this.mHttpGet);
            int respondCode = response1.getStatusLine().getStatusCode();
            if (respondCode != 200) {
                throw new Exception("NOT EXIST");
            }
            HttpEntity entity = response1.getEntity();
            EntityUtils.consume((HttpEntity)entity);
            CustomMultiPartEntity multipartContent = new CustomMultiPartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, null, Charset.forName("UTF-8"), this);
            multipartContent.addPart("thumbnail", (ContentBody)new StringBody("NO"));
            multipartContent.addPart("upload", (ContentBody)new FileBody(this.task.getFile()));
            multipartContent.addPart("tenantId", (ContentBody)new StringBody(PreferencesUtil.getTenantId(this.context).toString()));
            multipartContent.addPart("employeeId", (ContentBody)new StringBody(PreferencesUtil.getUserId(this.context).toString()));
            multipartContent.addPart("accessKey", (ContentBody)new StringBody(accessKey));
            this.totalSize = multipartContent.getContentLength();
            this.mHttpPost.setEntity((HttpEntity)multipartContent);
            HttpResponse response = mHttpClient.execute((HttpUriRequest)this.mHttpPost);
            String serverResponse = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jsonObj = new JSONObject(serverResponse);
            FileTransferConnection fileTransferConnection = this;
            synchronized (fileTransferConnection) {
                this.isDone = true;
                if (jsonObj.has("downloadURL")) {
                    this.task.setFileDownloadUrl(jsonObj.getString("downloadURL"));
                    this.callBack.notifyUploadFileSucceed(this.task);
                } else {
                    this.callBack.notifyUploadFileFailed(this.task, null);
                }
            }
        }
        catch (Throwable e) {
            Log.e(FileTransferConnection.class.getSimpleName(), "notifyUploadFileFailed ERROR:" + e.getMessage());
            FileTransferConnection fileTransferConnection = this;
            synchronized (fileTransferConnection) {
                this.isDone = true;
                if (this.callBack != null) {
                    this.callBack.notifyUploadFileFailed(this.task, null);
                }
            }
        }
    }

    @Override
    public void transferred(long num) {
        int percent = (int)((double)num / (double)this.totalSize * 100.0);
        if (percent != this.lastPercent) {
            this.lastPercent = percent;
            if (this.callBack != null) {
                this.callBack.notifyUploadFileProgress(this.task, percent);
            }
        }
    }

    public void cancel() {
        try {
            if (this.mHttpGet != null) {
                this.mHttpGet.abort();
            }
            if (this.mHttpPost != null) {
                this.mHttpPost.abort();
            }
        }
        catch (Throwable e) {
            Log.e(FileTransferConnection.class.getSimpleName(), "cancel", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelMsg(String packetId) {
        FileTransferConnection fileTransferConnection = this;
        synchronized (fileTransferConnection) {
            boolean match = this.task.cancelReceiver(packetId);
            if (match && !this.isDone && !this.task.hasActiveReceiver()) {
                this.cancel();
            }
            return match;
        }
    }
}

