/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.MessageHeader;

public class ChatDataHelper {
    public static String[] chatRoomSelectColumns = new String[]{"chatRoomId", "subject", "subjectOwnerId", "type", "onTop"};
    public static String[] msgSelectColumns = new String[]{"id", "chatMsgId", "status", "fromJid", "toJid", "content", "contentType", "fileName", "fileSize", "fileLocalPath", "fileDownloadURL", "timeZone", "createTime", "serverTime", "msg_type", "playstatus", "isListen", "duration", "noticeContent", "noticeThumbnail", "chatEventId", "syncEventId", "readCount", "readerList", "chatRoomId", "extraProps", "lazyContent", "phoneNumber", "isRecalled", "isOutboundTrunk", "mimeType", "extraText", "contactRecordId", "title"};
    public static String[] msgHeaderSelectColumns = new String[]{"id", "chatMsgId", "status", "fromJid", "serverTime", "msg_type", "contentType", "fileName", "fileSize", "isListen", "lazyContent", "isRecalled", "mimeType"};

    public static void setChatRoomValue(Cursor cursor, ChatRoomInfo chatRoom) {
        chatRoom.setChatRoomId(cursor.getString(0));
        chatRoom.setSubject(cursor.getString(1));
        chatRoom.setSubjectOwnerId(cursor.getString(2));
        chatRoom.setType(cursor.getInt(3));
        chatRoom.setOnTop(cursor.getInt(4) == 1);
    }

    public static ContentValues createUpdateMsgValues(String status) {
        ContentValues values = new ContentValues();
        values.put("status", status);
        return values;
    }

    public static ContentValues createUpdateMsgReadCountValues(int readCount, String readerList) {
        ContentValues values = new ContentValues();
        values.put("readCount", readCount);
        values.put("readerList", readerList);
        return values;
    }

    public static ContentValues createUpdateMsgChatEventValues(long chatEventId) {
        ContentValues values = new ContentValues();
        values.put("chatEventId", chatEventId);
        return values;
    }

    public static ContentValues createUpdateMsgSyncEventValues(long chatEventId) {
        ContentValues values = new ContentValues();
        values.put("syncEventId", chatEventId);
        return values;
    }

    public static ContentValues createUpdateMsgValues(String status, String fileDownloadURL) {
        ContentValues values = new ContentValues();
        values.put("status", status);
        values.put("fileDownloadURL", fileDownloadURL);
        return values;
    }

    public static ContentValues createUpdateMsgValues(Long chatEventId, Long syncChatEventId, String fileDownloadURL) {
        ContentValues values = new ContentValues();
        if (chatEventId != null) {
            values.put("chatEventId", chatEventId);
        }
        if (syncChatEventId != null) {
            values.put("syncEventId", syncChatEventId);
        }
        values.put("fileDownloadURL", fileDownloadURL);
        return values;
    }

    public static void setMsgValue(Cursor cursor, Message message) {
        message.setId(cursor.getLong(0));
        message.setPacketId(cursor.getString(1));
        message.setStatus(cursor.getString(2));
        message.setFromJid(cursor.getString(3));
        message.setToJid(cursor.getString(4));
        message.setContent(cursor.getString(5));
        message.setContentType(cursor.getString(6));
        message.setFileName(cursor.getString(7));
        message.setFileSize(cursor.getLong(8));
        message.setFileLocalPath(cursor.getString(9));
        message.setFileDownloadURL(cursor.getString(10));
        message.setTimeZone(cursor.getString(11));
        message.setCreateTime(cursor.getLong(12));
        message.setServerTime(cursor.getLong(13));
        message.setMsgType(cursor.getInt(14));
        message.setRead(cursor.getInt(15) == 1);
        message.setPlayed(cursor.getInt(16) == 1);
        message.setDuration(cursor.getLong(17));
        message.setNoticeContent(cursor.getString(18));
        message.setNoticeThumbnail(cursor.getString(19));
        message.setChatEventId(cursor.getLong(20));
        message.setSyncEventId(cursor.getLong(21));
        message.setReadCount(cursor.getInt(22));
        message.setReaderList(cursor.getString(23));
        message.setChatRoomJid(cursor.getString(24));
        message.setProps(cursor.getString(25));
        message.setLazyContent(cursor.getInt(26) == 1);
        message.setPhoneNumber(cursor.getString(27));
        message.setRecalled(cursor.getInt(28) == 1);
        message.setOutboundTrunk(cursor.getInt(29) == 1);
        message.setMimeType(cursor.getString(30));
        message.setExtraMsgInfo(cursor.getString(31));
        message.setContactRecordId(cursor.getLong(32));
        message.setTitle(cursor.getString(33));
    }

    public static void setMsgValue(Cursor cursor, MessageHeader message) {
        message.setId(cursor.getLong(0));
        message.setPacketId(cursor.getString(1));
        message.setStatus(cursor.getString(2));
        message.setFromJid(cursor.getString(3));
        message.setTime(cursor.getLong(4));
        message.setMsgType(cursor.getInt(5));
        message.setContentType(cursor.getString(6));
        message.setFileName(cursor.getString(7));
        message.setFileSize(cursor.getLong(8));
        message.setIsListen(cursor.getInt(9));
        message.setIsLazy(cursor.getInt(10));
        message.setIsRecalled(cursor.getInt(11));
        message.setMimeType(cursor.getString(12));
    }

    public static ContentValues createUpdateMsgReadValues() {
        ContentValues values = new ContentValues();
        values.put("playstatus", 1);
        return values;
    }

    public static ContentValues createUpdateMsgPlayedValues() {
        ContentValues values = new ContentValues();
        values.put("isListen", 1);
        return values;
    }

    public static ContentValues createUpdateMsgReadPlayedValues(boolean isRead, boolean isPlayed) {
        ContentValues values = new ContentValues();
        values.put("playstatus", isRead ? 1 : 0);
        values.put("isListen", isPlayed ? 1 : 0);
        return values;
    }

    public static ContentValues createUpdateMsgRecalledValues() {
        ContentValues values = new ContentValues();
        values.put("isRecalled", 1);
        return values;
    }
}

