/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoomAuthType;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoomType;
import com.blisscloud.ezuc.bean.web.LiteConferenceUserStatus;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import java.util.ArrayList;
import java.util.List;

public class MeetmeDataHelper {
    public static String[] confSelectColumns = new String[]{"roomId", "type", "authType", "roomNo", "name", "siteName", "password", "adminPassword", "chatRoomId", "managerId", "managerName", "chairManId", "allMuted", "locked", "managerCount"};
    public static String[] confUsersSelectColumns = new String[]{"userNo", "callerIdNumber", "callerIdNumberSiteId", "callerIdName", "admin", "monitor", "muted", "request", "talking", "joinedTime", "callerDbId", "callerType", "roomId"};

    public static String getConfSelectColumnsStr() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < confSelectColumns.length; ++i) {
            if (i != 0) {
                buffer.append(",");
            }
            buffer.append(confSelectColumns[i]);
        }
        return buffer.toString();
    }

    public static ContentValues createConfRoomAddValues(LiteConferenceRoom room) {
        ContentValues values = MeetmeDataHelper.createConfRoomUpdateValues(room);
        values.put("roomId", room.getRoomId());
        values.put("initDone", 0);
        return values;
    }

    public static ContentValues createConfRoomIsDoneUpdateValues(boolean isDone) {
        ContentValues values = new ContentValues();
        values.put("initDone", isDone ? 1 : 0);
        return values;
    }

    public static ContentValues createConfRoomLockStateUpdateValues(boolean locked) {
        ContentValues values = new ContentValues();
        values.put("locked", locked ? 1 : 0);
        return values;
    }

    public static ContentValues createConfRoomUpdateValues(LiteConferenceRoom room) {
        ContentValues values = new ContentValues();
        if (room.getType() != null) {
            values.put("type", room.getType().getId());
        } else {
            values.put("type", LiteConferenceRoomType.DYNAMIC.getId());
        }
        if (room.getAuthType() != null) {
            values.put("authType", room.getAuthType().getId());
        } else {
            values.put("authType", LiteConferenceRoomAuthType.NONE.getId());
        }
        values.put("roomNo", room.getRoomNo());
        values.put("name", room.getName());
        values.put("siteName", room.getSiteName());
        values.put("password", room.getPassword());
        values.put("adminPassword", room.getAdminPassword());
        values.put("chatRoomId", room.getChatRoomId());
        values.put("managerId", room.getManagerId());
        values.put("managerName", room.getManagerName());
        List<Long> ids = room.getChairmanIds();
        StringBuffer b = new StringBuffer();
        for (int i = 0; ids != null && i < ids.size(); ++i) {
            if (i != 0) {
                b.append(",");
            }
            b.append(String.valueOf(ids.get(i)));
        }
        values.put("chairManId", b.toString());
        values.put("allMuted", room.isAllMute() ? 1 : 0);
        values.put("locked", room.isLocked() ? 1 : 0);
        values.put("managerCount", room.getMembers());
        return values;
    }

    public static void setConfRoomValue(Cursor cursor, LiteConferenceRoom confRoom) {
        confRoom.setRoomId(cursor.getLong(0));
        confRoom.setType(LiteConferenceRoomType.getValue(cursor.getInt(1)));
        confRoom.setAuthType(LiteConferenceRoomAuthType.getValue(cursor.getInt(2)));
        confRoom.setRoomNo(cursor.getString(3));
        confRoom.setName(cursor.getString(4));
        confRoom.setSiteName(cursor.getString(5));
        confRoom.setPassword(cursor.getString(6));
        confRoom.setAdminPassword(cursor.getString(7));
        confRoom.setChatRoomId(cursor.getString(8));
        confRoom.setManagerId(cursor.getLong(9));
        confRoom.setManagerName(cursor.getString(10));
        ArrayList<Long> chairmanIds = new ArrayList<Long>();
        String ids = cursor.getString(11);
        if (ids != null && !"".equals(ids.trim())) {
            String[] idsStr = ids.split(",");
            for (int i = 0; idsStr != null && i < idsStr.length; ++i) {
                chairmanIds.add(Long.parseLong(idsStr[i]));
            }
            confRoom.setChairmanIds(chairmanIds);
        }
        confRoom.setAllMute(cursor.getInt(12) == 1);
        confRoom.setLocked(cursor.getInt(13) == 1);
        confRoom.setMembers(cursor.getInt(14));
    }

    public static ContentValues createConfRoomUserAddValues(Long roomId, LiteConferenceUserStatus userStatus) {
        ContentValues values = MeetmeDataHelper.createConfRoomUserUpdateValues(userStatus);
        values.put("roomId", roomId);
        return values;
    }

    public static ContentValues createConfRoomUserUpdateValues(LiteConferenceUserStatus userStatus) {
        ContentValues values = new ContentValues();
        values.put("userNo", userStatus.getUserNo());
        values.put("callerIdNumber", userStatus.getCallerIdNumber());
        values.put("callerIdNumberSiteId", userStatus.getCallerIdNumberSite());
        values.put("callerIdName", userStatus.getCallerIdName());
        values.put("admin", userStatus.getAdmin());
        values.put("monitor", userStatus.getMonitor());
        values.put("muted", userStatus.getMuted());
        values.put("request", userStatus.getRequest());
        values.put("talking", userStatus.getTalking());
        values.put("joinedTime", userStatus.getJoinedTime());
        values.put("callerDbId", userStatus.getCallerDbId());
        values.put("callerType", userStatus.getCallerType());
        return values;
    }

    public static long setConfUserStatusValue(Cursor cursor, LiteConferenceUserStatus userStatus) {
        userStatus.setUserNo(cursor.getString(0));
        userStatus.setCallerIdNumber(cursor.getString(1));
        userStatus.setCallerIdNumberSite(cursor.getString(2));
        userStatus.setCallerIdName(cursor.getString(3));
        userStatus.setAdmin(cursor.getString(4));
        userStatus.setMonitor(cursor.getString(5));
        userStatus.setMuted(cursor.getString(6));
        userStatus.setRequest(cursor.getString(7));
        userStatus.setTalking(cursor.getString(8));
        userStatus.setJoinedTime(cursor.getString(9));
        userStatus.setCallerDbId(cursor.getString(10));
        userStatus.setCallerType(cursor.getString(11));
        Long roomId = cursor.getLong(12);
        return roomId;
    }
}

