/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteOutPrefix;
import com.blisscloud.ezuc.bean.web.LiteDepartment;
import com.blisscloud.ezuc.bean.web.LiteOutboundPrefix;
import com.blisscloud.ezuc.bean.web.LiteSite;
import com.blisscloud.ezuc.bean.web.LiteTeleNumber;
import com.blisscloud.ezuc.client.addressbook.AddressBookGroup;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.bean.ContactScope;
import com.blisscloud.mobile.ezuc.db.ContactDataHelper;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBDept;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import com.blisscloud.mobile.ezuc.db.UCDBSite;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.EmployeeMatchInfo;
import com.blisscloud.mobile.ezuc.util.EmpExtendedSysPhoneConfig;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PhoneNoUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class UCDBContact
extends UCDBBase {
    public static final String TABLE_CONTACT = "Contact";
    public static final String TABLE_CONTACT_OUTBOUND_PREFIX = "ContactOutboundPrefix";
    public static final String TABLE_NUMBER = "ContactNumber";

    public static void createContactTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS Contact");
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ");
        sql.append(TABLE_CONTACT);
        sql.append("(");
        sql.append("jid");
        sql.append(" LONGVARCHAR, ");
        sql.append("empId");
        sql.append(" NUMERIC, ");
        sql.append("type");
        sql.append(" NUMERIC, ");
        sql.append("surName");
        sql.append(" LONGVARCHAR, ");
        sql.append("givenName");
        sql.append(" LONGVARCHAR, ");
        sql.append("otherName");
        sql.append(" LONGVARCHAR, ");
        sql.append("dispName");
        sql.append(" LONGVARCHAR, ");
        sql.append("dispNameForPinYin");
        sql.append(" LONGVARCHAR, ");
        sql.append("extDispName");
        sql.append(" LONGVARCHAR, ");
        sql.append("siteId");
        sql.append(" INTEGER, ");
        sql.append("ext");
        sql.append(" LONGVARCHAR, ");
        sql.append("extList");
        sql.append(" LONGVARCHAR, ");
        sql.append("account");
        sql.append(" LONGVARCHAR, ");
        sql.append("photoFlag");
        sql.append(" BOOLEAN, ");
        sql.append("personalPhoto");
        sql.append(" CLOB, ");
        sql.append("personalPhotoTimestamp");
        sql.append(" NUMERIC, ");
        sql.append("email");
        sql.append(" LONGVARCHAR, ");
        sql.append("gender");
        sql.append(" INTEGER, ");
        sql.append("departmentNamePath");
        sql.append(" LONGVARCHAR, ");
        sql.append("departmentIdPath");
        sql.append(" LONGVARCHAR, ");
        sql.append("contactCount");
        sql.append(" INTEGER DEFAULT 0, ");
        sql.append("birthday");
        sql.append(" LONGVARCHAR, ");
        sql.append("currentPhotoTimestamp");
        sql.append(" NUMERIC, ");
        sql.append("disabled");
        sql.append(" INTEGER DEFAULT 0, ");
        sql.append("locked");
        sql.append(" INTEGER DEFAULT 0, ");
        sql.append("outboundPrefixId");
        sql.append(" INTEGER DEFAULT 0, ");
        sql.append("birthdayHideType");
        sql.append(" INTEGER DEFAULT 1, ");
        sql.append("abscope");
        sql.append(" INTEGER DEFAULT 0, ");
        sql.append("deptForSearch");
        sql.append(" LONGVARCHAR, ");
        sql.append("extForSearch");
        sql.append(" LONGVARCHAR, ");
        sql.append("extendedNumber1");
        sql.append(" LONGVARCHAR, ");
        sql.append("extendedNumber2");
        sql.append(" LONGVARCHAR, ");
        sql.append("extendedNumber3");
        sql.append(" LONGVARCHAR, ");
        sql.append("extendedNumber4");
        sql.append(" LONGVARCHAR ");
        sql.append(")");
        db.execSQL(sql.toString());
    }

    public static void createContactNumberTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS ContactNumber");
        String CREATE_NUMBER_TABLE = "CREATE TABLE ContactNumber(contactJid LONGVARCHAR,type INTEGER,number LONGVARCHAR)";
        db.execSQL(CREATE_NUMBER_TABLE);
    }

    public static void createContactOutboundPrefixTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS ContactOutboundPrefix");
        String CREATE_NUMBER_TABLE = "CREATE TABLE ContactOutboundPrefix(contactJid LONGVARCHAR,siteId NUMERIC,outboundPrefixId NUMERIC,pbxOutboundPrefixId NUMERIC)";
        db.execSQL(CREATE_NUMBER_TABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addContact(Context ctx, LiteContact contact, int contactType, int scope) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "addContact...." + String.valueOf(contact) + "," + contactType);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                int i;
                db = helper.getWritableDatabase();
                db.insert(TABLE_CONTACT, null, ContactDataHelper.createContactAddValues(contact, contactType, scope));
                for (i = 0; contact.getTelephones() != null && i < contact.getTelephones().size(); ++i) {
                    LiteTeleNumber number = contact.getTelephones().get(i);
                    db.insert(TABLE_NUMBER, null, ContactDataHelper.createNumberAddValues(contact, number));
                }
                for (i = 0; contact.getOutboundPrefixList() != null && i < contact.getOutboundPrefixList().size(); ++i) {
                    LiteOutPrefix liteOutPrefix = contact.getOutboundPrefixList().get(i);
                    db.insert(TABLE_CONTACT_OUTBOUND_PREFIX, null, ContactDataHelper.createOutPrefixAddValues(contact, liteOutPrefix));
                }
            }
            finally {
                UCDBContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LiteContact> getContactsByJids(Context ctx, Set<String> jidset) {
        UCDBContact._log(UCDBContact.class.getSimpleName(), "getContactsByJids...." + String.valueOf(jidset));
        ArrayList<LiteContact> contacts = new ArrayList<LiteContact>();
        HashMap numbersMap = new HashMap();
        HashMap outboundPrefixMap = new HashMap();
        UCDBHelper helper = UCDBHelper.getDB(ctx);
        UCDBHelper uCDBHelper = helper;
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor1 = null;
            Cursor cursor2 = null;
            Cursor cursor3 = null;
            try {
                ArrayList list;
                String contactJid;
                db = helper.getReadableDatabase();
                cursor1 = db.query(TABLE_CONTACT, ContactDataHelper.contactSelectColumns, "jid in (" + UCDBContact.prepareInSql(jidset) + ")", null, null, null, null, null);
                if (cursor1 != null && cursor1.moveToFirst()) {
                    do {
                        LiteContact contact = new LiteContact();
                        ContactDataHelper.setContactValue(cursor1, contact);
                        contacts.add(contact);
                    } while (cursor1.moveToNext());
                }
                if ((cursor2 = db.query(TABLE_NUMBER, ContactDataHelper.numberSelectColumns, "contactJid in (" + UCDBContact.prepareInSql(jidset) + ")", null, null, null, null, null)) != null && cursor2.moveToFirst()) {
                    do {
                        if (!numbersMap.containsKey(contactJid = cursor2.getString(0))) {
                            numbersMap.put(contactJid, new ArrayList());
                        }
                        list = (ArrayList)numbersMap.get(contactJid);
                        LiteTeleNumber number = new LiteTeleNumber();
                        ContactDataHelper.setNumberValue(cursor2, number);
                        list.add(number);
                    } while (cursor2.moveToNext());
                }
                if ((cursor3 = db.query(TABLE_CONTACT_OUTBOUND_PREFIX, ContactDataHelper.empOutboundPrefixSelectColumns, "contactJid in (" + UCDBContact.prepareInSql(jidset) + ")", null, null, null, null, null)) != null && cursor3.moveToFirst()) {
                    do {
                        if (!outboundPrefixMap.containsKey(contactJid = cursor3.getString(0))) {
                            outboundPrefixMap.put(contactJid, new ArrayList());
                        }
                        list = (ArrayList)outboundPrefixMap.get(contactJid);
                        LiteOutPrefix outboundPrefix = new LiteOutPrefix();
                        ContactDataHelper.setOutPrefixValue(cursor3, outboundPrefix);
                        list.add(outboundPrefix);
                    } while (cursor3.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBContact.closeCursor(cursor1);
                UCDBContact.closeCursor(cursor2);
                UCDBContact.closeCursor(cursor3);
                UCDBContact.closeDb(db);
                throw throwable;
            }
            UCDBContact.closeCursor(cursor1);
            UCDBContact.closeCursor(cursor2);
            UCDBContact.closeCursor(cursor3);
            UCDBContact.closeDb(db);
        }
        for (LiteContact contact : contacts) {
            contact.setTelephones((List)numbersMap.get(contact.getJid()));
            contact.setOutboundPrefixList((List)outboundPrefixMap.get(contact.getJid()));
        }
        return contacts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiteContact getContactByJid(Context ctx, String jid) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "getContactByJid...." + jid);
        LiteContact contact = null;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor1 = null;
            Cursor cursor2 = null;
            Cursor cursor3 = null;
            try {
                db = helper.getReadableDatabase();
                cursor1 = db.query(TABLE_CONTACT, ContactDataHelper.contactSelectColumns, "jid=?", new String[]{jid}, null, null, null, null);
                if (cursor1 != null && cursor1.moveToFirst()) {
                    contact = new LiteContact();
                    ContactDataHelper.setContactValue(cursor1, contact);
                }
                if (contact != null) {
                    ArrayList<LiteTeleNumber> numberList = new ArrayList<LiteTeleNumber>();
                    cursor2 = db.query(TABLE_NUMBER, ContactDataHelper.numberSelectColumns, "contactJid=?", new String[]{String.valueOf(contact.getJid())}, null, null, null, null);
                    if (cursor2 != null && cursor2.moveToFirst()) {
                        do {
                            LiteTeleNumber number = new LiteTeleNumber();
                            ContactDataHelper.setNumberValue(cursor2, number);
                            numberList.add(number);
                        } while (cursor2.moveToNext());
                    }
                    contact.setTelephones(numberList);
                    ArrayList<LiteOutPrefix> outboundPrefixList = new ArrayList<LiteOutPrefix>();
                    cursor3 = db.query(TABLE_CONTACT_OUTBOUND_PREFIX, ContactDataHelper.empOutboundPrefixSelectColumns, "contactJid=?", new String[]{String.valueOf(contact.getJid())}, null, null, null, null);
                    if (cursor3 != null && cursor3.moveToFirst()) {
                        do {
                            LiteOutPrefix outboundPrefix = new LiteOutPrefix();
                            ContactDataHelper.setOutPrefixValue(cursor3, outboundPrefix);
                            outboundPrefixList.add(outboundPrefix);
                        } while (cursor3.moveToNext());
                    }
                    contact.setOutboundPrefixList(outboundPrefixList);
                }
            }
            catch (Throwable throwable) {
                UCDBContact.closeCursor(cursor1);
                UCDBContact.closeCursor(cursor2);
                UCDBContact.closeCursor(cursor3);
                UCDBContact.closeDb(db);
                throw throwable;
            }
            UCDBContact.closeCursor(cursor1);
            UCDBContact.closeCursor(cursor2);
            UCDBContact.closeCursor(cursor3);
            UCDBContact.closeDb(db);
        }
        return contact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiteContact getContactByLodId(Context ctx, String siteId, String extension) {
        UCDBHelper helper;
        if (siteId == null || extension == null) {
            return null;
        }
        LiteContact contact = null;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor1 = null;
            Cursor cursor2 = null;
            Cursor cursor3 = null;
            try {
                db = helper.getReadableDatabase();
                cursor1 = db.query(TABLE_CONTACT, ContactDataHelper.contactSelectColumns, "ext=? and siteId=?", new String[]{extension, siteId}, null, null, null, null);
                if (cursor1 != null && cursor1.moveToFirst()) {
                    contact = new LiteContact();
                    ContactDataHelper.setContactValue(cursor1, contact);
                }
                if (contact != null) {
                    ArrayList<LiteTeleNumber> numbers = new ArrayList<LiteTeleNumber>();
                    cursor2 = db.query(TABLE_NUMBER, ContactDataHelper.numberSelectColumns, "contactJid=?", new String[]{String.valueOf(contact.getJid())}, null, null, null, null);
                    if (cursor2 != null && cursor2.moveToFirst()) {
                        do {
                            LiteTeleNumber number = new LiteTeleNumber();
                            ContactDataHelper.setNumberValue(cursor2, number);
                            numbers.add(number);
                        } while (cursor2.moveToNext());
                    }
                    contact.setTelephones(numbers);
                    ArrayList<LiteOutPrefix> outboundPrefixList = new ArrayList<LiteOutPrefix>();
                    cursor3 = db.query(TABLE_CONTACT_OUTBOUND_PREFIX, ContactDataHelper.empOutboundPrefixSelectColumns, "contactJid=?", new String[]{String.valueOf(contact.getJid())}, null, null, null, null);
                    if (cursor3 != null && cursor3.moveToFirst()) {
                        do {
                            LiteOutPrefix outPrefix = new LiteOutPrefix();
                            ContactDataHelper.setOutPrefixValue(cursor3, outPrefix);
                            outboundPrefixList.add(outPrefix);
                        } while (cursor3.moveToNext());
                    }
                    contact.setOutboundPrefixList(outboundPrefixList);
                }
            }
            catch (Throwable throwable) {
                UCDBContact.closeCursor(cursor1);
                UCDBContact.closeCursor(cursor2);
                UCDBContact.closeCursor(cursor3);
                UCDBContact.closeDb(db);
                throw throwable;
            }
            UCDBContact.closeCursor(cursor1);
            UCDBContact.closeCursor(cursor2);
            UCDBContact.closeCursor(cursor3);
            UCDBContact.closeDb(db);
        }
        return contact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiteContact getContactByEmpId(Context ctx, Long empId) {
        UCDBHelper helper;
        if (empId == null) {
            return null;
        }
        LiteContact contact = null;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor1 = null;
            Cursor cursor2 = null;
            Cursor cursor3 = null;
            try {
                db = helper.getReadableDatabase();
                cursor1 = db.query(TABLE_CONTACT, ContactDataHelper.contactSelectColumns, "empId=?", new String[]{String.valueOf(empId)}, null, null, null, null);
                if (cursor1 != null && cursor1.moveToFirst()) {
                    contact = new LiteContact();
                    ContactDataHelper.setContactValue(cursor1, contact);
                }
                if (contact != null) {
                    ArrayList<LiteTeleNumber> numbers = new ArrayList<LiteTeleNumber>();
                    cursor2 = db.query(TABLE_NUMBER, ContactDataHelper.numberSelectColumns, "contactJid=?", new String[]{String.valueOf(contact.getJid())}, null, null, null, null);
                    if (cursor2 != null && cursor2.moveToFirst()) {
                        do {
                            LiteTeleNumber number = new LiteTeleNumber();
                            ContactDataHelper.setNumberValue(cursor2, number);
                            numbers.add(number);
                        } while (cursor2.moveToNext());
                    }
                    contact.setTelephones(numbers);
                    ArrayList<LiteOutPrefix> outboundPrefixList = new ArrayList<LiteOutPrefix>();
                    cursor3 = db.query(TABLE_CONTACT_OUTBOUND_PREFIX, ContactDataHelper.empOutboundPrefixSelectColumns, "contactJid=?", new String[]{String.valueOf(contact.getJid())}, null, null, null, null);
                    if (cursor3 != null && cursor3.moveToFirst()) {
                        do {
                            LiteOutPrefix outPrefix = new LiteOutPrefix();
                            ContactDataHelper.setOutPrefixValue(cursor3, outPrefix);
                            outboundPrefixList.add(outPrefix);
                        } while (cursor3.moveToNext());
                    }
                    contact.setOutboundPrefixList(outboundPrefixList);
                }
            }
            catch (Throwable throwable) {
                UCDBContact.closeCursor(cursor1);
                UCDBContact.closeCursor(cursor2);
                UCDBContact.closeCursor(cursor3);
                UCDBContact.closeDb(db);
                throw throwable;
            }
            UCDBContact.closeCursor(cursor1);
            UCDBContact.closeCursor(cursor2);
            UCDBContact.closeCursor(cursor3);
            UCDBContact.closeDb(db);
        }
        return contact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<AddressBookGroup<T>> getContactsOrderByPresence(Context ctx, String searchKey, int contactType, Set<String> participants) {
        UCDBHelper helper = UCDBHelper.getDB(ctx);
        ArrayList<AddressBookGroup<T>> dataList = new ArrayList<AddressBookGroup<T>>();
        UCDBHelper uCDBHelper = helper;
        synchronized (uCDBHelper) {
            ArrayList<AddressBookGroup<T>> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                Object selection = contactType == -1 ? "" : "type = ?";
                String[] selectionArgs = null;
                String orderby = " dispName asc";
                Locale locale = I18NUtil.getAppLocale();
                if (!Locale.TAIWAN.equals(locale)) {
                    orderby = " UPPER( dispNameForPinYin) asc";
                }
                AddressBookGroup online = new AddressBookGroup("_PHONE_STATUS_IDLE_", I18NUtil.getString("phone_status_idle"));
                AddressBookGroup offline = new AddressBookGroup("_PHONE_STATUS_OFFLINE_", I18NUtil.getString("phone_status_off_line"));
                AddressBookGroup dnd = new AddressBookGroup("_PHONE_STATUS_DND_", I18NUtil.getString("phone_status_dnd"));
                AddressBookGroup busy = new AddressBookGroup("_PHONE_STATUS_BUSY_", I18NUtil.getString("phone_status_busy"));
                AddressBookGroup searchGroup = new AddressBookGroup("#", "#");
                boolean blank = UCDBContact.isBlank(searchKey);
                if (blank) {
                    if (contactType != -1) {
                        selectionArgs = new String[]{String.valueOf(contactType)};
                    }
                } else {
                    String searchKeyUpper = searchKey.toUpperCase();
                    if (Locale.TAIWAN.equals(locale)) {
                        if (contactType == -1) {
                            selectionArgs = new String[]{"%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                            selection = (String)selection + " (UPPER(dispName) LIKE ? OR UPPER(deptForSearch) LIKE ? OR UPPER(extForSearch) LIKE ?)";
                        } else {
                            selectionArgs = new String[]{String.valueOf(contactType), "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                            selection = (String)selection + " AND (UPPER(dispName) LIKE ? OR UPPER(deptForSearch) LIKE ? OR UPPER(extForSearch) LIKE ?)";
                        }
                    } else if (contactType == -1) {
                        selectionArgs = new String[]{"%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                        selection = (String)selection + " (UPPER(dispName) LIKE ? OR UPPER(dispNameForPinYin) LIKE ? OR UPPER(deptForSearch) LIKE ? OR UPPER(extForSearch) LIKE ?) ";
                    } else {
                        selectionArgs = new String[]{String.valueOf(contactType), "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                        selection = (String)selection + " AND (UPPER(dispName) LIKE ? OR UPPER(dispNameForPinYin) LIKE ? OR UPPER(deptForSearch) LIKE ? OR UPPER(extForSearch) LIKE ?) ";
                    }
                }
                if (participants != null && !participants.isEmpty()) {
                    selection = TextUtils.isBlank((CharSequence)selection) ? "jid not in (" + UCDBContact.prepareInSql(participants) + ")" : (String)selection + " AND jid not in (" + UCDBContact.prepareInSql(participants) + ")";
                }
                if ((cursor = db.query(TABLE_CONTACT, ContactDataHelper.contactSelectColumns, (String)(selection = TextUtils.isBlank((CharSequence)selection) ? (String)selection + "abscope = 1" : (String)selection + " AND abscope = 1"), selectionArgs, null, null, orderby, null)) != null && cursor.moveToFirst()) {
                    do {
                        LiteContact contact = new LiteContact();
                        ContactDataHelper.setContactValue(cursor, contact);
                        if (contact.getJid() == null && contact.getAccount() == null || JidUtil.isLocationJid(contact.getJid()) && StringUtils.isBlank((CharSequence)contact.getExt())) continue;
                        LiteContact record = contact;
                        if (blank) {
                            String phoneStatus = "";
                            if (JidUtil.isEmployeeJid(contact.getJid())) {
                                phoneStatus = ContactManager.getPhoneEmpStatus("" + contact.getId());
                            } else if (JidUtil.isLocationJid(contact.getJid())) {
                                phoneStatus = ContactManager.getPhoneLocStatus(contact.getJid());
                            }
                            String dispName = ContactManager.getContactFullName(contact);
                            if (!Locale.TAIWAN.equals(locale)) {
                                dispName = contact.getDispNameForPinYin();
                            }
                            if (phoneStatus.equals("OFF_LINE")) {
                                offline.getDataList().add(record);
                                continue;
                            }
                            if (phoneStatus.equals("DND")) {
                                dnd.getDataList().add(record);
                                continue;
                            }
                            if (phoneStatus.equals("BUSY")) {
                                busy.getDataList().add(record);
                                continue;
                            }
                            if (phoneStatus.equals("HARD_PHONE")) {
                                online.getDataList().add(record);
                                continue;
                            }
                            if (phoneStatus.equals("MOBILE")) {
                                online.getDataList().add(record);
                                continue;
                            }
                            if (phoneStatus.equals("MOBILE_NS")) {
                                online.getDataList().add(record);
                                continue;
                            }
                            if (!phoneStatus.equals("DESKTOP")) continue;
                            online.getDataList().add(record);
                            continue;
                        }
                        searchGroup.getDataList().add(record);
                    } while (cursor.moveToNext());
                    if (blank) {
                        if (online.getDataList().size() != 0) {
                            dataList.add(online);
                        }
                        if (busy.getDataList().size() != 0) {
                            dataList.add(busy);
                        }
                        if (dnd.getDataList().size() != 0) {
                            dataList.add(dnd);
                        }
                        if (offline.getDataList().size() != 0) {
                            dataList.add(offline);
                        }
                    } else if (searchGroup.getDataList().size() != 0) {
                        dataList.add(searchGroup);
                    }
                } else {
                    UCDBContact._log(UCDBContact.class.getSimpleName(), "search " + searchKey + ", contactType is " + contactType + ", size is 0");
                }
                arrayList = dataList;
            }
            catch (Throwable throwable) {
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                throw throwable;
            }
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<AddressBookGroup<T>> getContactsOrderByName(Context ctx, String searchKey, int contactType, Set<String> participants) {
        UCDBHelper helper;
        ArrayList<AddressBookGroup<T>> dataList = new ArrayList<AddressBookGroup<T>>();
        AddressBookGroup currentGroup = null;
        AddressBookGroup unKnownGroup = new AddressBookGroup("#", "#");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<AddressBookGroup<T>> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                boolean blank;
                db = helper.getReadableDatabase();
                Object selection = contactType == -1 ? "" : "type = ?";
                String[] selectionArgs = null;
                String orderby = " UPPER(dispName) asc";
                Locale locale = I18NUtil.getAppLocale();
                if (!Locale.TAIWAN.equals(locale)) {
                    orderby = " UPPER( dispNameForPinYin) asc";
                }
                if (blank = UCDBContact.isBlank(searchKey)) {
                    if (contactType != -1) {
                        selectionArgs = new String[]{String.valueOf(contactType)};
                    }
                } else {
                    String searchKeyUpper = searchKey.toUpperCase();
                    if (Locale.TAIWAN.equals(locale)) {
                        if (contactType == -1) {
                            selectionArgs = new String[]{"%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                            selection = (String)selection + " (UPPER(dispName) LIKE ? OR UPPER(deptForSearch) LIKE ? OR UPPER(extForSearch) LIKE ?)";
                        } else {
                            selectionArgs = new String[]{String.valueOf(contactType), "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                            selection = (String)selection + " AND (UPPER(dispName) LIKE ? OR UPPER(deptForSearch) LIKE ? OR UPPER(extForSearch) LIKE ?)";
                        }
                    } else if (contactType == -1) {
                        selectionArgs = new String[]{"%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                        selection = (String)selection + " (UPPER(dispName) LIKE ? OR UPPER(dispNameForPinYin) LIKE ? OR UPPER(deptForSearch) LIKE ? OR UPPER(extForSearch) LIKE ?)";
                    } else {
                        selectionArgs = new String[]{String.valueOf(contactType), "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                        selection = (String)selection + " AND (UPPER(dispName) LIKE ? OR UPPER(dispNameForPinYin) LIKE ? OR UPPER(deptForSearch) LIKE ? OR UPPER(extForSearch) LIKE ?)";
                    }
                }
                if (participants != null && !participants.isEmpty()) {
                    selection = TextUtils.isBlank((CharSequence)selection) ? "jid not in (" + UCDBContact.prepareInSql(participants) + ")" : (String)selection + " AND jid not in (" + UCDBContact.prepareInSql(participants) + ")";
                }
                selection = TextUtils.isBlank((CharSequence)selection) ? (String)selection + "abscope = 1" : (String)selection + " AND abscope = 1";
                cursor = db.query(TABLE_CONTACT, ContactDataHelper.contactSelectColumns, (String)selection, selectionArgs, null, null, orderby, null);
                String indexChar = null;
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        LiteContact contact = new LiteContact();
                        ContactDataHelper.setContactValue(cursor, contact);
                        if (contact.getJid() == null && contact.getAccount() == null || JidUtil.isLocationJid(contact.getJid()) && StringUtils.isBlank((CharSequence)contact.getExt())) continue;
                        LiteContact record = contact;
                        if (blank) {
                            String dispName = ContactManager.getContactFullName(contact);
                            if (!Locale.TAIWAN.equals(locale)) {
                                dispName = contact.getDispNameForPinYin();
                            }
                            if (TextUtils.isBlank((CharSequence)dispName) || !dispName.matches("[a-zA-Z].*")) {
                                unKnownGroup.getDataList().add(record);
                                continue;
                            }
                            indexChar = dispName.substring(0, 1).toUpperCase(Locale.US);
                            if (currentGroup == null) {
                                currentGroup = new AddressBookGroup(indexChar, indexChar);
                                dataList.add(currentGroup);
                            } else if (!indexChar.equalsIgnoreCase(currentGroup.getId())) {
                                currentGroup = new AddressBookGroup(indexChar, indexChar);
                                dataList.add(currentGroup);
                            }
                            currentGroup.getDataList().add(record);
                            continue;
                        }
                        unKnownGroup.getDataList().add(record);
                    } while (cursor.moveToNext());
                    dataList.add(unKnownGroup);
                } else {
                    UCDBContact._log(UCDBContact.class.getSimpleName(), "search " + searchKey + ", size is 0");
                }
                arrayList = dataList;
            }
            catch (Throwable throwable) {
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                throw throwable;
            }
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<AddressBookGroup<T>> getContactsOrderByGroup(Context ctx, String searchKey, int contactType, Set<String> participants) {
        UCDBHelper helper;
        ArrayList<AddressBookGroup<T>> dataList = new ArrayList<AddressBookGroup<T>>();
        AddressBookGroup currentGroup = null;
        AddressBookGroup unKnownGroup = new AddressBookGroup("#", "#");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<AddressBookGroup<T>> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                String orderby = "type DESC , departmentNamePath ASC , givenName ASC";
                Object selection = contactType == -1 ? "" : "type = ?";
                String[] selectionArgs = null;
                boolean blank = UCDBContact.isBlank(searchKey);
                if (blank) {
                    if (contactType != -1) {
                        selectionArgs = new String[]{String.valueOf(contactType)};
                    }
                } else {
                    String searchKeyUpper = searchKey.toUpperCase();
                    Locale locale = I18NUtil.getAppLocale();
                    if (Locale.TAIWAN.equals(locale)) {
                        if (contactType == -1) {
                            selectionArgs = new String[]{"%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                            selection = (String)selection + " (UPPER(dispName) LIKE ? OR UPPER(deptForSearch) LIKE ? OR UPPER(extForSearch) LIKE ?)";
                        } else {
                            selectionArgs = new String[]{String.valueOf(contactType), "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                            selection = (String)selection + " AND (UPPER(dispName) LIKE ? OR UPPER(deptForSearch) LIKE ? OR UPPER(extForSearch) LIKE ?)";
                        }
                    } else if (contactType == -1) {
                        selectionArgs = new String[]{"%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                        selection = (String)selection + " (UPPER(dispName) LIKE ? OR UPPER(dispNameForPinYin) LIKE ? OR UPPER(deptForSearch) LIKE ? OR UPPER(extForSearch) LIKE ?)";
                    } else {
                        selectionArgs = new String[]{String.valueOf(contactType), "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                        selection = (String)selection + " AND (UPPER(dispName) LIKE ? OR UPPER(dispNameForPinYin) LIKE ? OR UPPER(deptForSearch) LIKE ? OR UPPER(extForSearch) LIKE ?)";
                    }
                }
                if (participants != null && !participants.isEmpty()) {
                    selection = TextUtils.isBlank((CharSequence)selection) ? "jid not in (" + UCDBContact.prepareInSql(participants) + ")" : (String)selection + " AND jid not in (" + UCDBContact.prepareInSql(participants) + ")";
                }
                if ((cursor = db.query(TABLE_CONTACT, ContactDataHelper.contactSelectColumns, (String)(selection = TextUtils.isBlank((CharSequence)selection) ? (String)selection + "abscope = 1" : (String)selection + " AND abscope = 1"), selectionArgs, null, null, orderby, null)) != null && cursor.moveToFirst()) {
                    do {
                        LiteContact contact = new LiteContact();
                        ContactDataHelper.setContactValue(cursor, contact);
                        if (contact.getJid() == null && contact.getAccount() == null || JidUtil.isLocationJid(contact.getJid()) && StringUtils.isBlank((CharSequence)contact.getExt())) continue;
                        LiteContact record = contact;
                        if (blank) {
                            LiteDepartment dept;
                            String departmentPath;
                            String departmentName = departmentPath = contact.getDepartmentNamePath();
                            int deptMode = PreferencesUtil.getClientAppDeptMode(ctx);
                            if (deptMode == 1 && (dept = UCDBDept.getDeptByNamePath(ctx, departmentPath)) != null) {
                                departmentName = dept.getDispName();
                            }
                            if (currentGroup == null) {
                                currentGroup = new AddressBookGroup(departmentPath, departmentName);
                                dataList.add(currentGroup);
                                currentGroup.getDataList().add(record);
                                continue;
                            }
                            if (!currentGroup.getId().equals(departmentPath)) {
                                currentGroup = new AddressBookGroup(departmentPath, departmentName);
                                dataList.add(currentGroup);
                                currentGroup.getDataList().add(record);
                                continue;
                            }
                            currentGroup.getDataList().add(record);
                            continue;
                        }
                        unKnownGroup.getDataList().add(record);
                    } while (cursor.moveToNext());
                } else {
                    UCDBContact._log(UCDBContact.class.getSimpleName(), "search " + searchKey + ", size is 0");
                }
                dataList.add(unKnownGroup);
                arrayList = dataList;
            }
            catch (Throwable throwable) {
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                throw throwable;
            }
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
            return arrayList;
        }
    }

    public static String getMatchedContactJidByPhoneNo(Context ctx, String phoneNo, boolean isOutbound) {
        String extendedJid;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "getSuspectContactJidByPhoneNo...." + phoneNo);
        String cleanPhoneNo = PhoneNoUtil.cleanPhoneNo(phoneNo);
        if (TextUtils.isBlank((CharSequence)cleanPhoneNo)) {
            return null;
        }
        EmpExtendedSysPhoneConfig config = PreferencesUtil.getEmpExtendedSysPhoneConfig(ctx);
        if (config.hasFlagEnabled() && (extendedJid = UCDBContact.tryToMatchEmpExtendedPhone(ctx, cleanPhoneNo)) != null) {
            return extendedJid;
        }
        if (isOutbound) {
            List<LiteOutboundPrefix> outboundPrefixList = UCDBSite.getAllOutboundPrefixs(ctx);
            for (LiteOutboundPrefix prefix : outboundPrefixList) {
                String jid;
                String prefixStr = prefix.getPrefix();
                if (!TextUtils.isNotEmpty((CharSequence)prefixStr)) continue;
                String phoneNumberNoPrefix = cleanPhoneNo;
                if (phoneNumberNoPrefix.startsWith(prefixStr)) {
                    phoneNumberNoPrefix = PhoneNoUtil.getLastDigit(cleanPhoneNo, cleanPhoneNo.length() - prefixStr.length());
                }
                if ((jid = UCDBContact.tryToMatchEmpPhone(ctx, phoneNumberNoPrefix)) == null) continue;
                return jid;
            }
        }
        if (cleanPhoneNo.length() <= 8) {
            String jid = UCDBContact.tryToMatchEmpPhone(ctx, cleanPhoneNo);
            if (jid != null) {
                return jid;
            }
        } else {
            for (int i = cleanPhoneNo.length(); i >= 8; --i) {
                String fuzzyNum = PhoneNoUtil.getLastDigit(cleanPhoneNo, i);
                String jid = UCDBContact.tryToMatchEmpPhone(ctx, fuzzyNum);
                if (jid == null) continue;
                return jid;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String tryToMatchEmpExtendedPhone(Context ctx, String phoneNumber) {
        UCDBHelper helper;
        if (TextUtils.isEmpty((CharSequence)phoneNumber)) {
            return null;
        }
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block14: {
                String string;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    EmpExtendedSysPhoneConfig config = PreferencesUtil.getEmpExtendedSysPhoneConfig(ctx);
                    StringBuffer sql = new StringBuffer();
                    int numberEnabledCount = 0;
                    if (config.isEmpExtendedSystemPhoneFlag1()) {
                        sql.append("extendedNumber1 = ?");
                        ++numberEnabledCount;
                    }
                    if (config.isEmpExtendedSystemPhoneFlag2()) {
                        if (sql.length() > 0) {
                            sql.append(" OR ");
                        }
                        sql.append("extendedNumber2 = ?");
                        ++numberEnabledCount;
                    }
                    if (config.isEmpExtendedSystemPhoneFlag3()) {
                        if (sql.length() > 0) {
                            sql.append(" OR ");
                        }
                        sql.append("extendedNumber3 = ?");
                        ++numberEnabledCount;
                    }
                    if (config.isEmpExtendedSystemPhoneFlag4()) {
                        if (sql.length() > 0) {
                            sql.append(" OR ");
                        }
                        sql.append("extendedNumber4 = ?");
                        ++numberEnabledCount;
                    }
                    String[] param = new String[numberEnabledCount];
                    for (int i = 0; i < numberEnabledCount; ++i) {
                        param[i] = phoneNumber;
                    }
                    cursor = db.query(TABLE_CONTACT, new String[]{"jid"}, sql.toString(), param, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block14;
                    string = cursor.getString(0);
                }
                catch (Throwable throwable) {
                    UCDBContact.closeCursor(cursor);
                    UCDBContact.closeDb(db);
                    throw throwable;
                }
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                return string;
            }
            String string = null;
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String tryToMatchEmpPhone(Context ctx, String phoneNumber) {
        UCDBHelper helper;
        if (TextUtils.isEmpty((CharSequence)phoneNumber)) {
            return null;
        }
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block6: {
                String string;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_NUMBER, new String[]{"contactJid"}, "number = ?", new String[]{phoneNumber}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block6;
                    string = cursor.getString(0);
                }
                catch (Throwable throwable) {
                    UCDBContact.closeCursor(cursor);
                    UCDBContact.closeDb(db);
                    throw throwable;
                }
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                return string;
            }
            String string = null;
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateContact(Context ctx, LiteContact contact, int scope) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "updateContact...." + String.valueOf(contact));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                int i;
                db = helper.getWritableDatabase();
                db.update(TABLE_CONTACT, ContactDataHelper.createContactUpdateValues(contact, scope), "jid = ?", new String[]{String.valueOf(contact.getJid())});
                db.delete(TABLE_NUMBER, "contactJid = ?", new String[]{String.valueOf(contact.getJid())});
                for (i = 0; contact.getTelephones() != null && i < contact.getTelephones().size(); ++i) {
                    LiteTeleNumber number = contact.getTelephones().get(i);
                    db.insert(TABLE_NUMBER, null, ContactDataHelper.createNumberAddValues(contact, number));
                }
                db.delete(TABLE_CONTACT_OUTBOUND_PREFIX, "contactJid = ?", new String[]{String.valueOf(contact.getJid())});
                for (i = 0; contact.getOutboundPrefixList() != null && i < contact.getOutboundPrefixList().size(); ++i) {
                    LiteOutPrefix outPrefix = contact.getOutboundPrefixList().get(i);
                    db.insert(TABLE_CONTACT_OUTBOUND_PREFIX, null, ContactDataHelper.createOutPrefixAddValues(contact, outPrefix));
                }
            }
            finally {
                UCDBContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCurrentPhotoTimestamp(Context ctx, String jid, long timestamp) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "updateContactPhotoTimestamp...." + jid + "," + timestamp);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("photoFlag", true);
                values.put("currentPhotoTimestamp", timestamp);
                db.update(TABLE_CONTACT, values, "jid = ?", new String[]{jid});
            }
            finally {
                UCDBContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateContactPhotoTimestamp(Context ctx, String jid, long timestamp) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "updateContactPhotoTimestamp...." + jid + "," + timestamp);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("photoFlag", true);
                values.put("personalPhotoTimestamp", timestamp);
                db.update(TABLE_CONTACT, values, "jid = ?", new String[]{jid});
            }
            finally {
                UCDBContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getContactPhotoTimestamps(Context ctx, String jid) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "getContactPhotoTimestamps...." + jid);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            long[] lArray;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                String selection = "jid = ?";
                String[] selectionArgs = new String[]{jid};
                String[] columns = new String[]{"personalPhotoTimestamp", "currentPhotoTimestamp"};
                long[] timestamps = new long[]{-1L, -1L};
                cursor = db.query(TABLE_CONTACT, columns, selection, selectionArgs, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    timestamps[0] = cursor.getLong(0);
                    timestamps[1] = cursor.getLong(1);
                }
                lArray = timestamps;
            }
            catch (Throwable throwable) {
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                throw throwable;
            }
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
            return lArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getContactPhotoTimestamp(Context ctx, String jid) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "getContactPhotoTimestamp...." + jid);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            long l;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                String selection = "jid = ?";
                String[] selectionArgs = new String[]{jid};
                String[] columns = new String[]{"personalPhotoTimestamp"};
                long timestamp = -1L;
                cursor = db.query(TABLE_CONTACT, columns, selection, selectionArgs, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    timestamp = cursor.getLong(0);
                }
                l = timestamp;
            }
            catch (Throwable throwable) {
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                throw throwable;
            }
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteContactsByJids(Context ctx, Set<String> deletedJidSet) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "deleteContactsByJids...." + String.valueOf(deletedJidSet));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CONTACT, "jid IN (" + UCDBContact.jidsStrToQueryStr(deletedJidSet) + ")", null);
            }
            finally {
                UCDBContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteConfContacts(Context ctx) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "deleteConfContact....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CONTACT, "type = 4 OR type = 3", null);
            }
            finally {
                UCDBContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean deleteEmpContact(Context ctx, Long empId) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "deleteEmpContact...." + empId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block7: {
                boolean bl;
                db = null;
                cursor = null;
                try {
                    db = helper.getWritableDatabase();
                    cursor = db.query(TABLE_CONTACT, new String[]{"jid"}, "empId=? and type=?", new String[]{String.valueOf(empId), String.valueOf(0)}, null, null, null, null);
                    String contactJid = null;
                    if (cursor != null && cursor.moveToFirst()) {
                        contactJid = cursor.getString(0);
                    } else {
                        UCDBContact._log(UCDBContact.class.getSimpleName(), "deleteEmpContact: Contact not found for employee id " + empId);
                    }
                    if (contactJid == null) break block7;
                    db.delete(TABLE_CONTACT, "jid=?", new String[]{contactJid});
                    db.delete(TABLE_NUMBER, "contactJid = ?", new String[]{contactJid});
                    db.delete(TABLE_CONTACT_OUTBOUND_PREFIX, "contactJid = ?", new String[]{contactJid});
                    bl = true;
                }
                catch (Throwable throwable) {
                    UCDBContact.closeCursor(cursor);
                    UCDBContact.closeDb(db);
                    throw throwable;
                }
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                return bl;
            }
            boolean bl = false;
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllEmpContacts(Context ctx) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "deleteAllEmpContacts....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CONTACT, "type=?", new String[]{String.valueOf(0)});
                db.delete(TABLE_NUMBER, null, null);
                db.delete(TABLE_CONTACT_OUTBOUND_PREFIX, null, null);
            }
            finally {
                UCDBContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllLocationContacts(Context ctx) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "deleteAllLocationContacts....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CONTACT, "type=?", new String[]{String.valueOf(1)});
            }
            finally {
                UCDBContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getEmpJidList(Context ctx) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "getEmpJidList....");
        ArrayList<String> contactJidList = new ArrayList<String>();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_CONTACT, new String[]{"jid"}, "type=?", new String[]{String.valueOf(0)}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        String contactJid = cursor.getString(0);
                        contactJidList.add(contactJid);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                throw throwable;
            }
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
        }
        return contactJidList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long getEmpIdByJid(Context ctx, String jid) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "getEmpIdByJid...." + jid);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block4: {
                Long l;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CONTACT, new String[]{"empId"}, "type=? and jid=?", new String[]{String.valueOf(0), jid}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block4;
                    l = cursor.getLong(0);
                }
                catch (Throwable throwable) {
                    UCDBContact.closeCursor(cursor);
                    UCDBContact.closeDb(db);
                    throw throwable;
                }
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                return l;
            }
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContactJidByAccount(Context ctx, String account) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "getContactJidByAccount...." + account);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block4: {
                String string;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CONTACT, new String[]{"jid"}, "account=?", new String[]{account}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block4;
                    string = cursor.getString(0);
                }
                catch (Throwable throwable) {
                    UCDBContact.closeCursor(cursor);
                    UCDBContact.closeDb(db);
                    throw throwable;
                }
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                return string;
            }
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContactJidByEmpId(Context ctx, Long empId) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "getContactJidByEmpId...." + empId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block4: {
                String string;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CONTACT, new String[]{"jid"}, "empId=? and type=?", new String[]{String.valueOf(empId), String.valueOf(0)}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block4;
                    string = cursor.getString(0);
                }
                catch (Throwable throwable) {
                    UCDBContact.closeCursor(cursor);
                    UCDBContact.closeDb(db);
                    throw throwable;
                }
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                return string;
            }
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContactJidByLocId(Context ctx, String siteId, String extension) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "getContactJidByLocId...." + siteId + "," + extension);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block4: {
                String string;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CONTACT, new String[]{"jid"}, "ext=? and siteId=? and type=?", new String[]{extension, siteId, String.valueOf(1)}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block4;
                    string = cursor.getString(0);
                }
                catch (Throwable throwable) {
                    UCDBContact.closeCursor(cursor);
                    UCDBContact.closeDb(db);
                    throw throwable;
                }
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                return string;
            }
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LiteContact> findAllLocationContacts(Context ctx) {
        UCDBContact._log(UCDBContact.class.getSimpleName(), "findAllLocationContacts....");
        UCDBHelper helper = UCDBHelper.getDB(ctx);
        ArrayList<LiteContact> list = new ArrayList<LiteContact>();
        UCDBHelper uCDBHelper = helper;
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_CONTACT, ContactDataHelper.contactSelectColumns, "type=?", new String[]{String.valueOf(1)}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        LiteContact contact = new LiteContact();
                        ContactDataHelper.setContactValue(cursor, contact);
                        list.add(contact);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                throw throwable;
            }
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getContactEmpIdByJid(Context ctx, List<String> jid) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "getContactEmpIdByJid...." + String.valueOf(jid));
        ArrayList<String> data = new ArrayList<String>();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_CONTACT, new String[]{"empId"}, "jid in (" + UCDBContact.prepareInSql(jid) + ") and type=?", new String[]{String.valueOf(0)}, null, null, null, null);
                UCDBContact._log(UCDBContact.class.getSimpleName(), "getContactEmpIdByJid :" + cursor.getCount());
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        long value = cursor.getLong(0);
                        data.add(String.valueOf(value));
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                throw throwable;
            }
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContactEmpIdByJid(Context ctx, String jid) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "getContactEmpIdByJid...." + jid);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block4: {
                String string;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CONTACT, new String[]{"empId"}, "jid =? and type=?", new String[]{jid, String.valueOf(0)}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block4;
                    long value = cursor.getLong(0);
                    string = String.valueOf(value);
                }
                catch (Throwable throwable) {
                    UCDBContact.closeCursor(cursor);
                    UCDBContact.closeDb(db);
                    throw throwable;
                }
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                return string;
            }
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContactJidByEmail(Context ctx, String mail) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "getContactJidByEmail...." + mail);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block4: {
                String string;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CONTACT, new String[]{"jid"}, "email=? and type=?", new String[]{mail, String.valueOf(0)}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block4;
                    string = cursor.getString(0);
                }
                catch (Throwable throwable) {
                    UCDBContact.closeCursor(cursor);
                    UCDBContact.closeDb(db);
                    throw throwable;
                }
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                return string;
            }
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EmployeeMatchInfo getTargetJidByExt(Context ctx, String phoneNum, String mySitePrefix, List<LiteSite> siteList) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "getTargetJidByExt....phoneNum:" + phoneNum + ", mySitePrefix:" + mySitePrefix);
        if (TextUtils.isBlank((CharSequence)phoneNum)) {
            return null;
        }
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getReadableDatabase();
                String input = phoneNum.trim();
                EmployeeMatchInfo result = UCDBContact.trialFetchExt(db, mySitePrefix, input);
                if (result != null) {
                    EmployeeMatchInfo employeeMatchInfo = result;
                    return employeeMatchInfo;
                }
                if (siteList != null) {
                    for (LiteSite site : siteList) {
                        String targetExt;
                        String targetPrefix = site.getPrefix();
                        if (mySitePrefix.equalsIgnoreCase(targetPrefix) || !input.startsWith(targetPrefix) || (result = UCDBContact.trialFetchExt(db, targetPrefix, targetExt = input.substring(targetPrefix.length()))) == null) continue;
                        EmployeeMatchInfo employeeMatchInfo = result;
                        return employeeMatchInfo;
                    }
                }
                Iterator<LiteSite> iterator = null;
                return iterator;
            }
            finally {
                UCDBContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static EmployeeMatchInfo trialFetchExt(SQLiteDatabase db, String targetSitePrefix, String targetExt) {
        EmployeeMatchInfo employeeMatchInfo;
        Cursor cursor;
        block6: {
            EmployeeMatchInfo employeeMatchInfo2;
            cursor = null;
            try {
                cursor = db.query(TABLE_CONTACT, new String[]{"jid", "extList"}, "extList LIKE ? ", new String[]{"%" + targetSitePrefix + "_" + targetExt + "%"}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        String[] extList;
                        String jid = cursor.getString(0);
                        String extListStr = cursor.getString(1);
                        for (String ext : extList = extListStr.split(",")) {
                            String[] items = ext.split("_");
                            if (items.length <= 1 || !targetExt.equals(items[1]) || !targetSitePrefix.equals(items[0])) continue;
                            EmployeeMatchInfo info = new EmployeeMatchInfo();
                            info.setJid(jid);
                            info.setSitePrefix(items[0]);
                            info.setExt(items[1]);
                            employeeMatchInfo = info;
                            break block6;
                        }
                    } while (cursor.moveToNext());
                }
                employeeMatchInfo2 = null;
            }
            catch (Throwable throwable) {
                UCDBContact.closeCursor(cursor);
                throw throwable;
            }
            UCDBContact.closeCursor(cursor);
            return employeeMatchInfo2;
        }
        UCDBContact.closeCursor(cursor);
        return employeeMatchInfo;
    }

    public static Map<String, LiteContact> findAllRelatedContactsByJid(Context ctx, String jid) {
        UCDBContact._log(UCDBContact.class.getSimpleName(), "findAllRelatedContactsByJid...." + jid);
        HashSet<String> jids = new HashSet<String>();
        jids.add(jid);
        return UCDBContact._findAllRelatedContactsByJids(ctx, jids);
    }

    public static Map<String, LiteContact> findAllRelatedContactsByJids(Context ctx, Set<String> jidsSet) {
        UCDBContact._log(UCDBContact.class.getSimpleName(), "findAllRelatedContactsByJids...." + String.valueOf(jidsSet));
        return UCDBContact._findAllRelatedContactsByJids(ctx, jidsSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, LiteContact> _findAllRelatedContactsByJids(Context ctx, Set<String> jidsSet) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "_findAllRelatedContactsByJids....");
        HashMap<String, LiteContact> contactMap = new HashMap<String, LiteContact>();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor1 = null;
            Cursor cursor2 = null;
            Cursor cursor3 = null;
            try {
                String selectQuery3;
                String selectQuery2;
                db = helper.getReadableDatabase();
                String contactSQL = "SELECT ChatRoomParticipant.jid FROM ChatRoom,ChatRoomParticipant WHERE ChatRoom.chatRoomId = ChatRoomParticipant.chatRoomId and ChatRoom.chatRoomId IN (" + UCDBContact.jidsStrToQueryStr(jidsSet) + ")  UNION SELECT jid FROM Contact WHERE jid IN (" + UCDBContact.jidsStrToQueryStr(jidsSet) + ") ";
                cursor1 = db.query(TABLE_CONTACT, ContactDataHelper.contactSelectColumns, "jid IN (" + contactSQL + ")", null, null, null, null, null);
                if (cursor1 != null && cursor1.moveToFirst()) {
                    do {
                        LiteContact contact = new LiteContact();
                        ContactDataHelper.setContactValue(cursor1, contact);
                        if (contact.getJid() == null) continue;
                        contactMap.put(contact.getJid(), contact);
                    } while (cursor1.moveToNext());
                }
                if ((cursor2 = db.rawQuery(selectQuery2 = "SELECT * FROM ContactNumber", null)) != null && cursor2.moveToFirst()) {
                    do {
                        String contactJid = cursor2.getString(0);
                        LiteTeleNumber number = new LiteTeleNumber();
                        ContactDataHelper.setNumberValue(cursor2, number);
                        LiteContact contact = (LiteContact)contactMap.get(contactJid);
                        if (contact == null) continue;
                        if (contact.getTelephones() == null) {
                            contact.setTelephones(new ArrayList<LiteTeleNumber>());
                        }
                        contact.getTelephones().add(number);
                    } while (cursor2.moveToNext());
                }
                if ((cursor3 = db.rawQuery(selectQuery3 = "SELECT * FROM ContactOutboundPrefix", null)) != null && cursor3.moveToFirst()) {
                    do {
                        String contactJid = cursor3.getString(0);
                        LiteOutPrefix outPrefix = new LiteOutPrefix();
                        ContactDataHelper.setOutPrefixValue(cursor3, outPrefix);
                        LiteContact contact = contactMap.get(contactJid);
                        if (contact == null) continue;
                        if (contact.getOutboundPrefixList() == null) {
                            contact.setOutboundPrefixList(new ArrayList<LiteOutPrefix>());
                        }
                        contact.getOutboundPrefixList().add(outPrefix);
                    } while (cursor3.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBContact.closeCursor(cursor1);
                UCDBContact.closeCursor(cursor2);
                UCDBContact.closeCursor(cursor3);
                UCDBContact.closeDb(db);
                throw throwable;
            }
            UCDBContact.closeCursor(cursor1);
            UCDBContact.closeCursor(cursor2);
            UCDBContact.closeCursor(cursor3);
            UCDBContact.closeDb(db);
        }
        return contactMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ContactScope> findAllContactsIdList(Context ctx) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "findAllContactsIds ......... ");
        ArrayList<ContactScope> contactsIdList = new ArrayList<ContactScope>();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_CONTACT, new String[]{"empId", "abscope"}, null, null, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        long empId = cursor.getLong(0);
                        int scope = cursor.getInt(1);
                        ContactScope emp = new ContactScope();
                        emp.setEmployeeId(empId);
                        emp.setScpoe(scope);
                        contactsIdList.add(emp);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                throw throwable;
            }
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
        }
        return contactsIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateContactScope(Context ctx, int scope) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "updateContactScope.... scope:" + scope);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("abscope", scope);
                db.update(TABLE_CONTACT, values, "type = ?", new String[]{String.valueOf(0)});
            }
            finally {
                UCDBContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateContactScope(Context ctx, long empId, int scope) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "updateContactScope....empId:" + empId + ", scope:" + scope);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("abscope", scope);
                db.update(TABLE_CONTACT, values, "empId = ? AND type = ?", new String[]{String.valueOf(empId), String.valueOf(0)});
            }
            finally {
                UCDBContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, LiteContact> findAllContactsByEmpIdsWithoutNumber(Context ctx, Set<Long> empIdSet) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "findAllContactsByEmpIdsWithoutNumber ......... " + String.valueOf(empIdSet));
        HashMap<Long, LiteContact> contactsMap = new HashMap<Long, LiteContact>();
        if (empIdSet == null || empIdSet.size() == 0) {
            return contactsMap;
        }
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_CONTACT, ContactDataHelper.contactSelectColumns, "empId IN (" + UCDBContact.jidsLongToQueryStr(empIdSet) + ")", null, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        LiteContact contact = new LiteContact();
                        ContactDataHelper.setContactValue(cursor, contact);
                        if (contact.getId() == null) continue;
                        contactsMap.put(contact.getId(), contact);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                throw throwable;
            }
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
        }
        return contactsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, LiteContact> findAllContactsByJidsWithoutNumber(Context ctx, Collection<String> jids) {
        UCDBHelper helper;
        UCDBContact._log(UCDBContact.class.getSimpleName(), "findAllContactsByJidsWithoutNumber ......... " + String.valueOf(jids));
        HashMap<String, LiteContact> contactsMap = new HashMap<String, LiteContact>();
        if (jids == null || jids.size() == 0) {
            return contactsMap;
        }
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_CONTACT, ContactDataHelper.contactSelectColumns, "jid IN (" + UCDBContact.jidsStrToQueryStr(jids) + ")", null, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        LiteContact contact = new LiteContact();
                        ContactDataHelper.setContactValue(cursor, contact);
                        if (contact.getJid() == null) continue;
                        contactsMap.put(contact.getJid(), contact);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBContact.closeCursor(cursor);
                UCDBContact.closeDb(db);
                throw throwable;
            }
            UCDBContact.closeCursor(cursor);
            UCDBContact.closeDb(db);
        }
        return contactsMap;
    }
}

