/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.bean.LiteCustomer;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.db.CustomerDBConst;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UCDBCustomer
extends UCDBBase {
    public static final String TABLE_CUSTOMER = "Customer";

    public static void createCustomerTable(SQLiteDatabase db) {
        Log.d(UCDBHelper.class.getSimpleName(), "createCustomerTable....");
        db.execSQL("DROP TABLE IF EXISTS Customer");
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ");
        sql.append(TABLE_CUSTOMER);
        sql.append("(");
        sql.append("id");
        sql.append(" NUMERIC,");
        sql.append("openId");
        sql.append(" LONGVARCHAR,");
        sql.append("servCode");
        sql.append(" LONGVARCHAR,");
        sql.append("servName");
        sql.append(" LONGVARCHAR,");
        sql.append("nickname");
        sql.append(" LONGVARCHAR,");
        sql.append("sex");
        sql.append(" INTEGER,");
        sql.append("city");
        sql.append(" LONGVARCHAR,");
        sql.append("country");
        sql.append(" LONGVARCHAR,");
        sql.append("province");
        sql.append(" LONGVARCHAR,");
        sql.append("language");
        sql.append(" LONGVARCHAR,");
        sql.append("personalPhoto");
        sql.append(" INTEGER,");
        sql.append("personalPhotoTime");
        sql.append(" NUMERIC,");
        sql.append("account");
        sql.append(" LONGVARCHAR,");
        sql.append("createTime");
        sql.append(" LONGVARCHAR,");
        sql.append("lastUpdateTime");
        sql.append(" LONGVARCHAR,");
        sql.append("lastAccessTime");
        sql.append(" LONGVARCHAR,");
        sql.append("status");
        sql.append(" INTEGER,");
        sql.append("type");
        sql.append(" INTEGER,");
        sql.append("level");
        sql.append(" INTEGER,");
        sql.append("expireTime");
        sql.append(" NUMERIC,");
        sql.append("name");
        sql.append(" LONGVARCHAR,");
        sql.append("email");
        sql.append(" LONGVARCHAR,");
        sql.append("mobile");
        sql.append(" LONGVARCHAR,");
        sql.append("sessionId");
        sql.append(" LONGVARCHAR,");
        sql.append("sessionClose");
        sql.append(" INTEGER DEFAULT 0,");
        sql.append("transferred");
        sql.append(" INTEGER DEFAULT 0,");
        sql.append("assigner");
        sql.append(" LONGVARCHAR)");
        db.execSQL(sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCustomerTemp(Context ctx, String account, Long localExpiredTime, String sessionId, boolean isTransfferd) {
        UCDBHelper helper;
        UCDBCustomer._log(UCDBCustomer.class.getSimpleName(), "addCustomerTemp...." + account);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("account", account);
                values.put("expireTime", localExpiredTime);
                values.put("sessionId", sessionId);
                values.put("transferred", isTransfferd ? 1 : 0);
                db.insert(TABLE_CUSTOMER, null, values);
            }
            finally {
                UCDBCustomer.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCustomer(Context ctx, LiteCustomer cust) {
        UCDBHelper helper;
        UCDBCustomer._log(UCDBCustomer.class.getSimpleName(), "addCustomer...." + cust.getAccount());
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("id", cust.getId());
                values.put("openId", cust.getOpenId());
                values.put("servCode", cust.getServCode());
                values.put("servName", cust.getServName());
                values.put("nickname", cust.getNickname());
                values.put("sex", cust.getSex());
                values.put("city", cust.getCity());
                values.put("country", cust.getCountry());
                values.put("province", cust.getProvince());
                values.put("language", cust.getLanguage());
                values.put("personalPhoto", cust.isPersonalPhoto() ? 1 : 0);
                values.put("personalPhotoTime", cust.getPersonalPhotoTime());
                values.put("createTime", cust.getCreateTime());
                values.put("lastUpdateTime", cust.getLastUpdateTime());
                values.put("lastAccessTime", cust.getLastAccessTime());
                values.put("status", cust.getStatus());
                values.put("type", cust.getType());
                values.put("level", cust.getLevel() <= 0 ? 5 : cust.getLevel());
                values.put("name", cust.getName());
                values.put("email", cust.getEmail());
                values.put("mobile", cust.getMobile());
                values.put("account", cust.getAccount());
                values.put("sessionId", cust.getSessionId());
                values.put("sessionClose", cust.isSessionClose() ? 1 : 0);
                values.put("transferred", cust.isTransferred() ? 1 : 0);
                values.put("expireTime", cust.getExpireTime());
                values.put("assigner", cust.getAssigner());
                db.insert(TABLE_CUSTOMER, null, values);
            }
            finally {
                UCDBCustomer.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCustomer(Context ctx, LiteCustomer cust) {
        UCDBHelper helper;
        UCDBCustomer._log(UCDBCustomer.class.getSimpleName(), "updateCustomer...." + cust.getAccount());
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("id", cust.getId());
                values.put("openId", cust.getOpenId());
                values.put("servCode", cust.getServCode());
                values.put("servName", cust.getServName());
                values.put("nickname", cust.getNickname());
                values.put("sex", cust.getSex());
                values.put("city", cust.getCity());
                values.put("country", cust.getCountry());
                values.put("province", cust.getProvince());
                values.put("language", cust.getLanguage());
                values.put("personalPhoto", cust.isPersonalPhoto() ? 1 : 0);
                values.put("personalPhotoTime", cust.getPersonalPhotoTime());
                values.put("createTime", cust.getCreateTime());
                values.put("lastUpdateTime", cust.getLastUpdateTime());
                values.put("lastAccessTime", cust.getLastAccessTime());
                values.put("status", cust.getStatus());
                values.put("type", cust.getType());
                values.put("level", cust.getLevel() <= 0 ? 5 : cust.getLevel());
                values.put("name", cust.getName());
                values.put("email", cust.getEmail());
                values.put("mobile", cust.getMobile());
                if (ApiVersion.isApi7Later()) {
                    values.put("sessionId", cust.getSessionId());
                    values.put("sessionClose", cust.isSessionClose() ? 1 : 0);
                    values.put("transferred", cust.isTransferred() ? 1 : 0);
                    values.put("expireTime", cust.getExpireTime());
                    values.put("assigner", cust.getAssigner());
                }
                db.update(TABLE_CUSTOMER, values, "account = ?", new String[]{String.valueOf(cust.getAccount())});
            }
            finally {
                UCDBCustomer.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> getCustomerAccounts(Context ctx) {
        UCDBHelper helper;
        UCDBCustomer._log(UCDBCustomer.class.getSimpleName(), "getCustomerAccounts....");
        HashSet<String> set = new HashSet<String>();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                HashSet<String> hashSet;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CUSTOMER, new String[]{"account"}, null, null, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    do {
                        set.add(cursor.getString(0));
                    } while (cursor.moveToNext());
                    hashSet = set;
                }
                catch (Throwable throwable) {
                    UCDBCustomer.closeCursor(cursor);
                    UCDBCustomer.closeDb(db);
                    throw throwable;
                }
                UCDBCustomer.closeCursor(cursor);
                UCDBCustomer.closeDb(db);
                return hashSet;
            }
            UCDBCustomer.closeCursor(cursor);
            UCDBCustomer.closeDb(db);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<Long> getCustomerIds(Context ctx) {
        UCDBHelper helper;
        UCDBCustomer._log(UCDBCustomer.class.getSimpleName(), "getCustomerIds....");
        HashSet<Long> set = new HashSet<Long>();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                HashSet<Long> hashSet;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CUSTOMER, new String[]{"id"}, null, null, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    do {
                        set.add(cursor.getLong(0));
                    } while (cursor.moveToNext());
                    hashSet = set;
                }
                catch (Throwable throwable) {
                    UCDBCustomer.closeCursor(cursor);
                    UCDBCustomer.closeDb(db);
                    throw throwable;
                }
                UCDBCustomer.closeCursor(cursor);
                UCDBCustomer.closeDb(db);
                return hashSet;
            }
            UCDBCustomer.closeCursor(cursor);
            UCDBCustomer.closeDb(db);
            return null;
        }
    }

    public static void setCustomerValue(Cursor cursor, LiteCustomer liteCustomer) {
        liteCustomer.setNickname(cursor.getString(0));
        liteCustomer.setSex(cursor.getInt(1));
        liteCustomer.setCity(cursor.getString(2));
        liteCustomer.setCountry(cursor.getString(3));
        liteCustomer.setProvince(cursor.getString(4));
        liteCustomer.setLanguage(cursor.getString(5));
        liteCustomer.setPersonalPhoto(cursor.getInt(6) != 0);
        liteCustomer.setPersonalPhotoTime(cursor.getLong(7));
        liteCustomer.setAccount(cursor.getString(8));
        liteCustomer.setCreateTime(cursor.getString(9));
        liteCustomer.setLastUpdateTime(cursor.getString(10));
        liteCustomer.setLastAccessTime(cursor.getString(11));
        liteCustomer.setStatus(cursor.getInt(12));
        liteCustomer.setType(cursor.getInt(13));
        liteCustomer.setServName(cursor.getString(14));
        liteCustomer.setLevel(cursor.getInt(15));
        liteCustomer.setExpireTime(cursor.getLong(16));
        liteCustomer.setId(cursor.getLong(17));
        liteCustomer.setName(cursor.getString(18));
        liteCustomer.setEmail(cursor.getString(19));
        liteCustomer.setMobile(cursor.getString(20));
        liteCustomer.setSessionId(cursor.getString(21));
        liteCustomer.setSessionClose(cursor.getInt(22) != 0);
        liteCustomer.setTransferred(cursor.getInt(23) != 0);
        liteCustomer.setAssigner(cursor.getString(24));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteCustomer getCustomer(Context ctx, String account) {
        UCDBHelper helper;
        UCDBCustomer._log(UCDBCustomer.class.getSimpleName(), "getCustomer...." + account);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                LiteCustomer liteCustomer2;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CUSTOMER, CustomerDBConst.customerSelectColumns, "account=?", new String[]{account}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    LiteCustomer liteCustomer = new LiteCustomer();
                    UCDBCustomer.setCustomerValue(cursor, liteCustomer);
                    liteCustomer2 = liteCustomer;
                }
                catch (Throwable throwable) {
                    UCDBCustomer.closeCursor(cursor);
                    UCDBCustomer.closeDb(db);
                    throw throwable;
                }
                UCDBCustomer.closeCursor(cursor);
                UCDBCustomer.closeDb(db);
                return liteCustomer2;
            }
            LiteCustomer liteCustomer = null;
            UCDBCustomer.closeCursor(cursor);
            UCDBCustomer.closeDb(db);
            return liteCustomer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteCustomer getCustomerById(Context ctx, String id) {
        UCDBHelper helper;
        UCDBCustomer._log(UCDBCustomer.class.getSimpleName(), "getCustomerById...." + id);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                LiteCustomer liteCustomer2;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CUSTOMER, CustomerDBConst.customerSelectColumns, "id=?", new String[]{id}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    LiteCustomer liteCustomer = new LiteCustomer();
                    UCDBCustomer.setCustomerValue(cursor, liteCustomer);
                    liteCustomer2 = liteCustomer;
                }
                catch (Throwable throwable) {
                    UCDBCustomer.closeCursor(cursor);
                    UCDBCustomer.closeDb(db);
                    throw throwable;
                }
                UCDBCustomer.closeCursor(cursor);
                UCDBCustomer.closeDb(db);
                return liteCustomer2;
            }
            LiteCustomer liteCustomer = null;
            UCDBCustomer.closeCursor(cursor);
            UCDBCustomer.closeDb(db);
            return liteCustomer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCustomerLevel(Context ctx, String account, int level) {
        UCDBHelper helper;
        UCDBCustomer._log(UCDBCustomer.class.getSimpleName(), "updateCustomerLevel....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("level", level);
                db.update(TABLE_CUSTOMER, values, "account = ?", new String[]{String.valueOf(account)});
            }
            finally {
                UCDBCustomer.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCustomerSessionClose(Context ctx, String account, int isClose) {
        UCDBHelper helper;
        UCDBCustomer._log(UCDBCustomer.class.getSimpleName(), "updateCustomerLevel....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("sessionClose", isClose);
                db.update(TABLE_CUSTOMER, values, "account = ?", new String[]{String.valueOf(account)});
            }
            finally {
                UCDBCustomer.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCustomerStatusInfoOld(Context ctx, String account, Long localExpiredTime, String sessionId, boolean isTransfferd) {
        UCDBHelper helper;
        UCDBCustomer._log(UCDBCustomer.class.getSimpleName(), "updateCustomerStatusInfoOld....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("expireTime", localExpiredTime);
                values.put("sessionId", sessionId);
                values.put("transferred", isTransfferd ? 1 : 0);
                db.update(TABLE_CUSTOMER, values, "account = ?", new String[]{String.valueOf(account)});
            }
            finally {
                UCDBCustomer.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCustomerStatusInfo(Context ctx, String account, Long localExpiredTime, String sessionId, boolean isTransfferd, boolean isSessionClose, String assigner, int level, int status, String nickName) {
        UCDBHelper helper;
        UCDBCustomer._log(UCDBCustomer.class.getSimpleName(), "updateCustomerStatusInfo....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("expireTime", localExpiredTime);
                values.put("sessionId", sessionId);
                values.put("transferred", isTransfferd ? 1 : 0);
                values.put("sessionClose", isSessionClose ? 1 : 0);
                values.put("assigner", assigner);
                values.put("level", level <= 0 ? 5 : level);
                values.put("status", status);
                if (nickName != null) {
                    values.put("nickname", nickName);
                }
                db.update(TABLE_CUSTOMER, values, "account = ?", new String[]{String.valueOf(account)});
            }
            finally {
                UCDBCustomer.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCustomerSessionId(Context ctx, String account, String sessionId) {
        UCDBHelper helper;
        UCDBCustomer._log(UCDBCustomer.class.getSimpleName(), "updateCustomerSessionId....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("sessionId", sessionId);
                db.update(TABLE_CUSTOMER, values, "account = ?", new String[]{String.valueOf(account)});
            }
            finally {
                UCDBCustomer.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> findCustomerIds(Context ctx, String searchKey) {
        UCDBHelper helper;
        UCDBCustomer._log(UCDBCustomer.class.getSimpleName(), "findCustomerIds...." + searchKey);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<String> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<String> custIdList = new ArrayList<String>();
                String searchKeyUpper = searchKey;
                if (TextUtils.isNotBlank((CharSequence)searchKey)) {
                    searchKeyUpper = searchKey.trim().toUpperCase();
                }
                if ((cursor = db.rawQuery("SELECT account, COUNT(*)  FROM Customer WHERE UPPER(nickname) like ? ", new String[]{"%" + searchKeyUpper + "%"})) != null && cursor.moveToFirst()) {
                    do {
                        String account = cursor.getString(0);
                        int count = cursor.getInt(1);
                        if (count <= 0) continue;
                        if (ApiVersion.isApi5Later()) {
                            custIdList.add(account + "@social.blisscloud.com");
                            if (!account.startsWith("wechat_")) continue;
                            custIdList.add(account + "@blisscloud.com");
                            continue;
                        }
                        custIdList.add(account + "@blisscloud.com");
                    } while (cursor.moveToNext());
                }
                arrayList = custIdList;
            }
            catch (Throwable throwable) {
                UCDBCustomer.closeCursor(cursor);
                UCDBCustomer.closeDb(db);
                throw throwable;
            }
            UCDBCustomer.closeCursor(cursor);
            UCDBCustomer.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllCustomerData(Context ctx) {
        UCDBHelper helper;
        UCDBCustomer._log(UCDBCustomer.class.getSimpleName(), "deleteAllCustomerData....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CUSTOMER, null, null);
            }
            finally {
                UCDBCustomer.closeDb(db);
            }
        }
    }
}

