/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.bean.web.LiteFaxDoc;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.DatabaseUtils;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class UCDBFaxDoc
extends UCDBBase {
    public static final String TABLE_FAX_DOC = "FaxDoc";
    public static final String KEY_FAX_DOC_ID = "id";
    public static final String KEY_FAX_DOC_DIRECTION = "direction";
    public static final String KEY_FAX_DOC_PHONENUMBER = "phoneNumber";
    public static final String KEY_FAX_DOC_FILEPATH = "filePath";
    public static final String KEY_FAX_DOC_FILE_SIZE = "fileSize";
    public static final String KEY_FAX_DOC_PDF_FILEPATH = "pdfFilePath";
    public static final String KEY_FAX_DOC_PDF_FILE_SIZE = "pdfFileSize";
    public static final String KEY_FAX_DOC_CREATETIME = "createTimestamp";
    public static final String KEY_FAX_DOC_LASTUPDATETIME = "lastUpdateTimestamp";
    public static final String KEY_FAX_DOC_STATUS = "status";
    public static final String KEY_FAX_DOC_ERROR_CODE = "errorCode";
    public static final String KEY_FAX_DOC_SITE_ID = "siteId";
    public static final String KEY_FAX_DOC_READ_FLAG = "readFlag";
    public static final String KEY_FAX_DOC_ORIGINAL_DOWNLOAD_PATH = "originalDownloadPath";
    public static final String KEY_FAX_DOC_ORIGINAL_FILE_NAME = "originalFileName";
    public static final String KEY_FAX_DOC_ORIGINAL_FILE_SIZE = "originalFileSize";
    public static final String KEY_FAX_DOC_ORIGINAL_ENCODING_TYPE = "encodingType";
    public static final String KEY_FAX_DOC_ORIGINAL_FAX_PAGES = "faxPages";
    public static final String KEY_FAX_DOC_ORIGINAL_FAX_ERROR_DESCR = "faxErrorDescr";
    public static final String KEY_FAX_DOC_ORIGINAL_FAX_TIMESPENT = "faxTimeSpent";
    public static final String KEY_FAX_DOC_ORIGINAL_FAX_RETRY_COUNT = "faxRetryCount";
    public static final String[] selectColumns = new String[]{"id", "direction", "phoneNumber", "filePath", "fileSize", "pdfFilePath", "pdfFileSize", "createTimestamp", "lastUpdateTimestamp", "status", "errorCode", "siteId", "readFlag", "originalDownloadPath", "originalFileName", "originalFileSize", "encodingType", "faxPages", "faxErrorDescr", "faxTimeSpent", "faxRetryCount"};

    public static void createFaxDocTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS FaxDoc");
        String CREATE_READER_LOG = "CREATE TABLE FaxDoc(id NUMERIC PRIMARY KEY IDENTITY,direction TINYINT DEFAULT 0,phoneNumber LONGVARCHAR, filePath LONGVARCHAR, fileSize INTEGER, pdfFilePath LONGVARCHAR, pdfFileSize INTEGER, createTimestamp NUMERIC, lastUpdateTimestamp NUMERIC, status TINYINT, errorCode INTEGER, siteId NUMERIC, readFlag TINYINT DEFAULT 0, originalDownloadPath LONGVARCHAR, originalFileName LONGVARCHAR, originalFileSize INTEGER, encodingType LONGVARCHAR, faxPages INTEGER, faxErrorDescr LONGVARCHAR, faxTimeSpent NUMERIC, faxRetryCount INTEGER )";
        db.execSQL(CREATE_READER_LOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFaxDoc(Context ctx, JSONObject liteFaxDoc) {
        UCDBHelper helper;
        UCDBFaxDoc._log(UCDBFaxDoc.class.getSimpleName(), "addFaxDoc....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.insert(TABLE_FAX_DOC, null, UCDBFaxDoc.createContentValues(liteFaxDoc));
            }
            catch (JSONException e) {
                Log.w(UCDBFaxDoc.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
            }
            finally {
                UCDBFaxDoc.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateFaxDoc(Context ctx, long faxDocId, JSONObject liteFaxDoc) {
        UCDBHelper helper;
        UCDBFaxDoc._log(UCDBFaxDoc.class.getSimpleName(), "addFaxDoc....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = UCDBFaxDoc.createContentValues(liteFaxDoc);
                db.update(TABLE_FAX_DOC, values, "id=?", new String[]{String.valueOf(faxDocId)});
            }
            catch (JSONException e) {
                Log.w(UCDBFaxDoc.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
            }
            finally {
                UCDBFaxDoc.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markFaxDocReadFlag(Context ctx, long faxDocId) {
        UCDBHelper helper;
        UCDBFaxDoc._log(UCDBFaxDoc.class.getSimpleName(), "markFaxDocReadFlag....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put(KEY_FAX_DOC_READ_FLAG, 1);
                db.update(TABLE_FAX_DOC, values, "id=?", new String[]{String.valueOf(faxDocId)});
            }
            finally {
                UCDBFaxDoc.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFaxDoc(Context context, long faxDocId) {
        UCDBHelper helper;
        UCDBFaxDoc._log(UCDBFaxDoc.class.getSimpleName(), "deleteFaxDoc...." + faxDocId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(context);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_FAX_DOC, "id = ?", new String[]{String.valueOf(faxDocId)});
            }
            finally {
                UCDBFaxDoc.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFaxDocExist(Context ctx, long docId) {
        UCDBHelper helper;
        UCDBFaxDoc._log(UCDBFaxDoc.class.getSimpleName(), "isFaxDocExist ..." + docId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_FAX_DOC, "id=? ", new String[]{String.valueOf(docId)});
                bl = count > 0L;
            }
            catch (Throwable throwable) {
                UCDBFaxDoc.closeCursor(cursor);
                UCDBFaxDoc.closeDb(db);
                throw throwable;
            }
            UCDBFaxDoc.closeCursor(cursor);
            UCDBFaxDoc.closeDb(db);
            return bl;
        }
    }

    public static ContentValues createContentValues(JSONObject liteFaxDoc) throws JSONException {
        ContentValues values = new ContentValues();
        values.put(KEY_FAX_DOC_ID, liteFaxDoc.getLong(KEY_FAX_DOC_ID));
        values.put(KEY_FAX_DOC_DIRECTION, liteFaxDoc.getInt(KEY_FAX_DOC_DIRECTION));
        values.put(KEY_FAX_DOC_PHONENUMBER, liteFaxDoc.getString(KEY_FAX_DOC_PHONENUMBER));
        if (liteFaxDoc.has(KEY_FAX_DOC_FILEPATH)) {
            values.put(KEY_FAX_DOC_FILEPATH, liteFaxDoc.getString(KEY_FAX_DOC_FILEPATH));
        }
        if (liteFaxDoc.has(KEY_FAX_DOC_FILE_SIZE)) {
            values.put(KEY_FAX_DOC_FILE_SIZE, liteFaxDoc.getLong(KEY_FAX_DOC_FILE_SIZE));
        }
        if (liteFaxDoc.has(KEY_FAX_DOC_PDF_FILEPATH)) {
            values.put(KEY_FAX_DOC_PDF_FILEPATH, liteFaxDoc.getString(KEY_FAX_DOC_PDF_FILEPATH));
        }
        if (liteFaxDoc.has(KEY_FAX_DOC_PDF_FILE_SIZE)) {
            values.put(KEY_FAX_DOC_PDF_FILE_SIZE, liteFaxDoc.getLong(KEY_FAX_DOC_PDF_FILE_SIZE));
        }
        values.put(KEY_FAX_DOC_CREATETIME, liteFaxDoc.getLong("createTime"));
        values.put(KEY_FAX_DOC_LASTUPDATETIME, liteFaxDoc.getLong("lastUpdateTime"));
        if (liteFaxDoc.has(KEY_FAX_DOC_STATUS)) {
            values.put(KEY_FAX_DOC_STATUS, liteFaxDoc.getInt(KEY_FAX_DOC_STATUS));
        }
        values.put(KEY_FAX_DOC_SITE_ID, liteFaxDoc.getLong(KEY_FAX_DOC_SITE_ID));
        values.put(KEY_FAX_DOC_READ_FLAG, liteFaxDoc.getBoolean(KEY_FAX_DOC_READ_FLAG) ? 1 : 0);
        if (liteFaxDoc.has(KEY_FAX_DOC_ORIGINAL_DOWNLOAD_PATH)) {
            values.put(KEY_FAX_DOC_ORIGINAL_DOWNLOAD_PATH, liteFaxDoc.getString(KEY_FAX_DOC_ORIGINAL_DOWNLOAD_PATH));
        }
        if (liteFaxDoc.has(KEY_FAX_DOC_ORIGINAL_FILE_NAME)) {
            values.put(KEY_FAX_DOC_ORIGINAL_FILE_NAME, liteFaxDoc.getString(KEY_FAX_DOC_ORIGINAL_FILE_NAME));
        }
        if (liteFaxDoc.has(KEY_FAX_DOC_ORIGINAL_FILE_SIZE)) {
            values.put(KEY_FAX_DOC_ORIGINAL_FILE_SIZE, liteFaxDoc.getLong(KEY_FAX_DOC_ORIGINAL_FILE_SIZE));
        }
        if (liteFaxDoc.has(KEY_FAX_DOC_ORIGINAL_ENCODING_TYPE)) {
            values.put(KEY_FAX_DOC_ORIGINAL_ENCODING_TYPE, liteFaxDoc.getString(KEY_FAX_DOC_ORIGINAL_ENCODING_TYPE));
        }
        if (liteFaxDoc.has(KEY_FAX_DOC_ERROR_CODE)) {
            values.put(KEY_FAX_DOC_ERROR_CODE, liteFaxDoc.getInt(KEY_FAX_DOC_ERROR_CODE));
        }
        if (liteFaxDoc.has(KEY_FAX_DOC_ORIGINAL_FAX_PAGES)) {
            values.put(KEY_FAX_DOC_ORIGINAL_FAX_PAGES, liteFaxDoc.getInt(KEY_FAX_DOC_ORIGINAL_FAX_PAGES));
        }
        if (liteFaxDoc.has(KEY_FAX_DOC_ORIGINAL_FAX_ERROR_DESCR)) {
            values.put(KEY_FAX_DOC_ORIGINAL_FAX_ERROR_DESCR, liteFaxDoc.getString(KEY_FAX_DOC_ORIGINAL_FAX_ERROR_DESCR));
        }
        if (liteFaxDoc.has(KEY_FAX_DOC_ORIGINAL_FAX_TIMESPENT)) {
            values.put(KEY_FAX_DOC_ORIGINAL_FAX_TIMESPENT, liteFaxDoc.getLong(KEY_FAX_DOC_ORIGINAL_FAX_TIMESPENT));
        }
        if (liteFaxDoc.has(KEY_FAX_DOC_ORIGINAL_FAX_RETRY_COUNT)) {
            values.put(KEY_FAX_DOC_ORIGINAL_FAX_RETRY_COUNT, liteFaxDoc.getInt(KEY_FAX_DOC_ORIGINAL_FAX_RETRY_COUNT));
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int lastFaxInUnread(Context ctx) {
        UCDBHelper helper;
        UCDBFaxDoc._log(UCDBFaxDoc.class.getSimpleName(), "lastFaxInUnread....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            int n;
            SQLiteDatabase db = null;
            try {
                db = helper.getReadableDatabase();
                Long count = db.queryNumEntries(TABLE_FAX_DOC, "direction=? AND readFlag =?", new String[]{"0", "0"});
                n = count.intValue();
            }
            catch (Throwable throwable) {
                UCDBFaxDoc.closeDb(db);
                throw throwable;
            }
            UCDBFaxDoc.closeDb(db);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteFaxDoc getLastFaxDoc(Context ctx) {
        UCDBHelper helper;
        UCDBFaxDoc._log(UCDBFaxDoc.class.getSimpleName(), "getLastFaxDoc....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                LiteFaxDoc liteFaxDoc;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_FAX_DOC, selectColumns, null, null, null, null, "createTimestamp DESC", "1");
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    LiteFaxDoc liteLiteFaxDoc = new LiteFaxDoc();
                    UCDBFaxDoc.setFaxDocValue(cursor, liteLiteFaxDoc);
                    liteFaxDoc = liteLiteFaxDoc;
                }
                catch (Throwable throwable) {
                    UCDBFaxDoc.closeCursor(cursor);
                    UCDBFaxDoc.closeDb(db);
                    throw throwable;
                }
                UCDBFaxDoc.closeCursor(cursor);
                UCDBFaxDoc.closeDb(db);
                return liteFaxDoc;
            }
            LiteFaxDoc liteFaxDoc = null;
            UCDBFaxDoc.closeCursor(cursor);
            UCDBFaxDoc.closeDb(db);
            return liteFaxDoc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteFaxDoc getFaxDoc(Context ctx, long faxDocId) {
        UCDBHelper helper;
        UCDBFaxDoc._log(UCDBFaxDoc.class.getSimpleName(), "getFaxDoc....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                LiteFaxDoc liteFaxDoc;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_FAX_DOC, selectColumns, "id=?", new String[]{String.valueOf(faxDocId)}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    LiteFaxDoc liteLiteFaxDoc = new LiteFaxDoc();
                    UCDBFaxDoc.setFaxDocValue(cursor, liteLiteFaxDoc);
                    liteFaxDoc = liteLiteFaxDoc;
                }
                catch (Throwable throwable) {
                    UCDBFaxDoc.closeCursor(cursor);
                    UCDBFaxDoc.closeDb(db);
                    throw throwable;
                }
                UCDBFaxDoc.closeCursor(cursor);
                UCDBFaxDoc.closeDb(db);
                return liteFaxDoc;
            }
            LiteFaxDoc liteFaxDoc = null;
            UCDBFaxDoc.closeCursor(cursor);
            UCDBFaxDoc.closeDb(db);
            return liteFaxDoc;
        }
    }

    private static void setFaxDocValue(Cursor cursor, LiteFaxDoc liteLiteFaxDoc) {
        liteLiteFaxDoc.setId(cursor.getLong(0));
        liteLiteFaxDoc.setDirection(cursor.getInt(1));
        liteLiteFaxDoc.setPhoneNumber(cursor.getString(2));
        liteLiteFaxDoc.setFilePath(cursor.getString(3));
        liteLiteFaxDoc.setFileSize(cursor.getLong(4));
        liteLiteFaxDoc.setPdfFilePath(cursor.getString(5));
        liteLiteFaxDoc.setPdfFileSize(cursor.getLong(6));
        liteLiteFaxDoc.setCreateTime(cursor.getLong(7));
        liteLiteFaxDoc.setLastUpdateTime(cursor.getLong(8));
        liteLiteFaxDoc.setStatus(cursor.getInt(9));
        liteLiteFaxDoc.setErrorCode(cursor.getInt(10));
        liteLiteFaxDoc.setSiteId(cursor.getLong(11));
        liteLiteFaxDoc.setReadFlag(cursor.getInt(12) != 0);
        liteLiteFaxDoc.setOriginalDownloadPath(cursor.getString(13));
        liteLiteFaxDoc.setOriginalFileName(cursor.getString(14));
        liteLiteFaxDoc.setOriginalFileSize(cursor.getLong(15));
        liteLiteFaxDoc.setEncodingType(cursor.getString(16));
        liteLiteFaxDoc.setFaxPages(cursor.getInt(17));
        liteLiteFaxDoc.setFaxErrorDescr(cursor.getString(18));
        liteLiteFaxDoc.setFaxTimeSpent(cursor.getLong(19));
        liteLiteFaxDoc.setFaxRetryCount(cursor.getInt(20));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LiteFaxDoc> findFaxDocList(Context context, int option, String number, Date startTime, Date endTime, int pageIndex, int pageSize) {
        UCDBHelper helper;
        ArrayList<LiteFaxDoc> docList = new ArrayList<LiteFaxDoc>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        int ii = 0;
        for (String key : selectColumns) {
            if (ii != 0) {
                sql.append(",");
            }
            sql.append(key);
            ++ii;
        }
        sql.append(" FROM ");
        sql.append(TABLE_FAX_DOC);
        sql.append(" WHERE ");
        UCDBFaxDoc.applyOption(option, sql);
        ArrayList<Object> selectList = new ArrayList<Object>();
        if (startTime != null) {
            sql.append(" AND createTimestamp >= ? ");
            selectList.add(String.valueOf(startTime.getTime()));
        }
        if (endTime != null) {
            sql.append(" AND createTimestamp <= ? ");
            selectList.add(String.valueOf(endTime.getTime()));
        }
        if (TextUtils.isNotBlank((CharSequence)number)) {
            sql.append(" AND phoneNumber like ? ");
            selectList.add("%" + number.trim() + "%");
        }
        sql.append(" ORDER BY createTimestamp DESC");
        sql.append(" OFFSET " + pageSize * (pageIndex - 1));
        sql.append(" LIMIT " + pageSize);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(context);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.rawQuery(sql.toString(), selectList.toArray(new String[selectList.size()]));
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        LiteFaxDoc faxDoc = new LiteFaxDoc();
                        UCDBFaxDoc.setFaxDocValue(cursor, faxDoc);
                        docList.add(faxDoc);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBFaxDoc.closeCursor(cursor);
                UCDBFaxDoc.closeDb(db);
                throw throwable;
            }
            UCDBFaxDoc.closeCursor(cursor);
            UCDBFaxDoc.closeDb(db);
        }
        return docList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int countFaxDocList(Context ctx, int option, String number, Date startTime, Date endTime) {
        UCDBHelper helper;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT count(*) ");
        sql.append(" FROM ");
        sql.append(TABLE_FAX_DOC);
        sql.append(" WHERE ");
        UCDBFaxDoc.applyOption(option, sql);
        ArrayList<Object> selectList = new ArrayList<Object>();
        if (startTime != null) {
            sql.append(" AND createTimestamp >= ? ");
            selectList.add(String.valueOf(startTime.getTime()));
        }
        if (endTime != null) {
            sql.append(" AND createTimestamp <= ? ");
            selectList.add(String.valueOf(endTime.getTime()));
        }
        if (TextUtils.isNotBlank((CharSequence)number)) {
            sql.append(" AND phoneNumber like ? ");
            selectList.add("%" + number.trim() + "%");
        }
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block7: {
                int n;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.rawQuery(sql.toString(), selectList.toArray(new String[selectList.size()]));
                    if (cursor == null || !cursor.moveToFirst()) break block7;
                    n = cursor.getInt(0);
                }
                catch (Throwable throwable) {
                    UCDBFaxDoc.closeCursor(cursor);
                    UCDBFaxDoc.closeDb(db);
                    throw throwable;
                }
                UCDBFaxDoc.closeCursor(cursor);
                UCDBFaxDoc.closeDb(db);
                return n;
            }
            UCDBFaxDoc.closeCursor(cursor);
            UCDBFaxDoc.closeDb(db);
            return 0;
        }
    }

    private static void applyOption(int option, StringBuilder sql) {
        if (option == 11) {
            sql.append("direction = 0 ");
        } else if (option == 12) {
            sql.append("direction = 0 AND readFlag = 0 ");
        } else if (option == 21) {
            sql.append("direction = 1 ");
        } else if (option == 22) {
            sql.append("direction = 1 AND status IN (0,1,2,4,7) ");
        } else if (option == 23) {
            sql.append("direction = 1 AND status IN (3,5) ");
        } else if (option == 24) {
            sql.append("direction = 1 AND status = 8 ");
        } else if (option == 25) {
            sql.append("direction = 1 AND status = 6 ");
        } else {
            sql.append("direction IN (0,1) ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllFaxes(Context ctx) {
        UCDBHelper helper;
        UCDBFaxDoc._log(UCDBFaxDoc.class.getSimpleName(), "deleteAllFaxes....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_FAX_DOC, null, null);
            }
            finally {
                UCDBFaxDoc.closeDb(db);
            }
        }
    }
}

