/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteContactGroup;
import com.blisscloud.ezuc.bean.LiteContactType;
import com.blisscloud.ezuc.bean.LiteGroupMember;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.LiteMyGroup;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.DatabaseUtils;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.db.ChatDataHelper;
import com.blisscloud.mobile.ezuc.db.ContactDataHelper;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UCDBGroup
extends UCDBBase {
    public static final String TABLE_GROUP = "ChatGroup";
    public static final String TABLE_GROUP_CONTACT = "ChatGroupContact";

    public static void createGroupTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS ChatGroup");
        String CREATE_GROUP_TABLE = "CREATE TABLE ChatGroup(id INTEGER PRIMARY KEY IDENTITY,name LONGVARCHAR)";
        db.execSQL(CREATE_GROUP_TABLE);
    }

    public static void createGroupContactTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS ChatGroupContact");
        String CREATE_GROUP_CONTACT_TABLE = "CREATE TABLE ChatGroupContact(groupId NUMERIC,id LONGVARCHAR , type NUMERIC)";
        db.execSQL(CREATE_GROUP_CONTACT_TABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findGroupNameById(Context ctx, long groupId) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "findGroupNameById....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            String string;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                String[] selectionArgs = new String[]{String.valueOf(groupId)};
                String name = null;
                cursor = db.query(TABLE_GROUP, new String[]{"name"}, "id=?", selectionArgs, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    name = cursor.getString(0);
                }
                string = name;
            }
            catch (Throwable throwable) {
                UCDBGroup.closeCursor(cursor);
                UCDBGroup.closeDb(db);
                throw throwable;
            }
            UCDBGroup.closeCursor(cursor);
            UCDBGroup.closeDb(db);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long findGroupIdByName(Context ctx, String groupName) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "findGroupIdByName....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            long l;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                String[] selectionArgs = new String[]{groupName};
                long id = -1L;
                cursor = db.query(TABLE_GROUP, new String[]{"id"}, "name=?", selectionArgs, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    id = cursor.getLong(0);
                }
                l = id;
            }
            catch (Throwable throwable) {
                UCDBGroup.closeCursor(cursor);
                UCDBGroup.closeDb(db);
                throw throwable;
            }
            UCDBGroup.closeCursor(cursor);
            UCDBGroup.closeDb(db);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> findGroupJidsByName(Context ctx, String groupName) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "findGroupJidsByName....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            HashSet<String> hashSet;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                HashSet<String> set = new HashSet<String>();
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT C.");
                sql.append("jid");
                sql.append(" From ");
                sql.append(TABLE_GROUP_CONTACT);
                sql.append(" A ,");
                sql.append(TABLE_GROUP);
                sql.append(" B ,");
                sql.append("Contact");
                sql.append(" C WHERE B.");
                sql.append("name");
                sql.append("=? AND B.");
                sql.append("id");
                sql.append("= A.");
                sql.append("groupId");
                sql.append(" AND C.");
                sql.append("empId");
                sql.append(" =A.");
                sql.append("id");
                sql.append(" AND C.");
                sql.append("empId");
                sql.append(" != 0");
                cursor = db.rawQuery(sql.toString(), new String[]{groupName});
                if (cursor.moveToFirst()) {
                    do {
                        set.add(cursor.getString(0));
                    } while (cursor.moveToNext());
                }
                hashSet = set;
            }
            catch (Throwable throwable) {
                UCDBGroup.closeCursor(cursor);
                UCDBGroup.closeDb(db);
                throw throwable;
            }
            UCDBGroup.closeCursor(cursor);
            UCDBGroup.closeDb(db);
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> findMyFavoriteGroup(Context ctx, String searchKey, boolean hasExternalContact, boolean hasChatRoom) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "findFavoriteGroup....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<Object> arrayList;
            SQLiteDatabase db = null;
            Cursor cursorContact = null;
            Cursor cursorMyContact = null;
            Cursor cursorChatRoom = null;
            try {
                Object contact;
                String searchKeyUpper;
                db = helper.getReadableDatabase();
                ArrayList<Object> data = new ArrayList<Object>();
                boolean hasSearchKeyWord = TextUtils.isNotBlank((CharSequence)searchKey);
                String[] selectionArgs = null;
                StringBuilder contactSql = new StringBuilder();
                StringBuilder mycontactSql = new StringBuilder();
                StringBuilder chatroomSql = new StringBuilder();
                contactSql.append("Select ");
                UCDBGroup.setSelectionCloumns(contactSql, ContactDataHelper.contactSelectColumns, "B.");
                contactSql.append(" From ");
                contactSql.append(TABLE_GROUP_CONTACT);
                contactSql.append(" A, ");
                contactSql.append("Contact");
                contactSql.append(" B, ");
                contactSql.append(TABLE_GROUP);
                contactSql.append(" C Where A.");
                contactSql.append("type");
                contactSql.append("=");
                contactSql.append(1);
                contactSql.append(" AND C.");
                contactSql.append("name");
                contactSql.append("='");
                contactSql.append("My favorites");
                contactSql.append("' AND A.");
                contactSql.append("groupId");
                contactSql.append("=C.");
                contactSql.append("id");
                contactSql.append(" AND B.");
                contactSql.append("empId");
                contactSql.append("=A.");
                contactSql.append("id");
                contactSql.append(" AND B.");
                contactSql.append("empId");
                contactSql.append("!= 0");
                contactSql.append(" AND B.");
                contactSql.append("abscope");
                contactSql.append("= 1");
                Locale locale = I18NUtil.getAppLocale();
                if (hasSearchKeyWord) {
                    searchKeyUpper = searchKey.toUpperCase();
                    contactSql.append(" AND (");
                    if (Locale.TAIWAN.equals(locale)) {
                        contactSql.append("UPPER(B.");
                        contactSql.append("dispName");
                        contactSql.append(") LIKE ?");
                        contactSql.append(" OR UPPER(B.");
                        contactSql.append("deptForSearch");
                        contactSql.append(") LIKE ?");
                        contactSql.append(" OR UPPER(B.");
                        contactSql.append("extForSearch");
                        contactSql.append(") LIKE ?");
                        selectionArgs = new String[]{"%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                    } else {
                        contactSql.append("UPPER(B.");
                        contactSql.append("dispName");
                        contactSql.append(") LIKE ?");
                        contactSql.append(" OR UPPER(B.");
                        contactSql.append("dispNameForPinYin");
                        contactSql.append(") LIKE ?");
                        contactSql.append(" OR UPPER(B.");
                        contactSql.append("deptForSearch");
                        contactSql.append(") LIKE ?");
                        contactSql.append(" OR UPPER(B.");
                        contactSql.append("extForSearch");
                        contactSql.append(") LIKE ?");
                        selectionArgs = new String[]{"%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                    }
                    contactSql.append(")");
                }
                if (!Locale.TAIWAN.equals(locale)) {
                    contactSql.append(" ORDER BY UPPER(B.dispNameForPinYin) asc");
                } else {
                    contactSql.append(" ORDER BY UPPER(B.dispName) asc");
                }
                cursorContact = db.rawQuery(contactSql.toString(), selectionArgs);
                if (cursorContact.moveToFirst()) {
                    do {
                        contact = new LiteContact();
                        ContactDataHelper.setContactValue(cursorContact, (LiteContact)contact);
                        data.add(contact);
                    } while (cursorContact.moveToNext());
                }
                if (hasExternalContact) {
                    mycontactSql.append("Select ");
                    UCDBGroup.setSelectionCloumns(mycontactSql, ContactDataHelper.externalContactSelectColumns, "B.");
                    mycontactSql.append(" From ");
                    mycontactSql.append(TABLE_GROUP_CONTACT);
                    mycontactSql.append(" A, ");
                    mycontactSql.append("ExternalContact");
                    mycontactSql.append(" B, ");
                    mycontactSql.append(TABLE_GROUP);
                    mycontactSql.append(" C Where A.");
                    mycontactSql.append("type");
                    mycontactSql.append("=");
                    mycontactSql.append(2);
                    mycontactSql.append(" AND C.");
                    mycontactSql.append("name");
                    mycontactSql.append("='");
                    mycontactSql.append("My favorites");
                    mycontactSql.append("' AND A.");
                    mycontactSql.append("groupId");
                    mycontactSql.append("=C.");
                    mycontactSql.append("id");
                    mycontactSql.append(" AND B.");
                    mycontactSql.append("id");
                    mycontactSql.append("=A.");
                    mycontactSql.append("id");
                    if (hasSearchKeyWord) {
                        searchKeyUpper = searchKey.toUpperCase();
                        mycontactSql.append(" AND (");
                        if (Locale.TAIWAN.equals(locale)) {
                            mycontactSql.append("UPPER(B.");
                            mycontactSql.append("name");
                            mycontactSql.append(") LIKE ?");
                            mycontactSql.append(" OR UPPER(B.");
                            mycontactSql.append("comapnytel");
                            mycontactSql.append(") LIKE ?");
                            mycontactSql.append(" OR UPPER(B.");
                            mycontactSql.append("organization");
                            mycontactSql.append(") LIKE ?");
                            selectionArgs = new String[]{"%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                        } else {
                            mycontactSql.append("UPPER(B.");
                            mycontactSql.append("name");
                            mycontactSql.append(") LIKE ?");
                            mycontactSql.append(" OR UPPER(B.");
                            mycontactSql.append("nameForPinYin");
                            mycontactSql.append(") LIKE ?");
                            mycontactSql.append(" OR UPPER(B.");
                            mycontactSql.append("comapnytel");
                            mycontactSql.append(") LIKE ?");
                            mycontactSql.append(" OR UPPER(B.");
                            mycontactSql.append("organization");
                            mycontactSql.append(") LIKE ?");
                            selectionArgs = new String[]{"%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                        }
                        mycontactSql.append(")");
                    }
                    if (!Locale.TAIWAN.equals(locale)) {
                        mycontactSql.append(" ORDER BY UPPER(B.nameForPinYin) asc");
                    } else {
                        mycontactSql.append(" ORDER BY UPPER(B.name) asc");
                    }
                    cursorMyContact = db.rawQuery(mycontactSql.toString(), selectionArgs);
                    if (cursorMyContact.moveToFirst()) {
                        do {
                            contact = new LiteMyContact();
                            ContactDataHelper.setContactValue(cursorMyContact, (LiteMyContact)contact);
                            data.add(contact);
                        } while (cursorMyContact.moveToNext());
                    }
                }
                if (hasChatRoom) {
                    if (hasSearchKeyWord) {
                        searchKeyUpper = searchKey.toUpperCase();
                        selectionArgs = new String[]{"%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                    }
                    String meetmePrefix = OutboundPrefixManager.getMeetmePrefix(ctx);
                    chatroomSql.append("Select ");
                    UCDBGroup.setSelectionCloumns(chatroomSql, ChatDataHelper.chatRoomSelectColumns, "B.");
                    chatroomSql.append(" From ");
                    chatroomSql.append(TABLE_GROUP_CONTACT);
                    chatroomSql.append(" A, ");
                    chatroomSql.append("ChatRoom");
                    chatroomSql.append(" B, ");
                    chatroomSql.append(TABLE_GROUP);
                    chatroomSql.append(" C, ");
                    chatroomSql.append("ConferenceRoom");
                    chatroomSql.append(" D");
                    chatroomSql.append(" Where A.");
                    chatroomSql.append("type");
                    chatroomSql.append("=");
                    chatroomSql.append(3);
                    chatroomSql.append(" And B.");
                    chatroomSql.append("chatRoomId");
                    chatroomSql.append("=A.");
                    chatroomSql.append("id");
                    chatroomSql.append(" And C.");
                    chatroomSql.append("name");
                    chatroomSql.append("='");
                    chatroomSql.append("My favorites");
                    chatroomSql.append("' AND A.");
                    chatroomSql.append("groupId");
                    chatroomSql.append("=C.");
                    chatroomSql.append("id");
                    chatroomSql.append(" AND B.");
                    chatroomSql.append("chatRoomId");
                    chatroomSql.append("=D.");
                    chatroomSql.append("chatRoomId");
                    if (hasSearchKeyWord) {
                        chatroomSql.append(" And ('" + meetmePrefix + "' || D.");
                        chatroomSql.append("roomNo");
                        chatroomSql.append(") LIKE ?");
                    }
                    chatroomSql.append(" UNION ");
                    chatroomSql.append("Select ");
                    UCDBGroup.setSelectionCloumns(chatroomSql, ChatDataHelper.chatRoomSelectColumns, "B.");
                    chatroomSql.append(" From ");
                    chatroomSql.append(TABLE_GROUP_CONTACT);
                    chatroomSql.append(" A, ");
                    chatroomSql.append("ChatRoom");
                    chatroomSql.append(" B, ");
                    chatroomSql.append(TABLE_GROUP);
                    chatroomSql.append(" C Where A.");
                    chatroomSql.append("type");
                    chatroomSql.append("=");
                    chatroomSql.append(3);
                    chatroomSql.append(" And B.");
                    chatroomSql.append("chatRoomId");
                    chatroomSql.append("=A.");
                    chatroomSql.append("id");
                    chatroomSql.append(" And C.");
                    chatroomSql.append("name");
                    chatroomSql.append("='");
                    chatroomSql.append("My favorites");
                    chatroomSql.append("' AND A.");
                    chatroomSql.append("groupId");
                    chatroomSql.append(" = C.");
                    chatroomSql.append("id");
                    if (hasSearchKeyWord) {
                        chatroomSql.append(" And UPPER(");
                        chatroomSql.append("subject");
                        chatroomSql.append(") LIKE ?");
                    }
                    chatroomSql.append(" UNION ");
                    chatroomSql.append("Select ");
                    UCDBGroup.setSelectionCloumns(chatroomSql, ChatDataHelper.chatRoomSelectColumns, "D.");
                    chatroomSql.append(" From ");
                    chatroomSql.append(TABLE_GROUP_CONTACT);
                    chatroomSql.append(" A, ");
                    chatroomSql.append("ChatRoomParticipant");
                    chatroomSql.append(" B, ");
                    chatroomSql.append("Contact");
                    chatroomSql.append(" C, ");
                    chatroomSql.append("ChatRoom");
                    chatroomSql.append(" D, ");
                    chatroomSql.append(TABLE_GROUP);
                    chatroomSql.append(" E Where A.");
                    chatroomSql.append("type");
                    chatroomSql.append("=");
                    chatroomSql.append(3);
                    chatroomSql.append(" AND A.");
                    chatroomSql.append("id");
                    chatroomSql.append("=B.");
                    chatroomSql.append("chatRoomId");
                    chatroomSql.append(" AND D.");
                    chatroomSql.append("chatRoomId");
                    chatroomSql.append("=B.");
                    chatroomSql.append("chatRoomId");
                    chatroomSql.append(" AND C.");
                    chatroomSql.append("jid");
                    chatroomSql.append("=B.");
                    chatroomSql.append("jid");
                    chatroomSql.append(" And E.");
                    chatroomSql.append("name");
                    chatroomSql.append("='");
                    chatroomSql.append("My favorites");
                    chatroomSql.append("' AND A.");
                    chatroomSql.append("groupId");
                    chatroomSql.append(" = E.");
                    chatroomSql.append("id");
                    if (hasSearchKeyWord) {
                        chatroomSql.append(" AND (");
                        chatroomSql.append("UPPER(C.");
                        chatroomSql.append("dispName");
                        chatroomSql.append(") LIKE ?");
                        chatroomSql.append(" OR UPPER(C.");
                        chatroomSql.append("deptForSearch");
                        chatroomSql.append(") LIKE ?");
                        chatroomSql.append(" OR UPPER(C.");
                        chatroomSql.append("extForSearch");
                        chatroomSql.append(") LIKE ?");
                        chatroomSql.append(")");
                    }
                    if ((cursorChatRoom = db.rawQuery(chatroomSql.toString(), selectionArgs)).moveToFirst()) {
                        do {
                            ChatRoomInfo chatRoom = new ChatRoomInfo();
                            ChatDataHelper.setChatRoomValue(cursorChatRoom, chatRoom);
                            data.add(chatRoom);
                        } while (cursorChatRoom.moveToNext());
                    }
                }
                arrayList = data;
            }
            catch (Throwable throwable) {
                UCDBGroup.closeCursor(cursorContact);
                UCDBGroup.closeCursor(cursorMyContact);
                UCDBGroup.closeCursor(cursorChatRoom);
                UCDBGroup.closeDb(db);
                throw throwable;
            }
            UCDBGroup.closeCursor(cursorContact);
            UCDBGroup.closeCursor(cursorMyContact);
            UCDBGroup.closeCursor(cursorChatRoom);
            UCDBGroup.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> findMyChatRoomGroup(Context ctx, String searchKey) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "findMyChatRoomGroup....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<Object> arrayList;
            SQLiteDatabase db = null;
            Cursor cursorChatRoom = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<Object> data = new ArrayList<Object>();
                boolean hasSearchKeyWord = TextUtils.isNotBlank((CharSequence)searchKey);
                String[] selectionArgs = null;
                StringBuilder chatroomSql = new StringBuilder();
                if (hasSearchKeyWord) {
                    String searchKeyUpper = searchKey.toUpperCase();
                    selectionArgs = new String[]{"%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                }
                String meetmePrefix = OutboundPrefixManager.getMeetmePrefix(ctx);
                chatroomSql.append("Select ");
                UCDBGroup.setSelectionCloumns(chatroomSql, ChatDataHelper.chatRoomSelectColumns, "B.");
                chatroomSql.append(" From ");
                chatroomSql.append(TABLE_GROUP_CONTACT);
                chatroomSql.append(" A, ");
                chatroomSql.append("ChatRoom");
                chatroomSql.append(" B, ");
                chatroomSql.append(TABLE_GROUP);
                chatroomSql.append(" C, ");
                chatroomSql.append("ConferenceRoom");
                chatroomSql.append(" D");
                chatroomSql.append(" Where A.");
                chatroomSql.append("type");
                chatroomSql.append("=");
                chatroomSql.append(3);
                chatroomSql.append(" And B.");
                chatroomSql.append("chatRoomId");
                chatroomSql.append("=A.");
                chatroomSql.append("id");
                chatroomSql.append(" And C.");
                chatroomSql.append("name");
                chatroomSql.append("='");
                chatroomSql.append("My chat rooms");
                chatroomSql.append("' AND A.");
                chatroomSql.append("groupId");
                chatroomSql.append("=C.");
                chatroomSql.append("id");
                chatroomSql.append(" AND B.");
                chatroomSql.append("chatRoomId");
                chatroomSql.append("=D.");
                chatroomSql.append("chatRoomId");
                if (hasSearchKeyWord) {
                    chatroomSql.append(" And ('" + meetmePrefix + "' || D.");
                    chatroomSql.append("roomNo");
                    chatroomSql.append(") LIKE ?");
                }
                chatroomSql.append(" UNION ");
                chatroomSql.append("Select ");
                UCDBGroup.setSelectionCloumns(chatroomSql, ChatDataHelper.chatRoomSelectColumns, "B.");
                chatroomSql.append(" From ");
                chatroomSql.append(TABLE_GROUP_CONTACT);
                chatroomSql.append(" A, ");
                chatroomSql.append("ChatRoom");
                chatroomSql.append(" B, ");
                chatroomSql.append(TABLE_GROUP);
                chatroomSql.append(" C Where A.");
                chatroomSql.append("type");
                chatroomSql.append("=");
                chatroomSql.append(3);
                chatroomSql.append(" And B.");
                chatroomSql.append("chatRoomId");
                chatroomSql.append("=A.");
                chatroomSql.append("id");
                chatroomSql.append(" And C.");
                chatroomSql.append("name");
                chatroomSql.append("='");
                chatroomSql.append("My chat rooms");
                chatroomSql.append("' AND A.");
                chatroomSql.append("groupId");
                chatroomSql.append(" = C.");
                chatroomSql.append("id");
                if (hasSearchKeyWord) {
                    chatroomSql.append(" And UPPER(");
                    chatroomSql.append("subject");
                    chatroomSql.append(") LIKE ?");
                }
                chatroomSql.append(" UNION ");
                chatroomSql.append("Select ");
                UCDBGroup.setSelectionCloumns(chatroomSql, ChatDataHelper.chatRoomSelectColumns, "D.");
                chatroomSql.append(" From ");
                chatroomSql.append(TABLE_GROUP_CONTACT);
                chatroomSql.append(" A, ");
                chatroomSql.append("ChatRoomParticipant");
                chatroomSql.append(" B, ");
                chatroomSql.append("Contact");
                chatroomSql.append(" C, ");
                chatroomSql.append("ChatRoom");
                chatroomSql.append(" D, ");
                chatroomSql.append(TABLE_GROUP);
                chatroomSql.append(" E Where A.");
                chatroomSql.append("type");
                chatroomSql.append("=");
                chatroomSql.append(3);
                chatroomSql.append(" AND A.");
                chatroomSql.append("id");
                chatroomSql.append("=B.");
                chatroomSql.append("chatRoomId");
                chatroomSql.append(" AND D.");
                chatroomSql.append("chatRoomId");
                chatroomSql.append("=B.");
                chatroomSql.append("chatRoomId");
                chatroomSql.append(" AND C.");
                chatroomSql.append("jid");
                chatroomSql.append("=B.");
                chatroomSql.append("jid");
                chatroomSql.append(" And E.");
                chatroomSql.append("name");
                chatroomSql.append("='");
                chatroomSql.append("My chat rooms");
                chatroomSql.append("' AND A.");
                chatroomSql.append("groupId");
                chatroomSql.append(" = E.");
                chatroomSql.append("id");
                if (hasSearchKeyWord) {
                    chatroomSql.append(" AND (");
                    chatroomSql.append("UPPER(C.");
                    chatroomSql.append("dispName");
                    chatroomSql.append(") LIKE ?");
                    chatroomSql.append(" OR UPPER(C.");
                    chatroomSql.append("deptForSearch");
                    chatroomSql.append(") LIKE ?");
                    chatroomSql.append(" OR UPPER(C.");
                    chatroomSql.append("extForSearch");
                    chatroomSql.append(") LIKE ?");
                    chatroomSql.append(")");
                }
                if ((cursorChatRoom = db.rawQuery(chatroomSql.toString(), selectionArgs)).moveToFirst()) {
                    do {
                        ChatRoomInfo chatRoom = new ChatRoomInfo();
                        ChatDataHelper.setChatRoomValue(cursorChatRoom, chatRoom);
                        data.add(chatRoom);
                    } while (cursorChatRoom.moveToNext());
                }
                arrayList = data;
            }
            catch (Throwable throwable) {
                UCDBGroup.closeCursor(cursorChatRoom);
                UCDBGroup.closeDb(db);
                throw throwable;
            }
            UCDBGroup.closeCursor(cursorChatRoom);
            UCDBGroup.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> findMyGroup(Context ctx, String searchKey) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "findMyGroup....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<Object> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<Object> data = new ArrayList<Object>();
                boolean hasSearchKey = TextUtils.isNotBlank((CharSequence)searchKey);
                String[] selectionArgs = null;
                StringBuilder sql = new StringBuilder();
                sql.append("Select distinct A.");
                sql.append("name");
                sql.append(" From ");
                sql.append(TABLE_GROUP);
                sql.append(" A ,");
                sql.append(TABLE_GROUP_CONTACT);
                sql.append(" B ");
                if (hasSearchKey) {
                    sql.append(",  ");
                    sql.append("Contact");
                    sql.append(" C ");
                }
                sql.append(" Where B.");
                sql.append("type");
                sql.append("=");
                sql.append(1);
                sql.append(" And A.");
                sql.append("name");
                sql.append("!=?");
                sql.append(" And A.");
                sql.append("id");
                sql.append("=");
                sql.append("groupId");
                Locale locale = I18NUtil.getAppLocale();
                if (hasSearchKey) {
                    sql.append(" And B.");
                    sql.append("id");
                    sql.append("=");
                    sql.append("empId");
                    if (Locale.TAIWAN.equals(locale)) {
                        sql.append(" And UPPER(C.");
                        sql.append("dispName");
                        sql.append(") LIKE ?");
                    } else {
                        sql.append(" And (UPPER(C.");
                        sql.append("dispName");
                        sql.append(") LIKE ? OR UPPER(C.");
                        sql.append("dispNameForPinYin");
                        sql.append(") LIKE ?)");
                    }
                }
                if (hasSearchKey) {
                    String searchKeyUpper = searchKey.toUpperCase();
                    selectionArgs = Locale.TAIWAN.equals(locale) ? new String[]{"My favorites", "%" + searchKeyUpper + "%"} : new String[]{"My favorites", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                } else {
                    selectionArgs = new String[]{"My favorites"};
                }
                cursor = db.rawQuery(sql.toString(), selectionArgs);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        String groupName = cursor.getString(0);
                        data.add(groupName);
                    } while (cursor.moveToNext());
                }
                arrayList = data;
            }
            catch (Throwable throwable) {
                UCDBGroup.closeCursor(cursor);
                UCDBGroup.closeDb(db);
                throw throwable;
            }
            UCDBGroup.closeCursor(cursor);
            UCDBGroup.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateGroup(Context ctx, LiteMyGroup group) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "updateGroup...." + String.valueOf(group));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                String idStr = String.valueOf(group.getId());
                db.update(TABLE_GROUP, ContactDataHelper.createGroupUpdateValues(group), "id = ?", new String[]{idStr});
                db.delete(TABLE_GROUP_CONTACT, "groupId = ?", new String[]{idStr});
                List<LiteGroupMember> members = group.getMembers();
                if (members != null) {
                    int size = members.size();
                    for (int i = 0; i < size; ++i) {
                        LiteGroupMember member = members.get(i);
                        db.insert(TABLE_GROUP_CONTACT, null, ContactDataHelper.createGroupContactAddValues(group.getId(), member));
                    }
                }
            }
            finally {
                UCDBGroup.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGroup(Context ctx, LiteMyGroup group) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "addGroup...." + String.valueOf(group));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("name", group.getName());
                values.put("id", group.getId());
                db.insert(TABLE_GROUP, null, values);
                List<LiteGroupMember> members = group.getMembers();
                if (members != null) {
                    int size = members.size();
                    for (int i = 0; i < size; ++i) {
                        LiteGroupMember member = members.get(i);
                        db.insert(TABLE_GROUP_CONTACT, null, ContactDataHelper.createGroupContactAddValues(group.getId(), member));
                    }
                }
            }
            finally {
                UCDBGroup.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteGroup(Context ctx, LiteContactGroup group) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "deleteGroup...." + String.valueOf(group));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getWritableDatabase();
                Long groupId = null;
                cursor = db.query(TABLE_GROUP, new String[]{"id"}, "name=?", new String[]{group.getGroupName()}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    groupId = cursor.getLong(0);
                }
                if (groupId != null) {
                    db.delete(TABLE_GROUP_CONTACT, "groupId = ?", new String[]{String.valueOf(groupId)});
                    db.delete(TABLE_GROUP, "id = ?", new String[]{String.valueOf(groupId)});
                }
            }
            catch (Throwable throwable) {
                UCDBGroup.closeCursor(cursor);
                UCDBGroup.closeDb(db);
                throw throwable;
            }
            UCDBGroup.closeCursor(cursor);
            UCDBGroup.closeDb(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteGroups(Context ctx) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "deleteGroups....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_GROUP_CONTACT, null, null);
                db.delete(TABLE_GROUP, null, null);
            }
            finally {
                UCDBGroup.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> getJidListByGroupName(Context ctx, String groupName, int type) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "getJidListByGroupName...." + groupName);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<Long> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<Long> idList = new ArrayList<Long>();
                String query = "Select id from ChatGroup Where name=?";
                String[] selectionArgs = new String[]{groupName};
                long groupId = DatabaseUtils.longForQuery(db, query, selectionArgs);
                if (groupId > 0L && (cursor = db.query(TABLE_GROUP_CONTACT, new String[]{"id"}, "type=? and groupId=?", new String[]{String.valueOf(type), String.valueOf(groupId)}, null, null, null, null)) != null && cursor.moveToFirst()) {
                    do {
                        long id = cursor.getLong(0);
                        idList.add(id);
                    } while (cursor.moveToNext());
                }
                arrayList = idList;
            }
            catch (Throwable throwable) {
                UCDBGroup.closeCursor(cursor);
                UCDBGroup.closeDb(db);
                throw throwable;
            }
            UCDBGroup.closeCursor(cursor);
            UCDBGroup.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInGroupList(Context ctx, String groupName, int type, String id) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "isInGroupList....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                String[] selectionArgs = new String[]{groupName, id, String.valueOf(type)};
                String sql = "Select count(*) From ChatGroupContact A,ChatGroup B Where B.name=? And A.groupId=B.id And A.id=? And A.type=?";
                int count = 0;
                cursor = db.rawQuery(sql, selectionArgs);
                if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                    count = cursor.getInt(0);
                }
                bl = count > 0;
            }
            catch (Throwable throwable) {
                UCDBGroup.closeCursor(cursor);
                UCDBGroup.closeDb(db);
                throw throwable;
            }
            UCDBGroup.closeCursor(cursor);
            UCDBGroup.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGroupExist(Context ctx, String groupName) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "isGroupExist...." + groupName);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            try {
                db = helper.getReadableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_GROUP, "name=?", new String[]{groupName});
                bl = count > 0L;
            }
            catch (Throwable throwable) {
                UCDBGroup.closeDb(db);
                throw throwable;
            }
            UCDBGroup.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGroupExist(Context ctx, long id) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "isGroupExist...." + id);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            try {
                db = helper.getReadableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_GROUP, "id=?", new String[]{String.valueOf(id)});
                bl = count > 0L;
            }
            catch (Throwable throwable) {
                UCDBGroup.closeDb(db);
                throw throwable;
            }
            UCDBGroup.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteGroup(Context ctx, String groupIds) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "deleteGroup...." + groupIds);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                String[] ids;
                db = helper.getWritableDatabase();
                for (String idtemp : ids = groupIds.split(",")) {
                    db.delete(TABLE_GROUP, "id=?", new String[]{idtemp});
                    db.delete(TABLE_GROUP_CONTACT, "groupId=?", new String[]{idtemp});
                }
            }
            finally {
                UCDBGroup.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAddMemberList(Context ctx, String groupName, String id, int type) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "getAddMemberList...." + id);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            String string;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                String members = null;
                JSONArray array = new JSONArray();
                cursor = UCDBGroup.getMemberList(db, groupName);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        String idTemp = cursor.getString(1);
                        int typeTemp = cursor.getInt(2);
                        JSONObject object = UCDBGroup.getMemberObject(idTemp, typeTemp);
                        array.put(object);
                    } while (cursor.moveToNext());
                }
                JSONObject object = UCDBGroup.getMemberObject(id, type);
                array.put(object);
                string = members = array.toString();
            }
            catch (Throwable throwable) {
                UCDBGroup.closeCursor(cursor);
                UCDBGroup.closeDb(db);
                throw throwable;
            }
            UCDBGroup.closeCursor(cursor);
            UCDBGroup.closeDb(db);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAddMemberList(Context ctx, String groupName, List<String> ids, int type) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "getAddMemberList...." + String.valueOf(ids));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            String string;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                JSONObject object;
                db = helper.getReadableDatabase();
                String members = null;
                JSONArray array = new JSONArray();
                cursor = UCDBGroup.getMemberList(db, groupName);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        String idTemp = cursor.getString(1);
                        int typeTemp = cursor.getInt(2);
                        object = UCDBGroup.getMemberObject(idTemp, typeTemp);
                        array.put(object);
                    } while (cursor.moveToNext());
                }
                if (ids != null) {
                    for (String member : ids) {
                        object = UCDBGroup.getMemberObject(member, type);
                        array.put(object);
                    }
                }
                members = array.toString();
                string = members;
            }
            catch (Throwable throwable) {
                UCDBGroup.closeCursor(cursor);
                UCDBGroup.closeDb(db);
                throw throwable;
            }
            UCDBGroup.closeCursor(cursor);
            UCDBGroup.closeDb(db);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRemovedMemberList(Context ctx, String groupName, String id, int type) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "getRemovedMemberList...." + id);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            String string;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                String members = null;
                JSONArray array = new JSONArray();
                cursor = UCDBGroup.getMemberList(db, groupName);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        String idTemp = cursor.getString(1);
                        int typeTemp = cursor.getInt(2);
                        if (typeTemp == type && id.equals(idTemp)) continue;
                        JSONObject object = UCDBGroup.getMemberObject(idTemp, typeTemp);
                        array.put(object);
                    } while (cursor.moveToNext());
                }
                string = members = array.toString();
            }
            catch (Throwable throwable) {
                UCDBGroup.closeCursor(cursor);
                UCDBGroup.closeDb(db);
                throw throwable;
            }
            UCDBGroup.closeCursor(cursor);
            UCDBGroup.closeDb(db);
            return string;
        }
    }

    public static JSONObject getMemberObject(String idValue, int typeValue) {
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "getMemberObject....");
        JSONObject object = new JSONObject();
        try {
            object.put("memberId", idValue);
            String typeString = null;
            switch (typeValue) {
                case 1: {
                    typeString = LiteContactType.EMPLOYEE.name();
                    break;
                }
                case 2: {
                    typeString = LiteContactType.CONTACT.name();
                    break;
                }
                case 3: {
                    typeString = LiteContactType.CHATROOM.name();
                }
            }
            object.put("type", typeString);
        }
        catch (JSONException e) {
            Log.e(UCDBGroup.class.getSimpleName(), "getMemberObject", e);
        }
        return object;
    }

    public static Cursor getMemberList(SQLiteDatabase db, String groupName) {
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "getMemberList...." + groupName);
        String[] selectionArgs = new String[]{groupName};
        String sql = "Select A.groupId, A.id, A.type From ChatGroupContact A,ChatGroup B Where B.name=? And A.groupId=B.id";
        return db.rawQuery(sql, selectionArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> findGroupParticipants(Context ctx, String groupName) {
        UCDBHelper helper;
        UCDBGroup._log(UCDBGroup.class.getSimpleName(), "findGroupParticipants...." + groupName);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<String> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<String> participantList = new ArrayList<String>();
                StringBuilder sql = new StringBuilder();
                sql.append("Select distinct C.");
                sql.append("jid");
                sql.append(" From ");
                sql.append(TABLE_GROUP_CONTACT);
                sql.append(" A, ");
                sql.append(TABLE_GROUP);
                sql.append(" B, ");
                sql.append("Contact");
                sql.append(" C Where B.");
                sql.append("name");
                sql.append("=? And A.");
                sql.append("groupId");
                sql.append(" = B.");
                sql.append("id");
                sql.append(" And C.");
                sql.append("empId");
                sql.append(" = A.");
                sql.append("id");
                String[] selectionArgs = new String[]{groupName};
                cursor = db.rawQuery(sql.toString(), selectionArgs);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        participantList.add(cursor.getString(0));
                    } while (cursor.moveToNext());
                }
                arrayList = participantList;
            }
            catch (Throwable throwable) {
                UCDBGroup.closeCursor(cursor);
                UCDBGroup.closeDb(db);
                throw throwable;
            }
            UCDBGroup.closeCursor(cursor);
            UCDBGroup.closeDb(db);
            return arrayList;
        }
    }
}

