/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.CursorFactory;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.ezuc.client.util.simulate.sqlite.NullDatabaseImpl;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabaseImpl;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.db.ChatDataHelper;
import com.blisscloud.mobile.ezuc.db.ContactDataHelper;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBBulletin;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBConf;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.db.UCDBCustomer;
import com.blisscloud.mobile.ezuc.db.UCDBDeletedJidContact;
import com.blisscloud.mobile.ezuc.db.UCDBDept;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.db.UCDBFaxDoc;
import com.blisscloud.mobile.ezuc.db.UCDBGroup;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UCDBMessageChannel;
import com.blisscloud.mobile.ezuc.db.UCDBReaderLog;
import com.blisscloud.mobile.ezuc.db.UCDBRecording;
import com.blisscloud.mobile.ezuc.db.UCDBRemoteMark;
import com.blisscloud.mobile.ezuc.db.UCDBSite;
import com.blisscloud.mobile.ezuc.db.UCDBVoiceMsg;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.github.stuxuhai.jpinyin.PinyinFormat;
import com.github.stuxuhai.jpinyin.PinyinHelper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class UCDBHelper {
    public static final int DATABASE_VERSION = 167;
    public static final String DATABASE_NAME = "ucChatClient.db";
    public static final String DATABASE_URL = FileUtil.getDatabaseDir().toURI().getPath().toString() + "ucChatClient.db";
    public static final String TABLE_FREQUENT = "Frequent";
    public static final String TABLE_DELETED_CONTACT = "DeletedContact";
    public static final String TABLE_CONTACT_SUMMARY_DOC = "ContactSummary";
    private Context mCtx = null;
    SQLiteDatabase readableDB;
    SQLiteDatabase writableDB;
    private SQLiteDatabase nullDatabase = new NullDatabaseImpl();
    public static volatile UCDBHelper db;
    private static Object lock;

    public UCDBHelper(Context context, String name, CursorFactory factory, int version) {
        this.mCtx = context.getApplicationContext();
        this.createWritableDatabase();
        this.createReadableDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UCDBHelper getDB(Context context) {
        if (db == null) {
            Object object = lock;
            synchronized (object) {
                if (db == null) {
                    db = new UCDBHelper(context, DATABASE_NAME, null, 167);
                }
            }
        }
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDatabase(Context context) {
        if (db != null) {
            UCDBHelper uCDBHelper = db;
            synchronized (uCDBHelper) {
                if (UCDBHelper.db.readableDB != null) {
                    UCDBHelper.db.readableDB.closeDatabase();
                    UCDBHelper.db.readableDB = null;
                }
                if (UCDBHelper.db.writableDB != null) {
                    UCDBHelper.db.writableDB.closeDatabase();
                    UCDBHelper.db.writableDB = null;
                }
            }
            db = null;
        }
    }

    private void createReadableDatabase() {
        try {
            Properties prop = new Properties();
            prop.setProperty("shutdown", "true");
            prop.setProperty("readonly", "true");
            prop.setProperty("hsqldb.lock_file", "false");
            this.readableDB = new SQLiteDatabaseImpl(DATABASE_URL, prop, true);
        }
        catch (Exception e) {
            Log.e(UCDBHelper.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    private void createWritableDatabase() {
        try {
            Properties prop = new Properties();
            prop.setProperty("shutdown", "true");
            prop.setProperty("hsqldb.lock_file", "false");
            this.writableDB = new SQLiteDatabaseImpl(DATABASE_URL, prop, false);
        }
        catch (Exception e) {
            Log.e(UCDBHelper.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    public SQLiteDatabase getReadableDatabase() {
        if (this.readableDB != null) {
            return this.readableDB;
        }
        return this.nullDatabase;
    }

    public SQLiteDatabase getWritableDatabase() {
        if (this.writableDB != null) {
            this.writableDB.beginTransaction();
            return this.writableDB;
        }
        return this.nullDatabase;
    }

    public void onCreate(SQLiteDatabase db) {
        Log.i(UCDBHelper.class.getSimpleName(), "Create db ................. start ..... ");
        UCDBGroup.createGroupTable(db);
        UCDBGroup.createGroupContactTable(db);
        UCDBSite.createSiteTable(db);
        UCDBSite.createOutboundPrefixTable(db);
        UCDBDept.createDeptTable(db);
        UCDBContact.createContactTable(db);
        UCDBContact.createContactNumberTable(db);
        UCDBContact.createContactOutboundPrefixTable(db);
        UCDBConf.createConferenceRoomTable(db);
        UCDBConf.createConferenceUserTable(db);
        UCDBChatRoom.createChatRoomTable(db);
        UCDBChatRoom.createChatRoomParticipantTable(db);
        UCDBMessage.createChatMessageTable(db);
        UCDBReaderLog.createReaderLogTable(db);
        UCDBExternalContact.createExternalContactTable(db);
        UCDBExternalContact.createExternalNumberTable(db);
        UCDBVoiceMsg.createVoiceTable(db);
        UCDBCustomer.createCustomerTable(db);
        UCDBBulletin.createBulletinTable(db);
        UCDBRemoteMark.createRemoteMarkTable(db);
        UCDBMessageChannel.createMessageChannel(db);
        UCDBDeletedJidContact.createDeletedContact(db);
        UCDBFaxDoc.createFaxDocTable(db);
        UCDBRecording.createRecordingTable(db);
        this.createIndex(db);
        Log.i(UCDBHelper.class.getSimpleName(), "Create db .................  ..... end ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        block143: {
            Log.i(UCDBHelper.class.getSimpleName(), "onUpgrade db ................. start ..... " + oldVersion + " " + newVersion);
            try {
                ContentValues values;
                ContentValues values2;
                Cursor cursor;
                block141: {
                    String chatRoomId;
                    Long defaultValue;
                    ContentValues values3;
                    ContentValues values4;
                    if (oldVersion <= 91) {
                        UCDBSite.createOutboundPrefixTable(db);
                        db.execSQL("DROP TABLE IF EXISTS ContactNumber");
                        UCDBContact.createContactNumberTable(db);
                        db.execSQL("DROP TABLE IF EXISTS ContactExternalNumber");
                        UCDBExternalContact.createExternalNumberTable(db);
                    }
                    if (oldVersion <= 92) {
                        this.createIndex(db);
                    }
                    if (oldVersion <= 94) {
                        db.execSQL("DROP TABLE IF EXISTS Customer");
                        UCDBCustomer.createCustomerTable(db);
                    }
                    if (oldVersion <= 95) {
                        db.execSQL("ALTER TABLE Message ADD COLUMN noticeContent LONGVARCHAR");
                        db.execSQL("ALTER TABLE Message ADD COLUMN noticeThumbnail LONGVARCHAR");
                    }
                    if (oldVersion <= 96) {
                        db.execSQL("ALTER TABLE Contact ADD COLUMN dispNameForPinYin LONGVARCHAR");
                        cursor = null;
                        try {
                            cursor = db.query("Contact", ContactDataHelper.contactSelectColumnsForMerge, null, null, null, null, null, null);
                            if (cursor != null && cursor.moveToFirst()) {
                                do {
                                    String jid = cursor.getString(0);
                                    String surName = cursor.getString(1);
                                    String givenName = cursor.getString(2);
                                    String otherName = cursor.getString(3);
                                    Object displayNameForPinYin = cursor.getString(4);
                                    if (!TextUtils.isBlank((CharSequence)displayNameForPinYin) || !TextUtils.isNotBlank((CharSequence)otherName)) continue;
                                    String pinYinResult = PinyinHelper.convertToPinyinString((String)otherName, (String)" ", (PinyinFormat)PinyinFormat.WITHOUT_TONE);
                                    if (TextUtils.isBlank((CharSequence)surName) && TextUtils.isBlank((CharSequence)givenName)) {
                                        displayNameForPinYin = pinYinResult;
                                    } else if (TextUtils.isNotBlank((CharSequence)surName) && TextUtils.isBlank((CharSequence)givenName)) {
                                        displayNameForPinYin = surName + " " + pinYinResult;
                                    } else if (TextUtils.isBlank((CharSequence)surName) && TextUtils.isNotBlank((CharSequence)givenName)) {
                                        displayNameForPinYin = givenName + " " + pinYinResult;
                                    } else if (TextUtils.isNotBlank((CharSequence)surName) && TextUtils.isNotBlank((CharSequence)givenName)) {
                                        displayNameForPinYin = givenName + " " + surName + " " + pinYinResult;
                                    }
                                    ContentValues values5 = new ContentValues();
                                    values5.put("dispNameForPinYin", (String)displayNameForPinYin);
                                    db.update("Contact", values5, "jid = ?", new String[]{jid});
                                } while (cursor.moveToNext());
                            }
                            this.closeCursor(cursor);
                        }
                        catch (Throwable throwable) {
                            this.closeCursor(cursor);
                            throw throwable;
                        }
                    }
                    if (oldVersion <= 97) {
                        db.execSQL("ALTER TABLE ExternalContact ADD COLUMN nameForPinYin LONGVARCHAR");
                        cursor = null;
                        try {
                            cursor = db.query("ExternalContact", ContactDataHelper.externalSelectColumnsForMerge, null, null, null, null, null, null);
                            if (cursor != null && cursor.moveToFirst()) {
                                do {
                                    String id = cursor.getString(0);
                                    String name = cursor.getString(1);
                                    String pinYinResult = PinyinHelper.convertToPinyinString((String)name, (String)" ", (PinyinFormat)PinyinFormat.WITHOUT_TONE);
                                    values4 = new ContentValues();
                                    values4.put("nameForPinYin", pinYinResult);
                                    db.update("ExternalContact", values4, "id = ?", new String[]{id});
                                } while (cursor.moveToNext());
                            }
                            this.closeCursor(cursor);
                        }
                        catch (Throwable throwable) {
                            this.closeCursor(cursor);
                            throw throwable;
                        }
                    }
                    if (oldVersion <= 99) {
                        db.execSQL("ALTER TABLE Message ADD COLUMN chatEventId NUMERIC DEFAULT -1 ");
                        db.execSQL("drop index if exists message_eventid_index");
                        db.execSQL("create index message_eventid_index on Message(chatEventId)");
                        values3 = new ContentValues();
                        defaultValue = -1L;
                        values3.put("chatEventId", defaultValue);
                        db.update("Message", values3, null, null);
                    }
                    if (oldVersion <= 100) {
                        String[] selectColumns = new String[]{"chatRoomId", "lastMsgId"};
                        Cursor cursor2 = null;
                        try {
                            cursor2 = db.query("ChatRoom", selectColumns, null, null, null, null, null, null);
                            if (cursor2 != null && cursor2.moveToFirst()) {
                                do {
                                    chatRoomId = cursor2.getString(0);
                                    long lastMsgId = cursor2.getInt(1);
                                    values2 = new ContentValues();
                                    values2.put("playstatus", 1);
                                    db.update("Message", values2, "chatRoomId = ? AND id <= ?", new String[]{chatRoomId, String.valueOf(lastMsgId)});
                                } while (cursor2.moveToNext());
                            }
                            this.closeCursor(cursor2);
                        }
                        catch (Throwable throwable) {
                            this.closeCursor(cursor2);
                            throw throwable;
                        }
                        db.execSQL("drop index if exists chatroom_lastmsgid_index");
                        db.execSQL("ALTER TABLE ChatRoom DROP COLUMN lastMsgId");
                    }
                    if (oldVersion <= 102) {
                        db.execSQL("ALTER TABLE Message ADD COLUMN isListen NUMERIC DEFAULT 0 ");
                        values3 = new ContentValues();
                        defaultValue = 1L;
                        values3.put("isListen", defaultValue);
                        db.update("Message", values3, null, null);
                    }
                    if (oldVersion <= 103) {
                        db.execSQL("create index external_contact_id_index on ExternalContact(id)");
                        db.execSQL("create index group_contact_type_index on ChatGroupContact(type)");
                    }
                    if (oldVersion <= 104) {
                        db.execSQL("ALTER TABLE Contact ADD COLUMN outboundPrefixId NUMERIC");
                    }
                    if (oldVersion <= 105) {
                        db.execSQL("ALTER TABLE Contact ADD COLUMN birthdayHideType NUMERIC DEFAULT 1");
                    }
                    if (oldVersion <= 106) {
                        db.execSQL("ALTER TABLE OutboundPrefix ADD COLUMN nameCn LONGVARCHAR");
                        db.execSQL("ALTER TABLE OutboundPrefix ADD COLUMN nameTw LONGVARCHAR");
                        db.execSQL("ALTER TABLE OutboundPrefix ADD COLUMN nameEn LONGVARCHAR");
                        db.execSQL("ALTER TABLE OutboundPrefix ADD COLUMN countryNameCn LONGVARCHAR");
                        db.execSQL("ALTER TABLE OutboundPrefix ADD COLUMN countryNameTw LONGVARCHAR");
                        db.execSQL("ALTER TABLE OutboundPrefix ADD COLUMN countryNameEn LONGVARCHAR");
                        db.execSQL("ALTER TABLE OutboundPrefix ADD COLUMN countryCode LONGVARCHAR");
                        db.execSQL("ALTER TABLE OutboundPrefix ADD COLUMN cityCode LONGVARCHAR");
                    }
                    if (oldVersion <= 107) {
                        db.execSQL("ALTER TABLE ChatRoom ADD COLUMN lastNotifyTime NUMERIC DEFAULT 0");
                    }
                    if (oldVersion <= 109) {
                        db.execSQL("ALTER TABLE VoiceMessage ADD COLUMN chatPocketId LONGVARCHAR");
                    }
                    if (oldVersion <= 111) {
                        db.delete("VoiceMessage", null, null);
                    }
                    if (oldVersion <= 112) {
                        try {
                            db.execSQL("ALTER TABLE Customer ADD COLUMN transferred INTEGER DEFAULT 0");
                        }
                        catch (Throwable values6) {
                            // empty catch block
                        }
                    }
                    if (oldVersion <= 113) {
                        try {
                            db.execSQL("ALTER TABLE Message ADD COLUMN readCount INTEGER DEFAULT 0");
                            db.execSQL("ALTER TABLE Message ADD COLUMN readerList LONGVARCHAR");
                        }
                        catch (Throwable values6) {
                            // empty catch block
                        }
                    }
                    if (oldVersion <= 114) {
                        db.execSQL("drop index if exists participant_p_jid_index");
                        db.execSQL("drop index if exists participant_roomid_jid_index");
                        db.execSQL("create index participant_roomid_jid_index on ChatRoomParticipant(chatRoomId,jid)");
                    }
                    if (oldVersion <= 115) {
                        values3 = new ContentValues();
                        values3.put("msg_type", 200);
                        values3.put("status", "R");
                        db.update("Message", values3, "status = ? ", new String[]{"T"});
                        values3 = new ContentValues();
                        values3.put("msg_type", 201);
                        values3.put("status", "R");
                        db.update("Message", values3, "status = ? ", new String[]{"P"});
                        values3 = new ContentValues();
                        values3.put("msg_type", 210);
                        values3.put("status", "R");
                        db.update("Message", values3, "status = ? ", new String[]{"IO"});
                        values3 = new ContentValues();
                        values3.put("msg_type", 211);
                        values3.put("status", "R");
                        db.update("Message", values3, "status = ? ", new String[]{"I"});
                        values3 = new ContentValues();
                        values3.put("msg_type", 212);
                        values3.put("status", "R");
                        db.update("Message", values3, "status = ? ", new String[]{"IS"});
                        values3 = new ContentValues();
                        values3.put("msg_type", 213);
                        values3.put("status", "R");
                        db.update("Message", values3, "status = ? ", new String[]{"JS"});
                        values3 = new ContentValues();
                        values3.put("msg_type", 214);
                        values3.put("status", "R");
                        db.update("Message", values3, "status = ? ", new String[]{"L"});
                        values3 = new ContentValues();
                        values3.put("msg_type", 215);
                        values3.put("status", "R");
                        db.update("Message", values3, "status = ? ", new String[]{"LS"});
                        values3 = new ContentValues();
                        values3.put("msg_type", 216);
                        values3.put("status", "R");
                        db.update("Message", values3, "status = ? ", new String[]{"K"});
                        values3 = new ContentValues();
                        values3.put("msg_type", 221);
                        values3.put("status", "R");
                        db.update("Message", values3, "status = ? ", new String[]{"POT"});
                        values3 = new ContentValues();
                        values3.put("msg_type", 222);
                        values3.put("status", "R");
                        db.update("Message", values3, "status = ? ", new String[]{"POC"});
                        values3 = new ContentValues();
                        values3.put("msg_type", 223);
                        values3.put("status", "R");
                        db.update("Message", values3, "status = ? ", new String[]{"PIT"});
                        values3 = new ContentValues();
                        values3.put("msg_type", 224);
                        values3.put("status", "R");
                        db.update("Message", values3, "status = ? ", new String[]{"PIC"});
                        values3 = new ContentValues();
                        values3.put("msg_type", 231);
                        values3.put("status", "R");
                        db.update("Message", values3, "status = ? ", new String[]{"MJ"});
                        values3 = new ContentValues();
                        values3.put("msg_type", 232);
                        values3.put("status", "R");
                        db.update("Message", values3, "status = ? ", new String[]{"MJO"});
                        values3 = new ContentValues();
                        values3.put("msg_type", 233);
                        values3.put("status", "R");
                        db.update("Message", values3, "status = ? ", new String[]{"ML"});
                        values3 = new ContentValues();
                        values3.put("msg_type", 234);
                        values3.put("status", "R");
                        db.update("Message", values3, "status = ? ", new String[]{"MLO"});
                    }
                    if (oldVersion <= 116) {
                        try {
                            db.execSQL("ALTER TABLE VoiceMessage ADD COLUMN read INTEGER DEFAULT 0");
                            values3 = new ContentValues();
                            values3.put("read", 1);
                            db.update("VoiceMessage", values3, null, null);
                        }
                        catch (Throwable values7) {
                            // empty catch block
                        }
                    }
                    if (oldVersion <= 118) {
                        db.execSQL("DROP TABLE IF EXISTS Bulletin");
                        db.execSQL("DROP TABLE IF EXISTS BulletinAttachment");
                        UCDBBulletin.createBulletinTable(db);
                    }
                    if (oldVersion <= 120) {
                        db.execSQL("DROP TABLE IF EXISTS RemoteMark");
                        UCDBRemoteMark.createRemoteMarkTable(db);
                    }
                    if (oldVersion <= 121) {
                        UCDBMessageChannel.createMessageChannel(db);
                    }
                    if (oldVersion <= 122) {
                        db.execSQL("ALTER TABLE Message ADD COLUMN atMe INTEGER DEFAULT 0");
                    }
                    if (oldVersion <= 123) {
                        db.execSQL("ALTER TABLE Contact ADD COLUMN abscope NUMERIC DEFAULT 0");
                    }
                    if (oldVersion <= 126) {
                        db.execSQL("ALTER TABLE ChatRoom ADD COLUMN memberTimestamp NUMERIC DEFAULT -1");
                    }
                    if (oldVersion <= 127) {
                        db.execSQL("ALTER TABLE Message ADD COLUMN syncEventId NUMERIC DEFAULT -1 ");
                        db.execSQL("drop index if exists message_sync_eventid_index");
                        db.execSQL("create index message_sync_eventid_index on Message(syncEventId)");
                    }
                    if (oldVersion <= 128) {
                        db.execSQL("ALTER TABLE RemoteMark ADD COLUMN strId LONGVARCHAR ");
                    }
                    if (oldVersion <= 129) {
                        db.execSQL("ALTER TABLE ConferenceRoom ADD COLUMN initDone INTEGER DEFAULT 0");
                        values3 = new ContentValues();
                        values3.put("initDone", 1);
                        db.update("ConferenceRoom", values3, null, null);
                    }
                    if (oldVersion <= 130) {
                        db.execSQL("ALTER TABLE Message ADD COLUMN extraProps LONGVARCHAR");
                    }
                    if (oldVersion <= 131) {
                        db.execSQL("ALTER TABLE ChatRoom DROP COLUMN status");
                    }
                    if (oldVersion <= 132) {
                        UCDBDeletedJidContact.createDeletedContact(db);
                    }
                    if (oldVersion <= 133) {
                        db.execSQL("ALTER TABLE Contact DROP COLUMN sPhotoFailCount");
                        db.execSQL("ALTER TABLE Contact DROP COLUMN bPhotoFailCount");
                        db.execSQL("ALTER TABLE ExternalContact DROP COLUMN sPhotoFailCount");
                        db.execSQL("ALTER TABLE ExternalContact DROP COLUMN bPhotoFailCount");
                        db.execSQL("ALTER TABLE MessageChannel DROP COLUMN photoFailCount");
                    }
                    if (oldVersion <= 134) {
                        cursor = null;
                        try {
                            cursor = db.query("Message", ChatDataHelper.msgSelectColumns, null, null, null, null, null, null);
                            if (cursor != null && cursor.moveToFirst()) {
                                do {
                                    String tToJid;
                                    String tFromJid;
                                    String tChatRoomId;
                                    Message message = new Message();
                                    ChatDataHelper.setMsgValue(cursor, message);
                                    values = new ContentValues();
                                    String chatRoomId2 = message.getChatRoomJid();
                                    String fromJid = message.getFromJid();
                                    String toJid = message.getToJid();
                                    boolean doUpdate = false;
                                    if (chatRoomId2 != null && !chatRoomId2.equals(tChatRoomId = JidUtil.jidTranslate(chatRoomId2))) {
                                        doUpdate = true;
                                        values.put("chatRoomId", tChatRoomId);
                                    }
                                    if (fromJid != null && !fromJid.equals(tFromJid = JidUtil.jidTranslate(fromJid))) {
                                        doUpdate = true;
                                        values.put("fromJid", tFromJid);
                                    }
                                    if (toJid != null && !toJid.equals(tToJid = JidUtil.jidTranslate(toJid))) {
                                        doUpdate = true;
                                        values.put("toJid", tToJid);
                                    }
                                    if (!doUpdate) continue;
                                    db.update("Message", values, "id = ?", new String[]{String.valueOf(message.getId())});
                                } while (cursor.moveToNext());
                            }
                        }
                        finally {
                            this.closeCursor(cursor);
                        }
                        try {
                            cursor = db.query("ChatRoom", ChatDataHelper.chatRoomSelectColumns, null, null, null, null, null, null);
                            if (cursor == null || !cursor.moveToFirst()) break block141;
                            do {
                                String tChatRoomId;
                                ChatRoomInfo chatRoom = new ChatRoomInfo();
                                ChatDataHelper.setChatRoomValue(cursor, chatRoom);
                                chatRoomId = chatRoom.getChatRoomId();
                                if (chatRoomId == null || chatRoomId.equals(tChatRoomId = JidUtil.jidTranslate(chatRoomId))) continue;
                                values4 = new ContentValues();
                                values4.put("chatRoomId", tChatRoomId);
                                Cursor cursor2 = null;
                                try {
                                    cursor2 = db.query("Message", ChatDataHelper.msgSelectColumns, "chatRoomId = ? ", new String[]{String.valueOf(tChatRoomId)}, null, null, "serverTime DESC", "1");
                                    if (cursor2 != null && cursor2.moveToFirst()) {
                                        Message message = new Message();
                                        ChatDataHelper.setMsgValue(cursor2, message);
                                        values4.put("lastSysMsgTime", message.getServerTime());
                                        values4.put("lastMsgTime", message.getServerTime());
                                    }
                                    this.closeCursor(cursor2);
                                }
                                catch (Throwable throwable) {
                                    this.closeCursor(cursor2);
                                    throw throwable;
                                }
                                db.update("ChatRoom", values4, "chatRoomId = ?", new String[]{chatRoomId});
                            } while (cursor.moveToNext());
                        }
                        finally {
                            this.closeCursor(cursor);
                        }
                    }
                }
                if (oldVersion <= 135) {
                    db.execSQL("ALTER TABLE Customer ADD COLUMN assigner LONGVARCHAR");
                }
                if (oldVersion <= 136) {
                    db.execSQL("ALTER TABLE Message ADD COLUMN lazyContent NUMERIC DEFAULT 0 ");
                }
                if (oldVersion <= 137) {
                    db.execSQL("ALTER TABLE Message ADD COLUMN phoneNumber LONGVARCHAR ");
                    db.execSQL("ALTER TABLE Message ADD COLUMN phoneMergeFlag INTEGER DEFAULT 0 ");
                    List<MergeItem> mergeItemList = this.queryPhoneList(db);
                    while (mergeItemList != null && mergeItemList.size() != 0) {
                        for (int j = 0; mergeItemList != null && j < mergeItemList.size(); ++j) {
                            MergeItem item = mergeItemList.get(j);
                            ContentValues values8 = new ContentValues();
                            values8.put("phoneMergeFlag", 1);
                            if (item.getMsgType() == 221) {
                                content = item.getContent();
                                if (content != null && (contentAry = content.split("_@@_")) != null && contentAry.length >= 3) {
                                    phoneNum = contentAry[2];
                                    if (StringUtils.isNotBlank((CharSequence)phoneNum)) {
                                        values8.put("phoneNumber", phoneNum.trim());
                                    }
                                    if (StringUtils.isNotBlank((CharSequence)(durationStr = contentAry[3]))) {
                                        duration = this.getDuration(durationStr);
                                        values8.put("duration", duration);
                                    }
                                }
                            } else if (item.getMsgType() == 223) {
                                content = item.getContent();
                                if (content != null && (contentAry = content.split("_@@_")) != null && contentAry.length >= 3) {
                                    phoneNum = contentAry[2];
                                    if (StringUtils.isNotBlank((CharSequence)phoneNum)) {
                                        values8.put("phoneNumber", phoneNum.trim());
                                    }
                                    if (StringUtils.isNotBlank((CharSequence)(durationStr = contentAry[3]))) {
                                        duration = this.getDuration(durationStr);
                                        values8.put("duration", duration);
                                    }
                                }
                            } else if (item.getMsgType() == 225) {
                                content = item.getContent();
                                if (content != null && (contentAry = content.split("_@@_")) != null && contentAry.length >= 2 && StringUtils.isNotBlank((CharSequence)(phoneNum = contentAry[2]))) {
                                    values8.put("phoneNumber", phoneNum.trim());
                                }
                            } else if (item.getMsgType() == 222) {
                                content = item.getContent();
                                if (content != null && (contentAry = content.split("_@@_")) != null && contentAry.length >= 2 && StringUtils.isNotBlank((CharSequence)(phoneNum = contentAry[2]))) {
                                    values8.put("phoneNumber", phoneNum.trim());
                                }
                            } else if (item.getMsgType() == 13) {
                                values8.put("phoneNumber", item.getRoomSuject());
                            } else if (item.getMsgType() == 1006) {
                                values8.put("phoneNumber", item.getRoomSuject());
                            } else if (item.getMsgType() == 12) {
                                values8.put("phoneNumber", item.getRoomSuject());
                            } else if (item.getMsgType() == 1005) {
                                values8.put("phoneNumber", item.getRoomSuject());
                            }
                            db.update("Message", values8, "id = ?", new String[]{String.valueOf(item.getId())});
                        }
                        mergeItemList = this.queryPhoneList(db);
                    }
                }
                if (oldVersion <= 138) {
                    db.execSQL("ALTER TABLE Message ADD COLUMN isRecalled INTEGER DEFAULT 0 ");
                }
                if (oldVersion <= 139) {
                    db.execSQL("DROP TABLE IF EXISTS Frequent");
                }
                if (oldVersion <= 141) {
                    db.execSQL("ALTER TABLE ChatRoom DROP COLUMN lastSysMsgTime");
                    db.execSQL("ALTER TABLE ChatRoom DROP COLUMN lastMsgTime");
                    db.execSQL("DROP TABLE IF EXISTS DeletedContact");
                }
                if (oldVersion <= 142) {
                    UCDBContact.createContactOutboundPrefixTable(db);
                    db.execSQL("ALTER TABLE OutboundPrefix ADD COLUMN meetmePrefix LONGVARCHAR");
                    db.execSQL("ALTER TABLE OutboundPrefix ADD COLUMN optionOrder INTEGER DEFAULT 0");
                    db.execSQL("ALTER TABLE ContactNumber DROP COLUMN siteId");
                    db.execSQL("ALTER TABLE ContactNumber DROP COLUMN outboundPrefixId");
                    db.execSQL("drop index if exists contactoutboundprefix_jid_index");
                    db.execSQL("create index contactoutboundprefix_jid_index on ContactOutboundPrefix(contactJid)");
                }
                if (oldVersion <= 143) {
                    db.execSQL("ALTER TABLE OutboundPrefix ADD COLUMN defaultRule INTEGER DEFAULT 0");
                }
                if (oldVersion <= 144) {
                    UCDBReaderLog.createReaderLogTable(db);
                    db.execSQL("drop index if exists readerlog_packetId_index");
                    db.execSQL("create index readerlog_packetId_index on ReaderLog(packetId)");
                }
                if (oldVersion <= 146) {
                    db.execSQL("ALTER TABLE Contact ADD COLUMN deptForSearch LONGVARCHAR");
                    db.execSQL("ALTER TABLE Contact ADD COLUMN extForSearch LONGVARCHAR");
                    cursor = null;
                    try {
                        cursor = db.query("Contact", ContactDataHelper.contactSelectColumns, null, null, null, null, null, null);
                        if (cursor != null && cursor.moveToFirst()) {
                            do {
                                String[] args;
                                LiteContact contact = new LiteContact();
                                ContactDataHelper.setContactValue(cursor, contact);
                                values = new ContentValues();
                                StringBuffer c = new StringBuffer();
                                for (int i = 0; contact.getExtList() != null && i < contact.getExtList().size(); ++i) {
                                    if (i != 0) {
                                        c.append(" ");
                                    }
                                    c.append(contact.getExtList().get(i));
                                }
                                values.put("extForSearch", c.toString());
                                String selfDept = null;
                                if (contact.getDepartmentNamePath() != null && (args = contact.getDepartmentNamePath().split("/")).length > 0) {
                                    selfDept = args[args.length - 1];
                                }
                                values.put("deptForSearch", selfDept);
                                db.update("Contact", values, "jid = ?", new String[]{contact.getJid()});
                            } while (cursor.moveToNext());
                        }
                    }
                    finally {
                        this.closeCursor(cursor);
                    }
                }
                if (oldVersion <= 147) {
                    UCDBFaxDoc.createFaxDocTable(db);
                }
                if (oldVersion <= 148) {
                    db.execSQL("ALTER TABLE ChatRoom ADD COLUMN onTop TINYINT DEFAULT 0");
                }
                if (oldVersion <= 149) {
                    db.execSQL("ALTER TABLE FaxDoc ADD COLUMN pdfFilePath LONGVARCHAR");
                    db.execSQL("ALTER TABLE FaxDoc ADD COLUMN pdfFileSize INTEGER");
                }
                if (oldVersion <= 150) {
                    db.execSQL("ALTER TABLE VoiceMessage ADD COLUMN outboundTrunk INTEGER DEFAULT 0");
                }
                if (oldVersion <= 151) {
                    db.execSQL("ALTER TABLE Message ADD COLUMN isOutboundTrunk INTEGER DEFAULT 0");
                }
                if (oldVersion <= 152) {
                    db.execSQL("ALTER TABLE Message ADD COLUMN fileSize NUMERIC DEFAULT 0");
                    db.execSQL("ALTER TABLE Message ADD COLUMN fileLocalPath LONGVARCHAR");
                    db.execSQL("ALTER TABLE Message ADD COLUMN mimeType LONGVARCHAR");
                }
                if (oldVersion <= 153) {
                    db.execSQL("ALTER TABLE Message ADD COLUMN extraText LONGVARCHAR");
                }
                if (oldVersion <= 157) {
                    PreferencesUtil.setLastContactLogId(this.mCtx, -1L);
                    db.execSQL("DROP TABLE IF EXISTS Recording");
                    UCDBRecording.createRecordingTable(db);
                }
                if (oldVersion <= 158) {
                    db.execSQL("ALTER TABLE Message ADD COLUMN contactRecordId NUMERIC DEFAULT 0");
                }
                if (oldVersion <= 159) {
                    db.execSQL("DROP TABLE IF EXISTS ContactSummary");
                }
                if (oldVersion <= 160) {
                    db.execSQL("DROP TABLE IF EXISTS Department");
                    UCDBDept.createDeptTable(db);
                    db.execSQL("drop index if exists department_namepath_index");
                    db.execSQL("create index department_namepath_index on Department(namePath)");
                }
                if (oldVersion <= 161) {
                    db.execSQL("ALTER TABLE Contact ADD COLUMN extendedNumber1 LONGVARCHAR");
                    db.execSQL("ALTER TABLE Contact ADD COLUMN extendedNumber2 LONGVARCHAR");
                    db.execSQL("ALTER TABLE Contact ADD COLUMN extendedNumber3 LONGVARCHAR");
                    db.execSQL("ALTER TABLE Contact ADD COLUMN extendedNumber4 LONGVARCHAR");
                }
                if (oldVersion > 166) break block143;
                db.execSQL("ALTER TABLE Message ADD COLUMN title LONGVARCHAR");
                cursor = null;
                try {
                    String cond = "msg_type in (8,9)";
                    cursor = db.query("Message", ChatDataHelper.msgSelectColumns, cond, null, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block143;
                    do {
                        Message message = new Message();
                        ChatDataHelper.setMsgValue(cursor, message);
                        String title = null;
                        String props = message.getProps();
                        if (props != null) {
                            try {
                                JSONObject obj = new JSONObject(props);
                                if (obj.has("title")) {
                                    title = obj.getString("title");
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (!StringUtils.isNotBlank(title)) continue;
                        values2 = new ContentValues();
                        values2.put("title", title);
                        db.update("Message", values2, "id = ?", new String[]{String.valueOf(message.getId())});
                    } while (cursor.moveToNext());
                }
                finally {
                    this.closeCursor(cursor);
                }
            }
            catch (Throwable t) {
                Log.e(UCDBHelper.class.getSimpleName(), t.getLocalizedMessage(), t);
            }
        }
        Log.i(UCDBHelper.class.getSimpleName(), "onUpgrade db ................. end ..... ");
    }

    private long getDuration(String input) {
        String[] parts = input.split(":");
        Duration d = Duration.ZERO;
        if (parts.length == 3) {
            int hours = Integer.parseInt(parts[0]);
            int minutes = Integer.parseInt(parts[1]);
            int seconds = Integer.parseInt(parts[2]);
            d = d.plusHours(hours).plusMinutes(minutes).plusSeconds(seconds);
        } else if (parts.length == 2) {
            int minutes = Integer.parseInt(parts[0]);
            int seconds = Integer.parseInt(parts[1]);
            d = d.plusMinutes(minutes).plusSeconds(seconds);
        } else {
            Log.e(UCDBHelper.class.getSimpleName(), "ERROR - Unexpected input.");
        }
        return d.getSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MergeItem> queryPhoneList(SQLiteDatabase db) {
        ArrayList<MergeItem> msgList = new ArrayList<MergeItem>();
        ArrayList<Integer> callTypeList = new ArrayList<Integer>();
        callTypeList.add(221);
        callTypeList.add(223);
        callTypeList.add(225);
        callTypeList.add(222);
        callTypeList.add(1006);
        callTypeList.add(1005);
        callTypeList.add(13);
        callTypeList.add(12);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT M.id, M.content, M.msg_type, R.subject");
        sql.append(" FROM ");
        sql.append("Message");
        sql.append(" M, ");
        sql.append("ChatRoom");
        sql.append(" R WHERE M.");
        sql.append("chatRoomId");
        sql.append(" = R.");
        sql.append("chatRoomId");
        sql.append(" AND M.");
        sql.append("msg_type IN (");
        for (int i = 0; i < callTypeList.size(); ++i) {
            int typeToHide = (Integer)callTypeList.get(i);
            if (i != 0) {
                sql.append(",");
            }
            sql.append(typeToHide);
        }
        sql.append(") AND M.phoneMergeFlag = 0 ");
        sql.append(" LIMIT 20");
        Cursor cursor = null;
        try {
            cursor = db.rawQuery(sql.toString(), null);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    MergeItem item = new MergeItem(this);
                    item.setId(cursor.getLong(0));
                    item.setContent(cursor.getString(1));
                    item.setMsgType(cursor.getInt(2));
                    item.setRoomSuject(cursor.getString(3));
                    msgList.add(item);
                } while (cursor.moveToNext());
            }
            this.closeCursor(cursor);
        }
        catch (Throwable throwable) {
            this.closeCursor(cursor);
            throw throwable;
        }
        return msgList;
    }

    private void closeCursor(Cursor cursor) {
        try {
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Throwable t) {
            Log.e(UCDBBase.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    private void createIndex(SQLiteDatabase db) {
        db.execSQL("drop index if exists contact_jid_index");
        db.execSQL("create index contact_jid_index on Contact(jid)");
        db.execSQL("drop index if exists contact_empid_index");
        db.execSQL("create index contact_empid_index on Contact(empId)");
        db.execSQL("drop index if exists contact_type_index");
        db.execSQL("create index contact_type_index on Contact(type)");
        db.execSQL("drop index if exists contactnumber_jid_index");
        db.execSQL("create index contactnumber_jid_index on ContactNumber(contactJid)");
        db.execSQL("drop index if exists contactoutboundprefix_jid_index");
        db.execSQL("create index contactoutboundprefix_jid_index on ContactOutboundPrefix(contactJid)");
        db.execSQL("drop index if exists chatroom_roomid_index");
        db.execSQL("create index chatroom_roomid_index on ChatRoom(chatRoomId)");
        db.execSQL("drop index if exists participant_roomid_index");
        db.execSQL("create index participant_roomid_index on ChatRoomParticipant(chatRoomId)");
        db.execSQL("drop index if exists participant_roomid_jid_index");
        db.execSQL("create index participant_roomid_jid_index on ChatRoomParticipant(chatRoomId,jid)");
        db.execSQL("drop index if exists message_roomid_index");
        db.execSQL("create index message_roomid_index on Message(chatRoomId)");
        db.execSQL("drop index if exists message_msgid_index");
        db.execSQL("create index message_msgid_index on Message(id)");
        db.execSQL("drop index if exists message_chatmsgid_index");
        db.execSQL("create index message_chatmsgid_index on Message(chatMsgId)");
        db.execSQL("drop index if exists message_roomid_msgid_index");
        db.execSQL("create index message_roomid_msgid_index on Message(chatRoomId,id)");
        db.execSQL("drop index if exists conferenceuser_roomid_userno_index");
        db.execSQL("create index conferenceuser_roomid_userno_index on ConferenceRoomUser(roomId,userNo)");
        db.execSQL("drop index if exists conferenceuser_roomid_index");
        db.execSQL("create index conferenceuser_roomid_index on ConferenceRoomUser(roomId)");
        db.execSQL("drop index if exists conference_roomid_index");
        db.execSQL("create index conference_roomid_index on ConferenceRoom(roomId)");
        db.execSQL("drop index if exists conference_chatroomid_index");
        db.execSQL("create index conference_chatroomid_index on ConferenceRoom(chatRoomId)");
        db.execSQL("drop index if exists message_eventid_index");
        db.execSQL("create index message_eventid_index on Message(chatEventId)");
        db.execSQL("drop index if exists message_sync_eventid_index");
        db.execSQL("create index message_sync_eventid_index on Message(syncEventId)");
        db.execSQL("drop index if exists external_contact_id_index");
        db.execSQL("create index external_contact_id_index on ExternalContact(id)");
        db.execSQL("drop index if exists group_contact_type_index");
        db.execSQL("create index group_contact_type_index on ChatGroupContact(type)");
        db.execSQL("drop index if exists bulletin_attachment_index");
        db.execSQL("create index bulletin_attachment_index on BulletinAttachment(attachmentIndex)");
        db.execSQL("drop index if exists readerlog_packetId_index");
        db.execSQL("create index readerlog_packetId_index on ReaderLog(packetId)");
        db.execSQL("drop index if exists department_namepath_index");
        db.execSQL("create index department_namepath_index on Department(namePath)");
    }

    static {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        db = null;
        lock = new Object();
    }

    class MergeItem {
        long id;
        int msgType;
        String content;
        String roomSuject;

        MergeItem(UCDBHelper this$0) {
        }

        public void setId(long id) {
            this.id = id;
        }

        public void setMsgType(int msgType) {
            this.msgType = msgType;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setRoomSuject(String roomSuject) {
            this.roomSuject = roomSuject;
        }

        public long getId() {
            return this.id;
        }

        public int getMsgType() {
            return this.msgType;
        }

        public String getContent() {
            return this.content;
        }

        public String getRoomSuject() {
            return this.roomSuject;
        }
    }
}

