/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.DatabaseUtils;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.bean.MessageChannel;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBBulletin;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import com.blisscloud.mobile.ezuc.util.JidUtil;

public class UCDBMessageChannel
extends UCDBBase {
    public static final String TABLE_MESSAGE_CHANNEL = "MessageChannel";
    public static final String FIELD_ID = "id";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_JID = "jid";
    public static final String FIELD_PHOTO_TIMESTAMP = "photoTimestamp";
    public static final String FIELD_CURRENT_PHOTO_TIMESTAMP = "currentPhotoTimestamp";
    @Deprecated
    public static final String FIELD_PHOTO_FAILED_COUNT = "photoFailCount";
    public static final String[] selectColumns = new String[]{"id", "name", "jid", "photoTimestamp"};

    public static void setMessageChannelValue(Cursor cursor, MessageChannel item) {
        item.setId(cursor.getLong(0));
        item.setName(cursor.getString(1));
        item.setJid(cursor.getString(2));
        item.setLastUpdateIcon(cursor.getLong(3));
    }

    public static void createMessageChannel(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS MessageChannel");
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ");
        sql.append(TABLE_MESSAGE_CHANNEL);
        sql.append("(");
        sql.append(FIELD_ID);
        sql.append(" NUMERIC PRIMARY KEY,");
        sql.append(FIELD_NAME);
        sql.append(" LONGVARCHAR,");
        sql.append(FIELD_JID);
        sql.append(" LONGVARCHAR,");
        sql.append(FIELD_PHOTO_TIMESTAMP);
        sql.append(" NUMERIC,");
        sql.append(FIELD_CURRENT_PHOTO_TIMESTAMP);
        sql.append(" NUMERIC");
        sql.append(")");
        db.execSQL(sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existChannelById(Context ctx, long channelId) {
        UCDBHelper helper;
        UCDBMessageChannel._log(UCDBMessageChannel.class.getSimpleName(), "existChannelById...." + channelId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            try {
                db = helper.getReadableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_MESSAGE_CHANNEL, "id=?", new String[]{String.valueOf(channelId)});
                bl = count > 0L;
            }
            catch (Throwable throwable) {
                UCDBMessageChannel.closeDb(db);
                throw throwable;
            }
            UCDBMessageChannel.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMessageChannel(Context ctx, MessageChannel channel) {
        UCDBHelper helper;
        UCDBMessageChannel._log(UCDBMessageChannel.class.getSimpleName(), "addMessageChannel....(" + String.valueOf(channel) + ")");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put(FIELD_ID, channel.getId());
                values.put(FIELD_NAME, channel.getName());
                values.put(FIELD_JID, channel.getJid());
                values.put(FIELD_PHOTO_TIMESTAMP, channel.getLastUpdateIcon());
                db.insert(TABLE_MESSAGE_CHANNEL, null, values);
            }
            finally {
                UCDBMessageChannel.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateMessageChannel(Context ctx, MessageChannel channel) {
        UCDBHelper helper;
        UCDBMessageChannel._log(UCDBBulletin.class.getSimpleName(), "updateMessageChannel...." + String.valueOf(channel));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put(FIELD_NAME, channel.getName());
                values.put(FIELD_JID, channel.getJid());
                values.put(FIELD_PHOTO_TIMESTAMP, channel.getLastUpdateIcon());
                db.update(TABLE_MESSAGE_CHANNEL, values, "id = ?", new String[]{String.valueOf(channel.getId())});
            }
            finally {
                UCDBMessageChannel.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteMessageChannel(Context ctx, Long id) {
        UCDBHelper helper;
        UCDBMessageChannel._log(UCDBMessageChannel.class.getSimpleName(), "deleteMessageChannel....(" + id + ")");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_MESSAGE_CHANNEL, "id = ? ", new String[]{String.valueOf(id)});
            }
            finally {
                UCDBMessageChannel.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllMessageChannels(Context ctx) {
        UCDBHelper helper;
        UCDBMessageChannel._log(UCDBMessageChannel.class.getSimpleName(), "deleteAllMessageChannels....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_MESSAGE_CHANNEL, null, null);
            }
            finally {
                UCDBMessageChannel.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageChannel getMessageChannelById(Context ctx, Long id) {
        UCDBHelper helper;
        UCDBMessageChannel._log(UCDBMessageChannel.class.getSimpleName(), "getMessageChannelById...." + id);
        MessageChannel channel = null;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_MESSAGE_CHANNEL, selectColumns, "id=?", new String[]{String.valueOf(id)}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    channel = new MessageChannel();
                    UCDBMessageChannel.setMessageChannelValue(cursor, channel);
                }
            }
            catch (Throwable throwable) {
                UCDBMessageChannel.closeCursor(cursor);
                UCDBMessageChannel.closeDb(db);
                throw throwable;
            }
            UCDBMessageChannel.closeCursor(cursor);
            UCDBMessageChannel.closeDb(db);
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageChannel getMessageChannelByJid(Context ctx, String jid) {
        UCDBHelper helper;
        UCDBMessageChannel._log(UCDBMessageChannel.class.getSimpleName(), "getMessageChannelByJid...." + jid);
        MessageChannel channel = null;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                Object jid2 = jid;
                if (jid.endsWith("@apiuser.blisscloud.com")) {
                    jid2 = JidUtil.convertKey(jid) + "@blisscloud.com";
                } else if (jid.endsWith("@blisscloud.com")) {
                    jid2 = JidUtil.convertKey(jid) + "@apiuser.blisscloud.com";
                }
                cursor = db.query(TABLE_MESSAGE_CHANNEL, selectColumns, "jid=? OR jid=?", new String[]{jid, jid2}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    channel = new MessageChannel();
                    UCDBMessageChannel.setMessageChannelValue(cursor, channel);
                }
            }
            catch (Throwable throwable) {
                UCDBMessageChannel.closeCursor(cursor);
                UCDBMessageChannel.closeDb(db);
                throw throwable;
            }
            UCDBMessageChannel.closeCursor(cursor);
            UCDBMessageChannel.closeDb(db);
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getMessageChannelPhotoTimestamps(Context ctx, long id) {
        UCDBHelper helper;
        UCDBMessageChannel._log(UCDBMessageChannel.class.getSimpleName(), "getMessageChannelPhotoTimestamps...." + id);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            long[] lArray;
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                String selection = "id = ?";
                String[] selectionArgs = new String[]{String.valueOf(id)};
                String[] columns = new String[]{FIELD_PHOTO_TIMESTAMP, FIELD_CURRENT_PHOTO_TIMESTAMP};
                Cursor cursor = null;
                long[] timestamps = new long[]{-1L, -1L};
                cursor = db.query(TABLE_MESSAGE_CHANNEL, columns, selection, selectionArgs, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    timestamps[0] = cursor.getLong(0);
                    timestamps[1] = cursor.getLong(1);
                }
                lArray = timestamps;
            }
            catch (Throwable throwable) {
                UCDBMessageChannel.closeDb(db);
                throw throwable;
            }
            UCDBMessageChannel.closeDb(db);
            return lArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getPhotoTimestamp(Context ctx, long id) {
        UCDBHelper helper;
        UCDBMessageChannel._log(UCDBMessageChannel.class.getSimpleName(), "getPhotoTimestamp...." + id);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            long l;
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                String selection = "id = ?";
                String[] selectionArgs = new String[]{String.valueOf(id)};
                String[] columns = new String[]{FIELD_PHOTO_TIMESTAMP};
                Cursor cursor = null;
                long timestamp = -1L;
                cursor = db.query(TABLE_MESSAGE_CHANNEL, columns, selection, selectionArgs, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    timestamp = cursor.getLong(0);
                }
                l = timestamp;
            }
            catch (Throwable throwable) {
                UCDBMessageChannel.closeDb(db);
                throw throwable;
            }
            UCDBMessageChannel.closeDb(db);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCurrentPhotoTimestamp(Context ctx, long id, long timestamp) {
        UCDBHelper helper;
        UCDBMessageChannel._log(UCDBMessageChannel.class.getSimpleName(), "updateCurrentPhotoTimestamp...." + id + "," + timestamp);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put(FIELD_CURRENT_PHOTO_TIMESTAMP, timestamp);
                db.update(TABLE_MESSAGE_CHANNEL, values, "id = ?", new String[]{String.valueOf(id)});
            }
            finally {
                UCDBMessageChannel.closeDb(db);
            }
        }
    }
}

