/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.DatabaseUtils;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.bean.MsgReaderTime;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UCDBSite;
import java.util.ArrayList;
import java.util.List;

public class UCDBReaderLog
extends UCDBBase {
    public static final String TABLE_READER_LOG = "ReaderLog";
    public static final String KEY_READER_LOG_ID = "id";
    public static final String KEY_READER_LOG_PACKETID = "packetId";
    public static final String KEY_READER_LOG_CHATEVENTID = "chatEventId";
    public static final String KEY_READER_LOG_READER_EMP_ID = "readerEmpId";
    public static final String KEY_READER_LOG_READER_TIMESTAMP = "readerTimestamp";

    public static void createReaderLogTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS ReaderLog");
        String CREATE_READER_LOG = "CREATE TABLE ReaderLog(id INTEGER PRIMARY KEY IDENTITY,packetId LONGVARCHAR,chatEventId NUMERIC, readerEmpId NUMERIC, readerTimestamp NUMERIC )";
        db.execSQL(CREATE_READER_LOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLogExist(Context ctx, long logId) {
        UCDBHelper helper;
        UCDBReaderLog._log(UCDBMessage.class.getSimpleName(), "isLogExist ..." + logId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            try {
                db = helper.getReadableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_READER_LOG, "id=?", new String[]{String.valueOf(logId)});
                bl = count > 0L;
            }
            catch (Throwable throwable) {
                UCDBReaderLog.closeDb(db);
                throw throwable;
            }
            UCDBReaderLog.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long addReaderLog(Context ctx, MsgReaderTime readerTime) {
        UCDBHelper helper;
        UCDBReaderLog._log(UCDBReaderLog.class.getSimpleName(), "addReaderLog....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            long l;
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put(KEY_READER_LOG_ID, readerTime.getId());
                values.put(KEY_READER_LOG_PACKETID, readerTime.getPacketId());
                values.put(KEY_READER_LOG_CHATEVENTID, readerTime.getChatEventId());
                values.put(KEY_READER_LOG_READER_EMP_ID, readerTime.getReaderEmpId());
                values.put(KEY_READER_LOG_READER_TIMESTAMP, readerTime.getReaderTimestamp());
                l = db.insert(TABLE_READER_LOG, null, values);
            }
            catch (Throwable throwable) {
                UCDBReaderLog.closeDb(db);
                throw throwable;
            }
            UCDBReaderLog.closeDb(db);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateReaderLog(Context ctx, MsgReaderTime readerTime) {
        UCDBHelper helper;
        UCDBReaderLog._log(UCDBMessage.class.getSimpleName(), "updateReaderLog...." + String.valueOf(readerTime));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put(KEY_READER_LOG_PACKETID, readerTime.getPacketId());
                values.put(KEY_READER_LOG_CHATEVENTID, readerTime.getChatEventId());
                values.put(KEY_READER_LOG_READER_EMP_ID, readerTime.getReaderEmpId());
                values.put(KEY_READER_LOG_READER_TIMESTAMP, readerTime.getReaderTimestamp());
                db.update(TABLE_READER_LOG, values, "id=?", new String[]{String.valueOf(readerTime.getId())});
            }
            finally {
                UCDBReaderLog.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastReaderLogId(Context ctx, String packetId) {
        UCDBHelper helper;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            long l;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT MAX(id) FROM ReaderLog WHERE packetId = '" + packetId + "'");
                long maxReaderLogId = -1L;
                cursor = db.rawQuery(sql.toString(), null);
                if (cursor != null && cursor.moveToFirst()) {
                    maxReaderLogId = cursor.getLong(0);
                }
                l = maxReaderLogId;
            }
            catch (Throwable throwable) {
                UCDBReaderLog.closeCursor(cursor);
                UCDBReaderLog.closeDb(db);
                throw throwable;
            }
            UCDBReaderLog.closeCursor(cursor);
            UCDBReaderLog.closeDb(db);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MsgReaderTime> getMsgReaderTimeList(Context ctx, String packetId, boolean asc) {
        UCDBHelper helper;
        UCDBReaderLog._log(UCDBSite.class.getSimpleName(), "getMsgReaderTimes....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<MsgReaderTime> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<MsgReaderTime> readerTimeList = new ArrayList<MsgReaderTime>();
                String selectQuery = "SELECT id,packetId, chatEventId, readerEmpId, readerTimestamp FROM ReaderLog WHERE packetId = '" + packetId + "' order by readerTimestamp " + (asc ? "ASC" : "DESC");
                cursor = db.rawQuery(selectQuery, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        MsgReaderTime readerTime = new MsgReaderTime();
                        readerTime.setId(cursor.getLong(0));
                        readerTime.setPacketId(cursor.getString(1));
                        readerTime.setChatEventId(cursor.getLong(2));
                        readerTime.setReaderEmpId(cursor.getLong(3));
                        readerTime.setReaderTimestamp(cursor.getLong(4));
                        readerTimeList.add(readerTime);
                    } while (cursor.moveToNext());
                }
                arrayList = readerTimeList;
            }
            catch (Throwable throwable) {
                UCDBReaderLog.closeCursor(cursor);
                UCDBReaderLog.closeDb(db);
                throw throwable;
            }
            UCDBReaderLog.closeCursor(cursor);
            UCDBReaderLog.closeDb(db);
            return arrayList;
        }
    }
}

