/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.bean.web.LiteOutboundPrefix;
import com.blisscloud.ezuc.bean.web.LiteSite;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.DatabaseUtils;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import java.util.ArrayList;
import java.util.List;

public class UCDBSite
extends UCDBBase {
    public static final String TABLE_SITE = "Site";
    public static final String TABLE_OUTBOUND_PREFIX = "OutboundPrefix";
    public static String[] outboundPrefixSelectColumns = new String[]{"id", "name", "siteId", "prefix", "meetmePrefix", "optionOrder", "defaultRule", "nameCn", "nameTw", "nameEn", "countryNameCn", "countryNameTw", "countryNameEn", "countryCode", "cityCode"};

    public static void createSiteTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS Site");
        String CREATE_SITE_TABLE = "CREATE TABLE Site(id NUMERIC PRIMARY KEY,name LONGVARCHAR,prefix LONGVARCHAR,outboundPrefix LONGVARCHAR)";
        db.execSQL(CREATE_SITE_TABLE);
    }

    public static void createOutboundPrefixTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS OutboundPrefix");
        String CREATE_SITE_TABLE = "CREATE TABLE OutboundPrefix(id NUMERIC PRIMARY KEY,name LONGVARCHAR,siteId NUMERIC,prefix LONGVARCHAR,meetmePrefix LONGVARCHAR,optionOrder INTEGER DEFAULT 0,defaultRule INTEGER DEFAULT 0,nameCn LONGVARCHAR,nameTw LONGVARCHAR,nameEn LONGVARCHAR,countryNameCn LONGVARCHAR,countryNameTw LONGVARCHAR,countryNameEn LONGVARCHAR,countryCode LONGVARCHAR,cityCode LONGVARCHAR)";
        db.execSQL(CREATE_SITE_TABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSite(Context ctx, LiteSite site) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "addSite...." + String.valueOf(site));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("id", site.getId());
                values.put("name", site.getName());
                values.put("prefix", site.getPrefix());
                values.put("outboundPrefix", site.getOutboundPrefix());
                db.insert(TABLE_SITE, null, values);
            }
            finally {
                UCDBSite.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existSiteById(Context ctx, long siteId) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "existSiteById...." + siteId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            try {
                db = helper.getReadableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_SITE, "id=?", new String[]{String.valueOf(siteId)});
                bl = count > 0L;
            }
            catch (Throwable throwable) {
                UCDBSite.closeDb(db);
                throw throwable;
            }
            UCDBSite.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteSite getSite(Context ctx, long id) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "getSite...." + id);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                LiteSite liteSite;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_SITE, new String[]{"id", "name", "prefix", "outboundPrefix"}, "id=?", new String[]{String.valueOf(id)}, null, null, null, null);
                    if (cursor == null || cursor.getCount() <= 0) break block5;
                    cursor.moveToFirst();
                    LiteSite site = new LiteSite();
                    site.setId(Long.parseLong(cursor.getString(0)));
                    site.setName(cursor.getString(1));
                    site.setPrefix(cursor.getString(2));
                    site.setOutboundPrefix(cursor.getString(3));
                    liteSite = site;
                }
                catch (Throwable throwable) {
                    UCDBSite.closeCursor(cursor);
                    UCDBSite.closeDb(db);
                    throw throwable;
                }
                UCDBSite.closeCursor(cursor);
                UCDBSite.closeDb(db);
                return liteSite;
            }
            LiteSite liteSite = null;
            UCDBSite.closeCursor(cursor);
            UCDBSite.closeDb(db);
            return liteSite;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteSite getSiteByPrefix(Context ctx, String prefix) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "getSiteByPrefix...." + prefix);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                LiteSite liteSite;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_SITE, new String[]{"id", "name", "prefix", "outboundPrefix"}, "prefix=?", new String[]{prefix}, null, null, null, null);
                    if (cursor == null || cursor.getCount() <= 0) break block5;
                    cursor.moveToFirst();
                    LiteSite site = new LiteSite();
                    site.setId(Long.parseLong(cursor.getString(0)));
                    site.setName(cursor.getString(1));
                    site.setPrefix(cursor.getString(2));
                    site.setOutboundPrefix(cursor.getString(3));
                    liteSite = site;
                }
                catch (Throwable throwable) {
                    UCDBSite.closeCursor(cursor);
                    UCDBSite.closeDb(db);
                    throw throwable;
                }
                UCDBSite.closeCursor(cursor);
                UCDBSite.closeDb(db);
                return liteSite;
            }
            LiteSite liteSite = null;
            UCDBSite.closeCursor(cursor);
            UCDBSite.closeDb(db);
            return liteSite;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LiteSite> getAllSites(Context ctx) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "getAllSites....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<LiteSite> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<LiteSite> siteList = new ArrayList<LiteSite>();
                String selectQuery = "SELECT  * FROM Site";
                cursor = db.rawQuery(selectQuery, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        LiteSite site = new LiteSite();
                        site.setId(Long.parseLong(cursor.getString(0)));
                        site.setName(cursor.getString(1));
                        site.setPrefix(cursor.getString(2));
                        site.setOutboundPrefix(cursor.getString(3));
                        siteList.add(site);
                    } while (cursor.moveToNext());
                }
                arrayList = siteList;
            }
            catch (Throwable throwable) {
                UCDBSite.closeCursor(cursor);
                UCDBSite.closeDb(db);
                throw throwable;
            }
            UCDBSite.closeCursor(cursor);
            UCDBSite.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSitesCount(Context ctx) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "getSitesCount....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            int n;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                String countQuery = "SELECT COUNT(*) FROM Site";
                cursor = db.rawQuery(countQuery, null);
                n = cursor.getInt(0);
            }
            catch (Throwable throwable) {
                UCDBSite.closeCursor(cursor);
                UCDBSite.closeDb(db);
                throw throwable;
            }
            UCDBSite.closeCursor(cursor);
            UCDBSite.closeDb(db);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSite(Context ctx, LiteSite site) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "updateSite...." + String.valueOf(site));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("name", site.getName());
                values.put("prefix", site.getPrefix());
                values.put("outboundPrefix", site.getOutboundPrefix());
                db.update(TABLE_SITE, values, "id = ?", new String[]{String.valueOf(site.getId())});
            }
            finally {
                UCDBSite.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSite(Context ctx, long siteId) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "deleteSite...." + siteId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_SITE, "id = ?", new String[]{String.valueOf(siteId)});
            }
            finally {
                UCDBSite.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllSites(Context ctx) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "deleteAllSites....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_SITE, null, null);
            }
            finally {
                UCDBSite.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOutboundPrefix(Context ctx, LiteOutboundPrefix outboundPrefix) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "addOutboundPrefix...." + String.valueOf(outboundPrefix));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = UCDBSite.getOutboundPrefixContentValues(outboundPrefix);
                db.insert(TABLE_OUTBOUND_PREFIX, null, values);
            }
            finally {
                UCDBSite.closeDb(db);
            }
        }
    }

    private static ContentValues getOutboundPrefixContentValues(LiteOutboundPrefix outboundPrefix) {
        ContentValues values = new ContentValues();
        values.put("id", outboundPrefix.getId());
        values.put("name", outboundPrefix.getName());
        values.put("siteId", outboundPrefix.getSiteId());
        values.put("prefix", outboundPrefix.getPrefix());
        values.put("meetmePrefix", outboundPrefix.getMeetmePrefix());
        values.put("optionOrder", outboundPrefix.getOrder());
        values.put("defaultRule", outboundPrefix.isDefaultRule() ? 1 : 0);
        values.put("nameCn", outboundPrefix.getNameCn());
        values.put("nameTw", outboundPrefix.getNameTw());
        values.put("nameEn", outboundPrefix.getNameEn());
        values.put("countryNameCn", outboundPrefix.getCountryNameCn());
        values.put("countryNameTw", outboundPrefix.getCountryNameTw());
        values.put("countryNameEn", outboundPrefix.getCountryNameEn());
        values.put("countryCode", outboundPrefix.getCountryCode());
        values.put("cityCode", outboundPrefix.getCityCode());
        return values;
    }

    private static void setOutboundPrefixFromCursor(Cursor cursor, LiteOutboundPrefix outboundPrefix) {
        outboundPrefix.setId(Long.parseLong(cursor.getString(0)));
        outboundPrefix.setName(cursor.getString(1));
        outboundPrefix.setSiteId(Long.parseLong(cursor.getString(2)));
        outboundPrefix.setPrefix(cursor.getString(3));
        outboundPrefix.setMeetmePrefix(cursor.getString(4));
        outboundPrefix.setOrder(cursor.getInt(5));
        outboundPrefix.setDefaultRule(cursor.getInt(6) == 1);
        outboundPrefix.setNameCn(cursor.getString(7));
        outboundPrefix.setNameTw(cursor.getString(8));
        outboundPrefix.setNameEn(cursor.getString(9));
        outboundPrefix.setCountryNameCn(cursor.getString(10));
        outboundPrefix.setCountryNameTw(cursor.getString(11));
        outboundPrefix.setCountryNameEn(cursor.getString(12));
        outboundPrefix.setCountryCode(cursor.getString(13));
        outboundPrefix.setCityCode(cursor.getString(14));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existOutboundPrefixById(Context ctx, long outboundPrefixId) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "existOutboundPrefixById...." + outboundPrefixId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            try {
                db = helper.getReadableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_OUTBOUND_PREFIX, "id=?", new String[]{String.valueOf(outboundPrefixId)});
                bl = count > 0L;
            }
            catch (Throwable throwable) {
                UCDBSite.closeDb(db);
                throw throwable;
            }
            UCDBSite.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteOutboundPrefix getDefaultOutboundPrefix(Context ctx, long siteId) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "getDefaultOutboundPrefix....siteId:" + siteId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            block5: {
                LiteOutboundPrefix liteOutboundPrefix;
                cursor = null;
                try {
                    SQLiteDatabase db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_OUTBOUND_PREFIX, outboundPrefixSelectColumns, "siteId=?", new String[]{String.valueOf(siteId)}, null, null, "defaultRule DESC, optionOrder ASC", null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    LiteOutboundPrefix outboundPrefix = new LiteOutboundPrefix();
                    UCDBSite.setOutboundPrefixFromCursor(cursor, outboundPrefix);
                    liteOutboundPrefix = outboundPrefix;
                }
                catch (Throwable throwable) {
                    UCDBSite.closeCursor(cursor);
                    throw throwable;
                }
                UCDBSite.closeCursor(cursor);
                return liteOutboundPrefix;
            }
            LiteOutboundPrefix liteOutboundPrefix = null;
            UCDBSite.closeCursor(cursor);
            return liteOutboundPrefix;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<LiteOutboundPrefix> getOutboundPrefixList(Context ctx, long siteId) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "getOutboundPrefixList....siteId:" + siteId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            block6: {
                ArrayList<LiteOutboundPrefix> arrayList;
                ArrayList<LiteOutboundPrefix> prefixList = new ArrayList<LiteOutboundPrefix>();
                cursor = null;
                try {
                    SQLiteDatabase db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_OUTBOUND_PREFIX, outboundPrefixSelectColumns, "siteId=?", new String[]{String.valueOf(siteId)}, null, null, "optionOrder ASC", null);
                    if (cursor == null || !cursor.moveToFirst()) break block6;
                    do {
                        LiteOutboundPrefix outboundPrefix = new LiteOutboundPrefix();
                        UCDBSite.setOutboundPrefixFromCursor(cursor, outboundPrefix);
                        prefixList.add(outboundPrefix);
                    } while (cursor.moveToNext());
                    arrayList = prefixList;
                }
                catch (Throwable throwable) {
                    UCDBSite.closeCursor(cursor);
                    throw throwable;
                }
                UCDBSite.closeCursor(cursor);
                return arrayList;
            }
            List<LiteOutboundPrefix> list = null;
            UCDBSite.closeCursor(cursor);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteOutboundPrefix getOutboundPrefix(Context ctx, long id) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "getSite...." + id);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                LiteOutboundPrefix liteOutboundPrefix;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_OUTBOUND_PREFIX, outboundPrefixSelectColumns, "id=?", new String[]{String.valueOf(id)}, null, null, null, null);
                    if (cursor == null || cursor.getCount() <= 0) break block5;
                    cursor.moveToFirst();
                    LiteOutboundPrefix outboundPrefix = new LiteOutboundPrefix();
                    UCDBSite.setOutboundPrefixFromCursor(cursor, outboundPrefix);
                    liteOutboundPrefix = outboundPrefix;
                }
                catch (Throwable throwable) {
                    UCDBSite.closeCursor(cursor);
                    UCDBSite.closeDb(db);
                    throw throwable;
                }
                UCDBSite.closeCursor(cursor);
                UCDBSite.closeDb(db);
                return liteOutboundPrefix;
            }
            LiteOutboundPrefix liteOutboundPrefix = null;
            UCDBSite.closeCursor(cursor);
            UCDBSite.closeDb(db);
            return liteOutboundPrefix;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getOutboundPrefixsCount(Context ctx) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "getOutboundPrefixsCount....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block4: {
                int n;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    String countQuery = "SELECT COUNT(*) FROM OutboundPrefix";
                    cursor = db.rawQuery(countQuery, null);
                    if (cursor == null || !cursor.moveToFirst()) break block4;
                    n = cursor.getInt(0);
                }
                catch (Throwable throwable) {
                    UCDBSite.closeCursor(cursor);
                    UCDBSite.closeDb(db);
                    throw throwable;
                }
                UCDBSite.closeCursor(cursor);
                UCDBSite.closeDb(db);
                return n;
            }
            UCDBSite.closeCursor(cursor);
            UCDBSite.closeDb(db);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LiteOutboundPrefix> getAllOutboundPrefixs(Context ctx) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "getAllOutboundPrefixs....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<LiteOutboundPrefix> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<LiteOutboundPrefix> prefixList = new ArrayList<LiteOutboundPrefix>();
                String orderBy = "prefix ASC";
                cursor = db.query(TABLE_OUTBOUND_PREFIX, outboundPrefixSelectColumns, null, null, null, null, orderBy);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        LiteOutboundPrefix outboundPrefix = new LiteOutboundPrefix();
                        UCDBSite.setOutboundPrefixFromCursor(cursor, outboundPrefix);
                        prefixList.add(outboundPrefix);
                    } while (cursor.moveToNext());
                }
                arrayList = prefixList;
            }
            catch (Throwable throwable) {
                UCDBSite.closeCursor(cursor);
                UCDBSite.closeDb(db);
                throw throwable;
            }
            UCDBSite.closeCursor(cursor);
            UCDBSite.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateOutboundPrefix(Context ctx, LiteOutboundPrefix outboundPrefix) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "updateSite...." + String.valueOf(outboundPrefix));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = UCDBSite.getOutboundPrefixContentValues(outboundPrefix);
                db.update(TABLE_OUTBOUND_PREFIX, values, "id = ?", new String[]{String.valueOf(outboundPrefix.getId())});
            }
            finally {
                UCDBSite.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteOutboundPrefix(Context ctx, long outboundPrefixId) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "deleteOutboundPrefix...." + outboundPrefixId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_OUTBOUND_PREFIX, "id = ?", new String[]{String.valueOf(outboundPrefixId)});
            }
            finally {
                UCDBSite.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllOutboundPrefixs(Context ctx) {
        UCDBHelper helper;
        UCDBSite._log(UCDBSite.class.getSimpleName(), "deleteAllOutboundPrefixs....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_OUTBOUND_PREFIX, null, null);
            }
            finally {
                UCDBSite.closeDb(db);
            }
        }
    }
}

