/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.bean.MsgBean;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcher;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcherResult;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class ChatEventCallLog {
    public static boolean handleCallLogEvent(Context context, int msgType, long chatEventId, JSONObject data, boolean isRead, boolean isListen, boolean isOldEvent) throws JSONException {
        if (!data.has("text")) {
            return true;
        }
        String packetId = data.getString("packetId");
        String fromJid = data.getString("fromJid");
        String phoneNumber = data.getString("text");
        long serverReceiveTime = data.getLong("timestamp");
        JSONObject props = data.getJSONObject("props");
        String myJid = PreferencesUtil.getUserJid(context);
        if (TextUtils.isBlank((CharSequence)phoneNumber)) {
            return true;
        }
        String chatRoomId = null;
        Long targetSiteId = null;
        if (JidUtil.isAPI000001UserJid(fromJid)) {
            boolean isOutbound = msgType == 1003 || msgType == 1004;
            PhoneMatcherResult result = PhoneMatcher.match(context, phoneNumber, isOutbound);
            if (result != null) {
                fromJid = result.getTargetJid();
                chatRoomId = result.getTargetJid();
                targetSiteId = result.getTargetSiteId();
                if (JidUtil.isChatConfJid(chatRoomId)) {
                    return true;
                }
                ChatRoomManager.checkAndGenerateChatRoomData(context, result.getTargetJid(), result.getTargetName(), false, true);
            } else {
                fromJid = phoneNumber;
                chatRoomId = ChatRoomManager.prepareExternalPhoneRoom(context);
            }
        } else if (JidUtil.isRingGroupJid(fromJid)) {
            fromJid = phoneNumber;
            chatRoomId = ChatRoomManager.prepareExternalPhoneRoom(context);
        } else {
            chatRoomId = fromJid;
            if (JidUtil.isChatConfJid(chatRoomId)) {
                return true;
            }
            ChatRoomManager.checkAndGenerateChatRoomData(context, chatRoomId, null, false, true);
        }
        long startTime = 0L;
        startTime = props != null && props.has("start") ? props.getLong("start") : serverReceiveTime;
        long contactRecordId = 0L;
        if (props != null && props.has("contactRecordId")) {
            contactRecordId = props.getLong("contactRecordId");
        }
        if (msgType == 1001) {
            if (props != null && props.has("srcSiteId")) {
                targetSiteId = props.getLong("srcSiteId");
            }
            String content = "[PHONE_CANCEL_IN2]_@@_" + ChatEventCallLog.toParam(targetSiteId) + "_@@_" + ChatEventCallLog.toParam(phoneNumber);
            MsgBean bean = new MsgBean();
            bean.setChatEventId(chatEventId);
            bean.setSyncEventId(-1L);
            bean.setChatRoomId(chatRoomId);
            bean.setPacketId(packetId);
            bean.setStatus("R");
            bean.setFromJid(fromJid);
            bean.setToJid(myJid);
            bean.setContent(content);
            bean.setMsgType(225);
            bean.setDuration(0L);
            bean.setRead(isRead);
            bean.setPlayed(isListen);
            bean.setReadCount(0);
            bean.setReaderList(null);
            bean.setLazy(false);
            bean.setPhoneNumber(phoneNumber);
            bean.setContactLogId(contactRecordId);
            bean.setProps(props != null ? props.toString() : null);
            UCDBMessage.addMessage(context, bean, startTime, isOldEvent);
            if (!isOldEvent) {
                BroadcastUtil.sendContactHistoryChangedEvent(context);
                BroadcastUtil.sendMsgChangedEvent(context, chatRoomId);
            }
            if (!isOldEvent && ChatRoomManager.isNotificationEnabled(context, chatRoomId) && !isRead) {
                BroadcastUtil.sendNotificationPopupEvent(context, chatRoomId, packetId);
            }
        } else if (msgType == 1002) {
            int duration = 0;
            if (props != null && props.has("duration")) {
                duration = props.getInt("duration");
            }
            if (props != null && props.has("srcSiteId")) {
                targetSiteId = props.getLong("srcSiteId");
            }
            String content = "[PHONE_TALKING]_@@_" + ChatEventCallLog.toParam(targetSiteId) + "_@@_" + ChatEventCallLog.toParam(phoneNumber) + "_@@_" + CommonUtil.getDurationSeconds(duration);
            MsgBean bean = new MsgBean();
            bean.setChatEventId(chatEventId);
            bean.setSyncEventId(-1L);
            bean.setChatRoomId(chatRoomId);
            bean.setPacketId(packetId);
            bean.setStatus("R");
            bean.setFromJid(fromJid);
            bean.setToJid(myJid);
            bean.setContent(content);
            bean.setMsgType(223);
            bean.setDuration(duration);
            bean.setRead(true);
            bean.setPlayed(true);
            bean.setReadCount(0);
            bean.setReaderList(null);
            bean.setLazy(false);
            bean.setPhoneNumber(phoneNumber);
            bean.setContactLogId(contactRecordId);
            bean.setProps(props != null ? props.toString() : null);
            UCDBMessage.addMessage(context, bean, startTime, isOldEvent);
            if (!isOldEvent) {
                BroadcastUtil.sendContactHistoryChangedEvent(context);
                BroadcastUtil.sendMsgChangedEvent(context, chatRoomId);
            }
        } else if (msgType == 1003) {
            if (props != null && props.has("dstSiteId")) {
                targetSiteId = props.getLong("dstSiteId");
            }
            String content = "[PHONE_CANCEL_OUT]_@@_" + ChatEventCallLog.toParam(targetSiteId) + "_@@_" + ChatEventCallLog.toParam(phoneNumber);
            MsgBean bean = new MsgBean();
            bean.setChatEventId(chatEventId);
            bean.setSyncEventId(-1L);
            bean.setChatRoomId(chatRoomId);
            bean.setPacketId(packetId);
            bean.setStatus("R");
            bean.setFromJid(myJid);
            bean.setToJid(fromJid);
            bean.setContent(content);
            bean.setMsgType(222);
            bean.setDuration(0L);
            bean.setRead(true);
            bean.setPlayed(true);
            bean.setReadCount(0);
            bean.setReaderList(null);
            bean.setLazy(false);
            bean.setPhoneNumber(phoneNumber);
            bean.setContactLogId(contactRecordId);
            bean.setProps(props != null ? props.toString() : null);
            UCDBMessage.addMessage(context, bean, startTime, isOldEvent);
            if (!isOldEvent) {
                BroadcastUtil.sendContactHistoryChangedEvent(context);
                BroadcastUtil.sendMsgChangedEvent(context, chatRoomId);
            }
        } else if (msgType == 1004) {
            int duration = 0;
            if (props != null && props.has("duration")) {
                duration = props.getInt("duration");
            }
            if (props != null && props.has("dstSiteId")) {
                targetSiteId = props.getLong("dstSiteId");
            }
            String content = "[PHONE_TALKING]_@@_" + ChatEventCallLog.toParam(targetSiteId) + "_@@_" + ChatEventCallLog.toParam(phoneNumber) + "_@@_" + CommonUtil.getDurationSeconds(duration);
            MsgBean bean = new MsgBean();
            bean.setChatEventId(chatEventId);
            bean.setSyncEventId(-1L);
            bean.setChatRoomId(chatRoomId);
            bean.setPacketId(packetId);
            bean.setStatus("R");
            bean.setFromJid(myJid);
            bean.setToJid(fromJid);
            bean.setContent(content);
            bean.setMsgType(221);
            bean.setDuration(duration);
            bean.setRead(true);
            bean.setPlayed(true);
            bean.setReadCount(0);
            bean.setReaderList(null);
            bean.setLazy(false);
            bean.setPhoneNumber(phoneNumber);
            bean.setContactLogId(contactRecordId);
            bean.setProps(props != null ? props.toString() : null);
            UCDBMessage.addMessage(context, bean, startTime, isOldEvent);
            if (!isOldEvent) {
                BroadcastUtil.sendContactHistoryChangedEvent(context);
                BroadcastUtil.sendMsgChangedEvent(context, chatRoomId);
            }
        }
        return msgType != 1001;
    }

    private static String toParam(Long siteId) {
        if (siteId == null) {
            return " ";
        }
        return siteId.toString();
    }

    private static String toParam(String value) {
        if (TextUtils.isBlank((CharSequence)value)) {
            return " ";
        }
        return value;
    }
}

