/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.bean.ReaderCountBean;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Base64;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.FileBean;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.MsgBean;
import com.blisscloud.mobile.ezuc.bean.NoticeBean;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UCDBRemoteMark;
import com.blisscloud.mobile.ezuc.manager.ChatEventCallLog;
import com.blisscloud.mobile.ezuc.manager.ChatEventVoicemailRecord;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.CustomerManager;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.manager.task.UpdateSingleChatRoomMembersTask;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ChatEventManager {
    public static void processChatEventDetails(Context context, JSONObject dataObj) {
        try {
            String roomJid = null;
            long id = dataObj.getLong("id");
            String source = dataObj.getString("source");
            JSONObject chatdata = dataObj.getJSONObject("data");
            String packetId = chatdata.getString("packetId");
            if ("notifyTextMsgReceived".equals(source)) {
                String fromJID = chatdata.getString("fromJid");
                JSONObject props = chatdata.getJSONObject("props");
                roomJid = fromJID;
                if (JidUtil.isBcAnnouncerJid(fromJID)) {
                    String thumbnail = null;
                    if (props.has("attachementList")) {
                        try {
                            JSONObject item;
                            JSONArray ary = props.getJSONArray("attachementList");
                            if (ary != null && ary.length() > 0 && (item = ary.getJSONObject(0)).has("thumbnail")) {
                                thumbnail = item.getString("thumbnail");
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                    if (thumbnail != null) {
                        UCDBMessage.updateNoticeThumbnail(context, id, thumbnail);
                    }
                } else {
                    roomJid = JidUtil.jidTranslate(fromJID);
                    String content = chatdata.getString("text");
                    if (content == null || TextUtils.isEmpty((CharSequence)content.trim())) {
                        return;
                    }
                    int type = props.optInt("message_type", 0);
                    if (type == 1 || type == 6) {
                        UCDBMessage.updateMessageContent(context, id, content);
                    }
                }
            } else if ("syncTextMsgSent".equals(source) || "notifyRoomTextMsgReceived".equals(source)) {
                String content = null;
                content = "syncTextMsgSent".equals(source) ? chatdata.getString("content") : chatdata.getString("text");
                JSONObject props = chatdata.getJSONObject("props");
                if (content == null || TextUtils.isEmpty((CharSequence)content.trim())) {
                    return;
                }
                if ("syncTextMsgSent".equals(source)) {
                    String receiverJID = chatdata.getString("receiverJid");
                    roomJid = JidUtil.jidTranslate(receiverJID);
                } else {
                    roomJid = chatdata.getString("roomJid");
                }
                int type = props.optInt("message_type", 0);
                if (type == 1 || type == 6) {
                    UCDBMessage.updateMessageContent(context, id, content);
                }
            } else if ("notifyFileMsgReceived".equals(source) || "syncFileMsgSent".equals(source) || "notifyRoomFileMsgReceived".equals(source)) {
                if ("notifyFileMsgReceived".equals(source)) {
                    String fromJID = chatdata.getString("fromJid");
                    roomJid = JidUtil.jidTranslate(fromJID);
                } else if ("syncFileMsgSent".equals(source)) {
                    String receiverJID = chatdata.getString("receiverJid");
                    roomJid = JidUtil.jidTranslate(receiverJID);
                } else {
                    roomJid = chatdata.getString("roomJid");
                }
                String fileContent = chatdata.getString("fileContent");
                UCDBMessage.updateMessageContent(context, id, fileContent);
            }
            if (PreferencesUtil.isSyncOldChatEventDone(context)) {
                BroadcastUtil.sendMsgChangedEventByPacketId(context, roomJid, packetId);
            }
        }
        catch (JSONException e) {
            Log.e(ChatEventManager.class.getSimpleName(), "chatevent:" + e.getLocalizedMessage(), e);
        }
    }

    public static void processChatEventLocal(Context context, JSONObject dataObj, boolean isOldEvent, ConcurrentHashMap<String, ReaderCountBean> downloadFileTaskMap) {
        try {
            long lastChatEventId;
            long id = dataObj.getLong("id");
            if (id > -1L && id > (lastChatEventId = PreferencesUtil.getLastChatEventId(context).longValue())) {
                PreferencesUtil.setLastChatEventId(context, id);
            }
            String source = dataObj.getString("source");
            boolean isRead = false;
            boolean isPlayed = false;
            if (dataObj.has("read")) {
                isRead = dataObj.getBoolean("read");
            }
            if (dataObj.has("played")) {
                isPlayed = dataObj.getBoolean("played");
            } else if (isRead) {
                isPlayed = true;
            }
            JSONObject chatdata = dataObj.getJSONObject("data");
            boolean showMarkRead = false;
            if ("deleteChatEvent".equals(source)) {
                String chatEventIds;
                if (chatdata.has("roomJid")) {
                    String roomJid = chatdata.getString("roomJid");
                    if (JidUtil.isChatConfJid(roomJid)) {
                        ChatRoomManager.clearChatMsg(context, roomJid);
                        if (!isOldEvent) {
                            BroadcastUtil.sendChatRoomMsgDeletedEvent(context, roomJid);
                            BroadcastUtil.sendContactHistoryChangedEvent(context);
                            BroadcastUtil.sendMsgChangedEvent(context);
                        }
                    }
                } else if (chatdata.has("userJid")) {
                    String userJid = chatdata.getString("userJid");
                    if (JidUtil.isEmployeeJid(userJid)) {
                        long timestamp = chatdata.getLong("timestamp");
                        ChatRoomManager.clearChatMsgByTimestamp(context, userJid, timestamp);
                        if (!isOldEvent) {
                            BroadcastUtil.sendChatRoomMsgDeletedEvent(context, userJid);
                            BroadcastUtil.sendContactHistoryChangedEvent(context);
                            BroadcastUtil.sendMsgChangedEvent(context);
                        }
                    }
                } else if (chatdata.has("chatEventIds") && TextUtils.isNotBlank((CharSequence)(chatEventIds = chatdata.getString("chatEventIds")))) {
                    String[] eventIds = chatEventIds.split(",");
                    for (int i = 0; eventIds != null && i < eventIds.length; ++i) {
                        String chatEventIdStr = eventIds[i];
                        try {
                            Message msg;
                            long eventId = Long.parseLong(chatEventIdStr);
                            if (eventId <= 0L || (msg = UCDBMessage.findMsgByEventId(context, eventId)) == null) continue;
                            ChatRoomManager.clearSpecificChatMsg(context, msg.getId());
                            BroadcastUtil.sendMsgDeletedEvent(context, msg.getPacketId());
                            continue;
                        }
                        catch (Throwable eventId) {
                            // empty catch block
                        }
                    }
                    if (!isOldEvent) {
                        BroadcastUtil.sendContactHistoryChangedEvent(context);
                        BroadcastUtil.sendMsgChangedEvent(context);
                    }
                }
                showMarkRead = true;
            } else if ("getRoomMembersSucceedNew".equals(source)) {
                UpdateSingleChatRoomMembersTask task = new UpdateSingleChatRoomMembersTask(context, chatdata);
                TaskController.getInstance().addTask(task);
                task.start();
                showMarkRead = true;
            } else if ("getRoomMembersFailedNew".equals(source)) {
                if (chatdata == null || !chatdata.has("roomJid")) {
                    return;
                }
                String chatRoomJid = chatdata.getString("roomJid");
                ChatRoomManager.cleanChatRoom(context, chatRoomJid, false);
                showMarkRead = true;
            } else if ("changeRoomSubjectFailed".equals(source)) {
                showMarkRead = true;
            } else if ("changeRoomSubjectSucceed".equals(source)) {
                String subject = chatdata.getString("subject");
                String roomJid = chatdata.getString("roomJid");
                String myJid = PreferencesUtil.getUserJid(context);
                ChatRoomManager.updateChatSubject(context, roomJid, subject, myJid);
                if (!isOldEvent) {
                    BroadcastUtil.sendChatRoomInfoUpdateEvent(context, roomJid);
                }
                showMarkRead = true;
            } else if ("notifyRoomSubjectUpdated".equals(source)) {
                if (isOldEvent) {
                    return;
                }
                String subject = chatdata.getString("subject");
                String roomJid = chatdata.getString("roomJid");
                String byParticipantJid = chatdata.getString("byParticipantJid");
                Log.i(ChatEventManager.class.getSimpleName(), "notifyRoomSubjectUpdated roomJID:" + roomJid + ", subject:" + subject + ", byParticipantJid:" + byParticipantJid);
                ChatRoomManager.updateChatSubject(context, roomJid, subject, byParticipantJid);
                if (!isOldEvent) {
                    BroadcastUtil.sendChatRoomInfoUpdateEvent(context, roomJid);
                }
                showMarkRead = true;
            } else if ("sendTextMsgSucceed".equals(source)) {
                String receiverJID = chatdata.getString("receiverJid");
                String packetId = chatdata.getString("packetId");
                ChatRoomManager.updateMessageStatusWithEvent(context, receiverJID, packetId, null, "S", isOldEvent);
                showMarkRead = true;
            } else if ("sendTextMsgFailed".equals(source)) {
                String receiverJID = chatdata.getString("receiverJid");
                String packetId = chatdata.getString("packetId");
                String errorMsg = ChatEventManager.errorMsg(chatdata);
                ChatRoomManager.updateMessageStatusWithEvent(context, receiverJID, packetId, errorMsg, "E", isOldEvent);
                showMarkRead = true;
            } else if ("sendFileMsgSucceed".equals(source)) {
                String receiverJID = chatdata.getString("receiverJid");
                String packetId = chatdata.getString("packetId");
                ChatRoomManager.updateMessageStatusWithEvent(context, receiverJID, packetId, null, "S", isOldEvent);
                showMarkRead = true;
            } else if ("sendFileMsgFailed".equals(source)) {
                String receiverJID = chatdata.getString("receiverJid");
                String packetId = chatdata.getString("packetId");
                String errorMsg = ChatEventManager.errorMsg(chatdata);
                ChatRoomManager.updateMessageStatusWithEvent(context, receiverJID, packetId, errorMsg, "E", isOldEvent);
                showMarkRead = true;
            } else if ("sendRoomTextMsgSucceed".equals(source)) {
                String roomJID = chatdata.getString("roomJid");
                String packetId = chatdata.getString("packetId");
                ChatRoomManager.updateMessageStatusWithEvent(context, roomJID, packetId, null, "S", isOldEvent);
                showMarkRead = true;
            } else if ("sendRoomTextMsgFailed".equals(source)) {
                String roomJID = chatdata.getString("roomJid");
                String packetId = chatdata.getString("packetId");
                String errorMsg = ChatEventManager.errorMsg(chatdata);
                ChatRoomManager.updateMessageStatusWithEvent(context, roomJID, packetId, errorMsg, "E", isOldEvent);
                showMarkRead = true;
            } else if ("sendRoomFileMsgSucceed".equals(source)) {
                String roomJID = chatdata.getString("roomJid");
                String packetId = chatdata.getString("packetId");
                ChatRoomManager.updateMessageStatusWithEvent(context, roomJID, packetId, null, "S", isOldEvent);
                showMarkRead = true;
            } else if ("sendRoomFMsgFailed".equals(source)) {
                String roomJID = chatdata.getString("roomJid");
                String packetId = chatdata.getString("packetId");
                String errorMsg = ChatEventManager.errorMsg(chatdata);
                ChatRoomManager.updateMessageStatusWithEvent(context, roomJID, packetId, errorMsg, "E", isOldEvent);
                showMarkRead = true;
            } else if ("notifyMsgProcessed".equals(source)) {
                ChatEventManager.processNotifyMessageProcessed(context, chatdata, isOldEvent);
                showMarkRead = true;
            } else if ("notifyMsgDelivered".equals(source)) {
                ChatEventManager.processNotifyMessageDelivered(context, chatdata, isOldEvent);
                showMarkRead = true;
            } else if ("notifyMsgDisplayed".equals(source)) {
                ChatEventManager.processNotifyMessageDisplayed(context, chatdata, isOldEvent);
                showMarkRead = true;
            } else if ("notifyTextMsgReceived".equals(source)) {
                showMarkRead = ChatEventManager.processMessageReceived(context, id, chatdata, isRead, isPlayed, isOldEvent);
            } else if ("notifyFileMsgReceived".equals(source)) {
                showMarkRead = ChatEventManager.processFileReceived(context, id, chatdata, isRead, isPlayed, isOldEvent);
            } else if ("syncTextMsgSent".equals(source)) {
                if (chatdata != null) {
                    int readerCount = 0;
                    String readerList = null;
                    if (dataObj.has("readerCount")) {
                        readerCount = dataObj.getInt("readerCount");
                    }
                    if (dataObj.has("readerList")) {
                        readerList = dataObj.getString("readerList");
                    }
                    ChatEventManager.processSyncMessageReceived(context, id, chatdata, readerCount, readerList, isOldEvent);
                }
                showMarkRead = true;
            } else if ("syncFileMsgSent".equals(source)) {
                if (chatdata != null) {
                    int readerCount = 0;
                    String readerList = null;
                    if (dataObj.has("readerCount")) {
                        readerCount = dataObj.getInt("readerCount");
                    }
                    if (dataObj.has("readerList")) {
                        readerList = dataObj.getString("readerList");
                    }
                    ChatEventManager.processSyncFileReceived(context, id, chatdata, readerCount, readerList, isOldEvent);
                }
                showMarkRead = true;
            } else if ("syncRoomTextMsgSent".equals(source)) {
                if (isOldEvent && chatdata != null && chatdata.has("packetId")) {
                    String roomJID = chatdata.getString("roomJid");
                    String packetId = chatdata.getString("packetId");
                    int readerCount = 0;
                    String readerList = null;
                    long sycnEventId = -1L;
                    if (dataObj.has("readerCount")) {
                        readerCount = dataObj.getInt("readerCount");
                    }
                    if (dataObj.has("readerList")) {
                        readerList = dataObj.getString("readerList");
                    }
                    if (dataObj.has("chatEventId")) {
                        sycnEventId = dataObj.getLong("chatEventId");
                    }
                    if (UCDBMessage.isMessageExist(context, packetId)) {
                        UCDBMessage.updateSyncEventId(context, packetId, sycnEventId);
                        if (readerCount != 0) {
                            UCDBMessage.updateChatMsgReadCountInfo(context, packetId, readerCount, readerList);
                        }
                    } else {
                        downloadFileTaskMap.put(roomJID + "_" + packetId, new ReaderCountBean(readerCount, readerList, sycnEventId));
                    }
                }
                showMarkRead = true;
            } else if ("syncRoomFileMsgSent".equals(source)) {
                if (isOldEvent && chatdata != null && chatdata.has("packetId")) {
                    String roomJID = chatdata.getString("roomJid");
                    String packetId = chatdata.getString("packetId");
                    int readerCount = 0;
                    String readerList = null;
                    long sycnEventId = -1L;
                    if (dataObj.has("readerCount")) {
                        readerCount = dataObj.getInt("readerCount");
                    }
                    if (dataObj.has("readerList")) {
                        readerList = dataObj.getString("readerList");
                    }
                    if (dataObj.has("chatEventId")) {
                        sycnEventId = dataObj.getLong("chatEventId");
                    }
                    if (UCDBMessage.isMessageExist(context, packetId)) {
                        UCDBMessage.updateSyncEventId(context, packetId, sycnEventId);
                        if (readerCount != 0) {
                            UCDBMessage.updateChatMsgReadCountInfo(context, packetId, readerCount, readerList);
                        }
                    } else {
                        downloadFileTaskMap.put(roomJID + "_" + packetId, new ReaderCountBean(readerCount, readerList, sycnEventId));
                    }
                }
                showMarkRead = true;
            } else if ("notifyRoomParticipantJoined".equals(source)) {
                showMarkRead = true;
            } else if ("notifyRoomParticipantLeft".equals(source)) {
                showMarkRead = true;
            } else if ("notifyRoomUserAdded".equals(source)) {
                showMarkRead = ChatEventManager.processRoomUserAdded(context, id, chatdata, isRead, isPlayed, isOldEvent);
            } else if ("notifyRoomMemberAdded".equals(source)) {
                showMarkRead = ChatEventManager.processRoomMemberAdded(context, id, chatdata, isRead, isPlayed, isOldEvent);
            } else if ("notifyRoomUserRemoved".equals(source)) {
                showMarkRead = ChatEventManager.processRoomUserRemoved(context, id, chatdata, isRead, isPlayed, isOldEvent);
            } else if ("notifyRoomMemberRemoved".equals(source)) {
                showMarkRead = ChatEventManager.processRoomMemberRemoved(context, id, chatdata, isRead, isPlayed, isOldEvent);
            } else if ("notifyRoomMsgProcessed".equals(source)) {
                ChatEventManager.processNotifyRoomMsgProcessed(context, chatdata, isOldEvent);
                showMarkRead = true;
            } else if ("notifyRoomTextMsgReceived".equals(source)) {
                showMarkRead = ChatEventManager.processRoomMessageReceived(context, id, chatdata, isRead, isPlayed, isOldEvent, downloadFileTaskMap);
            } else if ("notifyRoomFileMsgReceived".equals(source)) {
                showMarkRead = ChatEventManager.processRoomFileReceived(context, id, chatdata, isRead, isPlayed, isOldEvent, downloadFileTaskMap);
            } else if ("removeRoomMembersSucceed".equals(source)) {
                showMarkRead = true;
            } else if ("removeRoomMembersFailed".equals(source)) {
                showMarkRead = true;
            } else if ("inviteRoomParticipantsSucceed".equals(source)) {
                ChatEventManager.inviteRoomParticipantsSucceed(context, chatdata);
                showMarkRead = true;
            } else if ("inviteRoomParticipantsFailed".equals(source)) {
                ChatEventManager.inviteRoomParticipantsFailed(context, chatdata);
                showMarkRead = true;
            } else if ("enterRoomSucceed".equals(source)) {
                ChatEventManager.processEnterRoomSucceed(context, chatdata, isOldEvent);
                showMarkRead = true;
            } else if ("enterRoomFailed".equals(source)) {
                ChatEventManager.processEnterRoomFailed(context, chatdata, isOldEvent);
                showMarkRead = true;
            } else if ("exitRoomSucceed".equals(source)) {
                ChatEventManager.processExitRoomSucceed(context, chatdata, isOldEvent);
                showMarkRead = true;
            } else if ("exitRoomNotExist".equals(source)) {
                ChatEventManager.processExitRoomNotExist(context, chatdata, isOldEvent);
                showMarkRead = true;
            } else if ("exitChatRoomFailed".equals(source)) {
                ChatEventManager.processExitRoomFailed(context, chatdata, isOldEvent);
                showMarkRead = true;
            } else if ("createChatRoomSucceed".equals(source)) {
                ChatEventManager.processCreateChatRoomSucceed(context, chatdata);
                showMarkRead = true;
            } else if ("createChatRoomFailed".equals(source)) {
                ChatEventManager.processCreateChatRoomFailed(context, chatdata);
                showMarkRead = true;
            } else {
                showMarkRead = "notifyPromptMessageReceived".equals(source) ? ChatEventManager.notifyPromptMessageReceived(context, id, chatdata, isRead, isPlayed, isOldEvent) : ("changePresenceSucceed".equals(source) ? true : true);
            }
            if (!isRead && showMarkRead && id > -1L) {
                UCDBRemoteMark.addRemoteMark(context, 3, id);
                WebAgent.getInstance().markChatEventAsRead(id);
            }
        }
        catch (JSONException e) {
            Log.e(ChatEventManager.class.getSimpleName(), "chatevent:" + e.getLocalizedMessage(), e);
        }
    }

    private static String handleEncodedMsg(JSONObject props, String decodedMsg) throws JSONException {
        if (props == null) {
            return decodedMsg;
        }
        if (props.has("org_msg")) {
            String originalEncodedMsg = props.getString("org_msg");
            return new String(Base64.decode(originalEncodedMsg, 0));
        }
        return ChatEventManager.trimQuote(decodedMsg);
    }

    public static String trimQuote(String str) {
        if (TextUtils.isBlank((CharSequence)str)) {
            return null;
        }
        String ret = str.trim();
        if (ret.startsWith("\"[") && ret.endsWith("]\"")) {
            return ret.substring(1, ret.length() - 1);
        }
        return ret;
    }

    private static String errorMsg(JSONObject data) {
        String errorMsg = null;
        if (data.has("errorMsg")) {
            try {
                errorMsg = data.getString("errorMsg");
            }
            catch (JSONException e) {
                Log.e(ChatEventManager.class.getSimpleName(), "errorMsg:" + e.getLocalizedMessage(), e);
            }
        }
        if (TextUtils.isBlank(errorMsg)) {
            errorMsg = "UnknownError";
        }
        return errorMsg;
    }

    private static void processNotifyMessageProcessed(Context context, JSONObject data, boolean isOldEvent) throws JSONException {
        if (!data.has("packetId")) {
            return;
        }
        String receiverJID = data.getString("receiverJid");
        String packetId = data.getString("packetId");
        UCDBMessage.updateChatMsgStatus(context, packetId, "PROCESSED");
        if (!isOldEvent) {
            BroadcastUtil.sendMsgStatusChangedEvent(context, receiverJID, packetId, "PROCESSED", null);
        }
    }

    private static void processNotifyMessageDelivered(Context context, JSONObject data, boolean isOldEvent) throws JSONException {
        if (!data.has("packetId")) {
            return;
        }
        String receiverJID = data.getString("receiverJid");
        String packetId = data.getString("packetId");
        UCDBMessage.updateChatMsgStatus(context, packetId, "D");
        if (!isOldEvent) {
            BroadcastUtil.sendMsgStatusChangedEvent(context, receiverJID, packetId, "D", null);
        }
    }

    private static void processNotifyMessageDisplayed(Context context, JSONObject data, boolean isOldEvent) throws JSONException {
        if (!data.has("packetId")) {
            return;
        }
        String receiverJID = data.getString("receiverJid");
        String packetId = data.getString("packetId");
        long serverReceiveTime = data.getLong("timestamp");
        Log.d(ChatEventManager.class.getSimpleName(), "notifyMessageDisplayed receiverJID:" + receiverJID + ", packetId:" + packetId + ", serverReceiveTime:" + serverReceiveTime);
        UCDBMessage.updateChatMsgStatus(context, packetId, "V");
        if (!isOldEvent) {
            BroadcastUtil.sendMsgStatusChangedEvent(context, receiverJID, packetId, "V", null);
        }
    }

    private static boolean processMessageReceived(Context context, long chatEventId, JSONObject data, boolean isRead, boolean isPlayed, boolean isOldEvent) throws JSONException {
        JSONObject props = data.getJSONObject("props");
        int msgType = -1;
        if (props != null && props.has("message_type")) {
            msgType = props.getInt("message_type");
        }
        if (msgType == 1001 || msgType == 1002 || msgType == 1003 || msgType == 1004) {
            return ChatEventCallLog.handleCallLogEvent(context, msgType, chatEventId, data, isRead, isPlayed, isOldEvent);
        }
        if (msgType == 1005 || msgType == 1006) {
            return ChatEventVoicemailRecord.handleMsg(context, msgType, chatEventId, data, isRead, isPlayed, isOldEvent);
        }
        return ChatEventManager.handleNormalChatEvent(context, chatEventId, data, isRead, isPlayed, isOldEvent);
    }

    private static boolean handleNormalChatEvent(Context context, long chatEventId, JSONObject data, boolean isRead, boolean isPlayed, boolean isOldEvent) throws JSONException {
        String fromJID = data.getString("fromJid");
        String packetId = data.getString("packetId");
        String text = null;
        if (data.has("text")) {
            text = data.getString("text");
        }
        long serverReceiveTime = data.getLong("timestamp");
        JSONObject props = data.getJSONObject("props");
        if (JidUtil.isBcAnnouncerJid(fromJID)) {
            text = ChatEventManager.handleEncodedMsg(props, text);
            String content = null;
            long fileSize = 0L;
            String fileName = null;
            String fileDownloadURL = null;
            String thumbnail = null;
            if (props.has("content")) {
                try {
                    content = props.getString("content");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (props.has("attachementList")) {
                try {
                    JSONArray ary = props.getJSONArray("attachementList");
                    if (ary != null && ary.length() > 0) {
                        JSONObject item = ary.getJSONObject(0);
                        if (item.has("content")) {
                            fileDownloadURL = item.getString("content");
                        }
                        if (item.has("thumbnail")) {
                            thumbnail = item.getString("thumbnail");
                        }
                        if (item.has("fileName")) {
                            fileName = item.getString("fileName");
                        }
                        if (item.has("fileSize")) {
                            fileSize = item.getLong("fileSize");
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            NoticeBean bean = new NoticeBean();
            bean.setChatEventId(chatEventId);
            bean.setPacketId(packetId);
            bean.setStatus("R");
            bean.setSubject(text);
            bean.setContent(content);
            bean.setFileSize(fileSize);
            bean.setFileName(fileName);
            bean.setFileDownloadURL(fileDownloadURL);
            bean.setThumbnail(thumbnail);
            bean.setRead(isRead);
            bean.setPlayed(isPlayed);
            bean.setLazy(thumbnail != null && "<LAZY>".equals(thumbnail));
            ChatRoomManager.newNoticeMsg(context, bean, serverReceiveTime, isOldEvent);
            if (!isOldEvent) {
                BroadcastUtil.sendContactHistoryChangedEvent(context);
                BroadcastUtil.sendMsgChangedEvent(context, fromJID);
            }
            if (!isOldEvent && ChatRoomManager.isNotificationEnabled(context, fromJID) && !isRead) {
                BroadcastUtil.sendNotificationPopupEvent(context, fromJID, packetId);
            }
            return false;
        }
        if (UCDBMessage.isMessageExist(context, packetId)) {
            return true;
        }
        boolean isLazy = false;
        String targetJid = JidUtil.jidTranslate(fromJID);
        int type = props.optInt("message_type", 0);
        long duration = props.optLong("duration", 0L);
        String title = null;
        if (type == 0) {
            text = ChatEventManager.handleEncodedMsg(props, text);
        } else if (type == 8) {
            text = ChatEventManager.handleEncodedMsg(props, text);
            title = props.optString("title");
        } else if (type == 9) {
            text = ChatEventManager.handleEncodedMsg(props, text);
            title = props.optString("title");
        }
        if (JidUtil.isCustomerJid(targetJid)) {
            CustomerManager.handleCustomer(context, targetJid, props, isOldEvent);
        }
        if (type == 0 && (text == null || TextUtils.isEmpty((CharSequence)text.trim()))) {
            return true;
        }
        if (!(type != 1 && type != 6 || text != null && !TextUtils.isEmpty((CharSequence)text.trim()))) {
            isLazy = true;
        }
        MsgBean bean = new MsgBean();
        bean.setChatEventId(chatEventId);
        bean.setSyncEventId(-1L);
        bean.setChatRoomId(targetJid);
        bean.setPacketId(packetId);
        bean.setStatus("R");
        bean.setFromJid(targetJid);
        bean.setToJid(PreferencesUtil.getUserJid(context));
        bean.setContent(text);
        bean.setMsgType(type);
        bean.setDuration(duration);
        bean.setRead(isRead);
        bean.setPlayed(isPlayed);
        bean.setReadCount(0);
        bean.setReaderList(null);
        bean.setAtMe(ChatEventManager.isAtMe(context, text));
        bean.setLazy(isLazy);
        bean.setTitle(title);
        bean.setProps(props != null ? props.toString() : null);
        ChatRoomManager.newIncomingChatMsg(context, targetJid, bean, serverReceiveTime, isOldEvent);
        if (!isOldEvent) {
            BroadcastUtil.sendContactHistoryChangedEvent(context);
            BroadcastUtil.sendMsgChangedEvent(context, targetJid);
        }
        if (!isOldEvent && ChatRoomManager.isNotificationEnabled(context, targetJid) && !isRead) {
            BroadcastUtil.sendNotificationPopupEvent(context, targetJid, packetId);
        }
        return false;
    }

    private static boolean isAtMe(Context ctx, String content) {
        LiteContact self = PreferencesUtil.getUserInfo(ctx);
        if (content != null && self != null) {
            String cName = ContactManager.getContactShortName(ctx, self, Locale.TAIWAN);
            String eName = ContactManager.getContactShortName(ctx, self, Locale.ENGLISH);
            if (content.contains("@" + cName) || content.contains("@" + eName) || content.contains("\uff20" + cName) || content.contains("\uff20" + eName) || content.toLowerCase().contains("@all") || content.toLowerCase().contains("\uff20all")) {
                return true;
            }
        }
        return false;
    }

    private static boolean processFileReceived(Context context, long chatEventId, JSONObject data, boolean isRead, boolean isPlayed, boolean isOldEvent) throws JSONException {
        String fromJID = data.getString("fromJid");
        String packetId = data.getString("packetId");
        String fileName = data.getString("fileName");
        long fileSize = data.optLong("fileSize", -1L);
        String fileContent = data.optString("fileContent", null);
        String fileDownloadURL = data.optString("fileDownloadURL", null);
        long serverReceiveTime = data.getLong("timestamp");
        JSONObject props = data.getJSONObject("props");
        String mimeType = props.optString("mimeType", null);
        String extraText = data.optString("text", null);
        if (UCDBMessage.isMessageExist(context, packetId)) {
            return true;
        }
        String targetJid = JidUtil.jidTranslate(fromJID);
        int type = props.optInt("message_type", 2);
        long duration = props.optLong("duration", 0L);
        if (JidUtil.isCustomerJid(targetJid)) {
            CustomerManager.handleCustomer(context, targetJid, props, isOldEvent);
        }
        FileBean bean = new FileBean();
        bean.setChatEventId(chatEventId);
        bean.setSyncEventId(-1L);
        bean.setChatRoomId(targetJid);
        bean.setPacketId(packetId);
        bean.setStatus("R");
        bean.setFromJid(targetJid);
        bean.setToJid(PreferencesUtil.getUserJid(context));
        bean.setFileContent(fileContent);
        bean.setFileName(fileName);
        bean.setFileSize(fileSize);
        bean.setFileDownloadURL(fileDownloadURL);
        bean.setMsgType(type);
        bean.setDuration(duration);
        bean.setRead(isRead);
        bean.setPlayed(isPlayed);
        bean.setReadCount(0);
        bean.setReaderList(null);
        bean.setLazy(fileContent == null);
        bean.setMimeType(mimeType);
        bean.setExtraText(extraText);
        ChatRoomManager.newIncomingChatFile(context, targetJid, bean, serverReceiveTime, isOldEvent);
        if (!isOldEvent) {
            BroadcastUtil.sendContactHistoryChangedEvent(context);
            BroadcastUtil.sendMsgChangedEvent(context, targetJid);
        }
        if (!isOldEvent && ChatRoomManager.isNotificationEnabled(context, targetJid) && !isRead) {
            BroadcastUtil.sendNotificationPopupEvent(context, targetJid, packetId);
        }
        return false;
    }

    private static void processSyncMessageReceived(Context context, long chatEventId, JSONObject data, int readCount, String readerList, boolean isOldEvent) throws JSONException {
        String account;
        String targetJid;
        if (!data.has("packetId")) {
            return;
        }
        if (!data.has("receiverJid")) {
            return;
        }
        String packetId = data.getString("packetId");
        if (UCDBMessage.isMessageExist(context, packetId)) {
            return;
        }
        boolean isLazy = false;
        String receiverJID = data.getString("receiverJid");
        String content = null;
        if (data.has("content")) {
            content = data.getString("content");
        }
        long serverReceiveTime = data.getLong("timestamp");
        JSONObject props = data.getJSONObject("props");
        int type = props.optInt("message_type", 0);
        long duration = props.optLong("duration", 0L);
        String title = null;
        if (type == 0) {
            content = ChatEventManager.handleEncodedMsg(props, content);
        } else if (type == 8) {
            content = ChatEventManager.handleEncodedMsg(props, content);
            title = props.optString("title");
        } else if (type == 9) {
            content = ChatEventManager.handleEncodedMsg(props, content);
            title = props.optString("title");
        }
        if (type == 0 && (content == null || TextUtils.isEmpty((CharSequence)content.trim()))) {
            return;
        }
        if (!(type != 1 && type != 6 || content != null && !TextUtils.isEmpty((CharSequence)content.trim()))) {
            isLazy = true;
        }
        if (JidUtil.isCustomerJid(targetJid = JidUtil.jidTranslate(receiverJID)) && CustomerManager.getCustomerInfo(context, account = JidUtil.convertKey(targetJid)) == null) {
            WebAgent.getInstance().getCustomerInfo(account);
        }
        MsgBean bean = new MsgBean();
        bean.setChatEventId(chatEventId);
        bean.setSyncEventId(-1L);
        bean.setChatRoomId(targetJid);
        bean.setPacketId(packetId);
        bean.setStatus("Y");
        bean.setFromJid(PreferencesUtil.getUserJid(context));
        bean.setToJid(targetJid);
        bean.setContent(content);
        bean.setMsgType(type);
        bean.setDuration(duration);
        bean.setRead(true);
        bean.setPlayed(true);
        bean.setReadCount(readCount);
        bean.setReaderList(readerList);
        bean.setLazy(isLazy);
        bean.setTitle(title);
        bean.setProps(props != null ? props.toString() : null);
        ChatRoomManager.newChatMsg(context, targetJid, bean, serverReceiveTime, isOldEvent);
        if (!isOldEvent) {
            BroadcastUtil.sendContactHistoryChangedEvent(context);
            BroadcastUtil.sendMsgChangedEvent(context, targetJid);
        }
    }

    private static void processSyncFileReceived(Context context, long chatEventId, JSONObject data, int readCount, String readerList, boolean isOldEvent) throws JSONException {
        String account;
        if (!data.has("packetId")) {
            return;
        }
        if (!data.has("receiverJid")) {
            return;
        }
        String packetId = data.getString("packetId");
        if (UCDBMessage.isMessageExist(context, packetId)) {
            return;
        }
        String receiverJID = data.getString("receiverJid");
        String fileName = data.getString("fileName");
        long fileSize = data.optLong("fileSize", -1L);
        String fileDownloadURL = data.optString("fileDownloadURL", null);
        String fileContent = data.optString("fileContent", null);
        long serverReceiveTime = data.getLong("timestamp");
        JSONObject props = data.getJSONObject("props");
        String mimeType = props.optString("mimeType", null);
        String extraText = data.optString("text", null);
        String targetJid = JidUtil.jidTranslate(receiverJID);
        int type = props.optInt("message_type", 2);
        long duration = props.optLong("duration", 0L);
        if (JidUtil.isCustomerJid(targetJid) && CustomerManager.getCustomerInfo(context, account = JidUtil.convertKey(targetJid)) == null) {
            WebAgent.getInstance().getCustomerInfo(account);
        }
        FileBean bean = new FileBean();
        bean.setChatEventId(chatEventId);
        bean.setSyncEventId(-1L);
        bean.setChatRoomId(targetJid);
        bean.setPacketId(packetId);
        bean.setStatus("Y");
        bean.setFromJid(PreferencesUtil.getUserJid(context));
        bean.setToJid(targetJid);
        bean.setFileContent(fileContent);
        bean.setFileName(fileName);
        bean.setFileSize(fileSize);
        bean.setFileDownloadURL(fileDownloadURL);
        bean.setMsgType(type);
        bean.setDuration(duration);
        bean.setRead(true);
        bean.setPlayed(true);
        bean.setMimeType(mimeType);
        bean.setExtraText(extraText);
        bean.setReadCount(readCount);
        bean.setReaderList(readerList);
        bean.setLazy(fileContent == null);
        ChatRoomManager.newChatFile(context, targetJid, bean, serverReceiveTime, isOldEvent);
        if (!isOldEvent) {
            BroadcastUtil.sendContactHistoryChangedEvent(context);
            BroadcastUtil.sendMsgChangedEvent(context, targetJid);
        }
    }

    private static boolean processRoomUserAdded(Context context, long chatEventId, JSONObject data, boolean isRead, boolean isPlayed, boolean isOldEvent) throws JSONException {
        return ChatRoomManager.userAdd(context, chatEventId, data, isRead, isPlayed, isOldEvent);
    }

    private static boolean processRoomMemberAdded(Context context, long chatEventId, JSONObject data, boolean isRead, boolean isPlayed, boolean isOldEvent) throws JSONException {
        return ChatRoomManager.memberAdd(context, chatEventId, data, isRead, isPlayed, isOldEvent);
    }

    private static boolean processRoomUserRemoved(Context context, long chatEventId, JSONObject data, boolean isRead, boolean isPlayed, boolean isOldEvent) throws JSONException {
        boolean history = data.getBoolean("history");
        if (history) {
            return true;
        }
        return ChatRoomManager.userRemoved(context, chatEventId, data, isRead, isPlayed, isOldEvent);
    }

    private static boolean processRoomMemberRemoved(Context context, long chatEventId, JSONObject data, boolean isRead, boolean isPlayed, boolean isOldEvent) throws JSONException {
        return ChatRoomManager.memberRemoved(context, chatEventId, data, isRead, isPlayed, isOldEvent);
    }

    private static boolean processRoomMessageReceived(Context context, long chatEventId, JSONObject data, boolean isRead, boolean isPlayed, boolean isOldEvent, ConcurrentHashMap<String, ReaderCountBean> downloadFileTaskMap) throws JSONException {
        if (!data.has("roomJid")) {
            return true;
        }
        if (!data.has("packetId")) {
            return true;
        }
        if (!data.has("timestamp")) {
            return true;
        }
        if (!data.has("participantJid")) {
            return true;
        }
        String roomJID = data.getString("roomJid");
        String packetId = data.getString("packetId");
        long serverReceiveTime = data.getLong("timestamp");
        String participantJid = data.getString("participantJid");
        boolean isLazy = false;
        String text = null;
        if (data.has("text")) {
            text = data.getString("text");
        }
        JSONObject props = data.getJSONObject("props");
        if (participantJid.equals(PreferencesUtil.getUserJid(context))) {
            if (ChatRoomManager.isMessageExist(context, roomJID, packetId, participantJid, roomJID)) {
                UCDBMessage.updateChatMsgStatus(context, packetId, "D");
                UCDBMessage.updateChatEventId(context, packetId, chatEventId);
                if (!isOldEvent) {
                    BroadcastUtil.sendContactHistoryChangedEvent(context);
                    BroadcastUtil.sendMsgStatusChangedEvent(context, roomJID, packetId);
                }
            } else {
                int type = props.optInt("message_type", 0);
                long duration = props.optLong("duration", 0L);
                String title = null;
                if (type == 0) {
                    text = ChatEventManager.handleEncodedMsg(props, text);
                } else if (type == 8) {
                    text = ChatEventManager.handleEncodedMsg(props, text);
                    title = props.optString("title");
                } else if (type == 9) {
                    text = ChatEventManager.handleEncodedMsg(props, text);
                    title = props.optString("title");
                }
                if (type == 0 && (text == null || TextUtils.isEmpty((CharSequence)text.trim()))) {
                    return true;
                }
                if (!(type != 1 && type != 6 || text != null && !TextUtils.isEmpty((CharSequence)text.trim()))) {
                    isLazy = true;
                }
                String key = roomJID + "_" + packetId;
                ReaderCountBean cacheReaderData = null;
                if (downloadFileTaskMap.containsKey(key)) {
                    cacheReaderData = downloadFileTaskMap.get(roomJID + "_" + packetId);
                    downloadFileTaskMap.remove(key);
                }
                MsgBean bean = new MsgBean();
                bean.setChatEventId(chatEventId);
                if (cacheReaderData != null) {
                    bean.setSyncEventId(cacheReaderData.getSyncEventId());
                } else {
                    bean.setSyncEventId(-1L);
                }
                bean.setChatRoomId(roomJID);
                bean.setPacketId(packetId);
                bean.setStatus("D");
                bean.setFromJid(participantJid);
                bean.setToJid(roomJID);
                bean.setContent(text);
                bean.setMsgType(type);
                bean.setDuration(duration);
                bean.setRead(true);
                bean.setPlayed(true);
                if (cacheReaderData != null && cacheReaderData.getReaderCount() != 0) {
                    bean.setReadCount(cacheReaderData.getReaderCount());
                    bean.setReaderList(cacheReaderData.getReaderList());
                } else {
                    bean.setReadCount(0);
                    bean.setReaderList(null);
                }
                bean.setAtMe(ChatEventManager.isAtMe(context, text));
                bean.setLazy(isLazy);
                bean.setTitle(title);
                bean.setProps(props != null ? props.toString() : null);
                ChatRoomManager.newIncomingChatMsg(context, roomJID, bean, serverReceiveTime, isOldEvent);
                if (!isOldEvent) {
                    BroadcastUtil.sendContactHistoryChangedEvent(context);
                    BroadcastUtil.sendMsgChangedEvent(context, roomJID);
                }
            }
            return true;
        }
        int type = props.optInt("message_type", 0);
        long duration = props.optLong("duration", 0L);
        String title = null;
        if (type == 0) {
            text = ChatEventManager.handleEncodedMsg(props, text);
        } else if (type == 8) {
            text = ChatEventManager.handleEncodedMsg(props, text);
            title = props.optString("title");
        } else if (type == 9) {
            text = ChatEventManager.handleEncodedMsg(props, text);
            title = props.optString("title");
        }
        if (type == 0 && (text == null || TextUtils.isEmpty((CharSequence)text.trim()))) {
            return true;
        }
        if (!(type != 1 && type != 6 || text != null && !TextUtils.isEmpty((CharSequence)text.trim()))) {
            isLazy = true;
        }
        MsgBean bean = new MsgBean();
        bean.setChatEventId(chatEventId);
        bean.setSyncEventId(-1L);
        bean.setChatRoomId(roomJID);
        bean.setPacketId(packetId);
        bean.setStatus("R");
        bean.setFromJid(participantJid);
        bean.setToJid(PreferencesUtil.getUserJid(context));
        bean.setContent(text);
        bean.setMsgType(type);
        bean.setDuration(duration);
        bean.setRead(isRead);
        bean.setPlayed(isPlayed);
        bean.setReadCount(0);
        bean.setReaderList(null);
        bean.setAtMe(ChatEventManager.isAtMe(context, text));
        bean.setLazy(isLazy);
        bean.setTitle(title);
        bean.setProps(props != null ? props.toString() : null);
        ChatRoomManager.newIncomingChatMsg(context, roomJID, bean, serverReceiveTime, isOldEvent);
        if (!isOldEvent) {
            BroadcastUtil.sendContactHistoryChangedEvent(context);
            BroadcastUtil.sendMsgChangedEvent(context, roomJID);
        }
        if (!isOldEvent && ChatRoomManager.isNotificationEnabled(context, roomJID) && !isRead) {
            BroadcastUtil.sendNotificationPopupEvent(context, roomJID, packetId);
        }
        return false;
    }

    private static boolean processRoomFileReceived(Context context, long chatEventId, JSONObject data, boolean isRead, boolean isPlayed, boolean isOldEvent, ConcurrentHashMap<String, ReaderCountBean> downloadFileTaskMap) throws JSONException {
        if (!data.has("roomJid")) {
            return true;
        }
        if (!data.has("packetId")) {
            return true;
        }
        if (!data.has("timestamp")) {
            return true;
        }
        if (!data.has("participantJid")) {
            return true;
        }
        String roomJID = data.getString("roomJid");
        String packetId = data.getString("packetId");
        long serverReceiveTime = data.getLong("timestamp");
        String participantJid = data.getString("participantJid");
        String fileName = null;
        if (data.has("fileName")) {
            fileName = data.getString("fileName");
        }
        if (fileName == null || "".equals(fileName.trim())) {
            return true;
        }
        String fileContent = data.optString("fileContent", null);
        long fileSize = data.optLong("fileSize", -1L);
        String fileDownloadURL = data.optString("fileDownloadURL", null);
        JSONObject props = data.getJSONObject("props");
        if (participantJid.equals(PreferencesUtil.getUserJid(context))) {
            if (ChatRoomManager.isMessageExist(context, roomJID, packetId, participantJid, roomJID)) {
                UCDBMessage.updateChatMsgStatus(context, packetId, "D");
                UCDBMessage.updateChatEventId(context, packetId, chatEventId);
                if (!isOldEvent) {
                    BroadcastUtil.sendContactHistoryChangedEvent(context);
                    BroadcastUtil.sendMsgStatusChangedEvent(context, roomJID, packetId);
                }
            } else {
                int type = props.optInt("message_type", 2);
                long duration = props.optLong("duration", 0L);
                String mimeType = props.optString("mimeType", null);
                String extraText = data.optString("text", null);
                String key = roomJID + "_" + packetId;
                ReaderCountBean cacheReaderData = null;
                if (downloadFileTaskMap.containsKey(key)) {
                    cacheReaderData = downloadFileTaskMap.get(roomJID + "_" + packetId);
                    downloadFileTaskMap.remove(key);
                }
                FileBean bean = new FileBean();
                bean.setChatEventId(chatEventId);
                if (cacheReaderData != null) {
                    bean.setSyncEventId(cacheReaderData.getSyncEventId());
                } else {
                    bean.setSyncEventId(-1L);
                }
                bean.setChatRoomId(roomJID);
                bean.setPacketId(packetId);
                bean.setStatus("D");
                bean.setFromJid(participantJid);
                bean.setToJid(roomJID);
                bean.setFileContent(fileContent);
                bean.setFileName(fileName);
                bean.setFileSize(fileSize);
                bean.setFileDownloadURL(fileDownloadURL);
                bean.setMsgType(type);
                bean.setDuration(duration);
                bean.setRead(isRead);
                bean.setPlayed(isPlayed);
                bean.setMimeType(mimeType);
                bean.setExtraText(extraText);
                if (cacheReaderData != null && cacheReaderData.getReaderCount() != 0) {
                    bean.setReadCount(cacheReaderData.getReaderCount());
                    bean.setReaderList(cacheReaderData.getReaderList());
                } else {
                    bean.setReadCount(0);
                    bean.setReaderList(null);
                }
                bean.setLazy(fileContent == null);
                ChatRoomManager.newIncomingChatFile(context, roomJID, bean, serverReceiveTime, isOldEvent);
                if (!isOldEvent) {
                    BroadcastUtil.sendContactHistoryChangedEvent(context);
                    BroadcastUtil.sendMsgChangedEvent(context, roomJID);
                }
            }
            return true;
        }
        int type = props.optInt("message_type", 2);
        long duration = props.optLong("duration", 0L);
        String mimeType = props.optString("mimeType", null);
        String extraText = data.optString("text", null);
        FileBean bean = new FileBean();
        bean.setChatEventId(chatEventId);
        bean.setSyncEventId(-1L);
        bean.setChatRoomId(roomJID);
        bean.setPacketId(packetId);
        bean.setStatus("D");
        bean.setFromJid(participantJid);
        bean.setToJid(PreferencesUtil.getUserJid(context));
        bean.setFileContent(fileContent);
        bean.setFileName(fileName);
        bean.setFileSize(fileSize);
        bean.setFileDownloadURL(fileDownloadURL);
        bean.setMsgType(type);
        bean.setDuration(duration);
        bean.setRead(isRead);
        bean.setPlayed(isPlayed);
        bean.setMimeType(mimeType);
        bean.setExtraText(extraText);
        bean.setReadCount(0);
        bean.setReaderList(null);
        bean.setLazy(fileContent == null);
        ChatRoomManager.newIncomingChatFile(context, roomJID, bean, serverReceiveTime, isOldEvent);
        if (!isOldEvent) {
            BroadcastUtil.sendContactHistoryChangedEvent(context);
            BroadcastUtil.sendMsgChangedEvent(context, roomJID);
        }
        if (!isOldEvent && ChatRoomManager.isNotificationEnabled(context, roomJID) && !isRead) {
            BroadcastUtil.sendNotificationPopupEvent(context, roomJID, packetId);
        }
        return false;
    }

    private static void processNotifyRoomMsgProcessed(Context context, JSONObject data, boolean isOldEvent) throws JSONException {
        String roomJID = data.getString("roomJid");
        String packetId = data.getString("packetId");
        long serverReceiveTime = data.getLong("timestamp");
        Log.d(ChatEventManager.class.getSimpleName(), "notifyRoomMessageProcessed roomJID:" + roomJID + ", packetId:" + packetId + ", time:" + serverReceiveTime);
        UCDBMessage.updateChatMsgStatus(context, packetId, "PROCESSED");
        if (!isOldEvent) {
            BroadcastUtil.sendMsgStatusChangedEvent(context, roomJID, packetId, "PROCESSED", null);
        }
    }

    private static void processEnterRoomSucceed(Context context, JSONObject data, boolean isOldEvent) throws JSONException {
    }

    private static void processEnterRoomFailed(Context context, JSONObject data, boolean isOldEvent) throws JSONException {
    }

    private static void processExitRoomSucceed(Context context, JSONObject data, boolean isOldEvent) throws JSONException {
        String roomJID = data.getString("roomJid");
        Log.d(ChatEventManager.class.getName(), "processExitRoomSucceed roomJID:" + roomJID);
        ChatRoomManager.cleanChatRoom(context, roomJID, false);
        if (!isOldEvent) {
            BroadcastUtil.sendChatRoomRemovedEvent(context, roomJID);
        }
    }

    private static void processExitRoomNotExist(Context context, JSONObject data, boolean isOldEvent) throws JSONException {
        String roomJID = data.getString("roomJid");
        Log.d(ChatEventManager.class.getName(), "processExitRoomNotExist roomJID:" + roomJID);
        ChatRoomManager.cleanChatRoom(context, roomJID, false);
        if (!isOldEvent) {
            BroadcastUtil.sendChatRoomRemovedEvent(context, roomJID);
        }
    }

    private static void processExitRoomFailed(Context context, JSONObject data, boolean isOldEvent) throws JSONException {
        String roomJID = data.getString("roomJid");
        String errorMsg = ChatEventManager.errorMsg(data);
        Log.e(ChatEventManager.class.getSimpleName(), "exitRoomFailed roomJID:" + roomJID + ", errorMsg:" + errorMsg);
        if (!isOldEvent) {
            BroadcastUtil.sendChatRoomExitFailedEvent(context, roomJID, errorMsg);
        }
    }

    private static void processCreateChatRoomSucceed(Context context, JSONObject data) throws JSONException {
        String requestId = data.getString("requestId");
        String roomJID = data.getString("roomJid");
        String subject = data.getString("roomSubject");
        JSONArray participantJIDs = data.getJSONArray("participantJids");
        Log.d(ChatEventManager.class.getSimpleName(), "createChatRoomSucceed roomJID:" + roomJID + ", subject:" + subject + ", participantJIDs:" + participantJIDs.toString());
        ArrayList<String> jids = new ArrayList<String>();
        if (participantJIDs != null) {
            int size = participantJIDs.length();
            for (int i = 0; i < size; ++i) {
                jids.add(participantJIDs.getString(i));
            }
        }
        ChatRoomManager.selfCreateChatRoom(context, subject, PreferencesUtil.getUserJid(context), roomJID);
        ChatRoomManager.notifySelfCreateChatRoomDone(context, roomJID, requestId);
    }

    private static void processCreateChatRoomFailed(Context context, JSONObject data) throws JSONException {
        String roomJID = data.getString("roomJid");
        String subject = data.getString("subject");
        String errorMsg = ChatEventManager.errorMsg(data);
        JSONArray participantJIDs = data.getJSONArray("participantJid");
        Log.d(ChatEventManager.class.getSimpleName(), "createChatRoomFailed roomJID:" + roomJID + ", subject:" + subject + ", participantJIDs:" + participantJIDs.toString() + ", errorMsg:" + errorMsg);
        ArrayList<String> jids = new ArrayList<String>();
        if (participantJIDs != null) {
            int size = participantJIDs.length();
            for (int i = 0; i < size; ++i) {
                jids.add(participantJIDs.getString(i));
            }
        }
        ChatRoomManager.notifySelfCreateChatRoomFailed(context, roomJID, errorMsg);
    }

    private static void inviteRoomParticipantsSucceed(Context context, JSONObject data) throws JSONException {
        String roomJID = data.getString("roomJid");
        JSONArray participantJIDs = data.getJSONArray("participantJids");
        Log.d(ChatEventManager.class.getSimpleName(), "inviteRoomParticipantsSucceed roomJID:" + roomJID + ", participantJIDs:" + participantJIDs.toString());
    }

    private static void inviteRoomParticipantsFailed(Context context, JSONObject data) throws JSONException {
        String roomJID = data.getString("roomJid");
        JSONArray participantJIDs = data.getJSONArray("participantJids");
        String errorMsg = ChatEventManager.errorMsg(data);
        Log.e(ChatEventManager.class.getSimpleName(), "inviteRoomParticipantFailed roomJID:" + roomJID + ", participantJIDs:[" + participantJIDs.toString() + "], errorMsg:" + errorMsg);
    }

    private static boolean notifyPromptMessageReceived(Context context, long chatEventId, JSONObject data, boolean isRead, boolean isPlayed, boolean isOldEvent) throws JSONException {
        String fromJID = data.getString("fromJid");
        String fromResource = data.getString("fromResource");
        String packetId = data.getString("packetId");
        String text = data.getString("text");
        long serverReceiveTime = data.getLong("timestamp");
        JSONObject props = data.getJSONObject("props");
        Log.d(ChatEventManager.class.getSimpleName(), "notifyPromptMessageReceived fromJID:" + fromJID + ", fromResource:" + fromResource + ", packetId:" + packetId + ", text:" + text);
        int msgType = 201;
        String content = text;
        String targetJid = JidUtil.jidTranslate(fromJID);
        long duration = 0L;
        if (props != null) {
            duration = props.optLong("duration", 0L);
            if (JidUtil.isCustomerJid(targetJid)) {
                if (props.has("promptType")) {
                    switch (props.getInt("promptType")) {
                        case 11: {
                            msgType = 311;
                            break;
                        }
                        case 12: {
                            msgType = 312;
                            break;
                        }
                        case 13: {
                            msgType = 313;
                            break;
                        }
                        case 14: {
                            msgType = 314;
                            break;
                        }
                        case 15: {
                            msgType = 315;
                            break;
                        }
                        case 16: {
                            msgType = 316;
                            break;
                        }
                        case 17: {
                            msgType = 317;
                            break;
                        }
                        case 19: {
                            msgType = 318;
                            break;
                        }
                    }
                    content = props.toString();
                }
                CustomerManager.handleCustomer(context, targetJid, props, isOldEvent);
            }
        }
        MsgBean bean = new MsgBean();
        bean.setChatEventId(chatEventId);
        bean.setSyncEventId(-1L);
        bean.setChatRoomId(targetJid);
        bean.setPacketId(packetId);
        bean.setStatus("R");
        bean.setFromJid(targetJid);
        bean.setToJid(PreferencesUtil.getUserJid(context));
        bean.setContent(content);
        bean.setMsgType(msgType);
        bean.setDuration(duration);
        bean.setRead(isRead);
        bean.setPlayed(isPlayed);
        bean.setReadCount(0);
        bean.setReaderList(null);
        bean.setAtMe(ChatEventManager.isAtMe(context, text));
        bean.setProps(props != null ? props.toString() : null);
        bean.setLazy(false);
        ChatRoomManager.newIncomingChatMsg(context, targetJid, bean, serverReceiveTime, isOldEvent);
        if (!isOldEvent) {
            BroadcastUtil.sendContactHistoryChangedEvent(context);
            BroadcastUtil.sendMsgChangedEvent(context, targetJid);
        }
        if (!isOldEvent && ChatRoomManager.isNotificationEnabled(context, targetJid) && !isRead) {
            BroadcastUtil.sendNotificationPopupEvent(context, targetJid, packetId);
        }
        return false;
    }
}

