/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.bean.MsgBean;
import com.blisscloud.mobile.ezuc.bean.VoiceItem;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcher;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcherResult;
import com.blisscloud.mobile.ezuc.manager.VoicemailManager;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class ChatEventVoicemailRecord {
    public static boolean handleMsg(Context context, int msgType, long chatEventId, JSONObject data, boolean isRead, boolean isPlayed, boolean isOldEvent) throws JSONException {
        if (msgType != 1005 && msgType != 1006 && msgType != 12 && msgType != 13) {
            return true;
        }
        String packetId = data.getString("packetId");
        String fromJid = data.getString("fromJid");
        String phoneNumber = data.getString("text");
        long serverReceiveTime = data.getLong("timestamp");
        JSONObject props = data.getJSONObject("props");
        String myJid = PreferencesUtil.getUserJid(context);
        if (TextUtils.isBlank((CharSequence)phoneNumber)) {
            return true;
        }
        String chatRoomId = null;
        if (JidUtil.isAPI000001UserJid(fromJid)) {
            PhoneMatcherResult result = PhoneMatcher.match(context, phoneNumber, false);
            if (result != null) {
                fromJid = result.getTargetJid();
                chatRoomId = result.getTargetJid();
                ChatRoomManager.checkAndGenerateChatRoomData(context, result.getTargetJid(), result.getTargetName(), isOldEvent, true);
            } else {
                fromJid = phoneNumber;
                chatRoomId = ChatRoomManager.prepareExternalPhoneRoom(context);
            }
        } else {
            ChatRoomManager.checkAndGenerateChatRoomData(context, fromJid, null, isOldEvent, true);
            chatRoomId = fromJid;
        }
        long startTime = serverReceiveTime;
        long duration = 0L;
        boolean isOutboundTrunk = false;
        VoiceItem voiceItem = VoicemailManager.parseMessageProps(context, props);
        if (voiceItem != null) {
            startTime = voiceItem.getEndTime();
            duration = voiceItem.getDuration();
            isOutboundTrunk = voiceItem.isOutboundTrunk();
        }
        MsgBean bean = new MsgBean();
        bean.setChatEventId(chatEventId);
        bean.setSyncEventId(-1L);
        bean.setChatRoomId(chatRoomId);
        bean.setPacketId(packetId);
        bean.setStatus("R");
        bean.setFromJid(fromJid);
        bean.setToJid(myJid);
        bean.setContent(null);
        bean.setMsgType(msgType);
        bean.setDuration(duration);
        bean.setRead(isRead);
        bean.setPlayed(isPlayed);
        bean.setReadCount(0);
        bean.setReaderList(null);
        bean.setProps(props != null ? props.toString() : null);
        bean.setLazy(false);
        bean.setPhoneNumber(phoneNumber);
        bean.setOutboundTrunk(isOutboundTrunk);
        UCDBMessage.addMessage(context, bean, startTime, isOldEvent);
        if (!isOldEvent) {
            BroadcastUtil.sendContactHistoryChangedEvent(context);
            BroadcastUtil.sendMsgChangedEvent(context, chatRoomId);
        }
        if (!isOldEvent && ChatRoomManager.isNotificationEnabled(context, chatRoomId) && !isRead) {
            BroadcastUtil.sendNotificationPopupEvent(context, chatRoomId, packetId);
        }
        return false;
    }
}

