/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.LiteMyGroup;
import com.blisscloud.ezuc.bean.LiteOutPrefix;
import com.blisscloud.ezuc.bean.web.LiteOutboundPrefix;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.bean.PhotoLoadTask;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ContactPhotoTask;
import com.blisscloud.mobile.ezuc.bean.DeletedContact;
import com.blisscloud.mobile.ezuc.bean.EmpKey;
import com.blisscloud.mobile.ezuc.bean.EmpPhotoTask;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.db.UCDBGroup;
import com.blisscloud.mobile.ezuc.manager.DeletedContactManager;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import com.blisscloud.mobile.ezuc.manager.PhotoType;
import com.blisscloud.mobile.ezuc.manager.task.FetchEmpTaskController;
import com.blisscloud.mobile.ezuc.manager.task.GetContactDataTask;
import com.blisscloud.mobile.ezuc.manager.task.GetDeletedVoiceDataTask;
import com.blisscloud.mobile.ezuc.manager.task.GetExternalContactDataTask;
import com.blisscloud.mobile.ezuc.manager.task.GetGroupDataTask;
import com.blisscloud.mobile.ezuc.manager.task.GetLocationDataTask;
import com.blisscloud.mobile.ezuc.manager.task.GetVoiceDataTask;
import com.blisscloud.mobile.ezuc.manager.task.LoadContactDataTask;
import com.blisscloud.mobile.ezuc.manager.task.PhotoTaskController;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.KeyUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContactManager {
    private static ConcurrentHashMap<String, String> phoneEmpStatusMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> phoneLocStatusMap = new ConcurrentHashMap();
    private static Object lock = new Object();

    public static Image getContactPhotoWithType(Context context, PhotoType photoType, EmpKey empKey) {
        BufferedImage img = null;
        if (photoType == PhotoType.SMALL) {
            img = ContactManager.getPhotoWithRefresh(context, PhotoType.SMALL, empKey, true);
            if (img == null) {
                img = ContactManager.getPhotoWithRefresh(context, PhotoType.BIG, empKey, false);
            }
        } else if (photoType == PhotoType.BIG && (img = ContactManager.getPhotoWithRefresh(context, PhotoType.BIG, empKey, true)) == null) {
            img = ContactManager.getPhotoWithRefresh(context, PhotoType.SMALL, empKey, true);
        }
        if (img != null) {
            return img;
        }
        return null;
    }

    public static void setContactPhoto(Context context, String jid, PhotoType photoType, BufferedImage image) {
    }

    public static Image getExternalContactPhotoWithType(Context context, PhotoType photoType, Long contactId) {
        BufferedImage img = null;
        if (photoType == PhotoType.SMALL) {
            img = ContactManager.getExternalPhotoWithRefresh(context, PhotoType.SMALL, contactId, true);
            if (img == null) {
                img = ContactManager.getExternalPhotoWithRefresh(context, PhotoType.BIG, contactId, false);
            }
        } else if (photoType == PhotoType.BIG && (img = ContactManager.getExternalPhotoWithRefresh(context, PhotoType.BIG, contactId, true)) == null) {
            img = ContactManager.getExternalPhotoWithRefresh(context, PhotoType.SMALL, contactId, true);
        }
        if (img != null) {
            return img;
        }
        return null;
    }

    public static String getContactPhotoURI(String jid) {
        File imageFile = new File(FileUtil.getPhotoRoot(), jid + "_s.png");
        if (imageFile.exists()) {
            return imageFile.toURI().toString();
        }
        return null;
    }

    public static String getExternalContactPhotoURI(long contactId) {
        File imageFile = new File(FileUtil.getPhotoRoot(), "mycontact_" + contactId + "_s.png");
        if (imageFile.exists()) {
            return imageFile.toURI().toString();
        }
        return null;
    }

    public static BufferedImage getPhotoWithRefresh(Context context, PhotoType type, EmpKey empKey, boolean loadFromWeb) {
        LiteContact contact;
        if (empKey == null) {
            return null;
        }
        BufferedImage mImage = ContactManager.getPhotoFromLocal(context, type, empKey.getJid());
        if (mImage == null && loadFromWeb && (contact = ContactManager.getContact(context, empKey.getJid())) != null && contact.isPhotoFlag()) {
            ContactManager.refreshPhoto(context, type, empKey);
        }
        return mImage;
    }

    public static BufferedImage getExternalPhotoWithRefresh(Context context, PhotoType type, Long id, boolean loadFromWeb) {
        LiteMyContact existContact;
        if (id == null) {
            return null;
        }
        BufferedImage mBitmap = ContactManager.getExternalPhotoFromLocal(context, type, id);
        if (mBitmap == null && loadFromWeb && (existContact = UCDBExternalContact.getExternalContactById(context, id)) != null && existContact.isPhotoFlag()) {
            ContactManager.refreshContactPhoto(context, type, id);
        }
        return mBitmap;
    }

    public static BufferedImage getPhotoFromLocal(Context context, PhotoType photo, String jid) {
        BufferedImage mBitmap = null;
        if (photo == PhotoType.SMALL) {
            mBitmap = FileUtil.readJidSmallPhoto(jid);
        } else if (photo == PhotoType.BIG) {
            mBitmap = FileUtil.readJidBigPhoto(jid);
        }
        return mBitmap;
    }

    private static BufferedImage getExternalPhotoFromLocal(Context context, PhotoType photo, long id) {
        BufferedImage mBitmap = null;
        if (photo == PhotoType.SMALL) {
            mBitmap = FileUtil.readContactSmallPhoto(id);
        } else if (photo == PhotoType.BIG) {
            mBitmap = FileUtil.readContactBigPhoto(id);
        }
        return mBitmap;
    }

    public static String getJidByEmpId(Context context, Long employeeId) {
        return UCDBContact.getContactJidByEmpId(context, employeeId);
    }

    public static String getJidByLocId(Context context, String siteId, String extension) {
        return UCDBContact.getContactJidByLocId(context, siteId, extension);
    }

    public static String getJidByLoginAccount(Context context, String account) {
        return UCDBContact.getContactJidByAccount(context, account);
    }

    public static LiteContact getContact(Context context, String jid) {
        if (TextUtils.isBlank((CharSequence)jid)) {
            return null;
        }
        if (DeletedContactManager.existDeletedContact(context, jid)) {
            return null;
        }
        LiteContact liteContact = UCDBContact.getContactByJid(context, jid);
        if (liteContact == null) {
            Log.d(ContactManager.class.getSimpleName(), "getContact \u627e\u4e0d\u5230\u806f\u7d61\u4eba!!! (jid:" + jid + ")");
            FetchEmpTaskController.getInstance(context).addTaskNoScopeCheck(jid);
        }
        return liteContact;
    }

    public static LiteContact getContactNoLoad(Context ctx, String jid) {
        if (TextUtils.isBlank((CharSequence)jid)) {
            return null;
        }
        LiteContact liteContact = UCDBContact.getContactByJid(ctx, jid);
        if (liteContact == null) {
            Log.d(ContactManager.class.getSimpleName(), "getContact \u627e\u4e0d\u5230\u806f\u7d61\u4eba!!! (jid:" + jid + ")");
        }
        return liteContact;
    }

    public static LiteContact getContact(Context context, Long empId) {
        LiteContact liteContact = UCDBContact.getContactByEmpId(context, empId);
        if (liteContact == null) {
            Log.d(ContactManager.class.getSimpleName(), "getContact \u627e\u4e0d\u5230\u806f\u7d61\u4eba!!! (empId:" + empId + ")");
        }
        return liteContact;
    }

    public static LiteMyContact getExternalContact(Context context, long id) {
        return UCDBExternalContact.getExternalContactById(context, id);
    }

    public static LiteMyContact getExternalContact(Context context, String jid) {
        if (!JidUtil.isMyContactJid(jid)) {
            return null;
        }
        String[] keys = jid.split("@");
        return UCDBExternalContact.getExternalContactById(context, Long.parseLong(keys[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWSContact(Context context, LiteContact contact, int contactType, int scope) {
        String jid = contact.getJid();
        Object object = lock;
        synchronized (object) {
            LiteContact existContact = UCDBContact.getContactByJid(context, jid);
            if (existContact == null) {
                UCDBContact.addContact(context, contact, contactType, scope);
                if (contactType == 0 && contact.isPhotoFlag()) {
                    EmpKey empKey = KeyUtil.genEmpKey(contact);
                    ContactManager.refreshPhoto(context, PhotoType.SMALL, empKey);
                }
            } else {
                UCDBContact.updateContact(context, contact, scope);
                if (contactType == 0 && contact.isPhotoFlag() && existContact.getPersonalPhotoTimestamp() != contact.getPersonalPhotoTimestamp()) {
                    EmpKey empKey = KeyUtil.genEmpKey(contact);
                    ContactManager.refreshPhoto(context, PhotoType.SMALL, empKey);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setWSContactWithPhotoCheckIfNotExist(Context context, LiteContact contact, int contactType) {
        String jid = contact.getJid();
        Object object = lock;
        synchronized (object) {
            LiteContact existContact = UCDBContact.getContactByJid(context, jid);
            if (existContact == null) {
                UCDBContact.addContact(context, contact, contactType, 1);
                if (contactType == 0 && contact.isPhotoFlag()) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setWSContactWithPhotoCheck(Context context, LiteContact contact, int contactType, int scope) {
        String jid = contact.getJid();
        boolean updateNow = false;
        Object object = lock;
        synchronized (object) {
            LiteContact existContact = UCDBContact.getContactByJid(context, jid);
            if (existContact == null) {
                UCDBContact.addContact(context, contact, contactType, scope);
            } else {
                UCDBContact.updateContact(context, contact, scope);
                if (contactType == 0 && contact.getPersonalPhotoTimestamp() > existContact.getPersonalPhotoTimestamp()) {
                    FileUtil.deleteJidBigPhoto(jid);
                    if (FileUtil.existJidSmallPhoto(contact.getJid())) {
                        FileUtil.deleteJidSmallPhoto(jid);
                        updateNow = true;
                    }
                }
            }
        }
        return updateNow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setWSContact(Context context, LiteMyContact contact) {
        long id = contact.getId();
        Object object = lock;
        synchronized (object) {
            LiteMyContact existContact = UCDBExternalContact.getExternalContactById(context, id);
            if (existContact == null) {
                UCDBExternalContact.addContact(context, contact);
                if (contact.isPhotoFlag()) {
                    return true;
                }
            } else {
                UCDBExternalContact.updateContact(context, contact);
                if (contact.isPhotoFlag()) {
                    if (existContact.getPersonalPhotoTimestamp() != contact.getPersonalPhotoTimestamp()) {
                        return true;
                    }
                } else {
                    ContactManager.cleanExteranlContactCacheAndPhoto(context, id);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWSGroupData(Context context, LiteMyGroup group) {
        long id = group.getId();
        Object object = lock;
        synchronized (object) {
            boolean exist = UCDBGroup.isGroupExist(context, id);
            if (!exist) {
                UCDBGroup.addGroup(context, group);
            } else {
                UCDBGroup.updateGroup(context, group);
            }
        }
    }

    public static void deleteGroup(Context context, String groupIds) {
        UCDBGroup.deleteGroup(context, groupIds);
        BroadcastUtil.sendGroupListChangedEvent(context);
    }

    public static void updateEmployeeInfo(Context context, String ids) {
        if (ids.equals("ALL")) {
            PreferencesUtil.setAddressBookSyncUndone(context);
            PreferencesUtil.setTimeStamp(context, "employee.getEmployeeList.TimeStamp.20200730", -1L);
            WebAgent.getInstance().reloadDirtyEmployeeList(-1L);
        } else {
            boolean isWhole = PreferencesUtil.isAddressBookScopeWholeCompany(context);
            Set<Long> scopeEmpSet = PreferencesUtil.getAddressBookScopeEmpList(context);
            Set<Long> extraEmpSet = PreferencesUtil.getAddressBookExtraEmpList(context);
            HashSet<Long> idSet = new HashSet<Long>();
            String[] idArr = ids.split(",");
            for (int i = 0; i < idArr.length; ++i) {
                Long empId = Long.parseLong(idArr[i]);
                if (!isWhole && !scopeEmpSet.contains(empId) && !extraEmpSet.contains(empId)) continue;
                idSet.add(empId);
            }
            if (idSet.size() > 0) {
                WebAgent.getInstance().queryEmployeeListByIds(idSet);
            }
        }
    }

    public static boolean removeEmployee(Context ctx, String ids) {
        boolean isNeedLogout = false;
        if (ids.equals("ALL")) {
            UCDBContact.deleteAllEmpContacts(ctx);
            isNeedLogout = true;
        } else {
            String[] idArr = ids.split(",");
            for (int i = 0; i < idArr.length; ++i) {
                LiteContact liteContact;
                Long empId = Long.parseLong(idArr[i]);
                if (PreferencesUtil.getUserId(ctx).longValue() == empId.longValue()) {
                    isNeedLogout = true;
                }
                if ((liteContact = UCDBContact.getContactByEmpId(ctx, empId)) != null) {
                    DeletedContactManager.addOrUpdateDeletedContact(ctx, liteContact.getJid(), liteContact.getOtherName(), liteContact.getSurName(), liteContact.getGivenName());
                    ContactManager.cleanCacheAndPhoto(ctx, liteContact.getJid());
                }
                UCDBContact.deleteEmpContact(ctx, empId);
            }
        }
        BroadcastUtil.sendContactListChangedEvent(ctx);
        return isNeedLogout;
    }

    public static void removeExternalContacts(Context context, String ids) {
        if (ids.equals("ALL")) {
            UCDBExternalContact.deleteAllExternalContacts(context);
        } else {
            String[] idArr = ids.split(",");
            for (int i = 0; i < idArr.length; ++i) {
                long id = Long.parseLong(idArr[i]);
                if (!UCDBExternalContact.deleteExternalContact(context, id)) continue;
                ContactManager.cleanExteranlContactCacheAndPhoto(context, id);
            }
        }
        BroadcastUtil.sendExternalContactListChangedEvent(context);
    }

    public static void cleanCacheAndPhoto(Context context, String jid) {
        try {
            if (jid != null && !"".equals(jid.trim())) {
                FileUtil.deleteJidSmallPhoto(jid);
                FileUtil.deleteJidBigPhoto(jid);
            }
        }
        catch (Throwable t) {
            Log.e(ContactManager.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    public static void cleanExteranlContactCacheAndPhoto(Context context, long id) {
        FileUtil.deleteContactBigPhoto(id);
        FileUtil.deleteContactSmallPhoto(id);
    }

    public static void removeLocation(Context context) {
        UCDBContact.deleteAllLocationContacts(context);
        BroadcastUtil.sendContactListChangedEvent(context);
    }

    public static void handleBadJidList(Context context, JSONArray badJidArray) {
        try {
            if (badJidArray != null) {
                for (int i = 0; i < badJidArray.length(); ++i) {
                    String jid = badJidArray.getString(i);
                    DeletedContactManager.addOrUpdateDeletedContact(context, jid);
                }
            }
        }
        catch (Throwable t) {
            Log.e(ContactManager.class.getSimpleName(), t.getLocalizedMessage());
        }
    }

    public static void updateEmployeeListJids(Context context, JSONArray dataArray) {
        LoadContactDataTask t = new LoadContactDataTask(context, dataArray, null);
        TaskController.getInstance().addTask(t);
        t.start();
    }

    public static void updateEmployeeListIds(Context context, JSONArray dataArray, String token) {
        LoadContactDataTask t = new LoadContactDataTask(context, dataArray, token);
        TaskController.getInstance().addTask(t);
        t.start();
    }

    public static void updateEmployeeList(Context context, JSONArray dataArray, JSONObject paraObj, Long returnTimeStamp) {
        GetContactDataTask t = new GetContactDataTask(context, dataArray, paraObj, (long)returnTimeStamp);
        TaskController.getInstance().addTask(t);
        t.start();
    }

    public static void updateLocationList(Context context, JSONArray dataArray, long returnTimeStamp) {
        GetLocationDataTask t = new GetLocationDataTask(context, dataArray, returnTimeStamp);
        TaskController.getInstance().addTask(t);
        t.start();
    }

    public static void updateGroupList(Context context, JSONArray dataArray, long returnTimeStamp) {
        GetGroupDataTask t = new GetGroupDataTask(context, dataArray, returnTimeStamp);
        TaskController.getInstance().addTask(t);
        t.start();
    }

    public static List<LiteContact> parseLiteContactsJson(JSONArray dataArray) {
        if (dataArray == null) {
            return new ArrayList<LiteContact>();
        }
        Gson gson = new Gson();
        return (List)gson.fromJson(dataArray.toString(), new TypeToken<List<LiteContact>>(){}.getType());
    }

    public static List<LiteMyGroup> parseLiteGroupJson(JSONArray dataArray) {
        if (dataArray == null) {
            return new ArrayList<LiteMyGroup>();
        }
        Gson gson = new Gson();
        return (List)gson.fromJson(dataArray.toString(), new TypeToken<List<LiteMyGroup>>(){}.getType());
    }

    public static void clearPhoneEmpStatusCache() {
        phoneEmpStatusMap.clear();
    }

    public static void clearPhoneLocStatusCache() {
        phoneLocStatusMap.clear();
    }

    public static void setPhoneEmpStatus(String employeeId, String phoneStatus) {
        if (TextUtils.isNotBlank((CharSequence)phoneStatus)) {
            if ("OFF_LINE".equals(phoneStatus)) {
                phoneEmpStatusMap.remove(employeeId);
            } else {
                phoneEmpStatusMap.put(employeeId, phoneStatus);
            }
        }
    }

    public static void setPhoneLocStatus(String locJid, String phoneStatus) {
        if (TextUtils.isNotBlank((CharSequence)phoneStatus)) {
            if ("OFF_LINE".equals(phoneStatus)) {
                phoneLocStatusMap.remove(locJid);
            } else {
                phoneLocStatusMap.put(locJid, phoneStatus);
            }
        }
    }

    public static String getPhoneEmpStatus(String empIdStr) {
        if (!phoneEmpStatusMap.containsKey(empIdStr)) {
            return "OFF_LINE";
        }
        return phoneEmpStatusMap.get(empIdStr);
    }

    public static String getPhoneLocStatus(String empJid) {
        if (!phoneLocStatusMap.containsKey(empJid)) {
            return "OFF_LINE";
        }
        return phoneLocStatusMap.get(empJid);
    }

    private static void refreshPhoto(Context context, PhotoType type, EmpKey empKey) {
        ArrayList<PhotoLoadTask> list = new ArrayList<PhotoLoadTask>();
        EmpPhotoTask t = new EmpPhotoTask();
        t.setEmpKey(empKey);
        list.add(t);
        ContactManager.refreshPhotoList(context, type, list);
    }

    private static void refreshContactPhoto(Context context, PhotoType photoType, long contactId) {
        ArrayList<PhotoLoadTask> list = new ArrayList<PhotoLoadTask>();
        ContactPhotoTask task = new ContactPhotoTask();
        task.setContactId(contactId);
        list.add(task);
        ContactManager.refreshPhotoList(context, photoType, list);
    }

    public static void refreshPhotoList(Context context, PhotoType photoType, List<PhotoLoadTask> empPhotoTasks) {
        if (empPhotoTasks == null) {
            return;
        }
        PhotoTaskController.getInstance(context).addTask(empPhotoTasks, photoType);
    }

    public static boolean isInMyFavorite(Context context, String id, int type) {
        return UCDBGroup.isInGroupList(context, "My favorites", type, id);
    }

    public static boolean isInMyChatRoom(Context context, String id) {
        return UCDBGroup.isInGroupList(context, "My chat rooms", 3, id);
    }

    public static LiteContact getContact(Context ctx, Map<String, LiteContact> userCacheMap, String jid) {
        if (userCacheMap == null) {
            return ContactManager.getContact(ctx, jid);
        }
        if (userCacheMap.containsKey(jid)) {
            return userCacheMap.get(jid);
        }
        LiteContact contact = ContactManager.getContact(ctx, jid);
        if (contact != null) {
            userCacheMap.put(jid, contact);
        }
        return contact;
    }

    public static String getContactShortName(Context ctx, Map<String, LiteContact> userCacheMap, String jid) {
        LiteContact contact = null;
        contact = PreferencesUtil.getUserJid(ctx).equals(jid) ? PreferencesUtil.getUserInfo(ctx) : ContactManager.getContact(ctx, userCacheMap, jid);
        if (contact != null) {
            return ContactManager.getContactShortName(ctx, contact);
        }
        DeletedContact delContact = DeletedContactManager.getDeletedContact(ctx, jid);
        if (delContact != null) {
            return DeletedContactManager.getContactShortName(ctx, delContact);
        }
        return JidUtil.getJidName(jid);
    }

    public static String getContactFullName(Context ctx, Map<String, LiteContact> userCacheMap, String jid) {
        LiteContact contact = null;
        contact = PreferencesUtil.getUserJid(ctx).equals(jid) ? PreferencesUtil.getUserInfo(ctx) : ContactManager.getContact(ctx, userCacheMap, jid);
        if (contact != null) {
            return ContactManager.getContactFullName(contact);
        }
        DeletedContact delContact = DeletedContactManager.getDeletedContact(ctx, jid);
        if (delContact != null) {
            return DeletedContactManager.getContactShortName(ctx, delContact);
        }
        return JidUtil.getJidName(jid);
    }

    public static String getContactShortName(Context context, String jid) {
        return ContactManager.getContactShortName(context, null, jid);
    }

    public static String getContactShortName(Context context, LiteContact liteContact) {
        return ContactManager.getContactShortName(context, liteContact, I18NUtil.getAppLocale());
    }

    public static String getContactShortName(Context context, LiteContact contact, Locale locale) {
        boolean hasSurName;
        if (contact == null) {
            throw new RuntimeException("contact is null");
        }
        if (locale == null) {
            throw new RuntimeException("locale is null");
        }
        Object userName = "";
        boolean hasOtherName = contact.getOtherName() != null && contact.getOtherName().trim().length() > 0;
        boolean hasGivenName = contact.getGivenName() != null && contact.getGivenName().trim().length() > 0;
        boolean bl = hasSurName = contact.getSurName() != null && contact.getSurName().trim().length() > 0;
        if (locale.equals(Locale.TAIWAN) || locale.equals(Locale.CHINA) || locale.equals(Locale.CHINESE) || locale.equals(Locale.JAPAN) || locale.equals(Locale.JAPANESE) || locale.equals(Locale.KOREA) || locale.equals(Locale.KOREAN)) {
            if (hasOtherName) {
                userName = contact.getOtherName();
            } else if (hasGivenName && hasSurName) {
                userName = contact.getGivenName() + " " + contact.getSurName();
            } else if (!hasGivenName && hasSurName) {
                userName = contact.getSurName();
            } else if (hasGivenName && !hasSurName) {
                userName = contact.getGivenName();
            }
        } else if (hasGivenName && hasSurName) {
            userName = contact.getGivenName() + " " + contact.getSurName();
        } else if (!hasGivenName && hasSurName) {
            userName = contact.getSurName();
        } else if (hasGivenName && !hasSurName) {
            userName = contact.getGivenName();
        } else if (hasOtherName) {
            userName = contact.getOtherName();
        }
        if (userName == null || ((String)userName).length() == 0) {
            userName = JidUtil.getJidName(contact.getJid());
        }
        return userName;
    }

    public static String getContactFullName(Context ctx, LiteContact contact, String jid) {
        if (contact != null) {
            return ContactManager.getContactFullName(contact);
        }
        DeletedContact delContact = DeletedContactManager.getDeletedContact(ctx, jid);
        if (delContact != null) {
            return DeletedContactManager.getContactFullName(delContact);
        }
        return JidUtil.getJidName(jid);
    }

    public static String getContactFullName(LiteContact contact) {
        if (contact == null) {
            throw new RuntimeException("contact is null");
        }
        if (JidUtil.isLocationJid(contact.getJid())) {
            return contact.getDispName();
        }
        boolean hasOtherName = contact.getOtherName() != null && contact.getOtherName().trim().length() > 0;
        boolean hasGivenName = contact.getGivenName() != null && contact.getGivenName().trim().length() > 0;
        boolean hasSurName = contact.getSurName() != null && contact.getSurName().trim().length() > 0;
        StringBuffer buffer = new StringBuffer();
        if (hasGivenName && hasSurName) {
            buffer.append(contact.getGivenName() + " " + contact.getSurName());
        } else if (!hasGivenName && hasSurName) {
            buffer.append(contact.getSurName());
        } else if (hasGivenName && !hasSurName) {
            buffer.append(contact.getGivenName());
        }
        if (hasOtherName) {
            if (hasGivenName || hasSurName) {
                buffer.append(" ");
            }
            buffer.append(contact.getOtherName());
        }
        if (buffer.length() == 0) {
            buffer.append(JidUtil.getJidName(contact.getJid()));
        }
        return buffer.toString();
    }

    public static String getFullEnglishName(LiteContact contact) {
        boolean hasGivenName = contact.getGivenName() != null && contact.getGivenName().trim().length() > 0;
        boolean hasSurName = contact.getSurName() != null && contact.getSurName().trim().length() > 0;
        StringBuffer buffer = new StringBuffer();
        if (hasGivenName && hasSurName) {
            buffer.append(contact.getGivenName() + " " + contact.getSurName());
        } else if (!hasGivenName && hasSurName) {
            buffer.append(contact.getSurName());
        } else if (hasGivenName && !hasSurName) {
            buffer.append(contact.getGivenName());
        }
        return buffer.toString();
    }

    public static String getNonEnglishName(LiteContact contact) {
        boolean hasOtherName;
        boolean bl = hasOtherName = contact.getOtherName() != null && contact.getOtherName().trim().length() > 0;
        if (hasOtherName) {
            return contact.getOtherName();
        }
        return "";
    }

    public static void updateExternalContactList(Context context, String jsonStr, long returnTimeStamp) {
        if (TextUtils.isNotBlank((CharSequence)jsonStr)) {
            GetExternalContactDataTask t = new GetExternalContactDataTask(context, jsonStr, returnTimeStamp);
            TaskController.getInstance().addTask(t);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LiteMyContact> parseLiteExteranlContactsJson(String jsonStr) {
        Vector<LiteMyContact> contactList = new Vector<LiteMyContact>();
        if (jsonStr != null && jsonStr.length() > 0) {
            JSONArray dataArray;
            block8: {
                JSONObject dataObj;
                block7: {
                    dataObj = new JSONObject(jsonStr);
                    if (dataObj.has("data")) break block7;
                    Vector<LiteMyContact> vector = contactList;
                    return vector;
                }
                dataArray = (JSONArray)dataObj.get("data");
                if (dataArray != null) break block8;
                Vector<LiteMyContact> vector = contactList;
                return vector;
            }
            try {
                List contactListtemp = (List)new Gson().fromJson(dataArray.toString(), new TypeToken<List<LiteMyContact>>(){}.getType());
                contactList.addAll(contactListtemp);
            }
            catch (JSONException e) {
                Log.e(ContactManager.class.getSimpleName(), "parseLiteExteranlContactsJson", e);
            }
        }
        return contactList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getGroupIdByName(Context context, String name) {
        long id = -1L;
        Object object = lock;
        synchronized (object) {
            id = UCDBGroup.findGroupIdByName(context, name);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAddMembers(Context context, String groupName, String id, int type) {
        String members = null;
        Object object = lock;
        synchronized (object) {
            members = UCDBGroup.getAddMemberList(context, groupName, id, type);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAddMembers(Context context, String groupName, List<String> ids, int type) {
        String members = null;
        Object object = lock;
        synchronized (object) {
            members = UCDBGroup.getAddMemberList(context, groupName, ids, type);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRemoveMembers(Context context, String groupName, String id, int type) {
        String members = null;
        Object object = lock;
        synchronized (object) {
            members = UCDBGroup.getRemovedMemberList(context, groupName, id, type);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGroupExist(Context context, String name) {
        boolean isExist = false;
        Object object = lock;
        synchronized (object) {
            isExist = UCDBGroup.isGroupExist(context, name);
        }
        return isExist;
    }

    public static void updateVoiceList(Context context, JSONObject dataObj, long returnTimeStamp) {
        GetVoiceDataTask t = new GetVoiceDataTask(context, dataObj, returnTimeStamp);
        TaskController.getInstance().addTask(t);
        t.start();
    }

    public static void updateDeletedVoiceList(Context context, JSONObject dataObj, long returnTimeStamp) {
        GetDeletedVoiceDataTask t = new GetDeletedVoiceDataTask(context, dataObj, returnTimeStamp);
        TaskController.getInstance().addTask(t);
        t.start();
    }

    public static Image getContactImage(LiteContact contact, int photoSize, boolean noDefault, boolean roundImage) {
        Image contactImage = null;
        if (contact != null) {
            if (JidUtil.isLocationJid(contact.getJid())) {
                contactImage = UIConstants.ICON_PHONE_PUBLIC_PHONE200.getImage();
                contactImage = photoSize <= 32 ? UIConstants.ICON_PHONE_PUBLIC_PHONE32.getImage() : (photoSize <= 48 ? UIConstants.ICON_PHONE_PUBLIC_PHONE48.getImage() : (photoSize <= 64 ? UIConstants.ICON_PHONE_PUBLIC_PHONE64.getImage() : UIConstants.ICON_PHONE_PUBLIC_PHONE96.getImage()));
            } else if (JidUtil.isEmployeeJid(contact.getJid()) && contact.isPhotoFlag()) {
                contactImage = photoSize >= 64 ? ContactManager.getContactPhotoWithType(UCChatClient.context, PhotoType.BIG, KeyUtil.genEmpKey(contact)) : ContactManager.getContactPhotoWithType(UCChatClient.context, PhotoType.SMALL, KeyUtil.genEmpKey(contact));
            }
        }
        if (contactImage == null && noDefault) {
            return null;
        }
        return GraphicUtil.getPresencedPersonalPhoto(photoSize, photoSize, contactImage, null, roundImage);
    }

    public static Image getExternalContactImage(LiteMyContact contact, int photoSize, boolean noDefault, boolean roundImage) {
        Image contactImage = null;
        if (contact != null && contact.isPhotoFlag()) {
            contactImage = photoSize >= 64 ? ContactManager.getExternalContactPhotoWithType(UCChatClient.context, PhotoType.BIG, contact.getId()) : ContactManager.getExternalContactPhotoWithType(UCChatClient.context, PhotoType.SMALL, contact.getId());
        }
        if (contactImage == null && noDefault) {
            return null;
        }
        return GraphicUtil.getPresencedPersonalPhoto(photoSize, photoSize, contactImage, null, roundImage);
    }

    public static LiteOutboundPrefix getMySelfOutboundPrefix(Context context) {
        LiteContact mySelf = ContactManager.getContact(context, PreferencesUtil.getUserJid(context));
        return ContactManager.getContactOutboundPrefix(context, mySelf);
    }

    public static LiteOutboundPrefix getMySelfOutboundPrefix(Context context, long siteId) {
        LiteContact mySelf = ContactManager.getContact(context, PreferencesUtil.getUserJid(context));
        return ContactManager.getContactOutboundPrefix(context, mySelf, siteId);
    }

    public static LiteOutboundPrefix getContactOutboundPrefix(Context context, LiteContact contact) {
        long mySiteId = PreferencesUtil.getSipUsePbxSite(context);
        return ContactManager.getContactOutboundPrefix(context, contact, mySiteId);
    }

    public static LiteOutboundPrefix getContactOutboundPrefix(Context context, LiteContact contact, long siteId) {
        LiteOutboundPrefix outboundPrefix = null;
        if (ApiVersion.isApi14Later()) {
            LiteOutboundPrefix outboundPrefixTemp;
            List<LiteOutPrefix> outboundList = contact.getOutboundPrefixList();
            if (contact.getOutboundPrefixId() != null && contact.getOutboundPrefixId() != 0L && (outboundList == null || outboundList.size() == 0)) {
                HashSet idSet = new HashSet();
                idSet.add(contact.getId());
                WebAgent.getInstance().queryEmployeeListByIds(idSet);
            }
            for (LiteOutPrefix prefix : outboundList) {
                if (prefix.getSiteId() != siteId) continue;
                outboundPrefix = OutboundPrefixManager.getOutboundPrefix(context, prefix.getOutboundPrefixId());
            }
            if (outboundPrefix == null && contact.getOutboundPrefixId() != null && contact.getOutboundPrefixId() != 0L && (outboundPrefixTemp = OutboundPrefixManager.getOutboundPrefix(context, contact.getOutboundPrefixId())) != null && outboundPrefixTemp.getSiteId() == siteId) {
                outboundPrefix = outboundPrefixTemp;
            }
            if (outboundPrefix == null) {
                outboundPrefix = OutboundPrefixManager.getDefaultOutboundPrefix(context, siteId);
            }
        } else if (contact.getOutboundPrefixId() != null && contact.getOutboundPrefixId() != 0L) {
            outboundPrefix = OutboundPrefixManager.getOutboundPrefix(context, contact.getOutboundPrefixId());
        }
        return outboundPrefix;
    }
}

