/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.bean.LiteCustomer;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.bean.PhotoLoadTask;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.CustomerKey;
import com.blisscloud.mobile.ezuc.bean.CustomerPhotoTask;
import com.blisscloud.mobile.ezuc.db.UCDBCustomer;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.PhotoType;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.KeyUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomerManager {
    public static boolean isValid(Context context, LiteCustomer customer) {
        boolean sessionExpired;
        if (customer == null) {
            return false;
        }
        Long expireTime = customer.getExpireTime();
        boolean bl = sessionExpired = expireTime == null || expireTime <= 0L || expireTime - System.currentTimeMillis() <= 0L;
        if (ApiVersion.isApi7Later()) {
            String myJid = PreferencesUtil.getUserJid(context);
            String myAccount = JidUtil.convertKey(myJid);
            boolean isOwner = myAccount.equalsIgnoreCase(customer.getAssigner());
            return !customer.isSessionClose() && !sessionExpired && isOwner && customer.getStatus() != 0;
        }
        return !customer.isSessionClose() && !sessionExpired;
    }

    public static LiteCustomer getCustomerInfo(Context context, String customerAaccount) {
        LiteCustomer dbCustomer = UCDBCustomer.getCustomer(context, customerAaccount);
        return dbCustomer;
    }

    public static List<String> searchCustomer(Context context, String searchKey) {
        return UCDBCustomer.findCustomerIds(context, searchKey);
    }

    public static void processWeChatMessageOld(Context ctx, String customerJid, JSONObject props, boolean isOldEvent) {
        try {
            boolean isExpired;
            long timestamp = PreferencesUtil.getLong(ctx, "customer.service.cotegory.timestamp", 0L);
            if (timestamp == 0L || System.currentTimeMillis() - timestamp > 180000L) {
                WebAgent.getInstance().getCustomerServiceCategory();
            }
            boolean transferred = props.has("transferred") ? props.getBoolean("transferred") : false;
            String sessionId = props.has("sessionId") ? props.getString("sessionId") : null;
            long serverExpireTime = props.getLong("expireTime");
            long serverReceiveTime = props.getLong("serverReceiveTime");
            long serverExpiredDiff = serverExpireTime - serverReceiveTime;
            long expiredTime = serverExpireTime;
            boolean bl = isExpired = serverExpiredDiff <= 0L;
            if (!isExpired && !isOldEvent) {
                expiredTime = System.currentTimeMillis() + serverExpiredDiff;
            }
            Log.d(CustomerManager.class.getSimpleName(), "transferred:" + transferred + " sessionId:" + sessionId);
            String acct = JidUtil.convertKey(customerJid);
            LiteCustomer cust = CustomerManager.getCustomerInfo(ctx, acct);
            if (cust != null) {
                UCDBCustomer.updateCustomerStatusInfoOld(ctx, acct, expiredTime, sessionId, transferred);
            } else {
                UCDBCustomer.addCustomerTemp(ctx, acct, expiredTime, sessionId, transferred);
            }
            if (!isExpired) {
                UCDBCustomer.updateCustomerSessionClose(ctx, acct, 0);
            }
            WebAgent.getInstance().getCustomerInfo(acct);
        }
        catch (JSONException e) {
            Log.e(CustomerManager.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    public static void handleCustomer(Context context, String customerJid, JSONObject props, boolean isOldEvent) {
        if (ApiVersion.isApi7Later()) {
            String acct = JidUtil.convertKey(customerJid);
            LiteCustomer cust = CustomerManager.getCustomerInfo(context, acct);
            if (cust == null) {
                WebAgent.getInstance().getCustomerInfo(acct);
            }
        } else {
            CustomerManager.processWeChatMessageOld(context, customerJid, props, isOldEvent);
        }
    }

    public static void onCustomerDataChange(Context context, JSONObject dataObj) {
        Log.i(CustomerManager.class.getSimpleName(), "onCustomerDataChange:" + String.valueOf(dataObj) == null ? "" : dataObj.toString());
        if (dataObj == null) {
            return;
        }
        String id = null;
        try {
            id = dataObj.getString("ids");
        }
        catch (JSONException e) {
            Log.e(CustomerManager.class.getSimpleName(), e.getLocalizedMessage());
        }
        if (id == null) {
            return;
        }
        LiteCustomer dbCustomer = UCDBCustomer.getCustomerById(context, id);
        if (dbCustomer == null) {
            Log.i(CustomerManager.class.getSimpleName(), "LiteCustomer null");
            return;
        }
        WebAgent.getInstance().getCustomerInfo(dbCustomer.getAccount());
    }

    public static Image getContactImage(LiteCustomer customer, int photoSize, boolean noDefault) {
        Image contactImage = null;
        if (customer != null && customer.isPersonalPhoto()) {
            CustomerKey customerKey = KeyUtil.genCustomerKey(customer);
            contactImage = photoSize >= 64 ? CustomerManager.getContactPhotoWithType(UCChatClient.context, PhotoType.BIG, customerKey) : CustomerManager.getContactPhotoWithType(UCChatClient.context, PhotoType.SMALL, customerKey);
        }
        if (contactImage == null && noDefault) {
            return null;
        }
        return GraphicUtil.getPresencedPersonalPhoto(photoSize, photoSize, contactImage, null, true);
    }

    public static Image getContactPhotoWithType(Context context, PhotoType photoType, CustomerKey customerKey) {
        BufferedImage img = null;
        if (photoType == PhotoType.SMALL) {
            img = CustomerManager.getPhotoWithRefresh(context, PhotoType.SMALL, customerKey, true);
            if (img == null) {
                img = CustomerManager.getPhotoWithRefresh(context, PhotoType.BIG, customerKey, false);
            }
        } else if (photoType == PhotoType.BIG && (img = CustomerManager.getPhotoWithRefresh(context, PhotoType.BIG, customerKey, true)) == null) {
            img = CustomerManager.getPhotoWithRefresh(context, PhotoType.SMALL, customerKey, true);
        }
        if (img != null) {
            return img;
        }
        return null;
    }

    public static BufferedImage getPhotoWithRefresh(Context context, PhotoType type, CustomerKey customerKey, boolean loadFromWeb) {
        LiteCustomer dbCustomer;
        if (customerKey == null) {
            return null;
        }
        BufferedImage mImage = ContactManager.getPhotoFromLocal(context, type, customerKey.getJid());
        if (mImage == null && loadFromWeb && (dbCustomer = UCDBCustomer.getCustomerById(context, String.valueOf(customerKey.getCustomerId()))) != null && dbCustomer.isPersonalPhoto()) {
            CustomerManager.refreshPhoto(context, type, customerKey);
        }
        return mImage;
    }

    private static void refreshPhoto(Context context, PhotoType type, CustomerKey customerKey) {
        ArrayList<PhotoLoadTask> list = new ArrayList<PhotoLoadTask>();
        CustomerPhotoTask t = new CustomerPhotoTask();
        t.setCustomerKey(customerKey);
        list.add(t);
        ContactManager.refreshPhotoList(context, type, list);
    }

    public static String getContactPhotoURI(String jid) {
        File imageFile = new File(FileUtil.getPhotoRoot(), jid + "_s.png");
        if (imageFile.exists()) {
            return imageFile.toURI().toString();
        }
        return null;
    }
}

