/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.bean.web.LiteConferenceUserStatus;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.db.UCDBConf;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.task.FetchEmpTaskController;
import com.blisscloud.mobile.ezuc.manager.task.GetMeetmeRoomDataTask;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class MeetmeManager {
    private static Object lock = new Object();

    public static void updateMeetMeList(Context context, JSONObject dataObj) {
        MeetmeManager.parseMeetmeRoomList(context, dataObj);
    }

    public static void updateOneMeetMe(Context context, JSONObject dataObj) {
        MeetmeManager.parseMeetmeRoom(context, dataObj);
    }

    public static void updateMeetMeUserList(Context context, JSONObject dataObj) {
        Long roomId = MeetmeManager.parseMeetmeUserList(context, dataObj);
        if (roomId != null) {
            BroadcastUtil.sendMeetmeUserListChangedEvent(context, roomId);
        }
    }

    public static List<LiteConferenceRoom> getStaticMeetmeList(Context context) {
        return UCDBConf.getAllStaticConfRooms(context);
    }

    public static List<LiteConferenceUserStatus> getMeetmeUserList(Context context, long roomId) {
        return UCDBConf.getConfRoomUsers(context, roomId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseMeetmeRoom(Context ctx, JSONObject dataObj) {
        Object object = lock;
        synchronized (object) {
            if (dataObj == null) {
                return;
            }
            try {
                LiteConferenceRoom meetme = (LiteConferenceRoom)new Gson().fromJson(dataObj.toString(), new TypeToken<LiteConferenceRoom>(){}.getType());
                if (meetme != null) {
                    LiteContact managerContact;
                    HashSet<Long> empIdSet = new HashSet<Long>();
                    List<Long> cidList = meetme.getChairmanIds();
                    if (cidList != null) {
                        for (Long cid : cidList) {
                            LiteContact chairmanContact = UCDBContact.getContactByEmpId(UCChatClient.context, cid);
                            if (chairmanContact != null) continue;
                            empIdSet.add(cid);
                        }
                    }
                    if ((managerContact = UCDBContact.getContactByEmpId(UCChatClient.context, meetme.getManagerId())) == null) {
                        empIdSet.add(meetme.getManagerId());
                    }
                    MeetmeManager.addOrUpdateConfRoom(ctx, meetme);
                    WebAgent.getInstance().getOneRoomSync(meetme.getChatRoomId());
                    if (empIdSet.size() > 0) {
                        WebAgent.getInstance().queryEmployeeListByIds(empIdSet);
                    }
                    if (JidUtil.isConfJid(meetme.getChatRoomId())) {
                        PhoneAgent.getInstance().onConfRoomTitleChanged(meetme.getChatRoomId(), meetme.getName(), meetme.getRoomNo());
                    }
                    BroadcastUtil.sendMeetmeChangedEvent(ctx, meetme.getRoomId(), meetme.getChatRoomId());
                    if (PreferencesUtil.isSyncOldChatEventDone(ctx)) {
                        BroadcastUtil.sendContactHistoryChangedEvent(ctx);
                    }
                }
            }
            catch (Exception e) {
                Log.e(MeetmeManager.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseMeetmeRoomList(Context ctx, JSONObject dataObj) {
        Object object = lock;
        synchronized (object) {
            if (dataObj == null) {
                return;
            }
            try {
                if (!dataObj.has("dataList")) {
                    return;
                }
                JSONArray jsonArray = dataObj.getJSONArray("dataList");
                List meetmeList = (List)new Gson().fromJson(jsonArray.toString(), new TypeToken<List<LiteConferenceRoom>>(){}.getType());
                if (meetmeList != null) {
                    GetMeetmeRoomDataTask task = new GetMeetmeRoomDataTask((Context)UCChatClient.context, meetmeList);
                    TaskController.getInstance().addTask(task);
                    task.start();
                }
            }
            catch (Exception e) {
                Log.e(MeetmeManager.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Long parseMeetmeUserList(Context context, JSONObject dataObj) {
        Object object = lock;
        synchronized (object) {
            if (dataObj == null) {
                return null;
            }
            try {
                if (!dataObj.has("conferenceUserStatus")) {
                    return null;
                }
                if (!dataObj.has("roomId")) {
                    return null;
                }
                long meetmeRoomId = dataObj.getLong("roomId");
                UCDBConf.deleteAllConfRoomUsers(context, meetmeRoomId);
                JSONArray userListArray = dataObj.getJSONArray("conferenceUserStatus");
                List userList = (List)new Gson().fromJson(userListArray.toString(), new TypeToken<List<LiteConferenceUserStatus>>(){}.getType());
                HashSet<Long> idSet = new HashSet<Long>();
                if (userList != null) {
                    for (LiteConferenceUserStatus userStatus : userList) {
                        UCDBConf.addConfRoomUser(context, meetmeRoomId, userStatus);
                        try {
                            long empId;
                            LiteContact c;
                            if (!"EMPLOYEE".equals(userStatus.getCallerType())) continue;
                            if (TextUtils.isNotBlank((CharSequence)userStatus.getCallerJid())) {
                                String jid = userStatus.getCallerJid().trim();
                                LiteContact contact = ContactManager.getContactNoLoad(context, jid);
                                if (contact != null) continue;
                                FetchEmpTaskController.getInstance(context).addTaskNoScopeCheck(jid);
                                continue;
                            }
                            if (!TextUtils.isNotBlank((CharSequence)userStatus.getCallerDbId()) || (c = ContactManager.getContact(context, empId = Long.parseLong(userStatus.getCallerDbId().trim()))) != null) continue;
                            idSet.add(empId);
                        }
                        catch (Exception e) {
                            Log.e(MeetmeManager.class.getName(), "ERROR:" + e.getLocalizedMessage(), e);
                        }
                    }
                }
                if (idSet.size() > 0) {
                    WebAgent.getInstance().queryEmployeeListByIds(idSet);
                }
                int parties = dataObj.getInt("parties");
                boolean locked = dataObj.getBoolean("locked");
                boolean allMute = dataObj.getBoolean("allMute");
                if (UCDBConf.existMeetmeById(context, meetmeRoomId)) {
                    LiteConferenceRoom oldConf = UCDBConf.getConfRoom(context, meetmeRoomId);
                    oldConf.setMembers(parties);
                    oldConf.setLocked(locked);
                    oldConf.setAllMute(allMute);
                    UCDBConf.updateConfRoom(context, oldConf);
                }
                return meetmeRoomId;
            }
            catch (Exception e) {
                Log.e(MeetmeManager.class.getSimpleName(), e.getLocalizedMessage(), e);
                return null;
            }
        }
    }

    public static LiteConferenceRoom getMeetme(Context context, String chatRoomId) {
        return UCDBConf.getConfRoomByChatRoomId(context, chatRoomId);
    }

    public static LiteConferenceRoom getStaticMeetme(Context context, String chatRoomId) {
        return UCDBConf.getStaticConfRoomByChatRoomId(context, chatRoomId);
    }

    public static LiteConferenceRoom getMeetme(Context context, Long roomId) {
        return UCDBConf.getConfRoom(context, roomId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteConfRoomByIdNoBroadcast(Context context, long roomId) {
        Object object = lock;
        synchronized (object) {
            UCDBConf.deleteConfRoom(context, roomId);
        }
    }

    public static void deleteConfRoomById(Context context, long roomId, String roomJid) {
        MeetmeManager.deleteConfRoomByIdNoBroadcast(context, roomId);
        BroadcastUtil.sendMeetmeChangedEvent(context, roomId, roomJid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void leaveConfRoomUser(Context context, Long roomId, Set<String> userNoSet) {
        Object object = lock;
        synchronized (object) {
            UCDBConf.leaveConfRoomUser(context, roomId, userNoSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void muteConfRoomUser(Context context, Long roomId, Set<String> userNoSet, String status) {
        Object object = lock;
        synchronized (object) {
            UCDBConf.muteConfRoomUser(context, roomId, userNoSet, "true".equals(status));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfRoomUser(Context context, Long roomId, LiteConferenceUserStatus user) {
        Object object = lock;
        synchronized (object) {
            LiteConferenceUserStatus existUser = UCDBConf.getConfRoomUser(context, roomId, user.getUserNo());
            if (existUser != null) {
                UCDBConf.updateConfRoomUser(context, roomId, user);
            } else {
                UCDBConf.addConfRoomUser(context, roomId, user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllConfRoomUsers(Context context, long roomId) {
        Object object = lock;
        synchronized (object) {
            UCDBConf.deleteAllConfRoomUsers(context, roomId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllConfRoomUsers(Context context) {
        Object object = lock;
        synchronized (object) {
            UCDBConf.deleteAllConfRoomUsers(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOrUpdateConfRoom(Context context, LiteConferenceRoom liteConferenceRoom) {
        Object object = lock;
        synchronized (object) {
            if (UCDBConf.existMeetmeById(context, liteConferenceRoom.getRoomId())) {
                UCDBConf.updateConfRoom(context, liteConferenceRoom);
            } else {
                UCDBConf.addConfRoom(context, liteConferenceRoom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUserMeetmeInfo(Context context, long roomId, long userId) {
        Object object = lock;
        synchronized (object) {
            UCDBConf.leaveConfRoomByEmployeeId(context, roomId, userId);
        }
    }
}

