/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.bean.web.LiteSite;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.db.UCDBConf;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.db.UCDBSite;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.EmployeeMatchInfo;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcherResult;
import com.blisscloud.mobile.ezuc.manager.SiteManager;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.List;

public class PhoneMatcher {
    public static PhoneMatcherResult match(Context context, String phoneNumber, boolean isOutbound) {
        String meetmePrefix;
        List<LiteSite> siteList;
        PhoneMatcherResult result = new PhoneMatcherResult();
        long mySiteId = PreferencesUtil.getSipUsePbxSite(context);
        String mySitePrefix = SiteManager.getSitePrefixById(context, mySiteId);
        EmployeeMatchInfo infox = UCDBContact.getTargetJidByExt(context, phoneNumber, mySitePrefix, siteList = UCDBSite.getAllSites(context));
        if (infox != null) {
            LiteContact contact;
            result.setTargetJid(infox.getJid());
            result.setTargetName(JidUtil.convertKey(infox.getJid()));
            LiteSite site = UCDBSite.getSiteByPrefix(context, infox.getSitePrefix());
            if (site != null) {
                result.setTargetSiteId(site.getId());
            }
            if ((contact = ContactManager.getContact(context, infox.getJid())) != null) {
                if (JidUtil.isEmployeeJid(result.getTargetJid())) {
                    result.setMatchType(0);
                    result.setTargetName(ContactManager.getNonEnglishName(contact));
                    result.setTargetEngName(ContactManager.getFullEnglishName(contact));
                    result.setExt(infox.getExt());
                    result.setContact(contact);
                } else if (JidUtil.isLocationJid(result.getTargetJid())) {
                    result.setMatchType(1);
                    result.setTargetName(ContactManager.getContactFullName(contact));
                    result.setTargetEngName(null);
                    result.setExt(infox.getExt());
                    result.setContact(contact);
                }
            }
            return result;
        }
        if (isOutbound && phoneNumber.startsWith(meetmePrefix = OutboundPrefixManager.getMeetmePrefix(context))) {
            String possibleRoomNo = phoneNumber.substring(meetmePrefix.length());
            LiteConferenceRoom confRoom = UCDBConf.getConfRoomByRoomNo(context, possibleRoomNo);
            if (confRoom != null) {
                result.setMatchType(2);
                result.setTargetJid(confRoom.getChatRoomId());
                result.setTargetName(confRoom.getName());
                return result;
            }
            return null;
        }
        String macthedJid = UCDBContact.getMatchedContactJidByPhoneNo(context, phoneNumber, isOutbound);
        if (macthedJid != null) {
            result.setTargetJid(macthedJid);
            result.setMatchType(4);
            LiteContact contact = ContactManager.getContact(context, macthedJid);
            if (contact != null) {
                result.setTargetName(ContactManager.getNonEnglishName(contact));
                result.setTargetEngName(ContactManager.getFullEnglishName(contact));
                result.setContact(contact);
            } else {
                result.setTargetName(JidUtil.convertKey(macthedJid));
            }
            return result;
        }
        long macthedCid = UCDBExternalContact.getMatchedExternalContactIdByPhoneNo(context, phoneNumber, isOutbound);
        if (macthedCid != -1L) {
            LiteMyContact myContact = UCDBExternalContact.getExternalContactById(context, macthedCid);
            if (myContact != null) {
                result.setMatchType(5);
                result.setTargetJid(macthedCid + "@externalcontact");
                result.setTargetName(myContact.getName());
                result.setMyContact(myContact);
            } else {
                result.setTargetName(macthedCid + "@externalcontact");
            }
            return result;
        }
        return null;
    }
}

