/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.VoiceItem;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UCDBRemoteMark;
import com.blisscloud.mobile.ezuc.db.UCDBVoiceMsg;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.task.GetVoiceDataTask;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.MediaFileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;

public class VoicemailManager {
    public static final String VOICE_BTIME = "startTime";
    public static final String VOICE_ETIME = "endTime";
    public static final String VOICE_READ = "read";
    public static final String VOICE_LISTEN = "listen";
    public static final String VOICE_URL = "url";
    public static final String VOICE_ID = "id";
    public static final String VOICE_JID = "jid";
    public static final String VOICE_CTYPE = "callerType";
    public static final String VOICE_PHONE = "callerIdNumber";
    public static final String VOICE_DBID = "callerDbId";
    public static final String VOICE_SITE = "callerSite";
    public static final String VOICE_NAME = "callerIdName";
    public static final String VOICE_DURATION = "duration";
    public static final String VOICE_PACKET_ID = "packetId";
    public static final String VOICE_OWNER_DIAL_OUT_FLAG = "ownerDialOutFlag";

    public static File getLocalVoiceItemFile(VoiceItem item) {
        String localName;
        if (item.getGroup() == 2) {
            return new File(item.getUrl());
        }
        if (item.getGroup() == 1 && (localName = item.getUrl()) != null && localName.indexOf("https:") == -1) {
            return new File(localName);
        }
        return null;
    }

    public static File getVoiceItemCacheFile(VoiceItem item) {
        if (item.getGroup() == 1) {
            File recordingDir = MediaFileUtil.getRecordingRoot(UCChatClient.context);
            return new File(recordingDir, VoicemailManager.getVoiceItemDispName(item));
        }
        if (item.getGroup() == 0) {
            File voicemailDir = MediaFileUtil.getVoicemailRoot(UCChatClient.context);
            return new File(voicemailDir, VoicemailManager.getVoiceItemDispName(item));
        }
        return null;
    }

    public static String getVoiceItemDispName(VoiceItem item) {
        if (item.getGroup() == 1 || item.getGroup() == 2) {
            return String.format("recording-%1$s-%2$s.mp3", item.getNumber(), DateTimeUtil.getDateTimeStr(item.getBeginTime()));
        }
        if (item.getGroup() == 0) {
            return String.format("voicemail-%1$s-%2$s.mp3", item.getNumber(), DateTimeUtil.getDateTimeStr(item.getBeginTime()));
        }
        return "NA";
    }

    public static VoiceItem getVoiceItemByMessage(Context ctx, Message msg) {
        VoiceItem item = null;
        if (TextUtils.isNotBlank((CharSequence)msg.getProps())) {
            try {
                JSONObject obj = new JSONObject(msg.getProps());
                item = VoicemailManager.parseMessageProps(ctx, obj);
                if (item != null && TextUtils.isBlank((CharSequence)item.getPacketId())) {
                    item.setPacketId(msg.getPacketId());
                }
            }
            catch (JSONException e) {
                Log.e(VoicemailManager.class.getSimpleName(), "parseMessageProps:" + msg.getProps(), e);
            }
        }
        if (item == null) {
            item = UCDBVoiceMsg.getVoiceItemByPacketId(ctx, msg.getPacketId());
        }
        if (item != null) {
            GetVoiceDataTask.updateNameForDisp(ctx, item);
        }
        return item;
    }

    public static VoiceItem parseMessageProps(Context ctx, JSONObject props) throws JSONException {
        JSONObject recordingObj;
        JSONObject voicemailObj;
        if (props.has("vm") && (voicemailObj = props.getJSONObject("vm")) != null) {
            return VoicemailManager.parse(ctx, voicemailObj, 0);
        }
        if (props.has("record") && (recordingObj = props.getJSONObject("record")) != null) {
            return VoicemailManager.parse(ctx, recordingObj, 1);
        }
        return null;
    }

    public static VoiceItem parse(Context ctx, JSONObject obj, int type) throws JSONException {
        VoiceItem item = new VoiceItem();
        item.setBeginTime(obj.getLong(VOICE_BTIME));
        item.setEndTime(obj.getLong(VOICE_ETIME));
        item.setGroup(type);
        item.setRead(obj.optBoolean(VOICE_READ, true));
        item.setPlayed(obj.optBoolean(VOICE_LISTEN, false));
        item.setUrl(obj.optString(VOICE_URL));
        item.setId(obj.optLong(VOICE_ID, -1L));
        item.setJid(obj.optString(VOICE_JID));
        item.setType(obj.optString(VOICE_CTYPE));
        item.setNumber(obj.optString(VOICE_PHONE));
        item.setDBId(obj.optString(VOICE_DBID));
        item.setSite(obj.optString(VOICE_SITE));
        item.setName(obj.optString(VOICE_NAME));
        item.setDuration(obj.optLong(VOICE_DURATION, 0L) * 1000L);
        item.setPacketId(obj.optString(VOICE_PACKET_ID));
        item.setOutboundTrunk(obj.optInt(VOICE_OWNER_DIAL_OUT_FLAG, 0) == 1);
        if (!item.getType().startsWith("LINE_TYPE_")) {
            GetVoiceDataTask.configureVoiceItem(ctx, item);
        }
        return item;
    }

    public static void delete(Context ctx, long id, int type, boolean isDeleteVoiceEmail, boolean isDeleteChatEvent) {
        Log.i(VoicemailManager.class.getName(), "doDelete : id " + id + " Type :" + type);
        VoiceItem item = UCDBVoiceMsg.getVoiceItem(ctx, id, type);
        if (item == null) {
            return;
        }
        VoicemailManager.delete(ctx, item, isDeleteVoiceEmail, isDeleteChatEvent);
    }

    public static boolean isLocalRecording(VoiceItem item) {
        boolean isLocalVoiceItem = false;
        if (item.getGroup() == 2) {
            isLocalVoiceItem = true;
        } else if (!item.getUrl().contains("https:")) {
            isLocalVoiceItem = true;
        }
        return isLocalVoiceItem;
    }

    public static void delete(Context ctx, VoiceItem item, boolean isDeleteRemoteItem, boolean isDeleteChatEvent) {
        if (VoicemailManager.isLocalRecording(item)) {
            File localRecFile = VoicemailManager.getLocalVoiceItemFile(item);
            if (localRecFile.exists()) {
                try {
                    localRecFile.delete();
                }
                catch (Exception e) {
                    Log.e(VoicemailManager.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
            UCDBVoiceMsg.deleteVoiceMsgByPacketId(UCChatClient.context, item.getPacketId());
            BroadcastUtil.sendVoiceRecordChangedEvent(UCChatClient.context);
        } else {
            File cacheFile = VoicemailManager.getVoiceItemCacheFile(item);
            if (cacheFile != null && cacheFile.exists()) {
                cacheFile.delete();
            }
            if (item.getGroup() == 1) {
                UCDBVoiceMsg.deleteVoiceMsg(ctx, item.getId());
                BroadcastUtil.sendVoiceRecordChangedEvent(ctx);
                if (isDeleteRemoteItem) {
                    UCDBRemoteMark.addRemoteMark(ctx, 10, item.getId());
                    WebAgent.getInstance().deletePersonalRecord(String.valueOf(item.getId()));
                }
            } else if (item.getGroup() == 0) {
                UCDBVoiceMsg.deleteVoiceMsg(ctx, item.getId());
                BroadcastUtil.sendVoiceRecordChangedEvent(ctx);
                if (isDeleteRemoteItem) {
                    UCDBRemoteMark.addRemoteMark(ctx, 11, item.getId());
                    WebAgent.getInstance().deleteVoiceMessage(String.valueOf(item.getId()));
                }
            }
        }
        if (TextUtils.isNotBlank((CharSequence)item.getPacketId())) {
            Message msg = UCDBMessage.findMsgByPacketId(ctx, item.getPacketId());
            ChatRoomManager.clearSpecificChatMsg(ctx, item.getPacketId());
            if (isDeleteChatEvent && msg.getChatEventId() > 0L) {
                UCDBRemoteMark.addRemoteMark(ctx, 8, msg.getChatEventId());
                WebAgent.getInstance().deleteChatEvent(msg.getChatEventId());
            }
            if (PreferencesUtil.isSyncOldChatEventDone(ctx)) {
                BroadcastUtil.sendMsgDeletedEvent(ctx, item.getPacketId());
                BroadcastUtil.sendMsgChangedEvent(ctx);
                BroadcastUtil.sendContactHistoryChangedEvent(ctx);
            }
        }
    }
}

