/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.AsyncTask;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.ConnectionAgent;
import com.blisscloud.mobile.ezuc.bean.AuthOption;
import com.blisscloud.mobile.ezuc.manager.task.TaskComplete;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class CheckAuthOptionTask
extends AsyncTask<String, Void, Void> {
    public static final String UC_TENANT_AUTH_OPTION = "/ucrm/authOption/fetchAuthOption?enterpriseNo=%1$s";
    public static final String UC_NO_TENANT_AUTH_OPTION = "/ucrm/authOption/fetchAuthOption";
    private Context mCtx = null;
    private TaskComplete<Void> taskCompleteListener = null;

    public CheckAuthOptionTask(Context context, TaskComplete<Void> listener) {
        this.mCtx = context.getApplicationContext();
        this.taskCompleteListener = listener;
    }

    protected Void doInBackground(String ... params) {
        if (this.isCancelled()) {
            return null;
        }
        HttpClient mHttpClient = CommonUtil.getHttpsClient(this.mCtx, true, 5000, 5000);
        Log.i(CheckAuthOptionTask.class.getSimpleName(), "fetchAuthOption check ... ");
        int authOption = this.fetchAuthOption(mHttpClient);
        if (authOption == -1) {
            PreferencesUtil.setAuthOption(this.mCtx, AuthOption.UC_ONLY);
            BroadcastUtil.sendAuthOptionChanged(this.mCtx);
        } else {
            PreferencesUtil.setAuthOption(this.mCtx, AuthOption.getValue(authOption));
            BroadcastUtil.sendAuthOptionChanged(this.mCtx);
        }
        Log.i(CheckAuthOptionTask.class.getSimpleName(), "fetchAuthOption check ... done!");
        return null;
    }

    private int fetchAuthOption(HttpClient mHttpClient) {
        if (mHttpClient == null) {
            return -1;
        }
        ConnectionAgent.getInstance().checkInOfficeFlag();
        String enterpriseNo = PreferencesUtil.getEnterpriseNo(this.mCtx);
        String authOptionUrl = !TextUtils.isEmpty((CharSequence)enterpriseNo) ? "https://" + CommonUtil.getHttpsIpPort(this.mCtx) + String.format(UC_TENANT_AUTH_OPTION, enterpriseNo) : "https://" + CommonUtil.getHttpsIpPort(this.mCtx) + String.format(UC_NO_TENANT_AUTH_OPTION, new Object[0]);
        try {
            HttpGet request = new HttpGet();
            request.setURI(new URI(authOptionUrl));
            HttpResponse response = mHttpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                request.abort();
                return -1;
            }
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity);
            if (TextUtils.isEmpty((CharSequence)result)) {
                return -1;
            }
            JSONObject obj = new JSONObject(result);
            int resultCode = obj.getInt("returnCode");
            if (resultCode == 0 && obj.has("authOption")) {
                int optionOption = obj.getInt("authOption");
                return optionOption;
            }
        }
        catch (Throwable t) {
            Log.e(CheckAuthOptionTask.class.getSimpleName(), "isUpdateTimestampRequired fail", t);
        }
        return -1;
    }

    @Override
    protected void onPostExecute(Void result) {
        this.taskCompleteListener.onLoadFinished(result);
    }
}

