/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.manager.VoicemailManager;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetDeletedVoiceDataTask
extends ExThread {
    private final JSONObject mDataObj;
    private long mTimestamp = -1L;

    public GetDeletedVoiceDataTask(Context context, JSONObject dataObj, long returnTimeStamp) {
        super(context, "GetDeletedVoiceDataTask");
        this.mDataObj = dataObj;
        this.mTimestamp = returnTimeStamp;
    }

    @Override
    public void run() {
        try {
            if (this.mDataObj != null) {
                String idStr;
                int i;
                if (this.mDataObj.has("vmDeletedList")) {
                    JSONArray vmDeletedList = this.mDataObj.getJSONArray("vmDeletedList");
                    for (i = 0; vmDeletedList != null && i < vmDeletedList.length(); ++i) {
                        idStr = vmDeletedList.getString(i);
                        VoicemailManager.delete(this.mCtx, Long.parseLong(idStr), 0, false, false);
                    }
                }
                if (this.mDataObj.has("prDeletedList")) {
                    JSONArray prDeletedList = this.mDataObj.getJSONArray("prDeletedList");
                    for (i = 0; prDeletedList != null && i < prDeletedList.length(); ++i) {
                        idStr = prDeletedList.getString(i);
                        VoicemailManager.delete(this.mCtx, Long.parseLong(idStr), 1, false, false);
                    }
                }
            }
            PreferencesUtil.setTimeStamp(this.mCtx, "record.getDeletedVMAndPRList.TimeStamp", this.mTimestamp);
        }
        catch (JSONException e) {
            Log.e(this.getClass().getSimpleName(), "parseArray", e);
        }
        this.cleanUp();
    }

    private void cleanUp() {
        TaskController.getInstance().removeTask(this);
    }

    @Override
    public String toString() {
        return "GetDeletedVoiceDataTask - " + super.toString();
    }
}

