/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.client.bean.PhotoLoadTask;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.ContactPhotoTask;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.PhotoType;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.ArrayList;
import java.util.List;

public class GetExternalContactDataTask
extends ExThread {
    private final String mData;
    private final long returnTimeStamp;

    public GetExternalContactDataTask(Context context, String data, long returnTimeStamp) {
        super(context, "GetExternalContactDataTask");
        this.mData = data;
        this.returnTimeStamp = returnTimeStamp;
    }

    @Override
    public void run() {
        List<LiteMyContact> contacts = ContactManager.parseLiteExteranlContactsJson(this.mData);
        if (contacts == null || contacts.size() == 0) {
            Log.i(this.getClass().getSimpleName(), "GetExternalContactDataTask contacts is null or size is 0");
            this.cleanUp();
            return;
        }
        ArrayList<PhotoLoadTask> toGetPhotoList = new ArrayList<PhotoLoadTask>();
        for (LiteMyContact liteContact : contacts) {
            if (this.isTerminate()) {
                Log.e(this.getClass().getSimpleName(), "GetExternalContactDataTask terminated");
                UCDBExternalContact.deleteAllExternalContacts(this.mCtx);
                this.cleanUp();
                return;
            }
            boolean hasPhotoUpdate = ContactManager.setWSContact(this.mCtx, liteContact);
            if (!hasPhotoUpdate) continue;
            ContactPhotoTask task = new ContactPhotoTask();
            task.setContactId(liteContact.getId());
            toGetPhotoList.add(task);
        }
        if (toGetPhotoList != null && !toGetPhotoList.isEmpty()) {
            ContactManager.refreshPhotoList(this.mCtx, PhotoType.SMALL, toGetPhotoList);
        }
        if (!this.isTerminate()) {
            PreferencesUtil.setTimeStamp(this.mCtx, "contact.getMyContactList.TimeStamp", this.returnTimeStamp);
            BroadcastUtil.sendExternalContactListChangedEvent(this.mCtx);
        }
        this.cleanUp();
    }

    private void cleanUp() {
        TaskController.getInstance().removeTask(this);
    }

    @Override
    public String toString() {
        return "GetExternalContactDataTask - " + super.toString();
    }
}

