/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class GetLogoTask
extends ExThread {
    private long mNewPhotoTime = 0L;

    public GetLogoTask(Context context, long newPhotoTime) {
        super(context, "GetLogoTask");
        this.mNewPhotoTime = newPhotoTime;
    }

    @Override
    public void run() {
        String bigUrl = null;
        String smallUrl = null;
        try {
            bigUrl = "https://" + CommonUtil.getHttpsIpPort(this.mCtx) + "/ucrm/tenant/showBigPhoto?tenantId=" + PreferencesUtil.getTenantId(this.mCtx);
            boolean doneBig = this.getPhotoFromWeb(bigUrl, true);
            smallUrl = "https://" + CommonUtil.getHttpsIpPort(this.mCtx) + "/ucrm/tenant/showPhoto?tenantId=" + PreferencesUtil.getTenantId(this.mCtx);
            boolean doneSmall = this.getPhotoFromWeb(smallUrl, false);
            if (doneSmall) {
                PreferencesUtil.setTenantPhotoTime(this.mCtx, this.mNewPhotoTime);
            }
            BroadcastUtil.sendCompanyLogoChangedEvent(UCChatClient.context);
        }
        catch (Exception e) {
            Log.e(GetLogoTask.class.getSimpleName(), "GetLogoTask fail", e);
        }
        this.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getPhotoFromWeb(String url, boolean isBig) {
        InputStream is = null;
        HttpClient mHttpClient = null;
        try {
            mHttpClient = CommonUtil.getHttpsClient(UCChatClient.context, true);
            if (mHttpClient == null) {
                boolean bl = false;
                return bl;
            }
            HttpGet request = new HttpGet();
            request.setURI(new URI(url));
            HttpResponse response = mHttpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                request.abort();
                boolean bl = false;
                return bl;
            }
            is = response.getEntity().getContent();
            if (is != null) {
                if (isBig) {
                    FileUtil.writeLogoBigPhoto(is);
                } else {
                    FileUtil.writeLogoSmallPhoto(is);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Log.e(GetLogoTask.class.getSimpleName(), "getPhotoFromWeb fail", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    try {
                        is.close();
                        is = null;
                    }
                    catch (IOException e) {
                        Log.e(GetLogoTask.class.getSimpleName(), "getPhotoFromWeb fail", e);
                        is = null;
                    }
                }
                catch (Throwable throwable) {
                    is = null;
                    throw throwable;
                }
            }
        }
    }

    private void cleanUp() {
        TaskController.getInstance().removeTask(this);
    }

    @Override
    public String toString() {
        return "GetLogoTask - " + super.toString();
    }
}

